/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.quote;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;

public class QuoteStrategyMappingSubmitValidator
extends AbstractValidator {
    public void validate() {
        HashSet<String> mustMappingBills = new HashSet<String>();
        ArrayList<Long> schemePKs = new ArrayList<Long>(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            if (!QuoteOtherHelper.isNewMode(bill)) continue;
            DynamicObjectCollection conditonColl = bill.getDynamicObjectCollection("conditionentryentity");
            DynamicObjectCollection schemeColl = bill.getDynamicObjectCollection("entryentity");
            if (conditonColl.size() <= 0) continue;
            boolean hasNewModeScheme = false;
            if (schemeColl.size() > 0) {
                for (DynamicObject s : schemeColl) {
                    DynamicObject quoteScheme = s.getDynamicObject("quotescheme");
                    if (quoteScheme == null || !QuoteOtherHelper.isDimensionMode(quoteScheme)) continue;
                    hasNewModeScheme = true;
                    schemePKs.add((Long)quoteScheme.getPkValue());
                    if (quoteScheme.getDynamicObject("pricesourceentity") == null) continue;
                    mustMappingBills.add(quoteScheme.getDynamicObject("pricesourceentity").getString("id"));
                }
            }
            if (!hasNewModeScheme) continue;
            conditonColl.forEach(c -> {
                if (c.getDynamicObject("quotebill") != null) {
                    mustMappingBills.add(c.getDynamicObject("quotebill").getString("number"));
                }
            });
        }
        if (mustMappingBills.size() > 0 && schemePKs.size() > 0) {
            Map<String, Map<String, String>> billMapping;
            try {
                billMapping = QuoteHelper.buildBillMapping(mustMappingBills);
            }
            catch (KDBizException e) {
                for (ExtendedDataEntity data : this.dataEntities) {
                    this.addMessage(data, e.getMessage(), ErrorLevel.Error);
                }
                return;
            }
            Map<Object, DynamicObject> schemeMap = QuoteHelper.getActiveSchemeInfo(schemePKs, false);
            for (ExtendedDataEntity data : this.dataEntities) {
                DynamicObject bill = data.getDataEntity();
                if (!QuoteOtherHelper.isNewMode(bill)) continue;
                DynamicObjectCollection conditonColl = bill.getDynamicObjectCollection("conditionentryentity");
                DynamicObjectCollection schemeColl = bill.getDynamicObjectCollection("entryentity");
                if (conditonColl.size() <= 0 || schemeColl.size() <= 0) continue;
                for (DynamicObject s : schemeColl) {
                    String message;
                    DynamicObject quoteScheme = s.getDynamicObject("quotescheme");
                    if (quoteScheme == null || !QuoteOtherHelper.isDimensionMode(quoteScheme)) continue;
                    DynamicObject quoteSchemeFull = schemeMap.get(quoteScheme.getPkValue());
                    conditonColl.forEach(c -> {
                        if (c.getDynamicObject("quotebill") != null) {
                            String message;
                            String quoteBill = (String)c.getDynamicObject("quotebill").getPkValue();
                            MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)quoteBill);
                            Map quoteFieldMapping = (Map)billMapping.get(quoteBill);
                            DynamicObjectCollection mappingEntry = quoteSchemeFull.getDynamicObjectCollection("entryentity");
                            for (DynamicObject mappingInfo : mappingEntry) {
                                String quoteSign = mappingInfo.getString("quotesign");
                                String quoteSignDes = mappingInfo.getString("quotesignname");
                                if (StringUtils.isEmpty((String)(quoteSign = (String)quoteFieldMapping.get(quoteSign)))) {
                                    String message2 = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u53d6\u4ef7\u5355\u636e\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), quoteBillType.getDisplayName(), quoteSignDes);
                                    this.addMessage(data, message2, ErrorLevel.Error);
                                    continue;
                                }
                                String propName = AdvancedPricingHelper.subEntryField(quoteSign, quoteBillType);
                                if (!StringUtils.isEmpty((String)propName) && !quoteBillType.getAllEntities().containsKey(quoteSign)) continue;
                                message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u53d6\u4ef7\u5355\u636e\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u6709\u8bef\u3002", (String)"QuoteStrategyMappingSubmitValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), quoteBillType.getDisplayName(), quoteSignDes);
                                this.addMessage(data, message, ErrorLevel.Error);
                            }
                            DynamicObjectCollection resultEntry = quoteSchemeFull.getDynamicObjectCollection("entryresult");
                            for (DynamicObject resultInfo : resultEntry) {
                                String quoteSign = resultInfo.getString("quotesignr");
                                quoteSign = (String)quoteFieldMapping.get(quoteSign);
                                String quoteSignDes = resultInfo.getString("quotesignnamer");
                                if (StringUtils.isEmpty((String)quoteSign)) {
                                    message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u53d6\u4ef7\u5355\u636e\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), quoteBillType.getDisplayName(), quoteSignDes);
                                    this.addMessage(data, message, ErrorLevel.Error);
                                    continue;
                                }
                                String propName = AdvancedPricingHelper.subEntryField(quoteSign, quoteBillType);
                                if (!StringUtils.isEmpty((String)propName) && !quoteBillType.getAllEntities().containsKey(quoteSign)) continue;
                                String message3 = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u53d6\u4ef7\u5355\u636e\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u6709\u8bef\u3002", (String)"QuoteStrategyMappingSubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), quoteBillType.getDisplayName(), quoteSignDes);
                                this.addMessage(data, message3, ErrorLevel.Error);
                            }
                        }
                    });
                    if (quoteScheme.getDynamicObject("pricesourceentity") == null) continue;
                    String sourceBill = (String)quoteScheme.getDynamicObject("pricesourceentity").getPkValue();
                    MainEntityType sourceBillType = EntityMetadataCache.getDataEntityType((String)sourceBill);
                    Map<String, String> sourceFieldMapping = billMapping.get(sourceBill);
                    DynamicObjectCollection mappingEntry = quoteSchemeFull.getDynamicObjectCollection("entryentity");
                    for (DynamicObject mappingInfo : mappingEntry) {
                        String sourceSign = mappingInfo.getString("sourcesign");
                        sourceSign = sourceFieldMapping.get(sourceSign);
                        String sourceSignDes = mappingInfo.getString("sourcesignname");
                        if (StringUtils.isEmpty((String)sourceSign)) {
                            String message2 = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), sourceBillType.getDisplayName(), sourceSignDes);
                            this.addMessage(data, message2, ErrorLevel.Error);
                            continue;
                        }
                        String propName = AdvancedPricingHelper.subEntryField(sourceSign, sourceBillType);
                        if (!StringUtils.isEmpty((String)propName) && !sourceBillType.getAllEntities().containsKey(sourceSign)) continue;
                        message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u6709\u8bef\u3002", (String)"QuoteStrategyMappingSubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), sourceBillType.getDisplayName(), sourceSignDes);
                        this.addMessage(data, message, ErrorLevel.Error);
                    }
                    DynamicObjectCollection resultEntry = quoteSchemeFull.getDynamicObjectCollection("entryresult");
                    for (DynamicObject resultInfo : resultEntry) {
                        String sourceSign = resultInfo.getString("sourcesignr");
                        sourceSign = sourceFieldMapping.get(sourceSign);
                        String sourceSignDes = resultInfo.getString("sourcesignnamer");
                        if (StringUtils.isEmpty((String)sourceSign)) {
                            message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), sourceBillType.getDisplayName(), sourceSignDes);
                            this.addMessage(data, message, ErrorLevel.Error);
                            continue;
                        }
                        String propName = AdvancedPricingHelper.subEntryField(sourceSign, sourceBillType);
                        if (!StringUtils.isEmpty((String)propName) && !sourceBillType.getAllEntities().containsKey(sourceSign)) continue;
                        String message3 = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u6709\u8bef\u3002", (String)"QuoteStrategyMappingSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteSchemeFull.getString("name"), sourceBillType.getDisplayName(), sourceSignDes);
                        this.addMessage(data, message3, ErrorLevel.Error);
                    }
                }
            }
        }
    }
}

