/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.quote;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class QuoteStrategySubmitValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject bill;
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection calEntries;
            bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            if (entries != null && entries.size() > 0) {
                for (int i = 0; i < entries.size(); ++i) {
                    String termination;
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    DynamicObject scheme = entry.getDynamicObject("quotescheme");
                    if (scheme == null || !StringUtils.isEmpty((CharSequence)(termination = entry.getString("terminationsigndesc")))) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u65b9\u6848\u6392\u5e8f\u201d\u5206\u5f55\u7b2c%s\u884c\u7684\u201c\u53d6\u5230\u4ef7\u683c\u7ec8\u6b62\u201d\u3002", (String)"QuoteStrategySubmitValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
            }
            if ((calEntries = bill.getDynamicObjectCollection("calentry")) == null || calEntries.size() <= 0) continue;
            for (int i = 0; i < calEntries.size(); ++i) {
                String termination;
                DynamicObject entry = (DynamicObject)calEntries.get(i);
                DynamicObject calStrategy = entry.getDynamicObject("calstrategy");
                if (calStrategy == null || !StringUtils.isEmpty((CharSequence)(termination = entry.getString("quotetermsigndesc")))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8ba1\u7b97\u6392\u5e8f\u201d\u5206\u5f55\u7b2c%s\u884c\u7684\u201c\u53d6\u5230\u4ef7\u683c\u7ec8\u6b62\u201d\u3002", (String)"QuoteStrategySubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
        }
        for (ExtendedDataEntity strategy : this.dataEntities) {
            bill = strategy.getDataEntity();
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection calEntry = bill.getDynamicObjectCollection("calentry");
            DynamicObjectCollection conditionEntry = bill.getDynamicObjectCollection("conditionentryentity");
            if (this.isDimensionMode(bill) && conditionEntry.size() <= 0) {
                this.addMessage(strategy, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u524d\u7f6e\u6761\u4ef6\u201d\u3002", (String)"QuoteStrategySubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
            }
            String name = bill.getDataEntityType().getName();
            if (entryEntity.size() > 0 || calEntry.size() > 0) continue;
            if ("pm_quotestrategy".equals(name)) {
                this.addMessage(strategy, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u65b9\u6848\u6392\u5e8f\u3002", (String)"QuoteStrategySubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            this.addMessage(strategy, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u65b9\u6848\u6392\u5e8f\u201d\u6216\u201c\u8ba1\u7b97\u6392\u5e8f\u201d\u3002", (String)"QuoteStrategySubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private boolean isDimensionMode(DynamicObject bill) {
        return bill.getBoolean("isnewmode");
    }
}

