/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msbd.helper.ApiServiceHelper;

public class ApiDispatchedTrigger {
    private static final ThreadPool POOL = ThreadPools.newFixedThreadPool((String)"scmcOpenApi", (int)100);
    private static final Log logger = LogFactory.getLog(ApiDispatchedTrigger.class);
    private static ApiDispatchedTrigger instance = null;
    private boolean isRun = false;

    private ApiDispatchedTrigger() {
    }

    public static synchronized ApiDispatchedTrigger getInstance() {
        if (instance == null) {
            instance = new ApiDispatchedTrigger();
        }
        return instance;
    }

    public synchronized void start() {
        if (this.isRun) {
            return;
        }
        this.isRun = true;
        try {
            this.invoke();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.stop();
        }
    }

    /*
     * Loose catch block
     */
    private void invoke() {
        String sql = "select fapiproxy from t_msbd_apisubtask where fstatus = 'WAIT' group by fapiproxy ";
        DataSet subTaskDatas = DB.queryDataSet((String)(this.getClass().getName() + "queryApiSubTask"), (DBRoute)new DBRoute("scm"), (String)sql);
        HashMap<Long, Integer> fapiProxyIdMap = new HashMap<Long, Integer>(16);
        while (subTaskDatas.hasNext()) {
            Row row = subTaskDatas.next();
            Long apiProxy = row.getLong("fapiproxy");
            int slot = ApiServiceHelper.getTaskSlot(apiProxy);
            if (slot <= 0) continue;
            fapiProxyIdMap.put(apiProxy, slot);
        }
        if (fapiProxyIdMap.isEmpty()) {
            this.stop();
            return;
        }
        for (Map.Entry fapiProxyEntry : fapiProxyIdMap.entrySet()) {
            int batchSize;
            DynamicObjectCollection subTasks;
            block23: {
                Iterator iterator;
                TXHandle tx;
                block24: {
                    Long apiProxy = (Long)fapiProxyEntry.getKey();
                    Integer top = (Integer)fapiProxyEntry.getValue();
                    subTasks = QueryServiceHelper.query((String)"msbd_apisubtask", (String)"id,batchid,ptask", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"WAIT"), new QFilter("apiproxy", "=", (Object)apiProxy)}, (String)"batchid", (int)top);
                    if (subTasks.isEmpty()) continue;
                    batchSize = ApiDispatchedTrigger.getBatchSize();
                    tx = TX.requiresNew();
                    iterator = null;
                    try {
                        String updSql = "update t_msbd_apisubtask set fstatus = 'EXEC' where fid = ?";
                        ArrayList params = new ArrayList(16);
                        subTasks.forEach(v -> params.add(new Object[]{v.get("id")}));
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updSql, params);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        logger.error((Throwable)e);
                        if (tx == null) continue;
                        if (iterator != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable params) {
                                ((Throwable)((Object)iterator)).addSuppressed(params);
                            }
                            continue;
                        }
                        tx.close();
                        continue;
                    }
                    if (tx == null) break block23;
                    if (iterator == null) break block24;
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)((Object)iterator)).addSuppressed(e);
                    }
                    break block23;
                }
                tx.close();
                break block23;
                catch (Throwable e) {
                    try {
                        iterator = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (tx != null) {
                            if (iterator != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    ((Throwable)((Object)iterator)).addSuppressed(throwable2);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            HashMap<String, ArrayList<Long>> batchMap = new HashMap<String, ArrayList<Long>>(16);
            for (DynamicObject subTask : subTasks) {
                ArrayList<Long> subIds;
                String batchId = subTask.getString("batchid");
                if (StringUtils.isBlank((CharSequence)batchId)) {
                    batchId = subTask.get("ptask").toString();
                }
                if ((subIds = (ArrayList<Long>)batchMap.get(batchId)) == null) {
                    subIds = new ArrayList<Long>(16);
                    batchMap.put(batchId, subIds);
                }
                subIds.add(subTask.getLong("id"));
                if (subIds.size() < batchSize) continue;
                this.execute(subIds);
                subIds.clear();
            }
            for (List subIds : batchMap.values()) {
                if (subIds.isEmpty()) continue;
                this.execute(subIds);
            }
        }
        subTaskDatas.close();
    }

    private void execute(final List<Long> subIds) {
        POOL.execute(new Runnable(){

            @Override
            public void run() {
                DynamicObject[] subTasks = BusinessDataServiceHelper.load((String)"msbd_apisubtask", (String)"id,ptask.id,param_tag,apiproxy.id,apiproxy.scenesplugin", (QFilter[])new QFilter("id", "in", (Object)subIds).toArray());
                ApiServiceHelper.doInvoke(subTasks);
                ApiDispatchedTrigger.this.start();
            }
        });
    }

    private static int getBatchSize() {
        String val;
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"scmcOpenApiBatchSize").toArray());
        if (queryOne != null && StringUtils.isNotBlank((CharSequence)(val = queryOne.getString("value")))) {
            return Integer.parseInt(val);
        }
        return 1000;
    }

    public void stop() {
        this.isRun = false;
    }
}

