/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.helper.ApiDispatchedTrigger;
import kd.mpscmm.msbd.mservice.ApiProxyService;
import kd.sdk.kingscript.util.JsonUtil;

public class ApiServiceHelper {
    private static final String PTASKID = "ptaskid";
    private static final String MPSCMM_MSBD_SCMCAPI = "mpscmm-msbd-scmcapi";
    private static final String API_ASYNC_INFO = "T_MSBD_API_ASYNC_INFO";
    private static final String CREATE_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_MSBD_API_ASYNC_INFO') CREATE TABLE T_MSBD_API_ASYNC_INFO ( FID BIGINT NOT NULL DEFAULT '0',SUBTASKID BIGINT NOT NULL DEFAULT '0') ";
    private static final String ALTER_TABLE_PK = "EXEC P_ALTERPK 'T_MSBD_API_ASYNC_INFO', 'T_MSBD_API_ASYNC_INFO', 'FID', '1' ";
    private static final String INSERT_SQL = "insert into T_MSBD_API_ASYNC_INFO(FID) values(?)";

    private ApiServiceHelper() {
    }

    public static int getTaskSlot(Long scenesId) {
        int slot;
        String scenesSql = String.format("select count(1) from t_msbd_apisubtask where fstatus='EXEC' AND fapiproxy= %s;", scenesId);
        int scenesCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)scenesSql, resultSet -> {
            resultSet.next();
            return resultSet.getInt(1);
        });
        String sql = "select count(1) from t_msbd_apisubtask where fstatus='EXEC'";
        int count = (Integer)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sql, resultSet -> {
            resultSet.next();
            return resultSet.getInt(1);
        });
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)scenesId, (String)"msbd_apiproxycfg", (String)"joblimit");
        int scenesLimit = dynamicObject.getInt("joblimit") > 0 ? dynamicObject.getInt("joblimit") : 1000;
        int scenesSlot = scenesLimit - scenesCount;
        QFilter qFilter = new QFilter("key", "=", (Object)"scmc_api_job_limit");
        DynamicObject scmParam = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (String)"value", (QFilter[])qFilter.toArray());
        int allLimit = 10000;
        if (scmParam != null && scmParam.getInt("value") > 0) {
            allLimit = scmParam.getInt("value");
        }
        int s = scenesSlot < (slot = allLimit - count) ? scenesSlot : slot;
        return scenesSlot > 0 && slot > 0 ? s : 0;
    }

    private static List<DynamicObject> createSubTask(Long ptaskId, boolean isSync) {
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)ptaskId, (String)"msbd_apimaintask", (String)"id,reqparam_tag,apiproxy.id,apiproxy.scenesplugin");
            String reqParam = dynamicObject.getString("reqparam_tag");
            JSONObject jsonObject = JsonUtil.parseObject((String)reqParam);
            JSONObject params = jsonObject.getJSONObject("params");
            String batchId = jsonObject.getString("batchid");
            JSONArray data = params.getJSONArray("data");
            Map paramsMap = (Map)JSON.parseObject((String)jsonObject.getString("params"), Map.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"msbd_apisubtask");
            ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(data.size());
            data.forEach(item -> {
                DynamicObject subTask = new DynamicObject((DynamicObjectType)entityType);
                paramsMap.put("data", item);
                subTask.set("batchid", (Object)batchId);
                String paramJson = JSON.toJSONString((Object)paramsMap);
                subTask.set("param_tag", (Object)paramJson);
                subTask.set("param", (Object)paramJson.substring(0, 200));
                subTask.set("ptask", (Object)dynamicObject);
                subTask.set("status", (Object)"WAIT");
                subTask.set("apiproxy", (Object)dynamicObject.getDynamicObject("apiproxy"));
                insertList.add(subTask);
            });
            long apiProxyId = dynamicObject.getDynamicObject("apiproxy").getLong("id");
            if (isSync && ApiServiceHelper.getTaskSlot(apiProxyId) < insertList.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8fbe\u5230\u9650\u6d41\u9600\u503c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ApiServiceHelper_2", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[0]));
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
            }
            return insertList;
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u4ee3\u7406\u63a5\u53e3\u5b50\u4efb\u52a1\u521b\u5efa\u5f02\u5e38:{0}", (String)"ApiServiceHelper_1", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[0]), e.toString());
            throw new KDBizException((Throwable)e, new ErrorCode("mpscmm.msbd", msg), new Object[0]);
        }
    }

    public static ApiResult syncInvoke(Long pTaskId) {
        ApiResult apiResult = new ApiResult();
        try (TXHandle tx = TX.requiresNew((String)"syncInvokeApi");){
            try {
                List<DynamicObject> subTasks = ApiServiceHelper.createSubTask(pTaskId, true);
                ApiServiceHelper.doInvoke(subTasks.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pTaskId, (String)"msbd_apimaintask");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("status", dynamicObject.getString("status"));
        paramsMap.put("responseparam", dynamicObject.getString("responseparam"));
        apiResult.setErrorCode(JSON.toJSONString(paramsMap));
        return apiResult;
    }

    public static ApiResult asyncInvoke(Long pTaskId) {
        try (TXHandle tx = TX.requiresNew((String)"asyncInvokeApi");){
            try {
                ApiServiceHelper.createSubTask(pTaskId, false);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        ApiDispatchedTrigger.getInstance().start();
        return ApiResult.success(null);
    }

    public static void doInvoke(DynamicObject[] tasks) {
        if (tasks == null || tasks.length == 0) {
            return;
        }
        RequestContext context = RequestContext.getOrCreate();
        String traceId = context.getTraceId();
        long userId = context.getCurrUserId();
        String ip = "";
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        Date startTime = new Date();
        try {
            DynamicObject apiProxy = tasks[0].getDynamicObject("apiproxy");
            String scenesPlugin = apiProxy.getString("scenesplugin");
            ApiProxyService instance = null;
            try {
                Class<?> clazz = Class.forName(scenesPlugin);
                instance = (ApiProxyService)clazz.newInstance();
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u573a\u666f\u63d2\u4ef6\u5b9e\u4f8b\u5316\u5931\u8d25\uff1a{0}\u3002", (String)"ApiServiceHelper_3", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[]{e.toString()}));
            }
            ApiServiceHelper.updateTaskExecuting(tasks);
            Date endTime = null;
            try (TXHandle tx = TX.requiresNew((String)"scenesplugin_invoke");){
                try {
                    List<DynamicObject> dynamicObjects = Arrays.stream(tasks).collect(Collectors.toList());
                    Map<Long, ApiResult> result = instance.invoke(dynamicObjects);
                    endTime = new Date();
                    for (Map.Entry<Long, ApiResult> entry : result.entrySet()) {
                        ApiResult apiResult = entry.getValue();
                        Long taskId = entry.getKey();
                        if (apiResult.getSuccess()) {
                            updateParams.add(new Object[]{traceId, startTime, endTime, userId, ip, "SUC", "", "", taskId});
                            continue;
                        }
                        String errorMsg = StringUtils.isNotEmpty((String)apiResult.getMessage()) && apiResult.getMessage().length() > 200 ? apiResult.getMessage().substring(0, 200) : apiResult.getMessage() + "";
                        updateParams.add(new Object[]{traceId, startTime, endTime, userId, ip, "FAIL", errorMsg, apiResult.getMessage() + "", taskId});
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    endTime = new Date();
                    for (DynamicObject subTask : tasks) {
                        Long taskId = subTask.getLong("id");
                        String errMsg = ApiServiceHelper.parseMsg(e, 1600);
                        String errorMsg = StringUtils.isNotEmpty((String)errMsg) && errMsg.length() > 200 ? errMsg.substring(0, 200) : errMsg;
                        updateParams.add(new Object[]{traceId, startTime, endTime, userId, ip, "FAIL", errorMsg, errMsg, taskId});
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(updateParams)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_apisubtask set ftraceid = ?,fstartdate = ?,fenddate = ?,fuser = ?,fip =?,fcount = fcount + 1,fstatus=?,fresult = ?,fresult_tag = ? where fid = ?", updateParams);
            }
            ApiServiceHelper.updateMainTask(tasks, endTime);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u4ee3\u7406\u63a5\u53e3\u6267\u884c\u5f02\u5e38:{0}", (String)"ApiServiceHelper_0", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[]{e.toString()});
            throw new KDBizException((Throwable)e, new ErrorCode("mpscmm.msbd", msg), new Object[0]);
        }
    }

    private static void updateMainTask(DynamicObject[] tasks, Date endTime) {
        Set ptaskIds = Arrays.stream(tasks).map(item -> item.getLong("ptask.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("ptask.id", "in", ptaskIds).and("status", "not in", (Object)new String[]{"WAIT,EXEC"});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"updateMainTask", (String)"msbd_apisubtask", (String)"id,ptask.id ptaskid,status", (QFilter[])qFilter.toArray(), (String)"id");
        DataSet sucData = dataSet.copy().filter("status = 'SUC'").groupBy(new String[]{PTASKID}).finish();
        dataSet = dataSet.filter("status = 'FAIL'").groupBy(new String[]{PTASKID}).finish();
        HashSet<Long> sucPtaskIds = new HashSet<Long>();
        HashSet<Long> failPtaskIds = new HashSet<Long>();
        for (Row row : sucData) {
            sucPtaskIds.add(row.getLong(PTASKID));
        }
        for (Row row : dataSet) {
            failPtaskIds.add(row.getLong(PTASKID));
        }
        ArrayList<Object[]> pTaskParams = new ArrayList<Object[]>(16);
        for (Long id : ptaskIds) {
            if (sucPtaskIds.contains(id) && failPtaskIds.contains(id)) {
                pTaskParams.add(new Object[]{"PARTSUC", endTime, ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u5b50\u4efb\u52a1,\u6210\u529f\u4efb\u52a1\u6570\uff1a{0}\uff0c\u5931\u8d25\u4efb\u52a1\u6570\uff1a{1}\uff0c\u8bf7\u67e5\u770b\u4efb\u52a1\u65e5\u5fd7\u3002", (String)"ApiServiceHelper_5", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[]{sucPtaskIds.size(), failPtaskIds.size()}), id});
                continue;
            }
            if (sucPtaskIds.contains(id)) {
                pTaskParams.add(new Object[]{"SUC", endTime, ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ApiServiceHelper_4", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[0]), id});
                continue;
            }
            if (!failPtaskIds.contains(id)) continue;
            pTaskParams.add(new Object[]{"FAIL", endTime, ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\u5b50\u4efb\u52a1\uff0c\u8bf7\u67e5\u770b\u4efb\u52a1\u65e5\u5fd7\u3002", (String)"ApiServiceHelper_6", (String)MPSCMM_MSBD_SCMCAPI, (Object[])new Object[0]), id});
        }
        if (CollectionUtils.isNotEmpty(pTaskParams)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"update t_msbd_apimaintask set fstatus=?,fenddate = ?,fresponseparam = ? where fid = ?", pTaskParams);
        }
    }

    private static void updateTaskExecuting(DynamicObject[] tasks) {
        List taskIds = Arrays.stream(tasks).map(item -> item.getString("id")).collect(Collectors.toList());
        String idStr = String.join((CharSequence)",", taskIds);
        StringBuilder sql = new StringBuilder();
        sql.append("update t_msbd_apisubtask set fstatus = 'EXEC' where fid in (").append(idStr).append(")");
        try (TXHandle tx = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString());
        }
    }

    private static String parseMsg(Throwable e, int size) {
        StringBuilder msgStr = new StringBuilder();
        e = e.getCause() == null ? e : e.getCause();
        msgStr.append(e.getMessage());
        msgStr.append("\r\n").append(e.getClass().getName());
        StackTraceElement[] stackTrace = e.getStackTrace();
        int len = stackTrace.length;
        for (int i = 0; i < len; ++i) {
            if (msgStr.length() > size) {
                msgStr.setLength(size);
                break;
            }
            msgStr.append("\r\n at ").append(stackTrace[i]);
        }
        if (msgStr.length() > size) {
            msgStr.setLength(size);
        }
        return msgStr.toString();
    }

    public List<Long> getSubTaskTxRecord(List<Long> subTaskIds) {
        this.createTable();
        ArrayList<Long> existSubTaskId = new ArrayList<Long>();
        List taskIds = subTaskIds.stream().map(item -> item.toString()).collect(Collectors.toList());
        String idStr = String.join((CharSequence)",", taskIds);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select fid from T_MSBD_API_ASYNC_INFO where fid in (").append(idStr).append(")");
        DataSet dataSet = DB.queryDataSet((String)"checkTxRecord", (DBRoute)DBRoute.of((String)"scm"), (String)sqlBuilder.toString());
        if (dataSet.hasNext()) {
            for (Row row : dataSet) {
                existSubTaskId.add(row.getLong("fid"));
            }
        }
        return existSubTaskId;
    }

    public void createTxRecord(List<Long> subTaskIds) {
        this.createTable();
        ArrayList<Object[]> params = new ArrayList<Object[]>(subTaskIds.size());
        for (Long subTaskId : subTaskIds) {
            params.add(new Object[]{subTaskId});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)INSERT_SQL, params);
    }

    private void createTable() {
        DBRoute dbRoute = DBRoute.of((String)"scm");
        try (TXHandle tx = TX.notSupported((String)"ApiSubTaskTx.createTB");){
            if (!DB.exitsTable((DBRoute)dbRoute, (String)API_ASYNC_INFO)) {
                DB.execute((DBRoute)dbRoute, (String)CREATE_TABLE_SQL);
                DB.execute((DBRoute)dbRoute, (String)ALTER_TABLE_PK);
            }
        }
    }
}

