/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.function.callback;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;

public class InspectSuccessCallBack
implements AlgoXCallBack {
    private static final Log logger = LogFactory.getLog(InspectSuccessCallBack.class);
    private Long entryId;

    public InspectSuccessCallBack(Long entryId) {
        this.entryId = entryId;
    }

    public void onFinished() {
        try (TXHandle tx = TX.requiresNew((String)InspectSuccessCallBack.class.getName());){
            try {
                int expBillNum = 0;
                int expBillEntryNum = 0;
                String sql = "select fobjid,fobjentryid from t_msbd_inspectlogentry_e  where fentryid=?";
                try (DataSet subColl = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"SCM"), (String)sql, (Object[])new Object[]{this.entryId});){
                    DataSet entryColl;
                    String querySql;
                    DataSet transform = subColl.groupBy(new String[]{"fobjid"}).count("fobjentryid").finish();
                    DataSet lastResult = transform.groupBy().count("fobjid").sum("fobjentryid").finish();
                    for (Row row : lastResult) {
                        expBillNum = row.getInteger("fobjid");
                        expBillEntryNum = row.getInteger("fobjentryid");
                    }
                    if (expBillNum > 0) {
                        querySql = "select  finspectdetail  from  t_msbd_inspectlogentry  where  fentryid=?";
                        entryColl = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"SCM"), (String)querySql, (Object[])new Object[]{this.entryId});
                        Throwable throwable = null;
                        try {
                            Object expBillEntryNumBefore;
                            String inspectDetail = null;
                            for (Row row : entryColl) {
                                inspectDetail = row.getString("finspectdetail");
                            }
                            Map formatInspectDetail = (Map)SerializationUtils.fromJsonString(inspectDetail, Map.class);
                            Integer totalBillNum = (Integer)formatInspectDetail.get("inspect_unit_totalnum");
                            Integer totalBillEntryNum = (Integer)formatInspectDetail.get("inspect_unit_totalentrynum");
                            Object expBillNumBefore = formatInspectDetail.get("inspect_unit_expnum");
                            if (expBillNumBefore instanceof Integer) {
                                expBillNum += ((Integer)expBillNumBefore).intValue();
                            }
                            if ((expBillEntryNumBefore = formatInspectDetail.get("inspect_unit_expnum")) instanceof Integer) {
                                expBillEntryNum += ((Integer)expBillEntryNumBefore).intValue();
                            }
                            formatInspectDetail.put("inspect_unit_expnum", expBillNum);
                            formatInspectDetail.put("inspect_unit_expnum", expBillEntryNum);
                            String refreshInspectDetail = SerializationUtils.toJsonString((Object)formatInspectDetail);
                            String successTips = InsExecuteHelper.getSuccessTips(totalBillNum, totalBillEntryNum, expBillNum, expBillEntryNum);
                            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update  t_msbd_inspectlogentry   set  fruningstatus='C',fentrystatus ='C',fruningprocess='W',fdescription=?,finspectdetail=? where fentryid=?", (Object[])new Object[]{successTips, refreshInspectDetail, this.entryId});
                        }
                        catch (Throwable inspectDetail) {
                            throwable = inspectDetail;
                            throw inspectDetail;
                        }
                        finally {
                            if (entryColl != null) {
                                if (throwable != null) {
                                    try {
                                        entryColl.close();
                                    }
                                    catch (Throwable inspectDetail) {
                                        throwable.addSuppressed(inspectDetail);
                                    }
                                } else {
                                    entryColl.close();
                                }
                            }
                        }
                    }
                    querySql = "select  finspectdetail  from  t_msbd_inspectlogentry  where  fentryid=?";
                    entryColl = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"SCM"), (String)querySql, (Object[])new Object[]{this.entryId});
                    Throwable throwable = null;
                    try {
                        String inspectDetail = null;
                        for (Row row : entryColl) {
                            inspectDetail = row.getString("finspectdetail");
                        }
                        Map formatInspectDetail = (Map)SerializationUtils.fromJsonString(inspectDetail, Map.class);
                        Integer totalBillNum = (Integer)formatInspectDetail.get("inspect_unit_totalnum");
                        Integer totalBillEntryNum = (Integer)formatInspectDetail.get("inspect_unit_totalentrynum");
                        String successTips = InsExecuteHelper.getSuccessTips(totalBillNum, totalBillEntryNum, expBillNum, expBillEntryNum);
                        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update  t_msbd_inspectlogentry   set  fruningstatus='C',fentrystatus ='D',fruningprocess='W',fdescription=? where fentryid=?", (Object[])new Object[]{successTips, this.entryId});
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (entryColl != null) {
                            if (throwable != null) {
                                try {
                                    entryColl.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                entryColl.close();
                            }
                        }
                    }
                    this.saveLogHead();
                }
            }
            catch (Exception exp) {
                tx.markRollback();
                logger.error("AlgoX\u6210\u529f\u56de\u8c03\u51fa\u73b0\u4e86\u5f02\u5e38:{}", (Object)Arrays.toString(exp.getStackTrace()));
            }
        }
    }

    public void onFailed(Exception e) {
        try (TXHandle tx = TX.requiresNew((String)InspectSuccessCallBack.class.getName());){
            try {
                String mainMsg = e.toString();
                String stackTrace = Arrays.toString(e.getStackTrace());
                DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"update  t_msbd_inspectlogentry   set  fruningstatus='C',fruningprocess='W',fentrystatus ='B',fexcpstacktrace_tag=? where fentryid=?", (Object[])new Object[]{mainMsg.concat(stackTrace), this.entryId});
                this.saveLogHead();
            }
            catch (Exception exp) {
                tx.markRollback();
                logger.error("AlgoX\u5931\u8d25\u56de\u8c03\u6301\u4e45\u5316\u65f6\u5f02\u5e38:{}", (Object)Arrays.toString(exp.getStackTrace()));
            }
        }
    }

    private void saveLogHead() {
        DynamicObject inspectLog = BusinessDataServiceHelper.loadSingle((String)"msbd_inspectlog", (String)"endtime,exestatus,entryentity.runingstatus", (QFilter[])new QFilter("entryentity.id", "=", (Object)this.entryId).toArray());
        DynamicObjectCollection entryEntity = inspectLog.getDynamicObjectCollection("entryentity");
        boolean flag = true;
        for (DynamicObject entry : entryEntity) {
            String runningStatus = entry.getString("runingstatus");
            if (!"B".equals(runningStatus)) continue;
            flag = false;
        }
        if (flag) {
            inspectLog.set("endtime", (Object)new Date());
            inspectLog.set("exestatus", (Object)"B");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inspectLog});
        }
    }
}

