/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.function.reduce;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.util.DateUtils;
import kd.mpscmm.msbd.algox.common.util.ReflectUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;

public class IuPluginCalculateFunction
extends GroupReduceFunction {
    private static final Log logger = LogFactory.getLog(IuPluginCalculateFunction.class);
    private AbstractDmfPlugin extPluginSerivce;
    private String inspectEntity;
    private String billEntrySympol;
    private String queryFieldKeys;
    private Long entryId;
    private long defaultBatchMaxNum;
    private Long inspectUnitId;
    private int errorNum = 0;

    public IuPluginCalculateFunction(AbstractDmfPlugin extPluginSerivce, String inspectEntity, String queryFieldKeys, Long entryId, long defaultBatchMaxNum, String billEntrySympol) {
        this.extPluginSerivce = extPluginSerivce;
        this.inspectEntity = inspectEntity;
        this.queryFieldKeys = queryFieldKeys;
        this.entryId = entryId;
        this.defaultBatchMaxNum = defaultBatchMaxNum;
        this.billEntrySympol = billEntrySympol;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        int count = 0;
        for (RowX rowx : iterable) {
            Long id = (Long)rowx.get(0);
            idSet.add(id);
            if ((long)(++count) < this.defaultBatchMaxNum) continue;
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
            count = 0;
        }
        if (idSet.size() > 0) {
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
        }
    }

    private void calculateExtLogic(Set<Long> idSet, Collector collector) {
        this.getMulTermination();
        if (this.errorNum >= 10000) {
            return;
        }
        if (this.billEntrySympol == null || "".equals(this.billEntrySympol)) {
            int errorSize = this.exeSingleExtLogic(idSet, collector);
            this.errorNum += errorSize;
        } else {
            String pluginName = this.extPluginSerivce.getClass().getName();
            try (DataSet entryDataSet = this.queryDataSet(this.inspectEntity, String.format("id, %s.id entryid", this.billEntrySympol), new QFilter("id", "in", idSet).toArray());){
                DataSet totalEntryIdDataSet = entryDataSet.copy();
                int totalEntryIdNum = totalEntryIdDataSet.count("entryid", false);
                totalEntryIdDataSet.close();
                if (totalEntryIdNum < 10000) {
                    int errorSize = this.exeSingleExtLogic(idSet, collector);
                    this.errorNum += errorSize;
                    logger.info("singleExeData->\u5305\u542b\u5206\u5f55\u4f46\u662f\u4e0d\u5206\u6279\u6b21,\u5de1\u68c0\u7c7b\u578b\u662fDataSet\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
                } else {
                    Set<Long> singleBatchId;
                    int num;
                    DataSet entryIdDataSet = entryDataSet.groupBy(new String[]{"id"}).count("entryid").finish();
                    if (entryIdDataSet == null) {
                        return;
                    }
                    List<Set<Long>> batchIdList = this.getBatchIdList(entryIdDataSet);
                    if (entryIdDataSet != null) {
                        entryIdDataSet.close();
                    }
                    Iterator<Set<Long>> batchIdIterator = batchIdList.iterator();
                    int totalNum = 0;
                    while (batchIdIterator.hasNext() && (totalNum += (num = this.exeSingleExtLogic(singleBatchId = batchIdIterator.next(), collector))) < 10000) {
                        batchIdIterator.remove();
                    }
                    this.errorNum += totalNum;
                    logger.info("singleExeData->\u5206\u5f55\u5206\u6279\u6b21\u6570\u91cf\uff1a{},\u5de1\u68c0\u7c7b\u578b\u662fDataSet\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", new Object[]{batchIdList.size(), pluginName, DateUtils.getCurrentDateStr()});
                    batchIdList = null;
                }
            }
        }
    }

    private int exeSingleExtLogic(Set<Long> idSet, Collector collector) {
        QFilter[] filterIdArray = new QFilter("id", "in", idSet).toArray();
        try (DataSet partitionDataset = this.queryDataSet(this.inspectEntity, this.queryFieldKeys, filterIdArray);){
            List operateErrorInfoList = this.extPluginSerivce.exeInspectUnitExtPlugin(partitionDataset);
            int expNumSize = operateErrorInfoList.size();
            if (expNumSize <= 0) {
                int n = 0;
                return n;
            }
            if (operateErrorInfoList.size() >= 10000) {
                operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
            }
            operateErrorInfoList.stream().sorted(Comparator.comparing(OperateInfo::getTitle));
            int subEntrySize = operateErrorInfoList.size();
            int indexSeq = 1;
            long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_inspectlogentry_e", (int)subEntrySize);
            for (int i = 0; i < subEntrySize; ++i) {
                OperateErrorInfo result = (OperateErrorInfo)operateErrorInfoList.get(i);
                Object[] subEntry = new Object[8];
                subEntry[0] = detailPkIdList[i];
                subEntry[1] = this.entryId;
                subEntry[2] = indexSeq;
                subEntry[3] = result.getPkValue();
                Object[] reflectFieldsValue = ReflectUtils.reflectFieldsValue(result, "entryId");
                subEntry[4] = reflectFieldsValue[0] instanceof Long ? reflectFieldsValue[0] : Long.valueOf(0L);
                subEntry[5] = result.getEntityKey();
                String msg = "";
                msg = result.getMessage().length() > 512 ? result.getMessage().substring(0, 480) : result.getMessage();
                subEntry[6] = msg;
                String title = result.getTitle();
                if (title == null) {
                    title = "";
                }
                subEntry[7] = title;
                collector.collect(new RowX(subEntry));
                ++indexSeq;
            }
            int n = expNumSize;
            return n;
        }
    }

    public RowMeta getResultRowMeta() {
        Field fdetailid = new Field("fdetailid", (DataType)DataType.LongType);
        Field fentryid = new Field("fentryid", (DataType)DataType.LongType);
        Field fseq = new Field("fseq", (DataType)DataType.IntegerType);
        Field fobjid = new Field("fobjid", (DataType)DataType.LongType);
        Field fobjentryid = new Field("fobjentryid", (DataType)DataType.LongType);
        Field fobjtypeid = new Field("fobjtypeid", (DataType)DataType.StringType);
        Field fobjdes = new Field("fobjdes", (DataType)DataType.StringType);
        Field fbizuniquesympol = new Field("fbizuniquesympol", (DataType)DataType.StringType);
        RowMeta rowMeta = new RowMeta(new Field[]{fdetailid, fentryid, fseq, fobjid, fobjentryid, fobjtypeid, fobjdes, fbizuniquesympol});
        return rowMeta;
    }

    private IuPluginCalculateFunction() {
    }

    public DataSet queryDataSet(String inspectEntity, String queryFieldKeys, QFilter[] qFilter) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)inspectEntity, (String)queryFieldKeys, (QFilter[])qFilter, null);
    }

    private List<Set<Long>> getBatchIdList(DataSet entryIdDataSet) {
        ArrayList<Set<Long>> partition = new ArrayList<Set<Long>>(16);
        HashSet<Long> maxNum = new HashSet<Long>(16);
        try (DataSet maxNumDataSet = entryIdDataSet.copy();){
            for (Row row : maxNumDataSet) {
                int entryIdCount = row.getInteger("entryid");
                Long id = row.getLong("id");
                if (entryIdCount < 10000) continue;
                maxNum.add(id);
                HashSet<Long> maxBillIdSet = new HashSet<Long>(16);
                maxBillIdSet.add(id);
                partition.add(maxBillIdSet);
            }
        }
        int m = 0;
        HashSet<Long> addUpIdSet = new HashSet<Long>(16);
        for (Row row : entryIdDataSet) {
            Long id = row.getLong("id");
            if (maxNum.contains(id)) continue;
            int entryIdCount = row.getInteger("entryid");
            if ((m += entryIdCount) < 10000) {
                addUpIdSet.add(id);
                continue;
            }
            partition.add(addUpIdSet);
            addUpIdSet = new HashSet(16);
            addUpIdSet.add(id);
            m = entryIdCount;
        }
        partition.add(addUpIdSet);
        return partition;
    }

    private void getMulTermination() {
        boolean mulTermination = InsExecuteHelper.getMulTermination(this.inspectUnitId);
        if (mulTermination) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"IuPluginCalculateFunction_0", (String)"mpscmm-msbd-algox", (Object[])new Object[0]));
        }
    }

    public void setInspectUnitId(Long inspectUnitId) {
        this.inspectUnitId = inspectUnitId;
    }
}

