/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.logicsexecutor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.algox.business.logicsexecutor.AbstractInspectUnitExecutor;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.info.InspectExtExecutorInfo;
import kd.mpscmm.msbd.algox.common.info.InspectLogToolsInfo;
import kd.mpscmm.msbd.algox.common.util.DateUtils;
import kd.mpscmm.msbd.algox.common.util.InspectUnitContext;

public class IuMicroServiceExecutor
extends AbstractInspectUnitExecutor {
    private static final Log logger = LogFactory.getLog(IuMicroServiceExecutor.class);

    public IuMicroServiceExecutor(InspectUnitContext inspectUnitContext) {
        super(inspectUnitContext);
    }

    @Override
    public InspectExtExecutorInfo executeUnitLogic(DynamicObject inspectUnit, List<QFilter> inspectUnitQFilter) {
        DynamicObjectCollection msEntryRows = inspectUnit.getDynamicObjectCollection("msentry");
        String entryNumber = inspectUnit.getDataEntityType().getName();
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList(16);
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        for (DynamicObject row : msEntryRows) {
            boolean mulTermination = InsExecuteHelper.getMulTermination(inspectUnitId);
            if (mulTermination) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"IuMicroServiceExecutor_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
            DynamicObject bizAppObj = row.getDynamicObject("bizappid");
            String bizApp = bizAppObj.getString("number").toLowerCase();
            String bizCloud = row.getString("bizcloud");
            String msName = row.getString("msname");
            String msMethodName = row.getString("msmethodname");
            String msParameterArray = row.getString("msparameterarray");
            boolean msEnable = row.getBoolean("msenable");
            if (!msEnable) continue;
            String result = this.invokeMsResult(bizCloud, bizApp, msName, msMethodName, msParameterArray);
            OperateErrorInfo operateerrorinfo = new OperateErrorInfo("DmfUnitService.executeMicroServices", ErrorLevel.Error, (Object)0L, (Object)0L);
            operateerrorinfo.setEntityKey(entryNumber);
            operateerrorinfo.setMessage(result);
            operateErrorInfoList.add(operateerrorinfo);
        }
        if (operateErrorInfoList.size() > 100) {
            operateErrorInfoList = operateErrorInfoList.subList(0, 100);
        }
        Long entryId = this.inspectUnitContext.getLogEntryIdInspectId().get(inspectUnitId);
        Integer fseq = InsExecuteHelper.getLogSubEntrySeq(this.getClass().getName(), entryId);
        InspectLogToolsInfo.syncSaveExpEntry(operateErrorInfoList, entryId, fseq);
        return InspectExtExecutorInfo.assertInsResult(0, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String invokeMsResult(String bizCloud, String bizApp, String msName, String msMethodName, String msParameterArray) {
        try {
            String parameterVal;
            ArrayList<Object> parameterArray = new ArrayList<Object>();
            JSONArray parseArray = JSONObject.parseArray((String)msParameterArray);
            block33: for (int i = 0; i < parseArray.size(); ++i) {
                Map parameter = (Map)parseArray.get(i);
                String parameterType = (String)parameter.get("type");
                parameterVal = (String)parameter.get("val");
                switch (parameterType) {
                    case "string": {
                        parameterArray.add(parameterVal);
                        continue block33;
                    }
                    case "int": {
                        Integer factIntValue = Integer.valueOf(parameterVal);
                        parameterArray.add(factIntValue);
                        continue block33;
                    }
                    case "double": {
                        Double factDoubleValue = Double.valueOf(parameterVal);
                        parameterArray.add(factDoubleValue);
                        continue block33;
                    }
                    case "long": {
                        Long factLongValue = Long.valueOf(parameterVal);
                        parameterArray.add(factLongValue);
                        continue block33;
                    }
                    case "boolean": {
                        Boolean factBooleanValue = Boolean.valueOf(parameterVal);
                        parameterArray.add(factBooleanValue);
                        continue block33;
                    }
                    case "datetime": {
                        Date factDatetimeValue = DateUtils.parse(parameterVal);
                        parameterArray.add(factDatetimeValue);
                        continue block33;
                    }
                }
            }
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)IuMicroServiceExecutor.class.getName());){
                Object result = DispatchServiceHelper.invokeBizService((String)bizCloud, (String)bizApp, (String)msName, (String)msMethodName, (Object[])parameterArray.toArray());
                if (result == null) return "noexist return value";
                parameterVal = String.valueOf(result);
                return parameterVal;
            }
            catch (Exception exp) {
                tx.markRollback();
                String expMsg = Arrays.toString(exp.getStackTrace());
                logger.error("micro services exist exception:{}", (Object)expMsg);
                String string = expMsg;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            String msg = Arrays.toString(e.getStackTrace());
            logger.error("micro services exist exception:{}", (Object)msg);
            throw new KDBizException(msg);
        }
    }
}

