/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.algox.business.logicsexecutor.IIuUnitLogic;
import kd.mpscmm.msbd.algox.business.logicsexecutor.IuPluginExecutor;
import kd.mpscmm.msbd.algox.business.logicsexecutor.IuValidExecutor;
import kd.mpscmm.msbd.algox.business.service.IInspectUnitService;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.info.InspectExtExecutorInfo;
import kd.mpscmm.msbd.algox.common.info.InspectUnitResultInfo;
import kd.mpscmm.msbd.algox.common.util.InspectUnitContext;

public class InspectUnitService
implements IInspectUnitService {
    private static final Log logger = LogFactory.getLog(InspectUnitService.class);
    private List<IIuUnitLogic> LogicsExecutor = new ArrayList<IIuUnitLogic>();

    protected InspectUnitService(InspectUnitContext inspectUnitContext) {
        this.LogicsExecutor.addAll(IIuUnitLogic.create(inspectUnitContext));
    }

    protected InspectUnitService() {
    }

    @Override
    public InspectUnitResultInfo executeDmfUnit(DynamicObject inspectUnit) {
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        String number = inspectUnit.getString("number");
        try {
            String areaJSON = inspectUnit.getString("areajson_tag");
            String entity = (String)inspectUnit.getDynamicObject("entity").getPkValue();
            List<QFilter> inspectUnitQFilter = InsExecuteHelper.getQFilterList(areaJSON, entity);
            int totalInspectBillNum = 0;
            int totalInspectBillEntryNum = 0;
            int isAlgoX = 0;
            for (IIuUnitLogic logicsExecutor : this.LogicsExecutor) {
                InspectExtExecutorInfo inspectExtExecutorInfo;
                DynamicObjectCollection pluginEntry;
                DynamicObjectCollection msEntry;
                long validEnableNum;
                int size;
                boolean mulTermination = InsExecuteHelper.getMulTermination(inspectUnitId);
                if (mulTermination) {
                    return InspectUnitResultInfo.acceptExceptionStackTrace(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"InspectUnitService_0", (String)"mpscmm-msbd-algox", (Object[])new Object[0]), inspectUnitId);
                }
                if (logicsExecutor instanceof IuValidExecutor) {
                    DynamicObjectCollection validEntity = inspectUnit.getDynamicObjectCollection("validentity");
                    size = validEntity.size();
                    if (size <= 0 || (validEnableNum = validEntity.stream().filter(row -> row.getBoolean("validenable")).count()) <= 0L) {
                        continue;
                    }
                } else if (!(logicsExecutor instanceof IuPluginExecutor) ? (size = (msEntry = inspectUnit.getDynamicObjectCollection("msentry")).size()) <= 0 || (validEnableNum = msEntry.stream().filter(row -> row.getBoolean("msenable")).count()) <= 0L : (size = (pluginEntry = inspectUnit.getDynamicObjectCollection("pluginentry")).size()) <= 0 || (validEnableNum = pluginEntry.stream().filter(row -> row.getBoolean("pluginenable")).count()) <= 0L) continue;
                if ((inspectExtExecutorInfo = logicsExecutor.executeUnitLogic(inspectUnit, inspectUnitQFilter)).getIsAlgoX() == 1) {
                    isAlgoX = 1;
                }
                totalInspectBillNum += inspectExtExecutorInfo.getTotalBillNum();
                totalInspectBillEntryNum += inspectExtExecutorInfo.getTotalBillEntryNum();
            }
            inspectUnitQFilter = null;
            return InspectUnitResultInfo.acceptInspectUnitResult(isAlgoX, totalInspectBillNum, totalInspectBillEntryNum);
        }
        catch (Throwable e) {
            String mainMsg = e.toString();
            String stackTrace = Arrays.toString(e.getStackTrace());
            logger.error(ResManager.loadKDString((String)"\u7f16\u7801\uff1a{}\u7684\u5de1\u68c0\u6a21\u578b\u6267\u884c\u65f6\u51fa\u73b0\u4e86\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a{}", (String)"DmfUnitService_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), (Object)number, (Object)stackTrace);
            return InspectUnitResultInfo.acceptExceptionStackTrace(mainMsg.concat(stackTrace), inspectUnitId);
        }
    }
}

