/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.business.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.threads.ThreadPool;
import kd.mpscmm.msbd.algox.business.service.AbstractInspectPlanService;
import kd.mpscmm.msbd.algox.business.service.InspectUnitService;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;
import kd.mpscmm.msbd.algox.common.helper.InsThreadPoolsHelper;
import kd.mpscmm.msbd.algox.common.info.InspectLogToolsInfo;
import kd.mpscmm.msbd.algox.common.info.InspectUnitResultInfo;
import kd.mpscmm.msbd.algox.common.util.DataInspectContext;
import kd.mpscmm.msbd.algox.common.util.InspectUnitContext;

public class ParallelInspectPlanService
extends AbstractInspectPlanService {
    private static final Log logger = LogFactory.getLog(ParallelInspectPlanService.class);

    @Override
    public List<InspectUnitResultInfo> executeInspectUnits(DynamicObject[] inspectUnitList, List<QFilter> inspectPlanQFilter, long timeOut, long batchMaxNum, ShardingUtil.BroadcastVO broadcast) {
        logger.info("ParallelInspectPlanService\u5f00\u59cb\u5e76\u884c\u6267\u884c{}\u4e2a\u5de1\u68c0\u6a21\u578b\uff0c\u8d85\u65f6\u65f6\u95f4\u662f\uff1a{}", (Object)inspectUnitList.length, (Object)timeOut);
        DataInspectContext dataInspectContext = DataInspectContext.get();
        InspectLogToolsInfo inspectLogToolsInfo = dataInspectContext.getInspectLogToolsInfo();
        long maxInspectNum = dataInspectContext.getMaxInspectNum();
        long timeOutSeconds = timeOut == 0L ? 1800L : timeOut * 60L;
        InspectUnitContext inspectUnitContext = new InspectUnitContext(inspectPlanQFilter, maxInspectNum, batchMaxNum, timeOutSeconds, broadcast, new HashMap(16));
        this.initLogToolsEntry(inspectLogToolsInfo, inspectUnitContext);
        InspectUnitService inspectUnitService = new InspectUnitService(inspectUnitContext);
        ThreadPool threadPoolExecutor = InsThreadPoolsHelper.getInspectThreadPool();
        long maxParallelNum = dataInspectContext.getMaxParallelNum();
        List<List<DynamicObject>> partition = InsExecuteHelper.partition(Arrays.asList(inspectUnitList), (int)maxParallelNum);
        boolean isLastBatchFlag = false;
        for (int m = 0; m < partition.size(); ++m) {
            if (m == partition.size() - 1) {
                isLastBatchFlag = true;
            }
            List<DynamicObject> partitionInspectUnitList = partition.get(m);
            LinkedHashMap<Long, Future> inspectUnitResultCollect = new LinkedHashMap<Long, Future>(16);
            for (DynamicObject inspectUnit : partitionInspectUnitList) {
                Long inspectUnitId = (Long)inspectUnit.getPkValue();
                inspectLogToolsInfo.beginRun(inspectUnitId);
                Future result = threadPoolExecutor.submit((Callable)new AbstractInspectPlanService.InspectUnitCallable(inspectUnitService, inspectUnit));
                inspectUnitResultCollect.put(inspectUnitId, result);
            }
            int i = 0;
            boolean isLastInspectUnitFlag = false;
            for (Map.Entry entry : inspectUnitResultCollect.entrySet()) {
                Future inspectUnitResult = (Future)entry.getValue();
                Long inspectUnitId = (Long)entry.getKey();
                if (i == inspectUnitResultCollect.size() - 1 && isLastBatchFlag) {
                    isLastInspectUnitFlag = true;
                }
                try {
                    InspectUnitResultInfo inspectUnitResultInfo = (InspectUnitResultInfo)inspectUnitResult.get(timeOutSeconds, TimeUnit.SECONDS);
                    String exceptionStackTrace = inspectUnitResultInfo.getExceptionStackTrace();
                    if (exceptionStackTrace != null) {
                        inspectLogToolsInfo.collectExtExcpMsg(inspectUnitId, exceptionStackTrace, isLastInspectUnitFlag);
                    } else {
                        inspectLogToolsInfo.endRun(inspectUnitId, inspectUnitResultInfo.getTotalBillNum(), inspectUnitResultInfo.getTotalBillEntryNum(), isLastInspectUnitFlag, inspectUnitResultInfo.getIsAlgoX());
                    }
                    inspectUnitResult = null;
                    inspectUnitId = null;
                    inspectUnitResultInfo = null;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    inspectUnitResult.cancel(true);
                    String expMsg = String.format(ResManager.loadKDString((String)"\u5b50\u7ebf\u7a0b\u6267\u884c\u8d85\u65f6%s", (String)"ParallelInspectPlanService_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), e.toString().concat(Arrays.toString(e.getStackTrace())));
                    inspectLogToolsInfo.collectExtExcpMsg(inspectUnitId, expMsg, isLastInspectUnitFlag);
                    logger.error("exists  TimeoutException:{}", (Object)e.toString().concat(Arrays.toString(e.getStackTrace())));
                    inspectUnitResult = null;
                    inspectUnitId = null;
                }
                ++i;
            }
        }
        inspectUnitContext = null;
        inspectUnitService = null;
        inspectUnitList = null;
        partition = null;
        inspectPlanQFilter = null;
        return Collections.emptyList();
    }
}

