/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.algox.mserviceapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.algox.business.service.IInspectPlanService;
import kd.mpscmm.msbd.algox.business.service.ParallelInspectPlanService;
import kd.mpscmm.msbd.algox.business.service.SerialInspectPlanService;
import kd.mpscmm.msbd.algox.common.helper.InsExecuteHelper;

public interface InspectTaskService {
    public void execute(RequestContext var1, Map<String, Object> var2) throws KDException;

    default public IInspectPlanService createService(boolean runConCurrent) {
        if (runConCurrent) {
            return new ParallelInspectPlanService();
        }
        return new SerialInspectPlanService();
    }

    default public List<QFilter> getInspectPlanQFilter(DynamicObject inspectPlan) {
        DynamicObject inspectJob = inspectPlan.getDynamicObject("inspectjob");
        Set insUnitSet = inspectJob.getDynamicObjectCollection("entry").stream().map(row -> (Long)row.getDynamicObject("inspectunit").getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", insUnitSet);
        HashSet entityNumberSet = new HashSet();
        try (DataSet inspectUnit = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"msbd_inspectunit", (String)"entity.number", (QFilter[])qFilter.toArray(), null);){
            inspectUnit.forEach(row -> entityNumberSet.add(row.getString("entity.number")));
        }
        String qfilterEntity = null;
        qfilterEntity = entityNumberSet.size() != 1 ? (String)inspectPlan.getDynamicObject("entity").getPkValue() : (String)entityNumberSet.iterator().next();
        List<QFilter> qFilterList = InsExecuteHelper.getQFilterList(inspectPlan.getString("areajson_tag"), qfilterEntity);
        return qFilterList;
    }

    default public List<Long> getUnitIdList(DynamicObject inspectJob) {
        return inspectJob.getDynamicObjectCollection("entry").stream().filter(row -> row.getBoolean("dmfunitenable")).map(entry -> (Long)entry.getDynamicObject("inspectunit").getPkValue()).distinct().collect(Collectors.toList());
    }

    default public DynamicObject[] getEnableInspectUnit(List<Long> dmfUnitIdList, DynamicObject[] inspectUnitList) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(inspectUnitList.length);
        block0: for (int i = 0; i < dmfUnitIdList.size(); ++i) {
            Long unitId = dmfUnitIdList.get(i);
            for (DynamicObject obj : inspectUnitList) {
                Long pkValue = (Long)obj.getPkValue();
                if (!unitId.equals(pkValue)) continue;
                resultList.add(obj);
                continue block0;
            }
        }
        List<DynamicObject> dmfUnitList = Arrays.stream(resultList.toArray(new DynamicObject[0])).filter(row -> row.getBoolean("enable")).collect(Collectors.toList());
        return dmfUnitList.toArray(new DynamicObject[0]);
    }

    default public boolean isSendMsg(DynamicObject logResult) {
        boolean flag = false;
        for (DynamicObject resultEntry : logResult.getDynamicObjectCollection("entryentity")) {
            String entryStatus = resultEntry.getString("entrystatus");
            if (!"B".equals(entryStatus) && !"C".equals(entryStatus)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

