/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.XlogDirector;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.BatchXlogBuilder;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.ReviseBillComparator;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class BatXBillHelper {
    public static String[] getUnEnableProps(String entityType) {
        DynamicObjectCollection mappingEntrys;
        ArrayList<String> unEnableProps = new ArrayList<String>(8);
        if (StringUtils.isBlank((CharSequence)entityType)) {
            return unEnableProps.toArray(new String[0]);
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4BatchXBill(entityType);
        if (changeModel != null && (mappingEntrys = changeModel.getDynamicObjectCollection("mappingentity")) != null && mappingEntrys.size() > 0) {
            for (DynamicObject entry : mappingEntrys) {
                String targetField;
                Boolean canEnable = entry.getBoolean("canenable");
                if (!Boolean.FALSE.equals(canEnable) || !StringUtils.isNotBlank((CharSequence)(targetField = entry.getString("targetfield"))) || "xsbillno".equals(targetField)) continue;
                unEnableProps.add(targetField);
            }
        }
        return unEnableProps.toArray(new String[0]);
    }

    public static String getSrcFieldsByChangeModel(DynamicObject changeModel) {
        if (changeModel == null) {
            return "";
        }
        HashSet<String> srcFields = new HashSet<String>(8);
        DynamicObjectCollection mappingEntrys = changeModel.getDynamicObjectCollection("mappingentity");
        if (mappingEntrys != null && mappingEntrys.size() > 0) {
            for (DynamicObject entry : mappingEntrys) {
                String srcField = entry.getString("sourcefield");
                if (!StringUtils.isNotBlank((CharSequence)srcField)) continue;
                srcFields.add(srcField);
            }
        }
        return String.join((CharSequence)",", srcFields);
    }

    public static void recChangeLog(List<DynamicObject> srcBills, List<DynamicObject> changeBills, DynamicObject batchBill) {
        if (srcBills == null || changeBills == null) {
            return;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4BatchSrcBill(srcBills.get(0).getDataEntityType().getName());
        if (changeModel == null) {
            return;
        }
        Set<String> needLogFields = BatXBillHelper.getNeedLogFields(changeModel);
        String xLogEntity = ChangeModelHelper.getXlogEntityId(changeModel);
        HashMap<Long, DynamicObject> changeBillMap = new HashMap<Long, DynamicObject>(changeBills.size());
        for (DynamicObject dynamicObject : changeBills) {
            changeBillMap.put((Long)dynamicObject.getPkValue(), dynamicObject);
        }
        ArrayList<Object> ids = new ArrayList<Object>(srcBills.size());
        for (DynamicObject bill : srcBills) {
            ids.add(bill.getPkValue());
        }
        Map<Long, Integer> map = XlogHelper.getLatestVersions(ids, xLogEntity);
        ArrayList<DynamicObject> xLogs = new ArrayList<DynamicObject>();
        for (DynamicObject bill : srcBills) {
            DynamicObject changeBill = (DynamicObject)changeBillMap.get(bill.getPkValue());
            if (changeBill == null) continue;
            Integer version = map.get(bill.getPkValue());
            version = version == null ? Integer.valueOf(1) : Integer.valueOf(version + 1);
            BatchXlogBuilder builder = new BatchXlogBuilder(bill, changeBill, xLogEntity, BizChangeStatusEnum.CHANGED.getValue(), needLogFields, version);
            if (batchBill != null) {
                builder.setBatChangeBill(batchBill);
            }
            ReviseBillComparator comparator = new ReviseBillComparator(bill, changeBill, needLogFields);
            XlogDirector director = new XlogDirector(builder, comparator);
            director.constructXlog();
            if (director.getFirstVerXlog() != null) {
                xLogs.add(director.getFirstVerXlog());
            }
            if (director.getCurVerXlog() == null) continue;
            xLogs.add(director.getCurVerXlog());
        }
        SaveServiceHelper.save((DynamicObject[])xLogs.toArray(new DynamicObject[0]));
    }

    public static Set<String> getNeedLogFields(DynamicObject changeModel) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>(8);
        if (changeModel == null) {
            return fields;
        }
        DynamicObjectCollection entrys = changeModel.getDynamicObjectCollection("mappingentity");
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                String field = entry.getString("sourcefield");
                Boolean canLog = entry.getBoolean("canlog");
                if (!StringUtils.isNotBlank((CharSequence)field) || !Boolean.TRUE.equals(canLog)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static void addEntrysByReturnData(IDataModel model, ListSelectedRowCollection returnData) {
        if (returnData == null) {
            return;
        }
        DynamicObject bill = model.getDataEntity(true);
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4BatchXBill(bill.getDynamicObjectType().getName());
        if (changeModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatXBillHelper_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
        }
        DynamicObject srcBill = changeModel.getDynamicObject("srcbill");
        if (srcBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BatXBillHelper_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
        }
        String entryEntityKey = "";
        if (StringUtils.isNotBlank((CharSequence)returnData.get(0).getEntryEntityKey())) {
            entryEntityKey = returnData.get(0).getEntryEntityKey();
        }
        HashSet<Object> pks = new HashSet<Object>(8);
        HashSet<Object> entrypks = new HashSet<Object>(8);
        for (ListSelectedRow row : returnData) {
            pks.add(row.getPrimaryKeyValue());
            entrypks.add(row.getEntryPrimaryKeyValue());
        }
        String srcBillEntityKey = (String)srcBill.getPkValue();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)srcBillEntityKey);
        DynamicObjectCollection mappingEntrys = changeModel.getDynamicObjectCollection("mappingentity");
        HashSet<String> queryProps = new HashSet<String>(8);
        for (DynamicObject entry : mappingEntrys) {
            IDataEntityProperty property;
            String srcField = entry.getString("sourcefield");
            if (!StringUtils.isNotBlank((CharSequence)srcField) || (property = dataEntityType.findProperty(srcField)) == null) continue;
            if (srcBillEntityKey.equals(property.getParent().getName())) {
                queryProps.add(srcField);
                continue;
            }
            if (!entryEntityKey.equals(property.getParent().getName())) continue;
            String[] split = srcField.split("\\.");
            if ("id".equals(srcField = split[split.length - 1])) {
                queryProps.add(entryEntityKey + "." + srcField + " entryid");
                continue;
            }
            queryProps.add(entryEntityKey + "." + srcField + " " + srcField);
        }
        if (pks.size() > 0 && queryProps.size() > 0 && entrypks.size() > 0) {
            QFilter q1 = new QFilter("id", "in", pks);
            QFilter q2 = new QFilter(entryEntityKey + ".id", "in", entrypks);
            q1.and(q2);
            int row = model.getEntryCurrentRowIndex("entryentity");
            DynamicObjectCollection query = QueryServiceHelper.query((String)srcBillEntityKey, (String)String.join((CharSequence)",", queryProps), (QFilter[])new QFilter[]{q1}, (String)(entryEntityKey + ".id asc"));
            if (query != null) {
                DynamicObject srcData;
                int i;
                Long supplierId = null;
                if (srcBillEntityKey.equals("pm_purorderbill")) {
                    for (i = 0; i < query.size(); ++i) {
                        srcData = (DynamicObject)query.get(i);
                        if (srcData.getDynamicObjectType().getProperty("supplier") == null) continue;
                        Long curSupplier = srcData.getLong("supplier");
                        if (supplierId == null) {
                            supplierId = curSupplier;
                            continue;
                        }
                        if (supplierId.equals(curSupplier)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e00\u5f20\u6279\u91cf\u53d8\u66f4\u5355\u53ea\u80fd\u53d8\u66f4\u540c\u4e00\u8ba2\u8d27\u4f9b\u5e94\u5546\u7684\u8ba2\u5355\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatXBillHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                    }
                }
                model.beginInit();
                for (i = 0; i < query.size(); ++i) {
                    int[] rows;
                    if (i != 0 && (rows = model.appendEntryRow("entryentity", row, 1)) != null && rows.length > 0) {
                        row = rows[0];
                    }
                    if ((srcData = (DynamicObject)query.get(i)) == null) continue;
                    for (DynamicObject mappingentry : mappingEntrys) {
                        String srcField = mappingentry.getString("sourcefield");
                        String tarField = mappingentry.getString("targetfield");
                        if (srcField.equals(entryEntityKey + ".id")) {
                            model.setValue(tarField, srcData.get("entryid"), row);
                            continue;
                        }
                        String[] split = srcField.split("\\.");
                        if (!StringUtils.isNotBlank((CharSequence)(srcField = split[split.length - 1])) || !StringUtils.isNotBlank((CharSequence)tarField) || srcData.getDynamicObjectType().getProperty(srcField) == null) continue;
                        model.setValue(tarField, srcData.get(srcField), row);
                    }
                }
                model.endInit();
            }
        }
    }

    public static Set<Long> getSelectRows(OperateOption option) {
        Map variables = option.getVariables();
        String selectRows = "";
        if (variables != null && variables.containsKey("selectRows")) {
            selectRows = option.getVariableValue("selectRows");
        }
        String[] rowStrings = selectRows.split(",");
        HashSet<Long> entryPks = new HashSet<Long>(rowStrings.length);
        for (String rowString : rowStrings) {
            if (!StringUtils.isNotBlank((CharSequence)rowString)) continue;
            entryPks.add(Long.valueOf(rowString));
        }
        return entryPks;
    }
}

