/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;

public class ChangeContentHelper {
    public static void markChangeField(IFormView view, Map<String, Map<String, List<String>>> logFieldsMap) {
        ChangeContentHelper.markChangeFieldByColor(view, logFieldsMap, "#ffebd2");
    }

    public static void clearChangeFieldMark(IFormView view, Map<String, Map<String, List<String>>> logFieldsMap) {
        ChangeContentHelper.markChangeFieldByColor(view, logFieldsMap, null);
    }

    private static void markChangeFieldByColor(IFormView view, Map<String, Map<String, List<String>>> logFieldsMap, String color) {
        if (view == null || logFieldsMap == null) {
            return;
        }
        HashMap fieldMap = new HashMap();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("bc", color);
        fieldMap.put("item", itemMap);
        for (Map.Entry<String, Map<String, List<String>>> row : logFieldsMap.entrySet()) {
            if ("HEAD".equals(row.getKey())) {
                Map<String, List<String>> value = row.getValue();
                if (value == null) continue;
                for (List<String> fields : value.values()) {
                    for (String field : fields) {
                        view.updateControlMetadata(field, fieldMap);
                    }
                }
                continue;
            }
            EntryGrid entryGrid = (EntryGrid)view.getControl(row.getKey());
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            Map<String, List<String>> value = row.getValue();
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            int i = 0;
            for (DynamicObject dyn : dataEntitys) {
                List<String> fields = value.get(String.valueOf(dyn.getPkValue()));
                if (fields != null) {
                    for (String field : fields) {
                        CellStyle item = new CellStyle();
                        item.setFieldKey(field);
                        item.setRow(i);
                        item.setBackColor(color);
                        cellStyles.add(item);
                    }
                }
                ++i;
            }
            entryGrid.setCellStyle(cellStyles);
        }
    }

    public static void markChangeField4XBill(IFormView view, Map<String, Map<String, List<String>>> logFieldsMap) {
        ChangeContentHelper.markChangeFieldByColor4XBill(view, logFieldsMap, "#ffebd2");
    }

    public static void clearChangeFieldMark4XBill(IFormView view, String[] canLogFields) {
        if (view == null || canLogFields == null) {
            return;
        }
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        HashMap fieldMap = new HashMap();
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        itemMap.put("bc", null);
        fieldMap.put("item", itemMap);
        HashMap<String, Set> entryFields = new HashMap<String, Set>(8);
        for (String field : canLogFields) {
            IDataEntityProperty property = dataEntityType.findProperty(field);
            if (property == null) continue;
            IDataEntityType parent = property.getParent();
            if (parent instanceof EntryType) {
                Set fields = entryFields.computeIfAbsent(parent.getName(), k -> new HashSet(8));
                fields.add(field);
                continue;
            }
            view.updateControlMetadata(field, fieldMap);
        }
        for (Map.Entry next : entryFields.entrySet()) {
            Set fields = (Set)next.getValue();
            EntryGrid entryGrid = (EntryGrid)view.getControl((String)next.getKey());
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            for (int i = 0; i < dataEntitys.length; ++i) {
                if (fields == null) continue;
                for (String field : fields) {
                    CellStyle item = new CellStyle();
                    item.setFieldKey(field);
                    item.setRow(i);
                    item.setBackColor(null);
                    cellStyles.add(item);
                }
            }
            entryGrid.setCellStyle(cellStyles);
        }
    }

    private static void markChangeFieldByColor4XBill(IFormView view, Map<String, Map<String, List<String>>> logFieldsMap, String color) {
        if (view == null || logFieldsMap == null) {
            return;
        }
        Map customParams = view.getFormShowParameter().getCustomParams();
        HashMap fieldMap = new HashMap();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("bc", color);
        fieldMap.put("item", itemMap);
        Iterator<Map.Entry<String, Map<String, List<String>>>> it = logFieldsMap.entrySet().iterator();
        Map entryAndOp = (Map)customParams.get("XBillEntryAndOp");
        if (entryAndOp == null) {
            return;
        }
        while (it.hasNext()) {
            String srcId;
            Map.Entry<String, Map<String, List<String>>> row = it.next();
            if ("HEAD".equals(row.getKey())) {
                Map<String, List<String>> value = row.getValue();
                if (value == null) continue;
                for (List<String> fields : value.values()) {
                    for (String field : fields) {
                        view.updateControlMetadata(field, fieldMap);
                    }
                }
                continue;
            }
            EntryGrid entryGrid = (EntryGrid)view.getControl(row.getKey());
            Map map = (Map)entryAndOp.get(row.getKey());
            if (map == null || StringUtils.isBlank((CharSequence)(srcId = (String)map.get("srcid")))) continue;
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            Map<String, List<String>> value = row.getValue();
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            int i = 0;
            for (DynamicObject dyn : dataEntitys) {
                List<String> fields = value.get(String.valueOf(dyn.get(srcId)));
                if (fields != null) {
                    for (String field : fields) {
                        CellStyle item = new CellStyle();
                        item.setFieldKey(field);
                        item.setRow(i);
                        item.setBackColor(color);
                        cellStyles.add(item);
                    }
                }
                ++i;
            }
            entryGrid.setCellStyle(cellStyles);
        }
    }
}

