/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.MetaDataHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XBillLogHelper;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.pojo.ChangeResumeLogFieldInfo;
import kd.mpscmm.msbd.changemodel.common.pojo.ChangeResumeLogInfo;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class ChangeResumeLogHelper {
    private static final String KEY_UPDATE = "*";
    private static final String KEY_ADD = "+";
    private static final String KEY_DELETE = "-";
    private static final String KEY_EQUAL = "=";

    public static String getBilljson(DynamicObject srcBill, DynamicObject xBill) {
        if (srcBill != null && xBill != null) {
            ChangeResumeLogInfo cifo = new ChangeResumeLogInfo();
            cifo.setKeyId(String.valueOf(srcBill.getPkValue()));
            cifo.setKeyName(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f", (String)"ChangeLogHelper_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
            cifo.setKeyLine(null);
            String eq = KEY_EQUAL;
            String[] billfields = ChangeModelHelper.getCanLogProperty((IDataEntityType)xBill.getDynamicObjectType());
            DynamicPropertyCollection srcEntitys = (DynamicPropertyCollection)srcBill.getDataEntityType().getProperties();
            if (!CommonUtils.isNull((Object)billfields)) {
                for (String billfield : billfields) {
                    if (srcEntitys.get((Object)billfield) == null) continue;
                    Object srcField = srcBill.get(billfield);
                    Object newField = xBill.get(billfield);
                    String caption = MetaDataHelper.getPropertyAlias(srcBill.getDataEntityType(), billfield);
                    DynamicProperty srcdp = srcBill.getDynamicObjectType().getProperty(billfield);
                    String oField = ChangeResumeLogHelper.displayFieldValue(srcField, srcdp);
                    String nField = ChangeResumeLogHelper.displayFieldValue(newField, srcdp);
                    boolean equal = ChangeResumeLogHelper.compareField(srcField, newField);
                    ChangeResumeLogFieldInfo logFieldInfo = new ChangeResumeLogFieldInfo();
                    if (equal) {
                        logFieldInfo.setIsequals(KEY_EQUAL);
                    } else {
                        eq = KEY_UPDATE;
                        logFieldInfo.setIsequals(KEY_UPDATE);
                        if (srcField instanceof BigDecimal && newField instanceof BigDecimal || srcdp instanceof IntegerProp) {
                            nField = nField + ChangeResumeLogHelper.compareSizes(srcField, newField);
                        }
                    }
                    logFieldInfo.setFieldname(caption);
                    logFieldInfo.setOldValue(oField);
                    logFieldInfo.setNewValue(nField);
                    cifo.setLogFieldInfo(billfield, logFieldInfo);
                }
            }
            cifo.setKeyFlag(eq);
            return cifo.formatJson();
        }
        return null;
    }

    public static String getBillEntryjson(DynamicObject srcBill, DynamicObject xBill, Map<String, Map<String, String>> xbillEntryAndField) {
        if (srcBill == null || xBill == null) {
            return "";
        }
        Map<String, String[]> allChangeLogProperty = ChangeResumeLogHelper.getAllChangeLogPropertyMap(xBill);
        if (allChangeLogProperty.size() == 0) {
            return "";
        }
        List<EntityType> entryEntities = ChangeResumeLogHelper.getChildEntities(xBill.getDataEntityType());
        StringBuilder billEntrys = new StringBuilder();
        for (EntityType entryEntity : entryEntities) {
            String billEntry;
            String name = entryEntity.getName();
            if (xbillEntryAndField.get(name) == null) continue;
            try {
                srcBill.getDynamicObjectCollection(name);
            }
            catch (Exception e) {
                continue;
            }
            String[] canLogProperty = allChangeLogProperty.get(name);
            if (CommonUtils.isNull((Object)canLogProperty) || CommonUtils.isNull((Object)(billEntry = ChangeResumeLogHelper.genFormatString(srcBill, xBill, xbillEntryAndField, entryEntity, allChangeLogProperty)))) continue;
            billEntrys.append(billEntry).append(',');
        }
        if (billEntrys.length() > 0) {
            return "{" + billEntrys.substring(0, billEntrys.length() - 1) + "}";
        }
        return "";
    }

    public static String genFormatString(DynamicObject srcBill, DynamicObject xBill, Map<String, Map<String, String>> xBillEntryAndField, EntityType entryEntity, Map<String, String[]> allCanLogProperty) {
        if (xBill == null || entryEntity == null || CommonUtils.isNull(xBillEntryAndField) || CommonUtils.isNull(allCanLogProperty)) {
            return "";
        }
        String entryName = entryEntity.getName();
        Map<String, String> entryRegisterField = xBillEntryAndField.get(entryName);
        if (CommonUtils.isNull(entryRegisterField)) {
            return "";
        }
        String registerEntryID = entryRegisterField.get("srcid");
        String registerChangeType = entryRegisterField.get("changetype");
        DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection(entryName);
        String[] billEntryFields = allCanLogProperty.get(entryName);
        if (billEntryFields.length > 0 && !CommonUtils.isNull((Object)xBillEntrys)) {
            StringBuilder fieldJson = new StringBuilder();
            ChangeResumeLogInfo fieldinfo = new ChangeResumeLogInfo();
            fieldinfo.setKey_caption(entryName);
            int rows = 1;
            for (DynamicObject xBillEntry : xBillEntrys) {
                String formatJson;
                Long xBillID = xBillEntry.getLong(registerEntryID);
                String eq = KEY_EQUAL;
                ChangeResumeLogInfo cifo = new ChangeResumeLogInfo();
                cifo.setKeyId(String.valueOf(xBillID));
                cifo.setKeyName(String.valueOf(entryEntity.getDisplayName()));
                cifo.setKeyLine(String.valueOf(rows));
                String displayFieldName = ChangeResumeLogHelper.getDisplayFieldName(entryRegisterField, xBillEntry);
                cifo.setKeyDisplayFieldName(displayFieldName);
                ++rows;
                List<EntityType> childEntities = ChangeResumeLogHelper.getChildEntities(xBillEntry.getDataEntityType());
                StringBuilder childField = new StringBuilder();
                String changetype = String.valueOf(xBillEntry.get(registerChangeType));
                if (ChangeTypeEnum.ADDNEW.getValue().equals(changetype)) {
                    for (String billEntryField : billEntryFields) {
                        Integer newBig;
                        Object newField = xBillEntry.get(billEntryField);
                        DynamicProperty newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryField);
                        String caption = MetaDataHelper.getEntryPropertyAlias(xBill.getDataEntityType(), entryName, billEntryField);
                        String nField = ChangeResumeLogHelper.displayFieldValue(newField, newdp);
                        if (newField == null) continue;
                        if (newField instanceof BigDecimal) {
                            BigDecimal newBig2 = (BigDecimal)newField;
                            if (newBig2.compareTo(BigDecimal.valueOf(0L)) != 0) {
                                nField = nField + "\u2191";
                            }
                        } else if (newField instanceof Integer && (newBig = (Integer)newField).compareTo(0) != 0) {
                            nField = nField + "\u2191";
                        }
                        boolean isNewValueNull = ChangeResumeLogHelper.isNewValueNull(newField);
                        if (isNewValueNull) continue;
                        ChangeResumeLogFieldInfo logFieldInfo = new ChangeResumeLogFieldInfo();
                        logFieldInfo.setOldValue(null);
                        logFieldInfo.setNewValue(nField);
                        logFieldInfo.setIsequals(KEY_ADD);
                        logFieldInfo.setFieldname(caption);
                        cifo.setLogFieldInfo(billEntryField, logFieldInfo);
                    }
                    eq = KEY_ADD;
                    if (childEntities.size() > 0) {
                        for (EntityType childEntity : childEntities) {
                            String childJson;
                            String childEnName = childEntity.getName();
                            String[] canLogProperty = allCanLogProperty.get(childEnName);
                            if (CommonUtils.isNull((Object)canLogProperty) || CommonUtils.isNull((Object)(childJson = ChangeResumeLogHelper.genFormatString(null, xBillEntry, xBillEntryAndField, childEntity, allCanLogProperty)))) continue;
                            childField.append(childJson).append(',');
                        }
                    }
                } else if (ChangeTypeEnum.UPDATE.getValue().equals(changetype) || ChangeTypeEnum.CANCEL.getValue().equals(changetype)) {
                    if (srcBill == null) continue;
                    DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(entryName);
                    for (DynamicObject srcBillEntry : srcBillEntrys) {
                        Long srcBillID = (Long)srcBillEntry.getPkValue();
                        if (xBillID.longValue() != srcBillID.longValue()) continue;
                        for (String billEntryField : billEntryFields) {
                            Object srcField = srcBillEntry.get(billEntryField);
                            DynamicProperty srcdp = srcBillEntry.getDynamicObjectType().getProperty(billEntryField);
                            Object newField = xBillEntry.get(billEntryField);
                            DynamicProperty newdp = xBillEntry.getDynamicObjectType().getProperty(billEntryField);
                            String caption = MetaDataHelper.getEntryPropertyAlias(xBill.getDataEntityType(), entryName, billEntryField);
                            String nField = ChangeResumeLogHelper.displayFieldValue(newField, newdp);
                            String oField = ChangeResumeLogHelper.displayFieldValue(srcField, srcdp);
                            boolean equal = ChangeResumeLogHelper.compareField(srcField, newField);
                            ChangeResumeLogFieldInfo logFieldInfo = new ChangeResumeLogFieldInfo();
                            if (equal) {
                                logFieldInfo.setIsequals(KEY_EQUAL);
                            } else {
                                eq = KEY_UPDATE;
                                logFieldInfo.setIsequals(KEY_UPDATE);
                                if (srcField instanceof BigDecimal && newField instanceof BigDecimal || srcdp instanceof IntegerProp && newdp instanceof IntegerProp) {
                                    nField = nField + ChangeResumeLogHelper.compareSizes(srcField, newField);
                                }
                            }
                            logFieldInfo.setOldValue(oField);
                            logFieldInfo.setNewValue(nField);
                            logFieldInfo.setFieldname(caption);
                            cifo.setLogFieldInfo(billEntryField, logFieldInfo);
                        }
                        if (childEntities.size() <= 0) continue;
                        for (EntityType childEntity : childEntities) {
                            String childJson;
                            String childEnName = childEntity.getName();
                            String[] canLogProperty = allCanLogProperty.get(childEnName);
                            if (CommonUtils.isNull((Object)canLogProperty) || CommonUtils.isNull((Object)(childJson = ChangeResumeLogHelper.genFormatString(srcBillEntry, xBillEntry, xBillEntryAndField, childEntity, allCanLogProperty)))) continue;
                            childField.append(childJson).append(',');
                        }
                    }
                }
                if (ChangeTypeEnum.CANCEL.getValue().equals(changetype)) {
                    eq = KEY_DELETE;
                }
                cifo.setKeyFlag(eq);
                if (childField.length() > 0) {
                    childField.deleteCharAt(childField.length() - 1);
                }
                if ((formatJson = cifo.formatJson()).length() > 0) {
                    StringBuilder cifoStrBuilder = new StringBuilder(formatJson);
                    if (childField.length() > 0) {
                        cifoStrBuilder.deleteCharAt(cifoStrBuilder.length() - 1);
                        childField = cifoStrBuilder.append(',').append((CharSequence)childField).append('}');
                    } else {
                        childField = cifoStrBuilder;
                    }
                }
                fieldJson.append((CharSequence)childField).append(',');
            }
            if (fieldJson.length() > 0) {
                fieldJson = new StringBuilder(fieldJson.substring(0, fieldJson.length() - 1));
            }
            return fieldinfo.formatJson(fieldJson.toString());
        }
        return "";
    }

    public static boolean compareField(Object srcField, Object newField) {
        if (srcField == null && newField == null) {
            return true;
        }
        if (srcField instanceof OrmLocaleValue && ((OrmLocaleValue)srcField).isEmpty() && newField instanceof OrmLocaleValue && ((OrmLocaleValue)newField).isEmpty()) {
            return true;
        }
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal && srcField.equals(newField)) {
            return true;
        }
        if (srcField instanceof DynamicObject && newField instanceof DynamicObject && ((DynamicObject)srcField).getPkValue().equals(((DynamicObject)newField).getPkValue())) {
            return true;
        }
        if (srcField instanceof DynamicObjectCollection && newField instanceof MulBasedataDynamicObjectCollection) {
            DynamicObject value;
            DynamicObjectCollection srcCollection = (DynamicObjectCollection)srcField;
            DynamicObjectCollection newCollection = (DynamicObjectCollection)newField;
            HashSet<Object> srcPKSet = new HashSet<Object>(16);
            HashSet<Object> newPKSet = new HashSet<Object>(16);
            for (DynamicObject row : srcCollection) {
                value = row.getDynamicObject("fbasedataid");
                if (value == null) continue;
                srcPKSet.add(value.getPkValue());
            }
            for (DynamicObject row : newCollection) {
                value = row.getDynamicObject("fbasedataid");
                if (value == null) continue;
                newPKSet.add(value.getPkValue());
            }
            if (newPKSet.size() == srcPKSet.size() && newPKSet.containsAll(srcPKSet) && srcPKSet.containsAll(newPKSet)) {
                return true;
            }
        }
        if (newField != null && newField.equals(srcField)) {
            return true;
        }
        if (srcField != null && srcField.equals(newField)) {
            return true;
        }
        if (srcField != null && newField != null) {
            String srcFieldStr = srcField.toString();
            String newFieldStr = newField.toString();
            if (srcFieldStr == null && newFieldStr == null) {
                return true;
            }
            return srcFieldStr != null && srcFieldStr.equals(newFieldStr);
        }
        return false;
    }

    public static String compareSizes(Object srcField, Object newField) {
        if (srcField instanceof BigDecimal && newField instanceof BigDecimal) {
            BigDecimal oldBig = (BigDecimal)srcField;
            BigDecimal newBig = (BigDecimal)newField;
            if (CommonUtils.isNull((Object)oldBig) || CommonUtils.isNull((Object)newBig)) {
                return "";
            }
            if (oldBig.compareTo(newBig) < 0) {
                return "\u2191";
            }
            if (oldBig.compareTo(newBig) > 0) {
                return "\u2193";
            }
        } else if (srcField instanceof Integer && newField instanceof Integer) {
            Integer oldBig = (Integer)srcField;
            Integer newBig = (Integer)newField;
            if (CommonUtils.isNull((Object)oldBig) || CommonUtils.isNull((Object)newBig)) {
                return "";
            }
            if (oldBig.compareTo(newBig) < 0) {
                return "\u2191";
            }
            if (oldBig.compareTo(newBig) > 0) {
                return "\u2193";
            }
        }
        return "";
    }

    public static String displayFieldValue(Object newField, DynamicProperty newdp) {
        if (newField == null) {
            return "";
        }
        if (newField instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)newField;
            return b.stripTrailingZeros().toPlainString();
        }
        if (newField instanceof Date) {
            Date d = (Date)newField;
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            return ChangeResumeLogHelper.getTransString(df.format(d));
        }
        if (newField instanceof Boolean) {
            Boolean b = (Boolean)newField;
            return b != false ? ResManager.loadKDString((String)"\u662f", (String)"ChangeLogHelper_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ChangeLogHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
        }
        if (newField instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)newField;
            if (newdp instanceof BasedataProp) {
                if (newdp instanceof FlexProp) {
                    return ChangeResumeLogHelper.getTransString(dyo.toString());
                }
                BasedataProp bdProp = (BasedataProp)newdp;
                return ChangeResumeLogHelper.getTransString(bdProp.getDisplayValue(newField));
            }
            return ChangeResumeLogHelper.getTransString(dyo.toString());
        }
        if (newField instanceof DynamicObjectCollection) {
            DynamicObjectCollection dyoCol = (DynamicObjectCollection)newField;
            if (dyoCol.isEmpty()) {
                return "";
            }
            if (newdp instanceof MulBasedataProp) {
                if (newdp instanceof AttachmentProp) {
                    AttachmentProp panel = (AttachmentProp)newdp;
                    return ChangeResumeLogHelper.getTransString(panel.getDisplayValue(newField));
                }
                MulBasedataProp mulbdPro = (MulBasedataProp)newdp;
                return ChangeResumeLogHelper.getTransString(mulbdPro.getDisplayValue(newField));
            }
        } else {
            if (newdp instanceof MulComboProp) {
                MulComboProp cbPros = (MulComboProp)newdp;
                return ChangeResumeLogHelper.getTransString(cbPros.getItemByName((String)newField));
            }
            if (newdp instanceof ComboProp) {
                ComboProp cbPro = (ComboProp)newdp;
                List cbItems = cbPro.getComboItems();
                for (ValueMapItem cbItem : cbItems) {
                    if (cbItem == null || !newField.equals(cbItem.getValue())) continue;
                    return ChangeResumeLogHelper.getTransString(cbItem.getName().toString());
                }
            } else {
                if (newField instanceof OrmLocaleValue) {
                    String str = ((OrmLocaleValue)newField).getLocaleValue();
                    if (str == null) {
                        return "";
                    }
                    return ChangeResumeLogHelper.getTransString(str);
                }
                if (newdp instanceof AssistantProp) {
                    AssistantProp assistantPropdp = (AssistantProp)newdp;
                    return ChangeResumeLogHelper.getTransString(assistantPropdp.getDisplayValue(newField));
                }
            }
        }
        return ChangeResumeLogHelper.getTransString(newField.toString());
    }

    public static String getTransString(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            if (str.contains("\\")) {
                str = str.replaceAll("\\\\", "&#123;");
            }
            if (str.contains("\"")) {
                str = str.replaceAll("\"", "&#124;");
            }
        } else {
            str = "";
        }
        return str;
    }

    public static Map<String, String[]> getAllChangeLogPropertyMap(DynamicObject xBill) {
        HashMap<String, String[]> allCanLogProperty = new HashMap<String, String[]>();
        if (xBill == null) {
            return allCanLogProperty;
        }
        List<EntityType> entities = ChangeResumeLogHelper.getAllEntities(xBill.getDynamicObjectType().getProperties());
        if (entities.size() > 0) {
            for (EntityType entitie : entities) {
                String enName = entitie.getName();
                String[] canLogProperty = ChangeModelHelper.getCanLogProperty(xBill.getDataEntityType(), enName);
                allCanLogProperty.put(enName, canLogProperty);
            }
        }
        return allCanLogProperty;
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        if (entityType == null) {
            return childEntities;
        }
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
        }
        return childEntities;
    }

    public static List<EntityType> getAllEntities(DataEntityPropertyCollection entityType) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        if (entityType == null) {
            return entities;
        }
        for (IDataEntityProperty property : entityType) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            entities.add(childEntity);
            entities.addAll(ChangeResumeLogHelper.getAllEntities(childEntity.getProperties()));
        }
        return entities;
    }

    private static String getDisplayFieldName(Map<String, String> xBillEntryAndField, DynamicObject xBillEntry) {
        StringBuilder displayName = new StringBuilder();
        String displayfields = xBillEntryAndField.get("displayfields");
        if (displayfields != null) {
            String[] displayfieldArr = displayfields.split(",");
            DynamicObjectType dynType = xBillEntry.getDynamicObjectType();
            for (String displayfield : displayfieldArr) {
                String fieldName;
                Object fieldValue;
                if (dynType.getProperty(displayfield) == null || (fieldValue = xBillEntry.get(displayfield)) == null || !StringUtils.isNotBlank((CharSequence)(fieldName = XBillLogHelper.displayFieldValue(fieldValue, dynType.getProperty(displayfield))))) continue;
                displayName.append("_").append(fieldName);
            }
        }
        return displayName.toString();
    }

    private static boolean isNewValueNull(Object newField) {
        if (newField == null) {
            return true;
        }
        return newField instanceof BigDecimal ? ((BigDecimal)newField).compareTo(BigDecimal.ZERO) == 0 : (newField instanceof Integer ? (Integer)newField == 0 : (newField instanceof Long ? (Long)newField == 0L : newField instanceof String && StringUtils.isEmpty((CharSequence)((String)newField))));
    }
}

