/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.XlogDirector;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.ReviseXlogBuilder;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.ReviseBillComparator;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class ReviseHelper {
    public static Set<String> getNeedLogFields(DynamicObject changeModel) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>(8);
        if (changeModel == null) {
            return fields;
        }
        DynamicObjectCollection entrys = changeModel.getDynamicObjectCollection("revisefields");
        if (entrys != null) {
            for (DynamicObject entry : entrys) {
                String field = entry.getString("revisefield");
                Boolean canLog = entry.getBoolean("canreviselog");
                if (!StringUtils.isNotBlank((CharSequence)field) || !Boolean.TRUE.equals(canLog)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static DynamicObject recReviseLog(DynamicObject srcBill, DynamicObject changeBill, String opType) {
        if (srcBill == null || changeBill == null) {
            return changeBill;
        }
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4Revise(srcBill.getDataEntityType().getName());
        if (changeModel == null) {
            return changeBill;
        }
        String xLogEntity = ChangeModelHelper.getXlogEntityId(changeModel);
        String status = ReviseHelper.getStatusByOp(opType);
        if (status == null) {
            return changeBill;
        }
        Set<String> needLogFields = ReviseHelper.getNeedLogFields(changeModel);
        ReviseXlogBuilder builder = new ReviseXlogBuilder(srcBill, changeBill, xLogEntity, status, needLogFields);
        ReviseBillComparator comparator = new ReviseBillComparator(srcBill, changeBill, needLogFields);
        XlogDirector director = new XlogDirector(builder, comparator);
        director.constructXlog();
        director.saveXlog();
        return changeBill;
    }

    private static String getStatusByOp(String opType) {
        switch (opType) {
            case "save": {
                return BizChangeStatusEnum.REVISING.getValue();
            }
            case "submit": {
                return BizChangeStatusEnum.SUBMIT.getValue();
            }
            case "unsubmit": {
                return BizChangeStatusEnum.REVISING.getValue();
            }
            case "valid": {
                return BizChangeStatusEnum.CHANGED.getValue();
            }
        }
        return null;
    }

    public static List<Map<String, String>> getCustomParameterList() {
        String LocalVersion = ResManager.loadKDString((String)"\u53d8\u66f4\u7248\u672c", (String)"ReviseHelper_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
        String LocalChangeStatus = ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\uff08\u679a\u4e3e\u9879[A:\u6b63\u5e38\uff1bB:\u53d8\u66f4\u4e2d\uff1bB1:\u66f4\u6b63\u4e2d\uff1bC:\u5df2\u53d8\u66f4]\uff09", (String)"ReviseHelper_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
        String LocalChanger = ResManager.loadKDString((String)"\u53d8\u66f4\u4eba", (String)"ReviseHelper_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
        String LocalChangeDate = ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f", (String)"ReviseHelper_3", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]);
        String customJson = "[{\"name\":\"version\",\"type\":\"string\",\"val\":\"version\",\"description\":\"" + LocalVersion + "\"},{\"name\":\"changestatus\",\"type\":\"string\",\"val\":\"changestatus\",\"description\":\"" + LocalChangeStatus + "\"},{\"name\":\"changer\",\"type\":\"string\",\"val\":\"changer\",\"description\":\"" + LocalChanger + "\"},{\"name\":\"changedate\",\"type\":\"string\",\"val\":\"changedate\",\"description\":\"" + LocalChangeDate + "\"}]";
        return (List)SerializationUtils.fromJsonString((String)customJson, List.class);
    }
}

