/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ReviseHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LevelFieldsInfo;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LogEntryInfo;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class XlogHelper {
    public static boolean isBillChanging(Object pkId, String entityId) {
        DynamicObject reviseModel;
        if (pkId == null || StringUtils.isBlank((CharSequence)entityId)) {
            return false;
        }
        boolean isChanging = false;
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4SrcBill(entityId);
        if (changeModel != null && XlogHelper.isLogChanging(changeModel, pkId)) {
            isChanging = true;
        }
        if ((reviseModel = ChangeModelHelper.getChangeModel4Revise(entityId)) != null && XlogHelper.isLogChanging(reviseModel, pkId)) {
            isChanging = true;
        }
        return isChanging;
    }

    private static boolean isLogChanging(DynamicObject changeModel, Object pkId) {
        boolean isChanging = false;
        String XBillLogEntity = "plat_xbilllog";
        if (changeModel.getDynamicObject("xbilllog") != null) {
            XBillLogEntity = (String)changeModel.getDynamicObject("xbilllog").getPkValue();
        }
        QFilter q1 = new QFilter("srcbillid", "=", pkId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReviseHelper.class.getName(), (String)XBillLogEntity, (String)"srcbillversion,changestatus ", (QFilter[])new QFilter[]{q1}, (String)"id desc", (int)1);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                if (BizChangeStatusEnum.REVISING.getValue().equals(row.getString("changestatus")) || BizChangeStatusEnum.CHANGING.getValue().equals(row.getString("changestatus")) || BizChangeStatusEnum.SUBMIT.getValue().equals(row.getString("changestatus"))) {
                    isChanging = true;
                }
            }
        }
        return isChanging;
    }

    public static Map<String, Object> getLatestVersion(Object srcId, String XBillLogEntityKe) {
        return XlogHelper.getLatestVersion(srcId, null, XBillLogEntityKe);
    }

    public static Map<String, Object> getLatestVersion(Object srcId, Object xId, String XBillLogEntityKe) {
        int version;
        Boolean isNewVersion;
        HashMap<String, Object> resMap;
        block17: {
            resMap = new HashMap<String, Object>(4);
            isNewVersion = Boolean.TRUE;
            QFilter q1 = new QFilter("srcbillid", "=", srcId);
            if (xId != null) {
                QFilter q2 = new QFilter("xbillid", "=", xId);
                q1.and(q2);
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReviseHelper.class.getName(), (String)XBillLogEntityKe, (String)"id,srcbillversion,changestatus ", (QFilter[])new QFilter[]{q1}, (String)"id desc", (int)1);){
                if (ds == null || !ds.hasNext()) {
                    version = 0;
                    break block17;
                }
                try {
                    Row row = ds.next();
                    String status = row.getString("changestatus");
                    if (BizChangeStatusEnum.REVISING.getValue().equals(status) || BizChangeStatusEnum.CHANGING.getValue().equals(status) || BizChangeStatusEnum.SUBMIT.getValue().equals(status)) {
                        isNewVersion = Boolean.FALSE;
                    }
                    version = row.getInteger("srcbillversion");
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7248\u672c\u53f7\u201d\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReviseHelper_4", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                }
            }
        }
        resMap.put("srcbillversion", version);
        resMap.put("isNewVersion", isNewVersion);
        return resMap;
    }

    public static Map<Long, Integer> getLatestVersions(List ids, String XBillLogEntityKe) {
        HashMap<Long, Integer> resMap = new HashMap<Long, Integer>(4);
        QFilter q1 = new QFilter("srcbillid", "in", (Object)ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReviseHelper.class.getName(), (String)XBillLogEntityKe, (String)"id,srcbillid,srcbillversion ", (QFilter[])new QFilter[]{q1}, null);){
            for (Row row : ds) {
                Long srcbillid = row.getLong("srcbillid");
                Integer srcBillVersion = row.getInteger("srcbillversion");
                Integer version = (Integer)resMap.get(srcbillid);
                if (version == null) {
                    resMap.put(srcbillid, srcBillVersion);
                    continue;
                }
                if (srcBillVersion == null || version >= srcBillVersion) continue;
                resMap.put(srcbillid, srcBillVersion);
            }
        }
        return resMap;
    }

    public static Map<String, List<LogEntryInfo>> getXLogsById(Object srcId, String xlogEntityId, Boolean isLatest) {
        return XlogHelper.getXLogsById(srcId, null, xlogEntityId, isLatest);
    }

    public static Map<String, List<LogEntryInfo>> getXBillLogsById(Object srcId, Object xId, String xlogEntityId) {
        return XlogHelper.getXLogsById(srcId, xId, xlogEntityId, null);
    }

    public static Map<String, List<LogEntryInfo>> getXLogsById(Object srcId, Object xId, String xlogEntityId, Boolean isLatest) {
        Map<String, Object> latestVersion;
        QFilter q = new QFilter("srcbillid", "=", srcId);
        if (xId != null) {
            QFilter q1 = new QFilter("xbillid", "=", xId);
            q.and(q1);
        } else if (Boolean.TRUE.equals(isLatest) && (latestVersion = XlogHelper.getLatestVersion(srcId, xlogEntityId)) != null) {
            Integer version = (Integer)latestVersion.get("srcbillversion");
            QFilter q1 = "pm_xpurplanbilllog".equals(xlogEntityId) || "pm_xpurapplybilllog".equals(xlogEntityId) ? new QFilter("srcbillversion", "=", (Object)String.valueOf(version)) : new QFilter("srcbillversion", "=", (Object)version);
            q.and(q1);
        }
        LinkedHashMap<String, List<LogEntryInfo>> alllog = new LinkedHashMap<String, List<LogEntryInfo>>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntityId, (String)XlogHelper.getXlogSelectFields(), (QFilter[])new QFilter[]{q}, (String)"id desc");){
            if (ds != null) {
                for (Row row : ds) {
                    List logEntryInfos;
                    LogEntryInfo logInfo = new LogEntryInfo(row.getString("rowid"), row.getString("parentid"), row.getString("entrykey"), row.getString("fieldkey"), row.getString("beforevalue"), row.getString("aftervalue"), row.getString("changetype"), String.valueOf(row.getInteger("srcbillversion") + 1));
                    if ("0".equals(logInfo.getParentid())) {
                        if (logInfo.getFieldkey() == null) continue;
                        logEntryInfos = alllog.computeIfAbsent(logInfo.getFieldkey(), k -> new ArrayList());
                        logEntryInfos.add(logInfo);
                        continue;
                    }
                    if (logInfo.getParentid() == null && logInfo.getEntryKey() == null) continue;
                    logEntryInfos = alllog.computeIfAbsent(logInfo.getParentid() + logInfo.getEntryKey(), k -> new ArrayList());
                    logEntryInfos.add(logInfo);
                }
            }
        }
        return alllog;
    }

    public static Map<String, Map<String, List<String>>> getLogFieldsMap(Object srcId, String xlogEntity, Boolean isAllVer) {
        return XlogHelper.getLogFieldsMap(srcId, null, xlogEntity, isAllVer);
    }

    public static Map<String, Map<String, List<String>>> getXBillLogFieldsMap(Object srcId, Object xId, String xlogEntity) {
        return XlogHelper.getLogFieldsMap(srcId, xId, xlogEntity, null);
    }

    public static Map<String, Map<String, List<String>>> getLogFieldsMap(Object srcId, Object xId, String xlogEntity, Boolean isAllVer) {
        HashMap<String, Map<String, List<String>>> logFieldsMap = new HashMap<String, Map<String, List<String>>>(8);
        QFilter q1 = new QFilter("srcbillid", "=", srcId);
        if (xId != null) {
            QFilter q2 = new QFilter("xbillid", "=", xId);
            q1.and(q2);
        } else if (!Boolean.TRUE.equals(isAllVer)) {
            Map<String, Object> latestVersionMap = XlogHelper.getLatestVersion(srcId, xlogEntity);
            Object srcBillVersion = latestVersionMap.get("srcbillversion");
            QFilter q2 = "pm_xpurplanbilllog".equals(xlogEntity) || "pm_xpurapplybilllog".equals(xlogEntity) ? new QFilter("srcbillversion", "=", (Object)String.valueOf(srcBillVersion)) : new QFilter("srcbillversion", "=", srcBillVersion);
            q1.and(q2);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntity, (String)"entryentity.rowid rowid,entryentity.entrykey entrykey,entryentity.fieldkey fieldkey", (QFilter[])new QFilter[]{q1}, null);){
            if (ds == null || !ds.hasNext()) {
                HashMap<String, Map<String, List<String>>> hashMap = logFieldsMap;
                return hashMap;
            }
            for (Row row : ds) {
                String entrykey = StringUtils.isEmpty((CharSequence)row.getString("entrykey")) ? "HEAD" : row.getString("entrykey");
                Map entryMap = logFieldsMap.computeIfAbsent(entrykey, k -> new HashMap());
                String rowid = StringUtils.isEmpty((CharSequence)row.getString("rowid")) ? "0" : row.getString("rowid");
                List fieldList = entryMap.computeIfAbsent(rowid, k -> new ArrayList());
                fieldList.add(row.getString("fieldkey"));
            }
        }
        return logFieldsMap;
    }

    public static LinkedHashSet<String> getAllLogFields(Object id, String xlogEntityId) {
        QFilter q = new QFilter("srcbillid", "=", id);
        LinkedHashSet<String> fields = new LinkedHashSet<String>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntityId, (String)"entryentity.fieldkey fieldkey", (QFilter[])new QFilter[]{q}, (String)"id desc");){
            if (ds != null) {
                for (Row row : ds) {
                    if (!StringUtils.isNotBlank((CharSequence)row.getString("fieldkey"))) continue;
                    fields.add(row.getString("fieldkey"));
                }
            }
        }
        return fields;
    }

    public static LevelFieldsInfo getLevelFields(String entityId, Set<String> canLogFields) {
        HashMap<String, LevelFieldsInfo> levelMap = new HashMap<String, LevelFieldsInfo>(8);
        LevelFieldsInfo levelFields = new LevelFieldsInfo();
        if (canLogFields == null || canLogFields.size() == 0) {
            return levelFields;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        for (String field : canLogFields) {
            IDataEntityProperty property;
            IDataEntityType parent;
            if (!StringUtils.isNotBlank((CharSequence)field) || mainEntityType.findProperty(field) == null || (parent = (property = mainEntityType.findProperty(field)).getParent()) == null) continue;
            LevelFieldsInfo level = levelMap.computeIfAbsent(parent.getName(), k -> new LevelFieldsInfo());
            if (level.getCurrentApKey() == null) {
                level.setCurrentApKey(parent.getName());
            }
            if (parent.getParent() != null && level.getParentApKey() == null) {
                level.setParentApKey(parent.getParent().getName());
            }
            level.getFields().add(field);
            while (parent.getParent() != null && levelMap.get(parent.getParent().getName()) == null) {
                parent = parent.getParent();
                LevelFieldsInfo parentLevel = levelMap.computeIfAbsent(parent.getName(), k -> new LevelFieldsInfo());
                parentLevel.setCurrentApKey(parent.getName());
                if (parent.getParent() == null || parentLevel.getParentApKey() != null) continue;
                parentLevel.setParentApKey(parent.getParent().getName());
            }
        }
        for (LevelFieldsInfo level : levelMap.values()) {
            String parentKey = level.getParentApKey();
            if (parentKey == null) continue;
            LevelFieldsInfo parentLevel = (LevelFieldsInfo)levelMap.get(parentKey);
            parentLevel.getNextLeves().add(level);
        }
        return (LevelFieldsInfo)levelMap.get(entityId);
    }

    public static Map<String, Integer> getEntryIdSeqMap(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
        String xlogEntityId = ChangeModelHelper.getXlogEntityId(bill.getDataEntityType().getName());
        LinkedHashSet<String> allFields = XlogHelper.getAllLogFields(bill.getPkValue(), xlogEntityId);
        LevelFieldsInfo levelFields = XlogHelper.getLevelFields(bill.getDataEntityType().getName(), allFields);
        QFilter q = new QFilter("srcbillid", "=", bill.getPkValue());
        HashSet<String> rowids = new HashSet<String>(8);
        DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntityId, (String)"entryentity.rowid rowid", (QFilter[])new QFilter[]{q}, (String)"id desc");
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    if (!StringUtils.isNotBlank((CharSequence)row.getString("rowid"))) continue;
                    rowids.add(row.getString("rowid"));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<String, Integer> IdSeqMap = new HashMap<String, Integer>(8);
        for (LevelFieldsInfo level : levelFields.getNextLeves()) {
            XlogHelper.getIdSeqMap(bill, level, rowids, IdSeqMap);
        }
        return IdSeqMap;
    }

    public static Map<String, Map<String, Object>> getChangeVersionInfo(Object pkId, String entityId) {
        String xlogEntityId = ChangeModelHelper.getXlogEntityId(entityId);
        LinkedHashMap<String, Map<String, Object>> versionMap = new LinkedHashMap<String, Map<String, Object>>(8);
        QFilter q = new QFilter("srcbillid", "=", pkId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntityId, (String)"srcbillversion,creator,biztime,changestatus", (QFilter[])new QFilter[]{q}, (String)"id desc");){
            if (ds != null) {
                for (Row row : ds) {
                    Integer srcbillversion = row.getInteger("srcbillversion");
                    Date changeDate = row.getDate("biztime");
                    Long changer = row.getLong("creator");
                    String changestatus = row.getString("changestatus");
                    Map map = versionMap.computeIfAbsent(String.valueOf(srcbillversion + 1), k -> new HashMap(8));
                    map.put("biztime", changeDate);
                    map.put("creator", changer);
                    map.put("changestatus", changestatus);
                }
            }
        }
        return versionMap;
    }

    public static String subStringValue(String value) {
        if (value != null && value.length() > 2000) {
            value = value.substring(0, 2000);
        }
        return value;
    }

    private static void getIdSeqMap(DynamicObject bill, LevelFieldsInfo level, Set<String> rowids, Map<String, Integer> idSeqMap) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(level.getCurrentApKey());
        String entryName = entrys.getDynamicObjectType().getName();
        int i = 1;
        List<LevelFieldsInfo> nextLeves = level.getNextLeves();
        for (DynamicObject entry : entrys) {
            if (rowids.contains(String.valueOf(entry.getPkValue()))) {
                idSeqMap.put(String.valueOf(entry.getPkValue()), i);
            }
            if (nextLeves != null) {
                for (LevelFieldsInfo nextLevel : nextLeves) {
                    XlogHelper.getIdSeqMap(entry, nextLevel, rowids, idSeqMap);
                }
            }
            ++i;
        }
    }

    public static LinkedHashSet<String> getAllLogFields4XBill(Object id, String xlogEntityId) {
        QFilter q = new QFilter("xbillid", "=", id);
        LinkedHashSet<String> fields = new LinkedHashSet<String>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntityId, (String)"entryentity.fieldkey fieldkey", (QFilter[])new QFilter[]{q}, (String)"id desc");){
            if (ds != null) {
                for (Row row : ds) {
                    if (!StringUtils.isNotBlank((CharSequence)row.getString("fieldkey"))) continue;
                    fields.add(row.getString("fieldkey"));
                }
            }
        }
        return fields;
    }

    public static Map<String, Integer> getEntryIdSeqMap4XBill(DynamicObject bill, Map<String, Map<String, String>> entryAndOp) {
        HashMap<String, Integer> IdSeqMap = new HashMap<String, Integer>(8);
        if (bill == null) {
            return IdSeqMap;
        }
        bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
        DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill(bill.getDynamicObjectType().getName());
        String xlogEntityId = ChangeModelHelper.getXlogEntityId(changeModel);
        LinkedHashSet<String> allFields = XlogHelper.getAllLogFields4XBill(bill.getPkValue(), xlogEntityId);
        LevelFieldsInfo levelFields = XlogHelper.getLevelFields(bill.getDataEntityType().getName(), allFields);
        QFilter q = new QFilter("xbillid", "=", bill.getPkValue());
        HashSet<String> rowids = new HashSet<String>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)XlogHelper.class.getName(), (String)xlogEntityId, (String)"entryentity.rowid rowid", (QFilter[])new QFilter[]{q}, (String)"id desc");){
            if (ds != null) {
                for (Row row : ds) {
                    if (!StringUtils.isNotBlank((CharSequence)row.getString("rowid"))) continue;
                    rowids.add(row.getString("rowid"));
                }
            }
        }
        if (entryAndOp == null) {
            return IdSeqMap;
        }
        for (LevelFieldsInfo level : levelFields.getNextLeves()) {
            XlogHelper.getIdSeqMap4XBill(bill, level, rowids, IdSeqMap, entryAndOp);
        }
        return IdSeqMap;
    }

    private static void getIdSeqMap4XBill(DynamicObject bill, LevelFieldsInfo level, Set<String> rowids, Map<String, Integer> idSeqMap, Map<String, Map<String, String>> entryAndOp) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(level.getCurrentApKey());
        String entryName = entrys.getDynamicObjectType().getName();
        Map<String, String> map = entryAndOp.get(entryName);
        String entrySrcIdField = map.get("srcid");
        int i = 1;
        List<LevelFieldsInfo> nextLeves = level.getNextLeves();
        for (DynamicObject entry : entrys) {
            if (rowids.contains(String.valueOf(entry.get(entrySrcIdField)))) {
                idSeqMap.put(String.valueOf(entry.get(entrySrcIdField)), i);
            }
            if (nextLeves != null) {
                for (LevelFieldsInfo nextLevel : nextLeves) {
                    XlogHelper.getIdSeqMap4XBill(entry, nextLevel, rowids, idSeqMap, entryAndOp);
                }
            }
            ++i;
        }
    }

    private static String getXlogSelectFields() {
        return "srcbillversion,entryentity.rowid rowid,entryentity.parentid parentid,entryentity.entrykey entrykey,entryentity.fieldkey fieldkey,entryentity.beforevalue beforevalue,entryentity.aftervalue aftervalue,entryentity.changetype changetype";
    }
}

