/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.xlog;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.builder.AbstractXlogBuilder;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.AbstractBillComparator;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class XlogDirector {
    private AbstractBillComparator comparator;
    private AbstractXlogBuilder builder;
    protected DynamicObject firstVerXlog;
    protected DynamicObject curVerXlog;

    public XlogDirector(AbstractXlogBuilder builder, AbstractBillComparator comparator) {
        this.comparator = comparator;
        this.builder = builder;
    }

    public void constructXlog() {
        if (this.builder != null && this.comparator != null) {
            DynamicObject xlog = this.builder.getCurVerXlog();
            if (BizChangeStatusEnum.REVISING.getValue().equals(this.builder.getChangeStatus()) && BizChangeStatusEnum.SUBMIT.getValue().equals(xlog.getString("changestatus"))) {
                this.builder.buildHeadBaseInfo();
                this.curVerXlog = this.builder.getCurVerXlog();
            } else {
                this.comparator.compareDiff();
                this.builder.setValueMap(this.comparator.getResultMap());
                this.builder.buildFirstVersionLog();
                this.builder.buildHeadBaseInfo();
                this.builder.buildEntry();
                this.builder.buildHeadMD();
                this.firstVerXlog = this.builder.getFirstVerXlog();
                this.curVerXlog = this.builder.getCurVerXlog();
            }
        }
    }

    public void saveXlog() {
        try (TXHandle h = TX.required();){
            try {
                if (this.firstVerXlog != null) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.firstVerXlog});
                }
                if (this.curVerXlog != null) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.curVerXlog});
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public DynamicObject getFirstVerXlog() {
        return this.firstVerXlog;
    }

    public DynamicObject getCurVerXlog() {
        return this.curVerXlog;
    }
}

