/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.xlog.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LogEntryInfo;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public abstract class AbstractXlogBuilder {
    protected DynamicObject srcBill;
    protected DynamicObject changeBill;
    protected DynamicObject firstVerXlog;
    protected DynamicObject curVerXlog;
    protected String xLogEntity = "plat_xbilllog";
    protected Integer srcBillVersion;
    protected Boolean isNewVersion = Boolean.TRUE;
    protected String changeStatus;
    protected Map<String, LogEntryInfo> valueMap = new LinkedHashMap<String, LogEntryInfo>(8);

    public AbstractXlogBuilder(DynamicObject srcBill, DynamicObject changeBill, String xLogEntity, String changeStatus) {
        this.changeStatus = changeStatus;
        this.srcBill = srcBill;
        this.changeBill = changeBill;
        if (xLogEntity != null) {
            this.xLogEntity = xLogEntity;
        }
        if (srcBill != null) {
            Map<String, Object> latestVersion = XlogHelper.getLatestVersion(srcBill.getPkValue(), xLogEntity);
            this.srcBillVersion = (Integer)latestVersion.get("srcbillversion");
            this.isNewVersion = (Boolean)latestVersion.get("isNewVersion");
            if (Boolean.TRUE.equals(this.isNewVersion)) {
                this.srcBillVersion = this.srcBillVersion + 1;
                MainEntityType xlogdt = MetadataServiceHelper.getDataEntityType((String)xLogEntity);
                this.curVerXlog = new DynamicObject((DynamicObjectType)xlogdt);
            } else {
                QFilter q1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter q2 = "pm_xpurplanbilllog".equals(xLogEntity) || "pm_xpurapplybilllog".equals(xLogEntity) ? new QFilter("srcbillversion", "=", (Object)String.valueOf(this.srcBillVersion)) : new QFilter("srcbillversion", "=", (Object)this.srcBillVersion);
                this.curVerXlog = BusinessDataServiceHelper.loadSingleFromCache((String)xLogEntity, (QFilter[])new QFilter[]{q1, q2});
            }
        }
    }

    public AbstractXlogBuilder(DynamicObject srcBill, DynamicObject changeBill, String xLogEntity, String changeStatus, int srcBillVersion) {
        this.changeStatus = changeStatus;
        this.srcBill = srcBill;
        this.changeBill = changeBill;
        if (xLogEntity != null) {
            this.xLogEntity = xLogEntity;
        }
        this.srcBillVersion = srcBillVersion;
        MainEntityType xlogdt = MetadataServiceHelper.getDataEntityType((String)xLogEntity);
        this.curVerXlog = new DynamicObject((DynamicObjectType)xlogdt);
    }

    public void buildHeadBaseInfo() {
        if (Boolean.TRUE.equals(this.isNewVersion)) {
            this.curVerXlog.set("srcbillid", this.srcBill.getPkValue());
            this.curVerXlog.set("srcbillentity", (Object)this.srcBill.getDataEntityType().getName());
            this.curVerXlog.set("srcbillno", (Object)this.srcBill.getString(((BillEntityType)this.srcBill.getDataEntityType()).getBillNo()));
            this.curVerXlog.set("srcbillversion", (Object)this.srcBillVersion);
        }
        this.curVerXlog.set("changestatus", (Object)this.changeStatus);
        DynamicObject changer = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        this.curVerXlog.set("creator", (Object)changer);
        this.curVerXlog.set("biztime", (Object)TimeServiceHelper.now());
    }

    public abstract void buildHeadMD();

    public void buildEntry() {
        DynamicObjectCollection entrys = this.curVerXlog.getDynamicObjectCollection("entryentity");
        HashMap<String, Integer> fieldsMap = new HashMap<String, Integer>(8);
        int i = 0;
        for (DynamicObject entry : entrys) {
            fieldsMap.put(entry.getString("rowid") + entry.getString("fieldkey"), i++);
        }
        Iterator<Map.Entry<String, LogEntryInfo>> it = this.valueMap.entrySet().iterator();
        ArrayList<Object> indexesToRemove = new ArrayList<Object>();
        while (it.hasNext()) {
            DynamicObject entry;
            Map.Entry<String, LogEntryInfo> row = it.next();
            LogEntryInfo logEntryInfo = row.getValue();
            if (fieldsMap.get(row.getKey()) == null) {
                entry = entrys.addNew();
                entry.set("rowid", (Object)logEntryInfo.getRowid());
                entry.set("parentid", (Object)logEntryInfo.getParentid());
                entry.set("entrykey", (Object)logEntryInfo.getEntryKey());
                entry.set("fieldkey", (Object)logEntryInfo.getFieldkey());
                entry.set("beforevalue", (Object)logEntryInfo.getBeforeValue());
                entry.set("aftervalue", (Object)logEntryInfo.getAfterValue());
                entry.set("changetype", (Object)logEntryInfo.getChangetype());
                continue;
            }
            entry = (DynamicObject)entrys.get(((Integer)fieldsMap.get(row.getKey())).intValue());
            if (!StringUtils.isNotBlank((CharSequence)logEntryInfo.getFieldkey())) continue;
            if (CommonUtils.isRealChanged((Object)logEntryInfo.getAfterValue(), (Object)entry.getString("beforevalue"))) {
                entry.set("aftervalue", (Object)logEntryInfo.getAfterValue());
                entry.set("changetype", (Object)logEntryInfo.getChangetype());
                continue;
            }
            indexesToRemove.add(fieldsMap.get(row.getKey()));
        }
        if (indexesToRemove.size() > 0) {
            indexesToRemove.sort(Comparator.naturalOrder());
            for (int k = indexesToRemove.size() - 1; k >= 0; --k) {
                int index = (Integer)indexesToRemove.get(k);
                entrys.remove(index);
            }
        }
    }

    public void buildFirstVersionLog() {
        QFilter q1 = new QFilter("srcbillid", "=", this.srcBill.getPkValue());
        QFilter q2 = "pm_xpurplanbilllog".equals(this.xLogEntity) || "pm_xpurapplybilllog".equals(this.xLogEntity) ? new QFilter("srcbillversion", "=", (Object)"0") : new QFilter("srcbillversion", "=", (Object)0);
        this.firstVerXlog = BusinessDataServiceHelper.loadSingleFromCache((String)this.xLogEntity, (QFilter[])new QFilter[]{q1, q2});
        if (this.firstVerXlog == null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.xLogEntity);
            this.firstVerXlog = new DynamicObject((DynamicObjectType)dataEntityType);
            this.firstVerXlog.set("srcbillid", this.srcBill.getPkValue());
            this.firstVerXlog.set("srcbillentity", (Object)this.srcBill.getDataEntityType().getName());
            this.firstVerXlog.set("srcbillno", (Object)this.srcBill.getString(((BillEntityType)this.srcBill.getDataEntityType()).getBillNo()));
            this.firstVerXlog.set("srcbillversion", (Object)0);
        }
        HashSet<String> fields = new HashSet<String>(8);
        DynamicObjectCollection entrys = this.firstVerXlog.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            fields.add(entry.getString("rowid") + entry.getString("fieldkey"));
        }
        for (Map.Entry<String, LogEntryInfo> row : this.valueMap.entrySet()) {
            if (fields.contains(row.getKey())) continue;
            LogEntryInfo logEntryInfo = row.getValue();
            DynamicObject entry = entrys.addNew();
            entry.set("rowid", (Object)logEntryInfo.getRowid());
            entry.set("parentid", (Object)logEntryInfo.getParentid());
            entry.set("entrykey", (Object)logEntryInfo.getEntryKey());
            entry.set("fieldkey", (Object)logEntryInfo.getFieldkey());
            entry.set("beforevalue", (Object)logEntryInfo.getBeforeValue());
            entry.set("aftervalue", (Object)logEntryInfo.getBeforeValue());
        }
    }

    public DynamicObject getFirstVerXlog() {
        return this.firstVerXlog;
    }

    public DynamicObject getCurVerXlog() {
        return this.curVerXlog;
    }

    public void setValueMap(Map<String, LogEntryInfo> valueMap) {
        this.valueMap = valueMap;
    }

    public String getChangeStatus() {
        return this.changeStatus;
    }
}

