/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.xlog.comparator;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.servicehelper.DBServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XBillLogHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.AbstractBillComparator;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LevelFieldsInfo;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LogEntryInfo;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class ChangeBillComparator
extends AbstractBillComparator {
    private Map<String, Map<String, String>> entryAndOp;

    public ChangeBillComparator(DynamicObject srcBill, DynamicObject changeBill, Set<String> logFields, Map<String, Map<String, String>> entryAndOp) {
        this.logFields = logFields;
        this.srcBill = srcBill;
        this.changeBill = changeBill;
        this.entryAndOp = entryAndOp;
    }

    @Override
    protected boolean compareDiff(LevelFieldsInfo levelFields, DynamicObject srcDyn, DynamicObject changeDyn, Object parentId) {
        if (CommonUtils.isNull((Object)levelFields) || changeDyn == null || this.entryAndOp == null) {
            return false;
        }
        DynamicObjectType dynType = changeDyn.getDynamicObjectType();
        LinkedHashMap<String, LogEntryInfo> curDiffMap = new LinkedHashMap<String, LogEntryInfo>(8);
        if (changeDyn.getDataEntityType() instanceof EntryType) {
            if (this.entryAndOp.size() > 0 && this.entryAndOp.get(changeDyn.getDataEntityType().getName()) != null) {
                String entryKey = changeDyn.getDataEntityType().getName();
                String string = this.entryAndOp.get(changeDyn.getDataEntityType().getName()).get("changetype");
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    String oldValue;
                    String rowid;
                    if (BizChangeTypeEnum.UPDATE.getValue().equals(changeDyn.getString(string)) && srcDyn != null) {
                        rowid = srcDyn.getPkValue().toString();
                        for (String field : levelFields.getFields()) {
                            if (XBillLogHelper.compareField(srcDyn.get(field), changeDyn.get(field))) continue;
                            oldValue = XBillLogHelper.displayFieldValue(srcDyn.get(field), dynType.getProperty(field));
                            String newValue = XBillLogHelper.displayFieldValue(changeDyn.get(field), dynType.getProperty(field));
                            oldValue = XlogHelper.subStringValue(oldValue);
                            newValue = XlogHelper.subStringValue(newValue);
                            LogEntryInfo oldLog = new LogEntryInfo(rowid, parentId.toString(), entryKey, field, oldValue, newValue, ChangeTypeEnum.UPDATE.getValue());
                            curDiffMap.put(rowid + field, oldLog);
                        }
                    }
                    if (BizChangeTypeEnum.CANCEL.getValue().equals(changeDyn.getString(string)) && srcDyn != null) {
                        rowid = srcDyn.getPkValue().toString();
                        for (String field : levelFields.getFields()) {
                            oldValue = XBillLogHelper.displayFieldValue(srcDyn.get(field), dynType.getProperty(field));
                            oldValue = XlogHelper.subStringValue(oldValue);
                            LogEntryInfo oldLog = new LogEntryInfo(rowid, parentId.toString(), entryKey, field, oldValue, null, ChangeTypeEnum.CANCEL.getValue());
                            curDiffMap.put(rowid + field, oldLog);
                        }
                    }
                    if (BizChangeTypeEnum.ADDNEW.getValue().equals(changeDyn.getString(string))) {
                        rowid = changeDyn.getPkValue().toString();
                        for (String field : levelFields.getFields()) {
                            String newValue = XBillLogHelper.displayFieldValue(changeDyn.get(field), dynType.getProperty(field));
                            if (!StringUtils.isNotBlank((CharSequence)(newValue = XlogHelper.subStringValue(newValue))) || "0".equals(newValue)) continue;
                            LogEntryInfo newLog = new LogEntryInfo(rowid, parentId.toString(), entryKey, field, null, newValue, ChangeTypeEnum.ADDNEW.getValue());
                            curDiffMap.put(rowid + field, newLog);
                        }
                    }
                }
            }
        } else {
            for (String string : levelFields.getFields()) {
                if (XBillLogHelper.compareField(srcDyn.get(string), changeDyn.get(string))) continue;
                String oldValue = XBillLogHelper.displayFieldValue(srcDyn.get(string), dynType.getProperty(string));
                String newValue = XBillLogHelper.displayFieldValue(changeDyn.get(string), dynType.getProperty(string));
                oldValue = XlogHelper.subStringValue(oldValue);
                newValue = XlogHelper.subStringValue(newValue);
                LogEntryInfo oldLog = new LogEntryInfo("", parentId.toString(), "", string, oldValue, newValue, ChangeTypeEnum.UPDATE.getValue());
                curDiffMap.put(string, oldLog);
            }
        }
        if (curDiffMap.size() > 0) {
            this.resultMap.putAll(curDiffMap);
        }
        boolean isHasSon = false;
        if (levelFields.getNextLeves() != null) {
            for (LevelFieldsInfo level : levelFields.getNextLeves()) {
                String curEntryKey = level.getCurrentApKey();
                DynamicObjectCollection srcEntry = srcDyn == null ? null : srcDyn.getDynamicObjectCollection(curEntryKey);
                DynamicObjectCollection changeEntry = changeDyn == null ? null : changeDyn.getDynamicObjectCollection(curEntryKey);
                Map<Object, Object> srcPkMap = new LinkedHashMap(8);
                LinkedHashMap<Object, DynamicObject> changePkMap = new LinkedHashMap<Object, DynamicObject>(8);
                if (srcEntry != null && srcEntry.size() > 0) {
                    srcPkMap = srcEntry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, k -> k));
                }
                if (changeEntry != null && changeEntry.size() > 0) {
                    Map<String, String> entryOpMap = this.entryAndOp.get(changeEntry.getDynamicObjectType().getName());
                    if (entryOpMap == null) continue;
                    String entrySrcId = entryOpMap.get("srcid");
                    String entryChangeType = entryOpMap.get("changetype");
                    for (DynamicObject entry : changeEntry) {
                        if (!StringUtils.isNotBlank((CharSequence)entryChangeType)) continue;
                        String changeType = (String)entry.get(entryChangeType);
                        if (ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) {
                            if (entry.getPkValue() == null || entry.getPkValue().equals(0L)) {
                                long id = DBServiceHelper.genGlobalLongId();
                                entry.set("id", (Object)id);
                                changePkMap.put(id, entry);
                                continue;
                            }
                            changePkMap.put(entry.getPkValue(), entry);
                            continue;
                        }
                        changePkMap.put(entry.get(entrySrcId), entry);
                    }
                }
                LinkedHashSet pks = new LinkedHashSet(8);
                pks.addAll(srcPkMap.keySet());
                pks.addAll(changePkMap.keySet());
                Object ptId = srcDyn != null ? srcDyn.getPkValue() : changeDyn.getPkValue();
                for (Object id : pks) {
                    boolean isDiff = this.compareDiff(level, (DynamicObject)srcPkMap.get(id), (DynamicObject)changePkMap.get(id), ptId);
                    if (!isDiff) continue;
                    isHasSon = true;
                }
            }
            if (curDiffMap.size() == 0 && isHasSon && srcDyn != null && srcDyn.getDataEntityType() instanceof EntryType) {
                LogEntryInfo logEntryInfo = new LogEntryInfo(srcDyn.getPkValue().toString(), parentId.toString(), srcDyn.getDataEntityType().getName(), "", "", "", ChangeTypeEnum.UPDATE.getValue());
                this.resultMap.put(srcDyn.getPkValue().toString(), logEntryInfo);
            }
        }
        return curDiffMap.size() > 0 || isHasSon;
    }
}

