/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.business.xlog.comparator;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.servicehelper.DBServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XBillLogHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.business.xlog.comparator.AbstractBillComparator;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LevelFieldsInfo;
import kd.mpscmm.msbd.changemodel.business.xlog.pojo.LogEntryInfo;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class ReviseBillComparator
extends AbstractBillComparator {
    public ReviseBillComparator(DynamicObject srcBill, DynamicObject changeBill, Set<String> logFields) {
        this.logFields = logFields;
        this.srcBill = srcBill;
        this.changeBill = changeBill;
    }

    @Override
    protected boolean compareDiff(LevelFieldsInfo levelFields, DynamicObject srcDyn, DynamicObject changeDyn, Object parentId) {
        String oldValue;
        DynamicObjectType dynType;
        Object rowid;
        String entryKey;
        if (CommonUtils.isNull((Object)levelFields) || srcDyn == null && changeDyn == null) {
            return false;
        }
        LinkedHashMap<String, LogEntryInfo> curDiffMap = new LinkedHashMap<String, LogEntryInfo>(8);
        if (srcDyn != null && changeDyn != null) {
            entryKey = srcDyn.getDataEntityType() instanceof EntryType ? srcDyn.getDataEntityType().getName() : "";
            rowid = srcDyn.getDataEntityType() instanceof EntryType ? srcDyn.getPkValue().toString() : "";
            dynType = srcDyn.getDynamicObjectType();
            for (String field : levelFields.getFields()) {
                if (XBillLogHelper.compareField(srcDyn.get(field), changeDyn.get(field))) continue;
                oldValue = XBillLogHelper.displayFieldValue(srcDyn.get(field), dynType.getProperty(field));
                String newValue = XBillLogHelper.displayFieldValue(changeDyn.get(field), dynType.getProperty(field));
                oldValue = XlogHelper.subStringValue(oldValue);
                newValue = XlogHelper.subStringValue(newValue);
                LogEntryInfo log = new LogEntryInfo((String)rowid, parentId.toString(), entryKey, field, oldValue, newValue, ChangeTypeEnum.UPDATE.getValue());
                curDiffMap.put((String)rowid + field, log);
            }
        } else if (srcDyn == null && changeDyn != null) {
            entryKey = changeDyn.getDataEntityType() instanceof EntryType ? changeDyn.getDataEntityType().getName() : "";
            rowid = changeDyn.getDataEntityType() instanceof EntryType ? changeDyn.getPkValue().toString() : "";
            dynType = changeDyn.getDynamicObjectType();
            for (String field : levelFields.getFields()) {
                String newValue = XBillLogHelper.displayFieldValue(changeDyn.get(field), dynType.getProperty(field));
                if (!StringUtils.isNotBlank((CharSequence)(newValue = XlogHelper.subStringValue(newValue))) || "0".equals(newValue)) continue;
                LogEntryInfo newLog = new LogEntryInfo((String)rowid, parentId.toString(), entryKey, field, null, newValue, ChangeTypeEnum.ADDNEW.getValue());
                curDiffMap.put((String)rowid + field, newLog);
            }
        } else if (srcDyn != null) {
            entryKey = srcDyn.getDataEntityType() instanceof EntryType ? srcDyn.getDataEntityType().getName() : "";
            rowid = srcDyn.getDataEntityType() instanceof EntryType ? srcDyn.getPkValue().toString() : "";
            dynType = srcDyn.getDynamicObjectType();
            for (String field : levelFields.getFields()) {
                oldValue = XBillLogHelper.displayFieldValue(srcDyn.get(field), dynType.getProperty(field));
                oldValue = XlogHelper.subStringValue(oldValue);
                LogEntryInfo oldLog = new LogEntryInfo((String)rowid, parentId.toString(), entryKey, field, oldValue, null, ChangeTypeEnum.CANCEL.getValue());
                curDiffMap.put((String)rowid + field, oldLog);
            }
        }
        if (curDiffMap.size() > 0) {
            this.resultMap.putAll(curDiffMap);
        }
        boolean isHasSon = false;
        if (levelFields.getNextLeves() != null) {
            for (LevelFieldsInfo level : levelFields.getNextLeves()) {
                String entryKey2 = level.getCurrentApKey();
                DynamicObjectCollection srcEntry = srcDyn == null ? null : srcDyn.getDynamicObjectCollection(entryKey2);
                DynamicObjectCollection changeEntry = changeDyn == null ? null : changeDyn.getDynamicObjectCollection(entryKey2);
                LinkedHashMap<Object, DynamicObject> srcPkMap = new LinkedHashMap<Object, DynamicObject>(8);
                LinkedHashMap<Object, DynamicObject> changePkMap = new LinkedHashMap<Object, DynamicObject>(8);
                if (srcEntry != null) {
                    for (DynamicObject entry : srcEntry) {
                        srcPkMap.put(entry.getPkValue(), entry);
                    }
                }
                if (changeEntry != null) {
                    for (DynamicObject entry : changeEntry) {
                        if (entry.getPkValue() == null || entry.getPkValue().equals(0L)) {
                            long id = DBServiceHelper.genGlobalLongId();
                            entry.set("id", (Object)id);
                            changePkMap.put(id, entry);
                            continue;
                        }
                        changePkMap.put(entry.getPkValue(), entry);
                    }
                }
                LinkedHashSet pks = new LinkedHashSet(8);
                pks.addAll(srcPkMap.keySet());
                pks.addAll(changePkMap.keySet());
                Object ptId = srcDyn == null ? changeDyn.getPkValue() : srcDyn.getPkValue();
                for (Object id : pks) {
                    boolean isDiff = this.compareDiff(level, (DynamicObject)srcPkMap.get(id), (DynamicObject)changePkMap.get(id), ptId);
                    if (!isDiff) continue;
                    isHasSon = true;
                }
            }
            if (curDiffMap.size() == 0 && isHasSon && srcDyn != null && srcDyn.getDataEntityType() instanceof EntryType) {
                LogEntryInfo entryLog = new LogEntryInfo(srcDyn.getPkValue().toString(), parentId.toString(), srcDyn.getDataEntityType().getName(), "", "", "", ChangeTypeEnum.UPDATE.getValue());
                this.resultMap.put(srcDyn.getPkValue().toString(), entryLog);
            }
        }
        return curDiffMap.size() > 0 || isHasSon;
    }
}

