/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.changemodel.common.pojo.ChangeListEntryInfo;
import kd.mpscmm.msbd.changemodel.common.pojo.ChangeListInfo;

public class ChangeListImportPlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(ChangeListImportPlugin.class);

    public void initImportData(InitImportDataEventArgs e) {
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (e.getSourceData() instanceof JSONObject) {
            JSONObject bill = (JSONObject)e.getSourceData();
            if (bill == null) {
                e.setCancel(true);
                e.setFireAfterImportData(false);
                return;
            }
            String hashCode = (String)e.getSourceData().get("hashcode");
            if (StringUtils.isEmpty((CharSequence)hashCode)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fee\u6539\u6216\u4e0d\u662f\u5bfc\u51fa\u7684\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ChangeListImportPlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
            ChangeListInfo changeListInfo = new ChangeListInfo();
            String changeBill = null;
            Map<?, ?> changeBillMap = this.format4ImportAndApi(e.getSourceData().get("changebill"));
            if (changeBillMap != null && changeBillMap.get("importprop") != null) {
                changeBill = (String)changeBillMap.get(changeBillMap.get("importprop"));
            }
            changeListInfo.setChangeBill(changeBill);
            String changeBillId = null;
            if (e.getSourceData().get("id") != null) {
                changeBillId = e.getSourceData().get("id").toString();
            }
            changeListInfo.setId(changeBillId);
            ArrayList<ChangeListEntryInfo> entryList = new ArrayList<ChangeListEntryInfo>(8);
            JSONArray entrys = bill.getJSONArray("entryentity");
            entrys.forEach(entry -> {
                JSONObject jsonEntry = (JSONObject)entry;
                String entryId = null;
                if (jsonEntry.get((Object)"id") != null) {
                    entryId = jsonEntry.get((Object)"id").toString();
                }
                String fieldId = (String)jsonEntry.get((Object)"fieldid");
                Boolean canRevise = (Boolean)jsonEntry.get((Object)"canrevise");
                Boolean canChange = (Boolean)jsonEntry.get((Object)"canchange");
                Boolean canBatChange = (Boolean)jsonEntry.get((Object)"canbatchange");
                ChangeListEntryInfo changeListEntryInfo = new ChangeListEntryInfo(entryId, fieldId, canRevise, canChange, canBatChange);
                entryList.add(changeListEntryInfo);
            });
            changeListInfo.setEntryList(entryList);
            String reHashCode = this.calculateObjectSHA(changeListInfo);
            if (!hashCode.equals(reHashCode)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u4fee\u6539\u6216\u4e0d\u662f\u5bfc\u51fa\u7684\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ChangeListImportPlugin_1", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)changeBillId)) {
                Long changeBillLongId;
                try {
                    changeBillLongId = Long.parseLong(changeBillId);
                }
                catch (NumberFormatException e1) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u53d8\u66f4\u767d\u540d\u5355\u5185\u7801\u683c\u5f0f\u9519\u8bef\u3002", (String)"ChangeListImportPlugin_2", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
                    e.setFireAfterImportData(false);
                    return;
                }
                QFilter filter = new QFilter("id", "=", (Object)changeBillLongId);
                DynamicObject s = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_changewhitelist", (String)"id,entryentity.id", (QFilter[])new QFilter[]{filter});
                if (s != null) {
                    ArrayList<String> entryIdList = new ArrayList<String>(8);
                    DynamicObjectCollection sentrys = s.getDynamicObjectCollection("entryentity");
                    for (DynamicObject ss : sentrys) {
                        entryIdList.add(ss.getPkValue().toString());
                    }
                    entrys.forEach(entry -> {
                        JSONObject jsonEntry = (JSONObject)entry;
                        String entryId = null;
                        if (jsonEntry.get((Object)"id") != null) {
                            entryId = jsonEntry.get((Object)"id").toString();
                        }
                        if (!entryIdList.contains(entryId)) {
                            jsonEntry.put("id", null);
                        }
                    });
                }
            }
        } else {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u53d8\u66f4\u540d\u5355\u6682\u4e0d\u652f\u6301\u5f53\u524d\u5bfc\u5165\u65b9\u5f0f\u3002", (String)"ChangeListImportPlugin_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        for (DynamicObject entry : entrys) {
            entry.set("fieldname", entry.get("fieldid"));
        }
    }

    private String calculateObjectSHA(Object obj) {
        StringBuilder hexString = new StringBuilder();
        try {
            byte[] digest;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            byte[] data = baos.toByteArray();
            oos.close();
            baos.close();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (byte b : digest = md.digest(data)) {
                hexString.append(String.format("%02x", b));
            }
        }
        catch (Exception e1) {
            log.error("ChangeListImportPlugin : calculateObjectSHA error : " + e1.getMessage());
        }
        return hexString.toString();
    }

    private Map<?, ?> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return ChangeListImportPlugin.format4Api((Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class));
        }
        if (sourceData instanceof Map) {
            return ChangeListImportPlugin.format4Api((Map)sourceData);
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<String, ArrayList<Object>> propMap = new HashMap<String, ArrayList<Object>>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        return null;
    }

    private static Map<String, Object> format4Api(Map sourceData) {
        if (sourceData == null || sourceData.get("importprop") != null) {
            return sourceData;
        }
        if (sourceData.get("number") != null) {
            sourceData.put("importprop", "number");
        }
        if (sourceData.get("id") != null) {
            sourceData.put("importprop", "id");
        }
        if (sourceData.get("operatornumber") != null) {
            sourceData.put("importprop", "operatornumber");
        }
        if (sourceData.get("operatorname") != null) {
            sourceData.put("importprop", "operatorname");
        }
        if (sourceData.get("phone") != null) {
            sourceData.put("importprop", "phone");
        }
        return sourceData;
    }
}

