/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Timeline;
import kd.bos.form.control.TimelineContentOption;
import kd.bos.form.control.TimelineLabelOption;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineText;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.XlogHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;

public class ChangeVersionPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel model = parentView.getModel();
            String pkId = (String)model.getValue("billpkid");
            String billName = (String)model.getValue("billname");
            Boolean isAllVersion = (Boolean)model.getValue("isallversion");
            Map<String, Map<String, Object>> changeVersionInfo = XlogHelper.getChangeVersionInfo(Long.valueOf(pkId), billName);
            if (changeVersionInfo != null && changeVersionInfo.size() > 0) {
                Timeline timeline = (Timeline)this.getView().getControl("timeline");
                ArrayList<TimelineOption> newTimelineOptions = new ArrayList<TimelineOption>(4);
                Iterator<Map.Entry<String, Map<String, Object>>> it = changeVersionInfo.entrySet().iterator();
                String latestVer = "";
                while (it.hasNext()) {
                    Map.Entry<String, Map<String, Object>> row = it.next();
                    if (StringUtils.isBlank((CharSequence)latestVer)) {
                        latestVer = row.getKey();
                    }
                    this.addNewTimeLine(newTimelineOptions, row.getKey(), row.getValue(), latestVer);
                }
                timeline.setClientTimelineOptions(newTimelineOptions);
            }
        }
    }

    private void addNewTimeLine(List<TimelineOption> newTimelineOptions, String key, Map<String, Object> value, String latestVer) {
        TimelineOption newTimelineOption = new TimelineOption();
        if (!"1".equals(key)) {
            String versionMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u7248", (String)"ChangeVersionPlugin_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), key);
            String changeStatus = (String)value.get("changestatus");
            ArrayList<TimelineText> contents = new ArrayList<TimelineText>();
            Long changerId = (Long)value.get("creator");
            String changerName = "";
            if (changerId != null && changerId != 0L) {
                DynamicObject changer = BusinessDataServiceHelper.loadSingle((Object)changerId, (String)"bos_user");
                changerName = changer.getString("name");
            }
            Date changeDate = (Date)value.get("biztime");
            String date = "";
            if (changeDate != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                date = sdf.format(changeDate);
            }
            contents.add(new TimelineText(new LocaleString(changerName + " " + date), null));
            if (key.equals(latestVer)) {
                String changeStatusName = BizChangeStatusEnum.getName(changeStatus);
                newTimelineOption.setContent(new TimelineContentOption(new LocaleString(versionMsg + "(" + changeStatusName + ")"), contents));
            } else {
                newTimelineOption.setContent(new TimelineContentOption(new LocaleString(versionMsg), contents));
            }
            newTimelineOption.setLabel(new TimelineLabelOption());
            newTimelineOptions.add(newTimelineOption);
        }
    }
}

