/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.changemodel.validator;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.changemodel.common.enums.BillChangeTypeEnum;

public class ChangeModelBcValidator
extends AbstractValidator {
    private static final String[] mustFilds = new String[]{"xsbillno", "xsbillid", "xsbillentryseq", "xsbillentryid"};

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject bill = extend.getDataEntity();
            String changeType = bill.getString("changetype");
            ArrayList<String> mustFieldList = new ArrayList<String>(Arrays.asList(mustFilds));
            if (!BillChangeTypeEnum.BATCHANGE.getValue().equals(changeType)) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("mappingentity");
            for (DynamicObject entry : entrys) {
                String tarField = entry.getString("targetfield");
                String srcField = entry.getString("sourcefield");
                if (!StringUtils.isNotBlank((CharSequence)tarField) || !mustFieldList.contains(tarField) || !StringUtils.isNotBlank((CharSequence)srcField)) continue;
                mustFieldList.remove(tarField);
            }
            if (mustFieldList.size() <= 0) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u5b57\u6bb5\u6620\u5c04\u4e2d\u7ef4\u62a4\u53d8\u66f4\u5355\u5b57\u6bb5[%1$s]\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"ChangeModelBcValidator_0", (String)"mpscmm-msbd-changemodel", (Object[])new Object[0]), String.join((CharSequence)",", mustFieldList));
            this.addMessage(extend, errorMsg, ErrorLevel.Error);
        }
    }
}

