/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.mpscmm.msbd.reserve.business.ConvRate;
import kd.mpscmm.msbd.reserve.business.UnitHelper;

public class ConvRateContext {
    private Map<String, ConvRate> convRateMap = new HashMap<String, ConvRate>(16);

    public ConvRate getConvRate(Long materialId, Long srcUnitId, Long tarUnitId) {
        String rateKey = materialId + "_" + srcUnitId + "_" + tarUnitId;
        ConvRate rate = this.convRateMap.get(rateKey);
        if (rate != null) {
            return rate;
        }
        rate = UnitHelper.getConvRate(materialId, srcUnitId, tarUnitId);
        this.convRateMap.put(rateKey, rate);
        return rate;
    }

    public BigDecimal getSrcQty(BigDecimal tarQty, Long materialId, Long srcUnitId, Long tarUnitId) {
        if (tarQty == null) {
            return BigDecimal.ZERO;
        }
        if (srcUnitId == null || tarUnitId == null || srcUnitId.equals(tarUnitId)) {
            return tarQty;
        }
        ConvRate rate = this.getConvRate(materialId, srcUnitId, tarUnitId);
        return rate.getSrcQty(tarQty);
    }
}

