/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.io.Serializable;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReserveCommonHelper {
    private static final Log logger = LogFactory.getLog(ReserveCommonHelper.class);
    private static String[] highHotCreateSql = new String[]{"IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_RESERVE_ASYNC_INFO') CREATE TABLE T_RESERVE_ASYNC_INFO ( FID BIGINT NOT NULL DEFAULT '0',FTRANSID BIGINT NOT NULL DEFAULT '0') ", "EXEC P_ALTERPK 'PK_T_RESERVE_ASYNC_INFO', 'T_RESERVE_ASYNC_INFO', 'FID', '1' ", "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_RESERVE_ASYNC_TRANSID') CREATE INDEX IDX_RESERVE_ASYNC_TRANSID ON T_RESERVE_ASYNC_INFO ( FTRANSID) "};

    public static boolean getScmParam(String paramNumber) {
        String cacheKeyName = "Reserve_" + paramNumber;
        boolean isEnable = false;
        if (ThreadCache.get((Object)cacheKeyName) == null) {
            QFilter qFilter = new QFilter("number", "=", (Object)paramNumber);
            DynamicObject scmParam = QueryServiceHelper.queryOne((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])qFilter.toArray());
            if (scmParam != null) {
                isEnable = scmParam.getBoolean("enable");
            }
            ThreadCache.put((Object)cacheKeyName, (Object)isEnable);
        } else {
            isEnable = (Boolean)ThreadCache.get((Object)cacheKeyName);
        }
        return isEnable;
    }

    public static void dealHighHotInfo(String billName) {
        if (billName == null) {
            return;
        }
        boolean isHighHot = ReserveCommonHelper.getScmParam("INV0007");
        if (isHighHot && ThreadCache.get((Object)"reserveHighHotTransId") == null) {
            long[] transIds = DB.genLongIds((String)"T_RESERVE_ASYNC_INFO", (int)2);
            MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)billName);
            DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
            String createTableSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_RESERVE_ASYNC_INFO') CREATE TABLE T_RESERVE_ASYNC_INFO ( FID BIGINT NOT NULL DEFAULT '0',FTRANSID BIGINT NOT NULL DEFAULT '0') ";
            String pkSql = "EXEC P_ALTERPK 'PK_T_RESERVE_ASYNC_INFO', 'T_RESERVE_ASYNC_INFO', 'FID', '1' ";
            String indexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_RESERVE_ASYNC_TRANSID') CREATE INDEX IDX_RESERVE_ASYNC_TRANSID ON T_RESERVE_ASYNC_INFO ( FTRANSID) ";
            ReserveCommonHelper.executeSql(route, createTableSql);
            ReserveCommonHelper.executeSql(route, pkSql);
            ReserveCommonHelper.executeSql(route, indexSql);
            String insertSql = StringUtils.join((Object[])new Serializable[]{"insert into T_RESERVE_ASYNC_INFO(FID,FTRANSID) values(", Long.valueOf(transIds[0]), ",", Long.valueOf(transIds[1]), ")"});
            ReserveCommonHelper.executeSql(route, insertSql);
            ThreadCache.put((Object)"reserveHighHotTransId", (Object)transIds[1]);
        }
    }

    private static void executeSql(DBRoute db, String sql) {
        DB.execute((DBRoute)db, (String)sql);
    }
}

