/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.SchemeHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.QtyStore;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;
import org.apache.commons.lang3.StringUtils;

public class ReserveContext {
    private ConvRateContext convRate = new ConvRateContext();
    private static final Log logger = LogFactory.getLog(ReserveContext.class);
    private DynamicObject scheme;
    private QFilter schemeFilter;
    private boolean isAutoReserve;
    private boolean isAggregate;
    private List<String> aggregateField;
    private boolean compatibleDetail;
    private boolean isAggregateInit;
    private String reserveType;
    private DynamicObject requestBill;
    private String requestFormId;
    private Map<String, ColsMap> colsMap = new HashMap<String, ColsMap>(16);
    private DynamicObjectCollection requestEntryList;
    private BillReserveResult curBillResult = new BillReserveResult();
    private Map<Long, BillReserveResult> strategyCurResultMap = null;
    private Map<String, Object> extensionContext = new HashMap<String, Object>();
    private Map<Long, QFilter> orgFilterMap;
    private List<String> billModelFieldSet;
    private List<String> balModelFieldSet;

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public List<String> getAggregateField() {
        return this.aggregateField;
    }

    public boolean isCompatibleDetail() {
        return this.compatibleDetail;
    }

    public boolean isAggregateInit() {
        return this.isAggregateInit;
    }

    public Map<Long, QFilter> getOrgFilterMap() {
        return this.orgFilterMap;
    }

    public void setOrgFilterMap(Map<Long, QFilter> orgFilterMap) {
        this.orgFilterMap = orgFilterMap;
    }

    public List<String> getBillModelFieldSet() {
        return this.billModelFieldSet;
    }

    public void setBillModelFieldSet(List<String> billModelFieldSet) {
        this.billModelFieldSet = billModelFieldSet;
    }

    public List<String> getBalModelFieldSet() {
        return this.balModelFieldSet;
    }

    public void setBalModelFieldSet(List<String> balModelFieldSet) {
        this.balModelFieldSet = balModelFieldSet;
    }

    public ReserveContext() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        this.billModelFieldSet = new ArrayList<String>(32);
        this.balModelFieldSet = new ArrayList<String>(32);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                this.billModelFieldSet.add(key);
                continue;
            }
            if (!key.startsWith("s_")) continue;
            this.balModelFieldSet.add(key);
        }
    }

    public ReserveContext(DynamicObject requestBill, Map<String, Object> aggregateCfg) {
        this();
        this.requestBill = requestBill;
        this.scheme = SchemeHelper.getUsableSchemeForReqBill(requestBill);
        if (this.scheme == null) {
            throw new KDBizException(ResUtil.formatMsg(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u9884\u7559\u65b9\u6848\uff0c\u8bf7\u5148\u589e\u52a0\u9884\u7559\u65b9\u6848\u3002", (String)"ReserveContext_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveContext_0", requestBill.getPkValue()));
        }
        this.requestFormId = requestBill.getDynamicObjectType().getName();
        this.curBillResult.setBillId(this.getRequestBillId());
        this.isAggregate = (Boolean)aggregateCfg.get("isAggregate");
        this.isAggregateInit = (Boolean)aggregateCfg.get("isAggregateInit");
        this.aggregateField = (List)aggregateCfg.get("aggregateField");
        this.compatibleDetail = (Boolean)aggregateCfg.get("compatibleDetail");
        this.reserveType = "0";
    }

    public ReserveContext(DynamicObject requestBill, DynamicObject scheme) {
        this();
        this.requestBill = requestBill;
        if (!requestBill.equals(scheme)) {
            this.scheme = scheme;
        }
        this.requestFormId = requestBill.getDynamicObjectType().getName();
        this.curBillResult.setBillId(this.getRequestBillId());
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        this.isAggregate = (Boolean)aggregateCfg.get("isAggregate");
        this.isAggregateInit = (Boolean)aggregateCfg.get("isAggregateInit");
        this.aggregateField = (List)aggregateCfg.get("aggregateField");
        this.compatibleDetail = (Boolean)aggregateCfg.get("compatibleDetail");
        this.reserveType = "1";
    }

    public ReserveContext(DynamicObject requestBill, DynamicObject scheme, Map<String, Object> aggregateCfg) {
        this();
        this.requestBill = requestBill;
        this.scheme = scheme;
        this.requestFormId = requestBill.getDynamicObjectType().getName();
        this.curBillResult.setBillId(this.getRequestBillId());
        this.isAggregate = (Boolean)aggregateCfg.get("isAggregate");
        this.isAggregateInit = (Boolean)aggregateCfg.get("isAggregateInit");
        this.aggregateField = (List)aggregateCfg.get("aggregateField");
        this.compatibleDetail = (Boolean)aggregateCfg.get("compatibleDetail");
        this.reserveType = "0";
    }

    public ReserveContext(DynamicObject requestBill, ReserveContext parentContext) {
        this(requestBill, ReserveAggregateHelper.getAggregateConfig());
        this.extensionContext = parentContext == null ? new HashMap<String, Object>() : parentContext.getExtensionContext();
    }

    public String getSchemeResultHandlerType() {
        return this.scheme.getString("result_handler");
    }

    public DynamicObjectCollection getRequestEntryList() {
        if (this.requestEntryList == null) {
            this.requestEntryList = this.getEntryList();
        }
        return this.requestEntryList;
    }

    public List<RequestBillEntryParam> getRequestBillEntryParams() {
        List<RequestBillEntryParam> requestBillEntryParams = this.getRequestBillEntryParamList();
        return requestBillEntryParams;
    }

    public List<RequestBillEntryParam> getRequestBillEntryParamList() {
        if (this.requestEntryList == null) {
            this.requestEntryList = this.getRequestEntryList();
        }
        Map<Object, QtyStore> oldReserveQtyMap = this.getOldReserveQtyMap();
        ArrayList<RequestBillEntryParam> requestBillEntryParams = new ArrayList<RequestBillEntryParam>(this.requestEntryList.size());
        Iterator it = this.requestEntryList.iterator();
        while (it.hasNext()) {
            DynamicObject requestEntry = (DynamicObject)it.next();
            BigDecimal baseQty = this.getAllQty(requestEntry, "base_qty");
            if (baseQty.compareTo(BigDecimal.ZERO) > 0) {
                RequestBillEntryParam billEntryParam = RequestBillEntryParam.getInstance(requestEntry);
                QtyStore qtyStore = oldReserveQtyMap.getOrDefault(requestEntry.getPkValue(), new QtyStore());
                qtyStore.setBaseQty(baseQty);
                qtyStore.setQty(this.getAllQty(requestEntry, "qty"));
                qtyStore.setQty2end(this.getAllQty(requestEntry, "aux_qty"));
                billEntryParam.initQtyStore(qtyStore);
                requestBillEntryParams.add(billEntryParam);
                continue;
            }
            it.remove();
        }
        return requestBillEntryParams;
    }

    private Map<Object, QtyStore> getOldReserveQtyMap() {
        HashMap<Object, QtyStore> oldReserveQtyMap = new HashMap<Object, QtyStore>(16);
        QFilter billF = new QFilter("bill_id", "=", this.getRequestBill().getPkValue());
        DynamicObjectCollection reserveCols = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"id,billentry_id,base_qty,qty,qty2nd", (QFilter[])billF.toArray());
        HashMap<Long, Long> reserveEntryIdMap = new HashMap<Long, Long>(reserveCols.size());
        for (DynamicObject reserveCol : reserveCols) {
            Long reserveId = reserveCol.getLong("id");
            Long entryId = reserveCol.getLong("billentry_id");
            reserveEntryIdMap.put(reserveId, entryId);
            QtyStore qtyStore = (QtyStore)oldReserveQtyMap.get(entryId);
            if (qtyStore == null) {
                qtyStore = new QtyStore();
                oldReserveQtyMap.put(entryId, qtyStore);
            }
            qtyStore.addLockBaseQty(reserveCol.getBigDecimal("base_qty"));
            qtyStore.addLockQty(reserveCol.getBigDecimal("qty"));
            qtyStore.addLockQty2end(reserveCol.getBigDecimal("qty2nd"));
        }
        if (reserveEntryIdMap.isEmpty()) {
            return oldReserveQtyMap;
        }
        QFilter releaseFilter = new QFilter("reserve_record", "in", reserveEntryIdMap.keySet());
        releaseFilter = releaseFilter.and("deletestatus", "!=", (Object)"1");
        DynamicObjectCollection releaseCols = QueryServiceHelper.query((String)"msmod_release_record", (String)"reserve_record,base_qty,qty,qty2nd", (QFilter[])releaseFilter.toArray());
        for (DynamicObject releaseCol : releaseCols) {
            QtyStore qtyStore;
            Long entryId = (Long)reserveEntryIdMap.get(releaseCol.getLong("reserve_record"));
            if (entryId == null || (qtyStore = (QtyStore)oldReserveQtyMap.get(entryId)) == null) continue;
            qtyStore.addLockBaseQty(releaseCol.getBigDecimal("base_qty"));
            qtyStore.addLockQty(releaseCol.getBigDecimal("qty"));
            qtyStore.addLockQty2end(releaseCol.getBigDecimal("qty2nd"));
        }
        return oldReserveQtyMap;
    }

    public final Object getRequestBillId() {
        if (this.requestBill.getDynamicObjectType().getName().equals("msmod_std_request_bill")) {
            String value = this.requestBill.getString("bill_id");
            Long id = Long.valueOf(value);
            return id;
        }
        return this.requestBill.getPkValue();
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public QFilter getSchemeFilter() {
        return this.schemeFilter;
    }

    public void setSchemeFilter(QFilter schemeFilter) {
        this.schemeFilter = schemeFilter;
    }

    public DynamicObject getRequestBill() {
        return this.requestBill;
    }

    public String getRequestBillTypeName() {
        return this.requestBill.getDynamicObjectType().getName();
    }

    public Map<String, Object> getExtensionContext() {
        return this.extensionContext;
    }

    public void setExtensionContext(Map<String, Object> extensionContext) {
        this.extensionContext = extensionContext;
    }

    public Object getBillNo() {
        try {
            if (this.requestBill.getDynamicObjectType().getName().equals("msmod_std_request_bill")) {
                Object billNo = this.requestBill.get("bill_no");
                return billNo;
            }
            String key = this.getDemandColsMap(this.requestFormId).getByBalCol("bill_no");
            return this.requestBill.get(key);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public DynamicObjectCollection getEntryList() {
        Map<String, String> balColMap = this.getDemandColsMap(this.requestFormId).getBalColMap();
        if ("msmod_std_request_bill".equals(this.requestBill.getDynamicObjectType().getName())) {
            return this.requestBill.getDynamicObjectCollection("bill_entry");
        }
        String material = this.getDemandColsMap(this.requestFormId).getByBalCol("bill_entry.material");
        String[] materialName = material.split("\\.");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection();
        if (materialName.length == 1) {
            entryCollection = this.isMaterialAllowReserve(this.requestBill, balColMap, entryCollection);
        } else {
            String key = this.getDemandColsMap(this.requestFormId).getByBalCol("bill_entry");
            if (StringUtils.isBlank((CharSequence)key)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9700\u6c42\u5355\u636e\u7684\u6620\u5c04\u914d\u7f6e\u201c\u5355\u636e\u4f53\u201d\u3002", (String)"ReserveContext_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
            DynamicObjectCollection dynamicObjectCollection = this.requestBill.getDynamicObjectCollection(key);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                entryCollection = this.isMaterialAllowReserve(dynamicObject, balColMap, entryCollection);
            }
        }
        return entryCollection;
    }

    private DynamicObjectCollection isMaterialAllowReserve(DynamicObject entryObj, Map<String, String> balColMap, DynamicObjectCollection entryCollection) {
        String selectProperties = "isreserve";
        if (ReserveCommonHelper.getScmParam("RESERVE001")) {
            DataSet invDataSet = this.getInventoryInfo(entryObj, balColMap, selectProperties);
            if (invDataSet == null || !invDataSet.hasNext()) {
                String MapKey = "";
                if (balColMap.get("bill_entry.material") != null) {
                    MapKey = balColMap.get("bill_entry.material").replace(entryObj.getDataEntityType().getName() + ".", "");
                }
                MapKey = MapKey + ".number";
                String str = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"ReserveContext_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                if (entryObj.get(MapKey) != null) {
                    str = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u65e0\u53ef\u7528\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"ReserveContext_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), entryObj.get(MapKey));
                }
                throw new KDBizException(str);
            }
            if (invDataSet.next().getBoolean(selectProperties).booleanValue()) {
                entryCollection.add((Object)entryObj);
            }
            if (invDataSet != null) {
                invDataSet.close();
            }
        } else {
            entryCollection.add((Object)entryObj);
        }
        return entryCollection;
    }

    private DataSet getInventoryInfo(DynamicObject dynamicObject, Map<String, String> balColMap, String selectProperties) {
        QFilter orgQFilter;
        Object materialpkValue;
        String MapKey = "";
        if (balColMap.get("bill_entry.material") != null) {
            MapKey = balColMap.get("bill_entry.material").replace(dynamicObject.getDataEntityType().getName() + ".", "");
        }
        if ((materialpkValue = dynamicObject.get(MapKey + ".masterid")) instanceof DynamicObject) {
            materialpkValue = ((DynamicObject)materialpkValue).getPkValue();
        }
        DynamicObject invorg = null;
        if (balColMap.get("invorg") != null) {
            String[] invOrgNameArray = balColMap.get("invorg").split("\\.");
            invorg = invOrgNameArray.length == 1 ? (DynamicObject)this.requestBill.get(balColMap.get("invorg")) : (DynamicObject)dynamicObject.get(invOrgNameArray[1]);
        }
        long orgId = (Long)(invorg == null ? Long.valueOf(0L) : invorg.getPkValue());
        if (this.orgFilterMap == null) {
            this.orgFilterMap = new HashMap<Long, QFilter>(8);
        }
        if ((orgQFilter = this.orgFilterMap.get(orgId)) == null) {
            orgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
            this.orgFilterMap.put(orgId, orgQFilter);
        }
        QFilter materialQFilter = new QFilter("masterid", "=", materialpkValue);
        materialQFilter = materialQFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ":getInventoryInfo"), (String)"bd_materialinventoryinfo", (String)selectProperties, (QFilter[])new QFilter[]{orgQFilter, materialQFilter}, null);
    }

    public BigDecimal getEntryRequestBaseQty(DynamicObject entry) {
        if ("msmod_std_request_bill".equals(this.requestBill.getDynamicObjectType().getName())) {
            return entry.getBigDecimal("base_qty");
        }
        String key = this.colsMap.get(this.requestFormId + "msmod_std_request_bill").getByBalCol("base_qty");
        return entry.getBigDecimal(key);
    }

    public BigDecimal getEntryReservedBaseQty(DynamicObject entry) {
        Object id = this.getEntryId(entry);
        List<EntryReserveResult> entryReserveResultList = this.getCurBillResult().getEntryResultList();
        for (EntryReserveResult entryReserveResult : entryReserveResultList) {
            if (!entryReserveResult.getEntryId().equals(id)) continue;
            return entryReserveResult.getReservedBaseQty();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getEntryRemainBaseQty(DynamicObject entry) {
        BigDecimal reservedBaseQty = this.getEntryReservedBaseQty(entry);
        BigDecimal requestBaseQty = this.getEntryRequestBaseQty(entry);
        BigDecimal remainBaseQty = requestBaseQty.subtract(reservedBaseQty);
        if (remainBaseQty.compareTo(BigDecimal.ZERO) >= 0) {
            return remainBaseQty;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAllQty(DynamicObject entry, String qty) {
        try {
            if ("msmod_std_request_bill".equals(this.requestBill.getDynamicObjectType().getName())) {
                return entry.getBigDecimal(qty);
            }
            String key = this.colsMap.get(this.requestFormId + "msmod_std_request_bill").getByBalCol("bill_entry." + qty);
            return ColsMapHelper.getMpingQty(entry, key);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public Object getEntryId(DynamicObject entry) {
        Object billEntryId = 0L;
        if (this.requestFormId.equals("msmod_std_request_bill")) {
            billEntryId = entry.getLong("entry_id");
        } else {
            String[] split;
            String entryKey;
            ColsMap requestCols = this.colsMap.get(this.requestFormId + "msmod_std_request_bill");
            String byBalCol = requestCols.getByBalCol("bill_entry.entry_id");
            if (StringUtils.isNotBlank((CharSequence)byBalCol) && (entryKey = entry.getDynamicObjectType().getName()).equals((split = byBalCol.split("\\."))[0])) {
                billEntryId = entry.get(split[split.length - 1]);
            }
        }
        if (billEntryId.equals(0L)) {
            billEntryId = entry.getPkValue();
        }
        return billEntryId;
    }

    public Object getEntryId(int entrySeqId) {
        return this.getEntryId((DynamicObject)this.getEntryList().get(entrySeqId));
    }

    public Object getEntryName() {
        if ("msmod_std_request_bill".equals(this.requestBill.getDynamicObjectType().getName())) {
            return "bill_entry";
        }
        String key = this.colsMap.get(this.requestFormId + "msmod_std_request_bill").getByBalCol("bill_entry");
        return key;
    }

    public boolean isAutoReserve() {
        this.isAutoReserve = "msmod_std_request_bill".equals(this.requestBill.getDynamicObjectType().getName()) ? this.requestBill.getBoolean("auto_reserve") : true;
        return this.isAutoReserve;
    }

    public BillReserveResult getCurBillResult() {
        return this.curBillResult;
    }

    public void setCurBillResult(BillReserveResult curBillResult) {
        this.curBillResult = curBillResult;
    }

    public String getRequestFormId() {
        return this.requestFormId;
    }

    public ColsMap getDemandColsMap(String formId) {
        ColsMap billColsMap = this.colsMap.get(formId + "msmod_std_request_bill");
        if (billColsMap == null) {
            billColsMap = ColsMapHelper.findBillColMaps(formId, "msmod_std_request_bill");
            this.colsMap.put(formId + "msmod_std_request_bill", billColsMap);
        }
        return billColsMap;
    }

    public ColsMap getSupColsMap(String formId) {
        ColsMap billColsMap = this.colsMap.get(formId + "msmod_std_inv_field");
        if (billColsMap == null) {
            billColsMap = ColsMapHelper.findBillColMaps(formId, "msmod_std_inv_field");
            this.colsMap.put(formId + "msmod_std_inv_field", billColsMap);
        }
        return billColsMap;
    }

    public String getReserveType() {
        return this.reserveType;
    }

    public void setReserveType(String reserveType) {
        this.reserveType = reserveType;
    }

    public Map<Long, BillReserveResult> getStrategyCurResultMap() {
        if (this.strategyCurResultMap == null) {
            this.initStrategyCurResultMap();
        }
        return this.strategyCurResultMap;
    }

    private void initStrategyCurResultMap() {
        DynamicObjectCollection strategyList = this.getScheme().getDynamicObjectCollection("strategy_entry");
        this.strategyCurResultMap = new HashMap<Long, BillReserveResult>();
        for (DynamicObject strategy : strategyList) {
            this.strategyCurResultMap.put(strategy.getLong("strategy_id"), new BillReserveResult());
        }
    }

    public ConvRateContext getConvRate() {
        return this.convRate;
    }

    public void initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        this.billModelFieldSet = new ArrayList<String>(32);
        this.balModelFieldSet = new ArrayList<String>(32);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                this.billModelFieldSet.add(key);
                continue;
            }
            if (!key.startsWith("s_")) continue;
            this.balModelFieldSet.add(key);
        }
    }
}

