/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;

public class ReserveServiceCfgFilterHelper {
    private static final Log logger = LogFactory.getLog(ReserveServiceCfgFilterHelper.class);

    public static String isPredictReplaceInv(String billNumber) {
        DynamicObject dynamicObject = ReserveServiceCfgFilterHelper.ReserveServiceDynamic(billNumber, "ReserveReplace");
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("transfertype");
    }

    public static DynamicObject ReserveServiceDynamic(String billNumber, String serviceName) {
        QFilter qFilter = new QFilter("number", "=", (Object)serviceName);
        DynamicObject serviceGroup = BusinessDataServiceHelper.loadSingle((String)"msmod_reservesergroup", (String)"id", (QFilter[])qFilter.toArray());
        Object pkValue = serviceGroup.getPkValue();
        QFilter fs = new QFilter("group", "=", pkValue).and(new QFilter("billobject", "=", (Object)billNumber)).and(new QFilter("enable", "=", (Object)"1"));
        return BusinessDataServiceHelper.loadSingle((String)"msmod_reserve_service_cfg", (String)"filter_value_tag,id,transfertype,billoperation", (QFilter[])fs.toArray());
    }

    public static List<Object> canReserveBillIds(String serviceNumber, Long[] idArr, String billName, String opName) {
        HashSet<Object> realIdSet;
        block7: {
            Long[] row;
            block6: {
                realIdSet = new HashSet<Object>(idArr.length);
                if (opName != null) break block6;
                Long[] longArray = idArr;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long id = longArray[i];
                    realIdSet.add(id);
                }
                break block7;
            }
            DataSet reserveServiceDataSet = ReserveServiceCfgFilterHelper.getServiceCfg(serviceNumber, billName);
            boolean noFilter = false;
            boolean hasService = false;
            DataSet dataSetCopy = reserveServiceDataSet.copy();
            while (dataSetCopy.hasNext()) {
                row = dataSetCopy.next();
                hasService = true;
                String filterStr = row.getString("f_filter_value_tag");
                if (!StringUtils.isEmpty((CharSequence)filterStr) && !"{\"filterRow\":[],\"forList\":false}".equals(filterStr)) continue;
                noFilter = true;
            }
            if (!hasService) break block7;
            if (noFilter) {
                row = idArr;
                int filterStr = row.length;
                for (int i = 0; i < filterStr; ++i) {
                    long id = row[i];
                    realIdSet.add(id);
                }
            } else {
                DynamicObject[] reserveBill = BusinessDataServiceHelper.load((Object[])idArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billName));
                List<DynamicObject> dynamicObjects = ReserveServiceCfgFilterHelper.filterBillObj(serviceNumber, billName, reserveBill, opName, reserveServiceDataSet);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    realIdSet.add(dynamicObject.getPkValue());
                }
            }
        }
        return new ArrayList<Object>(realIdSet);
    }

    public static DynamicObject[] canReserveBillIdDynamic(String serviceNumber, String billName, DynamicObject[] reserveBill, String opName) {
        DataSet reserveServiceDataSet = ReserveServiceCfgFilterHelper.getServiceCfg(serviceNumber, billName);
        List<DynamicObject> realObjSet = ReserveServiceCfgFilterHelper.filterBillObj(serviceNumber, billName, reserveBill, opName, reserveServiceDataSet);
        return realObjSet.toArray(new DynamicObject[realObjSet.size()]);
    }

    private static List<DynamicObject> filterBillObj(String serviceNumber, String billName, DynamicObject[] reserveBill, String opName, DataSet reserveServiceDataSet) {
        ArrayList<DynamicObject> realObjSet = new ArrayList<DynamicObject>(8);
        List<DynamicObject> reserveFilterSet = ReserveServiceCfgFilterHelper.getReserveFilter(serviceNumber, billName, opName, reserveServiceDataSet);
        if (reserveFilterSet.size() > 0) {
            for (DynamicObject bill : reserveBill) {
                boolean isVer = false;
                try {
                    isVer = bill.getBoolean("isvirtualbill");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (isVer) continue;
                for (DynamicObject obj : reserveFilterSet) {
                    String filterStr = obj.getString("filter_value_tag");
                    try {
                        if (!FilterParser.execExcelFormula(filterStr, bill)) continue;
                        realObjSet.add(bill);
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                }
            }
        }
        return realObjSet;
    }

    private static List<DynamicObject> getReserveFilter(String serviceNumber, String billName, String opName, DataSet reserveServiceDataSet) {
        ArrayList<DynamicObject> filterSet = new ArrayList<DynamicObject>(8);
        HashMap<Long, DynamicObject> opFilterMap = new HashMap<Long, DynamicObject>(8);
        while (reserveServiceDataSet.hasNext()) {
            Row row = reserveServiceDataSet.next();
            String fbilloperation = row.getString("fbilloperation");
            String filterStr = row.getString("f_filter_value_tag");
            Long fid = row.getLong("fid");
            if (opName == null || StringUtils.isEmpty((CharSequence)filterStr)) {
                filterStr = "{\"filterRow\":[],\"forList\":false}";
            }
            DynamicObject serviceObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_service_cfg");
            serviceObj.set("billoperation", (Object)fbilloperation);
            serviceObj.set("filter_value_tag", (Object)filterStr);
            serviceObj.set("id", (Object)row.getLong("fid"));
            serviceObj.set("transfertype", (Object)row.getString("ftransfertype"));
            serviceObj.set("recordid", (Object)row.getString("frecordid"));
            serviceObj.set("entryid", (Object)row.getString("fentryid"));
            opFilterMap.put(fid, serviceObj);
        }
        for (Map.Entry opFilter : opFilterMap.entrySet()) {
            String fbilloperation = ((DynamicObject)opFilter.getValue()).getString("billoperation");
            String[] opValues = fbilloperation.split(",");
            DynamicObject filterResult = (DynamicObject)opFilter.getValue();
            ArrayList<String> opValList = new ArrayList<String>(8);
            for (String value : opValues) {
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                opValList.add(value);
            }
            if (opName != null && !opValList.contains(opName)) continue;
            filterSet.add(filterResult);
        }
        return filterSet;
    }

    private static DataSet getServiceCfg(String serviceNumber, String billName) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid from t_msmod_reservesergroup where fnumber = '").append(serviceNumber).append("'");
        long pkValue = 0L;
        DataSet groupDataSet = DB.queryDataSet((String)ReserveServiceCfgFilterHelper.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (String)sql.toString());
        while (groupDataSet.hasNext()) {
            Row row = groupDataSet.next();
            pkValue = row.getLong("fid");
        }
        String serviceSql = "select fid,fbilloperation,f_filter_value_tag,ftransfertype,frecordid,fentryid from t_msmod_reserveservice where fgroupid = ? and fbillobject = ? and fenable = '1'";
        Object[] param = new Object[]{pkValue, billName};
        return DB.queryDataSet((String)ReserveServiceCfgFilterHelper.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (String)serviceSql, (Object[])param);
    }

    public static Map<String, Object[]> getTransType(String serviceNumber, String billName, String opName, Set<Object> idSet) {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>(8);
        DataSet reserveServiceDataSet = ReserveServiceCfgFilterHelper.getServiceCfg(serviceNumber, billName);
        List<DynamicObject> reserveFilterSet = ReserveServiceCfgFilterHelper.getReserveFilter(serviceNumber, billName, opName, reserveServiceDataSet);
        if (reserveFilterSet.size() == 0) {
            return result;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billName);
        StringBuilder selFieldSb = new StringBuilder();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty po : properties) {
            if (po instanceof EntryProp) continue;
            if (selFieldSb.length() > 0) {
                selFieldSb.append(",");
            }
            selFieldSb.append(po.getName());
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObject[] reserveBill = BusinessDataServiceHelper.load((String)billName, (String)selFieldSb.toString(), (QFilter[])qFilter.toArray());
        StringBuilder errSb = new StringBuilder();
        for (DynamicObject bill : reserveBill) {
            boolean isVer = false;
            try {
                isVer = bill.getBoolean("isvirtualbill");
            }
            catch (Exception e) {
                errSb.append(e.getMessage());
            }
            if (isVer) continue;
            for (DynamicObject obj : reserveFilterSet) {
                String transType = obj.getString("transfertype");
                String filterStr = obj.getString("filter_value_tag");
                try {
                    if (!StringUtils.isEmpty((CharSequence)filterStr) && !"{\"filterRow\":[],\"forList\":false}".equals(filterStr) && !FilterParser.execExcelFormula(filterStr, bill)) continue;
                    Object[] objArray = (Object[])result.get(transType);
                    if (objArray == null) {
                        objArray = new Object[]{new HashSet(8), obj.getString("recordid"), obj.getString("entryid")};
                        result.put(transType, objArray);
                    }
                    Set realIdSet = (Set)objArray[0];
                    realIdSet.add(bill.getPkValue());
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        return result;
    }
}

