/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.check;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.check.NegativeFlag;
import kd.mpscmm.msbd.reserve.business.check.NegativeResult;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.helper.NegativeTipHelper;
import kd.mpscmm.msbd.reserve.common.constant.ReserveIgnoreCfgConst;
import org.apache.commons.lang3.StringUtils;

public class NegativeChecker {
    private static final String[] SELECT_COLS = new String[]{"id", "keycol", "warehouse", "material", "org", "baseqty", "qty", "qty2nd", "lockbaseqty", "lockqty", "lockqty2nd"};
    private static final String[] SELECT_PER_COLS = new String[]{"id", "keycol", "warehouse", "material", "org", "baseqty", "qty", "qty2nd"};
    private static final String[] outBillQtyArr = new String[]{"entryentity.baseqty", "entryentity.qty", "entryentity.qty2nd", "org"};
    public static final String ENTITY_MATERIALINVINFO = "bd_materialinventoryinfo";
    public static final String IMAPP_ID = "=9Q86DR2P+Q";
    public static final String CHECKQTYNEGIV = "ckqtynegiv";
    public static final String CHECKBASEQTYNEGIV = "ckbaseqtynegiv";
    public static final String CHECKTNDQTYNEGIV = "cktndqtynegiv";
    public static final String IM_INV_PERIODBALANCE = "im_inv_periodbalance";

    public static void check4Update(BalanceUpdateArgs args) {
        NegativeChecker.check(args);
    }

    private static void check(BalanceUpdateArgs args) {
        DataSet negativeBalance = NegativeChecker.getNegativeBalance(args);
        if (negativeBalance != null && negativeBalance.hasNext()) {
            NegativeChecker.checkNegative(args, negativeBalance);
        }
    }

    private static void checkNegative(BalanceUpdateArgs args, DataSet negativeBalance) {
        HashMap<Long, NegativeResult> negativeResultMap = new HashMap<Long, NegativeResult>(1024);
        Long orgId = null;
        NegativeFlag flag = null;
        NegativeResult flagResult = null;
        HashMap<Long, List<NegativeResult>> resultMaps = new HashMap<Long, List<NegativeResult>>(1024);
        ArrayList<NegativeResult> flagResults = null;
        HashMap<Long, NegativeFlag> params = new HashMap<Long, NegativeFlag>(64);
        HashMap<Long, Long> invIdOrgMap = new HashMap<Long, Long>(16);
        DataSet negativeBalanceCopy = negativeBalance.copy();
        for (Row row : negativeBalanceCopy) {
            orgId = row.getLong("forgid");
            flag = (NegativeFlag)params.get(orgId);
            if (flag == null) {
                params.put(orgId, flag);
                flag = NegativeChecker.getNeginvParams(orgId);
            }
            invIdOrgMap.put(row.getLong("fid"), row.getLong("forgid"));
            flagResult = new NegativeResult(flag, row);
            if (!flagResult.needCheck()) continue;
            if (row.get("isallowpartialneginv") != null && row.getBoolean("isallowpartialneginv").booleanValue()) {
                flagResults = (ArrayList<NegativeResult>)resultMaps.get(orgId);
                if (flagResults == null) {
                    flagResults = new ArrayList<NegativeResult>();
                    resultMaps.put(orgId, flagResults);
                }
                flagResults.add(flagResult);
                continue;
            }
            negativeResultMap.put(flagResult.getRecordId(), flagResult);
        }
        NegativeChecker.checkMaterial(args, resultMaps, negativeResultMap);
        if (!negativeResultMap.isEmpty()) {
            if (!IM_INV_PERIODBALANCE.equals(args.getRule().getBalanceNo())) {
                NegativeChecker.checkOutQty(args, negativeBalance, negativeResultMap, invIdOrgMap);
            }
            if (!negativeResultMap.isEmpty()) {
                NegativeChecker.throwNegativeException(args, negativeResultMap);
            }
        }
    }

    private static DataSet getOutBillData(BalanceUpdateArgs args, DataSet negativeBalanceCopy) {
        HashSet<String> billKeycols = new HashSet<String>(8);
        DataSet copy = negativeBalanceCopy.copy();
        while (copy.hasNext()) {
            Row next = copy.next();
            billKeycols.add(next.getString("fkeycol"));
        }
        String[] keyStr = billKeycols.toArray(new String[billKeycols.size()]);
        return args.getUpdatedSnapData(new String[]{"fbillid as outbillid", "fentryid", "fkeycol as keycol", "fbillno", "fentryseq"}, new String[]{"baseqty", "qty", "qty2nd"}, keyStr);
    }

    private static void checkOutQty(BalanceUpdateArgs args, DataSet negativeBalance, Map<Long, NegativeResult> negativeResultMap, Map<Long, Long> invIdOrgMap) {
        Long orgId = null;
        NegativeFlag flag = null;
        HashMap<Long, NegativeFlag> params = new HashMap<Long, NegativeFlag>(64);
        List<Long> noCheckBillList = NegativeChecker.checkIsIgnoreReserve(args);
        DataSet getOutBillData = NegativeChecker.getOutBillData(args, negativeBalance);
        String[] leftFieldNames = negativeBalance.getRowMeta().getFieldNames();
        negativeBalance = negativeBalance.join(getOutBillData, JoinType.INNER).on("fkeycol", "keycol").select(leftFieldNames, new String[]{"outbillid", "fentryid"}).finish();
        Set<Long> canOutSet = NegativeChecker.checkIsAllowOut(args, invIdOrgMap, negativeBalance.copy());
        for (Row row : negativeBalance) {
            if (negativeResultMap.get(row.getLong("fid")) == null) continue;
            orgId = row.getLong("forgid");
            flag = (NegativeFlag)params.get(orgId);
            if (flag == null) {
                params.put(orgId, flag);
                flag = NegativeChecker.getNeginvParams(orgId);
            }
            if (!NegativeChecker.isOutQtyLessThanInvQty(flag, row) || !noCheckBillList.contains(row.getLong("outbillid")) && !canOutSet.contains(row.getLong("fid"))) continue;
            negativeResultMap.remove(row.getLong("fid"));
        }
    }

    private static Set<Long> checkIsAllowOut(BalanceUpdateArgs args, Map<Long, Long> invIdOrgMap, DataSet negativeBalance) {
        HashSet<Long> canOutSet = new HashSet<Long>(8);
        HashSet<Long> reserveRecordId = new HashSet<Long>(16);
        QFilter reserveReleaseQFilter = new QFilter("billid", "in", (Object)args.getCtx().getBillIds());
        QFilter reserveRecordQFilter = new QFilter("id", "in", reserveRecordId);
        Set<Long> reserveIds = NegativeChecker.getReserveIds(negativeBalance);
        if (!reserveIds.isEmpty()) {
            QFilter qFilter = new QFilter("reserve_record", "in", reserveIds).or("aggregateid", "!=", (Object)0L);
            reserveReleaseQFilter.and(qFilter);
        } else {
            reserveReleaseQFilter.and("aggregateid", "!=", (Object)0L);
        }
        DataSet reserveReleaseDataSet = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)"msmod_release_record", (String)"reserve_record,billid,entryid,base_qty as releasebaseqty,qty as releaseqty,qty2nd as releaseqty2nd", (QFilter[])reserveReleaseQFilter.toArray(), null);
        DataSet resveReleaseCopy = reserveReleaseDataSet.copy();
        if (!resveReleaseCopy.hasNext()) {
            return canOutSet;
        }
        while (resveReleaseCopy.hasNext()) {
            Row releaseRow = resveReleaseCopy.next();
            Long reserve_record = releaseRow.getLong("reserve_record");
            reserveRecordId.add(reserve_record);
        }
        DataSet reserveRecordDataSet = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)"msmod_reserve_record", (String)"id as recordid,bal_id,aggregateid,base_qty as recordbaseqty,qty as recordqty,qty2nd as recordqty2nd", (QFilter[])reserveRecordQFilter.toArray(), null);
        JoinDataSet joinData = reserveRecordDataSet.join(reserveReleaseDataSet, JoinType.INNER).on("recordid", "reserve_record");
        reserveRecordDataSet = joinData.select(new String[]{"recordid", "aggregateid", "bal_id", "billid", "entryid", "releasebaseqty", "releaseqty", "releaseqty2nd", "recordbaseqty", "recordqty", "recordqty2nd"}).finish();
        DataSet invInfoDataSet = reserveRecordDataSet.copy();
        DataSet groupDataSet = reserveRecordDataSet.groupBy(new String[]{"billid", "entryid"}).sum("releasebaseqty").sum("releaseqty").sum("releaseqty2nd").finish();
        ColsMap colsMap = ColsMapHelper.findBillColMap(args.getCtx().getEntityNumber(), "msmod_releasebill");
        if (colsMap == null) {
            return canOutSet;
        }
        Map<String, String> balColMap = colsMap.getBalColMap();
        String entryentity = balColMap.get("entryentity");
        StringBuilder builder = new StringBuilder();
        for (String col : outBillQtyArr) {
            builder.append(balColMap.get(col));
            builder.append(",");
        }
        builder.append("id,").append(entryentity).append(".id");
        QFilter billQFilter = new QFilter("id", "in", (Object)args.getCtx().getBillIds());
        DataSet outBillDataSet = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)args.getCtx().getEntityNumber(), (String)builder.toString(), (QFilter[])billQFilter.toArray(), null);
        String[] leftCols = groupDataSet.getRowMeta().getFieldNames();
        DataSet outBillAndRecordDataSet = invInfoDataSet.join(groupDataSet, JoinType.INNER).on("billid", "billid").on("entryid", "entryid").select(new String[]{"aggregateid", "bal_id"}, leftCols).finish();
        String[] outBillRecordCols = outBillAndRecordDataSet.getRowMeta().getFieldNames();
        outBillAndRecordDataSet = outBillDataSet.join(outBillAndRecordDataSet, JoinType.LEFT).on("id", "billid").on(entryentity + ".id", "entryid").select(outBillDataSet.getRowMeta().getFieldNames(), outBillRecordCols).finish();
        outBillAndRecordDataSet = outBillAndRecordDataSet.join(negativeBalance, JoinType.INNER).on(entryentity + ".id", "fentryid").select(outBillAndRecordDataSet.getRowMeta().getFieldNames(), new String[]{"fid as supId"}).finish();
        HashMap<Long, NegativeFlag> params = new HashMap<Long, NegativeFlag>(64);
        HashSet<Long> canNotOutSet = new HashSet<Long>(8);
        while (outBillAndRecordDataSet.hasNext()) {
            Row row = outBillAndRecordDataSet.next();
            Long supId = null;
            Long orgId = null;
            NegativeFlag flag = null;
            supId = "msmod_reserveaggre".equals(args.getRule().getBalanceNo()) ? row.getLong("aggregateid") : row.getLong("bal_id");
            orgId = invIdOrgMap.get(supId) == null ? row.getLong(balColMap.get("org")) : invIdOrgMap.get(supId);
            flag = (NegativeFlag)params.get(orgId);
            if (flag == null) {
                params.put(orgId, flag);
                flag = NegativeChecker.getNeginvParams(orgId);
            }
            if (NegativeChecker.isNeedReleaseQtyCheck(flag, row, balColMap)) {
                canOutSet.add(supId);
                continue;
            }
            if (supId == null) {
                supId = row.getLong("supId");
            }
            canNotOutSet.add(supId);
        }
        canOutSet.removeAll(canNotOutSet);
        return canOutSet;
    }

    private static Set<Long> getReserveIds(DataSet negativeBalance) {
        HashSet<Long> balIds = new HashSet<Long>(8);
        HashSet<Long> reserveIds = new HashSet<Long>(8);
        HashSet<String> billKeycols = new HashSet<String>(8);
        DataSet copy = negativeBalance.copy();
        while (copy.hasNext()) {
            Row next = copy.next();
            billKeycols.add(next.getString("fkeycol"));
        }
        if (billKeycols.isEmpty()) {
            return reserveIds;
        }
        DataSet balData = QueryServiceHelper.queryDataSet((String)"kd.mpscmm.msbd.reserve.business.check.NegativeChecker.getBalUpdIds", (String)"im_inv_realbalance", (String)"id", (QFilter[])new QFilter("keycol", "in", billKeycols).toArray(), null);
        while (balData.hasNext()) {
            Row row = balData.next();
            balIds.add(row.getLong("id"));
        }
        if (!balIds.isEmpty()) {
            DataSet reserveData = QueryServiceHelper.queryDataSet((String)"kd.mpscmm.msbd.reserve.business.check.NegativeChecker.getBalUpdIds", (String)"msmod_reserve_record", (String)"id", (QFilter[])new QFilter("bal_id", "in", balIds).toArray(), null);
            while (reserveData.hasNext()) {
                Row row = reserveData.next();
                reserveIds.add(row.getLong("id"));
            }
        }
        return reserveIds;
    }

    private static boolean isOutQtyLessThanInvQty(NegativeFlag flag, Row row) {
        BigDecimal baseQty = row.getBigDecimal("fendbaseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fendbaseqty");
        BigDecimal qty = row.getBigDecimal("fendqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fendqty");
        BigDecimal tndQty = row.getBigDecimal("fendqty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("fendqty2nd");
        boolean baseQtyNegative = !flag.isCheckBaseQty() || baseQty.compareTo(BigDecimal.ZERO) >= 0;
        boolean qtyNegative = !flag.isCheckQty() || qty.compareTo(BigDecimal.ZERO) >= 0;
        boolean tndQtyNegative = !flag.isCheckTndQty() || tndQty.compareTo(BigDecimal.ZERO) >= 0;
        return baseQtyNegative && qtyNegative && tndQtyNegative;
    }

    private static boolean isNeedReleaseQtyCheck(NegativeFlag flag, Row row, Map<String, String> balColMap) {
        BigDecimal releasebaseQty = row.getBigDecimal("releasebaseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("releasebaseqty");
        BigDecimal releaseQty = row.getBigDecimal("releaseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("releaseqty");
        BigDecimal releaseQty2nd = row.getBigDecimal("releaseqty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("releaseqty2nd");
        BigDecimal outBillBaseQty = row.getBigDecimal(balColMap.get("entryentity.baseqty")) == null ? BigDecimal.ZERO : row.getBigDecimal(balColMap.get("entryentity.baseqty")).abs();
        BigDecimal outBillQty = row.getBigDecimal(balColMap.get("entryentity.qty")) == null ? BigDecimal.ZERO : row.getBigDecimal(balColMap.get("entryentity.qty")).abs();
        BigDecimal outBillQty2nd = row.getBigDecimal(balColMap.get("entryentity.qty2nd")) == null ? BigDecimal.ZERO : row.getBigDecimal(balColMap.get("entryentity.qty2nd")).abs();
        boolean baseQtyNegative = !flag.isCheckBaseQty() || releasebaseQty.compareTo(outBillBaseQty) >= 0;
        boolean qtyNegative = !flag.isCheckQty() || releaseQty.compareTo(outBillQty) >= 0;
        boolean tndQtyNegative = !flag.isCheckTndQty() || releaseQty2nd.compareTo(outBillQty2nd) >= 0;
        return baseQtyNegative && qtyNegative && tndQtyNegative;
    }

    private static List<Long> checkIsIgnoreReserve(BalanceUpdateArgs args) {
        ArrayList<Long> ignoreBillList = new ArrayList<Long>(8);
        Map<String, Map<QFilter, String>> ignoreCft = NegativeChecker.getIgnoreCft();
        String entityNumber = args.getCtx().getEntityNumber();
        String entryName = args.getRule().getEntryName();
        Set billIds = args.getCtx().getBillIds();
        for (Object billId : billIds) {
            boolean ignoreId = NegativeChecker.isIgnoreId(entityNumber, ignoreCft, billId, entryName);
            if (!ignoreId) continue;
            ignoreBillList.add((Long)billId);
        }
        return ignoreBillList;
    }

    private static boolean isIgnoreId(String entityNumber, Map<String, Map<QFilter, String>> ignoreCft, Object billId, String entryentity) {
        QFilter chain = null;
        for (Map.Entry<String, Map<QFilter, String>> stringQFilterEntry : ignoreCft.entrySet()) {
            if (!StringUtils.equals((CharSequence)stringQFilterEntry.getKey(), (CharSequence)entityNumber)) continue;
            String highFilter = "";
            Map<QFilter, String> filtAndHighFilter = stringQFilterEntry.getValue();
            if (filtAndHighFilter != null) {
                for (Map.Entry<QFilter, String> qFilterStringEntry : filtAndHighFilter.entrySet()) {
                    QFilter qFilter = qFilterStringEntry.getKey();
                    chain = new QFilter("id", "=", billId);
                    chain.and(qFilter);
                    highFilter = qFilterStringEntry.getValue();
                }
                DynamicObject autoBill = null;
                if (chain == null) continue;
                autoBill = BusinessDataServiceHelper.loadSingle((String)entityNumber, (QFilter[])chain.toArray());
                if (autoBill == null) {
                    return false;
                }
                DynamicObjectCollection entryCollection = autoBill.getDynamicObjectCollection(entryentity);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                boolean flag = false;
                if (entryCollection != null) {
                    for (DynamicObject entryDynamic : entryCollection) {
                        if (StringUtils.isEmpty((CharSequence)highFilter)) {
                            flag = true;
                            continue;
                        }
                        flag = StringUtils.isNotEmpty((CharSequence)highFilter) && NegativeChecker.checkHighCondition(highFilter, entryDynamic, dataEntityType);
                    }
                }
                return flag;
            }
            return true;
        }
        return false;
    }

    private static Map<String, Map<QFilter, String>> getIgnoreCft() {
        DynamicObject reserveIgnoreCfg = BusinessDataServiceHelper.loadSingle((String)"msmod_ignorereserve_cfg", (QFilter[])new QFilter("id", "=", (Object)ReserveIgnoreCfgConst.ID).toArray());
        DynamicObjectCollection billCfgEntry = reserveIgnoreCfg.getDynamicObjectCollection("entryentity");
        HashMap<String, Map<QFilter, String>> billFilter = new HashMap<String, Map<QFilter, String>>(billCfgEntry.size());
        for (DynamicObject billCfg : billCfgEntry) {
            DynamicObject bizEntry = billCfg.getDynamicObject("bizentity");
            if (bizEntry == null) continue;
            String number = bizEntry.getString("number");
            String condition = billCfg.getString("condition");
            String conJson = billCfg.getString("conditionjson_tag");
            boolean enable = billCfg.getBoolean("entryenable");
            if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
            HashMap<QFilter, String> highFilterMap = new HashMap<QFilter, String>(billCfgEntry.size());
            if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)conJson) && enable) {
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)number);
                CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)conJson, CRCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, crCondition.getFilterCondition());
                filterBuilder.buildFilter();
                QFilter filter = filterBuilder.getQFilter();
                highFilterMap.put(filter, crCondition.getExpression());
                billFilter.put(number, highFilterMap);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)condition) || !enable) continue;
            billFilter.put(number, null);
        }
        return billFilter;
    }

    private static void throwNegativeException(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        String negativeMsg = null;
        InteractionContext ctx = new InteractionContext();
        if ("msmod_reserveaggre".equals(args.getRule().getBalanceNo())) {
            ctx.setCustShowFormId("mscommon_bal_opresult");
            negativeMsg = NegativeChecker.getNegativeDetail(args, msgs);
        } else if (IM_INV_PERIODBALANCE.equals(args.getRule().getBalanceNo())) {
            ctx.setCustShowFormId("im_per_bal_opresult");
            negativeMsg = NegativeChecker.getPerBalNegativeDetail(args, msgs);
        } else {
            ctx.setCustShowFormId("im_bal_opresult");
            negativeMsg = NegativeChecker.getNegativeDetail(args, msgs);
        }
        ctx.getCustShowParameter().put("msg", negativeMsg);
        ctx.setSimpleMessage(NegativeTipHelper.dealSimpleMsg(negativeMsg));
        throw new KDInteractionException("", ctx);
    }

    private static DataSet getNegativeBalance(BalanceUpdateArgs args) {
        List<String> aggField;
        DataSet balData;
        DataSet dataSet = balData = IM_INV_PERIODBALANCE.equals(args.getRule().getBalanceNo()) ? NegativeChecker.getPerBalDataDataSet(args) : NegativeChecker.getBalDataDataSet(args);
        if (balData == null || !balData.hasNext()) {
            return balData;
        }
        if ("msmod_reserveaggre".equals(args.getRule().getBalanceNo()) && !(aggField = ReserveAggregateHelper.getAggregateField()).contains("warehouse")) {
            balData = balData.addField("0", "isallowpartialneginv");
            balData = balData.select(new String[]{"fid", "fkeycol", "fwarehouseid", "fmaterialid", "forgid", "fbaseqty", "fqty", "fqty2nd", "isallowpartialneginv", "fendbaseqty", "fendqty", "fendqty2nd"});
            return balData;
        }
        DataSet forWarehouseData = balData.copy();
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        HashSet<Long> wareHouseIdSet = new HashSet<Long>(8);
        Integer[] rowKeyIndexArray = new Integer[]{forWarehouseData.getRowMeta().getFieldIndex("forgid"), forWarehouseData.getRowMeta().getFieldIndex("fwarehouseid")};
        while (forWarehouseData.hasNext()) {
            Row row = forWarehouseData.next();
            Long forgid = row.getLong(rowKeyIndexArray[0].intValue());
            Long wareHouseid = row.getLong(rowKeyIndexArray[1].intValue());
            orgIdSet.add(forgid);
            wareHouseIdSet.add(wareHouseid);
        }
        QFilter fs = new QFilter("org", "in", orgIdSet);
        fs.and("warehouse", "in", wareHouseIdSet);
        DataSet warehouseData = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)"im_warehousesetup", (String)"org,warehouse,isallowpartialneginv,isallowallneginv", (QFilter[])fs.toArray(), null);
        String[] leftCols = balData.getRowMeta().getFieldNames();
        String[] rightCols = warehouseData.getRowMeta().getFieldNames();
        balData = balData.leftJoin(warehouseData).on("forgid", "org").on("fwarehouseid", "warehouse").select(leftCols, rightCols).finish();
        balData = balData.copy().filter(new FilterFunction(){

            public boolean test(Row row) {
                Boolean isAllowAllNeg = row.getBoolean("isallowallneginv");
                return isAllowAllNeg == null || isAllowAllNeg == false;
            }
        });
        return balData;
    }

    private static DataSet getBalDataDataSet(BalanceUpdateArgs args) {
        long t1 = System.currentTimeMillis();
        DataSet balData = args.getBalData4NegativeCheck(SELECT_COLS);
        long t2 = System.currentTimeMillis();
        if (ReserveCommonHelper.getScmParam("INV0007")) {
            DataSet balDataCopy = balData.copy();
            ArrayList<Long> invIdList = new ArrayList<Long>(16);
            while (balDataCopy.hasNext()) {
                invIdList.add(balDataCopy.next().getLong("id"));
            }
            QFilter spFilter = new QFilter("invid", "in", invIdList);
            DataSet spReserveDataSet = QueryServiceHelper.queryDataSet((String)"NegativeChecker.getBalDataDataSet", (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as spbaseqty,qty as spqty,qty2nd as spqty2nd", (QFilter[])spFilter.toArray(), null);
            if (spReserveDataSet.hasNext()) {
                spReserveDataSet = spReserveDataSet.groupBy(new String[]{"invid"}).sum("spbaseqty").sum("spqty").sum("spqty2nd").finish();
                balData = balData.leftJoin(spReserveDataSet).on("id", "invid").select(balData.getRowMeta().getFieldNames(), new String[]{"case when spbaseqty is null then 0 else spbaseqty end as spbaseqty", "case when spqty is null then 0 else spqty end as spqty", "case when spqty2nd is null then 0 else spqty2nd end as spqty2nd"}).finish();
            } else {
                balData = balData.addField("0", "spbaseqty").addField("0", "spqty").addField("0", "spqty2nd");
            }
            balData = balData.addFields(new String[]{"baseqty-lockbaseqty-spbaseqty", "qty-lockqty-spqty", "qty2nd-lockqty2nd-spqty2nd"}, new String[]{"fbaseqty", "fqty", "fqty2nd"});
        } else {
            balData = balData.addFields(new String[]{"baseqty-lockbaseqty", "qty-lockqty", "qty2nd-lockqty2nd"}, new String[]{"fbaseqty", "fqty", "fqty2nd"});
        }
        balData = balData.select(new String[]{"id as fid", "keycol as fkeycol", "warehouse as fwarehouseid", "material as fmaterialid", "org as forgid", "fbaseqty", "fqty", "fqty2nd", "baseqty as fendbaseqty", "qty as fendqty", "qty2nd as fendqty2nd"});
        balData = balData.filter("fbaseqty < 0 or fqty < 0 or fqty2nd < 0");
        return balData;
    }

    private static DataSet getPerBalDataDataSet(BalanceUpdateArgs args) {
        DataSet balData = args.getBalData4NegativeCheck(SELECT_PER_COLS);
        if (balData == null || !balData.hasNext()) {
            return null;
        }
        balData = balData.select(new String[]{"id as fid", "keycol as fkeycol", "warehouse as fwarehouseid", "material as fmaterialid", "org as forgid", "baseqty", "baseqty_bal as fbaseqty", "qty", "qty_bal as fqty", "qty2nd", "qty2nd_bal as fqty2nd", "baseqty as fendbaseqty", "qty as fendqty", "qty2nd as fendqty2nd"});
        balData = balData.filter("fbaseqty < 0 or fqty < 0 or fqty2nd < 0");
        return balData;
    }

    private static NegativeFlag getNeginvParams(Long orgId) {
        NegativeFlag flag = new NegativeFlag();
        Object ckBaseQty = NegativeChecker.getAppParameter(IMAPP_ID, "05", orgId, CHECKBASEQTYNEGIV);
        Object ckQty = NegativeChecker.getAppParameter(IMAPP_ID, "05", orgId, CHECKQTYNEGIV);
        Object cktndQty = NegativeChecker.getAppParameter(IMAPP_ID, "05", orgId, CHECKTNDQTYNEGIV);
        flag.setCheckBaseQty(ckBaseQty != null && "true".equalsIgnoreCase(ckBaseQty.toString()));
        flag.setCheckQty(ckQty != null && "true".equalsIgnoreCase(ckQty.toString()));
        flag.setCheckTndQty(cktndQty != null && "true".equalsIgnoreCase(cktndQty.toString()));
        return flag;
    }

    private static Map<Object, NegativeResult> getMaterialIdMap(List<NegativeResult> results) {
        HashMap<Object, NegativeResult> materialIdMap = new HashMap<Object, NegativeResult>(results.size());
        for (NegativeResult result : results) {
            materialIdMap.put(result.getMaterialId(), result);
        }
        return materialIdMap;
    }

    private static void checkMaterial(BalanceUpdateArgs args, Map<Long, List<NegativeResult>> resultMaps, Map<Long, NegativeResult> msgs) {
        QFilter fs = null;
        Map<Object, NegativeResult> materialIdMap = null;
        NegativeResult tempResult = null;
        for (Map.Entry<Long, List<NegativeResult>> result : resultMaps.entrySet()) {
            materialIdMap = NegativeChecker.getMaterialIdMap(result.getValue());
            fs = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_MATERIALINVINFO, (Long)result.getKey());
            fs.and("masterid", "in", materialIdMap.keySet());
            fs.and("isallowneginv", "=", (Object)"0");
            DataSet datas = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)ENTITY_MATERIALINVINFO, (String)"masterid", (QFilter[])fs.toArray(), null);
            for (Row row : datas) {
                tempResult = materialIdMap.get(row.getLong("masterid"));
                msgs.put(tempResult.getRecordId(), tempResult);
            }
        }
    }

    private static DataSet getSpData(BalanceUpdateArgs args, Map<Long, NegativeResult> msgMap) {
        DataSet record;
        String[] keyStr = new String[msgMap.size()];
        int index = 0;
        for (NegativeResult result : msgMap.values()) {
            keyStr[index++] = result.getKey();
        }
        if (IM_INV_PERIODBALANCE.equals(args.getRule().getBalanceNo())) {
            record = args.getUpdatedSnapData(new String[]{"fentryid", "fkeycol", "fbillno", "fentryseq", "fperiod"}, new String[]{"baseqty", "qty", "qty2nd"}, keyStr);
            return record;
        }
        record = args.getUpdatedSnapData(new String[]{"fentryid", "fkeycol", "fbillno", "fentryseq"}, new String[]{"baseqty", "qty", "qty2nd"}, keyStr);
        record = record.filter("baseqty < 0 or qty < 0 or qty2nd < 0");
        return record;
    }

    private static Map<Long, String> getBalQtyMsg(Map<Long, NegativeResult> results) {
        HashMap<Long, String> msg = new HashMap<Long, String>(results.size());
        NegativeResult result = null;
        for (Map.Entry<Long, NegativeResult> entry : results.entrySet()) {
            String oneMsg = "";
            ArrayList<String> strs = new ArrayList<String>(4);
            result = entry.getValue();
            if (result.isBaseQtyNegative()) {
                String baseQtyMsg = String.format(ResManager.loadResFormat((String)"\u57fa\u672c\u6570\u91cf\u77ed\u7f3a\uff1a%s", (String)"NegativeChecker_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), result.getBaseQty().abs().stripTrailingZeros().toPlainString());
                strs.add(baseQtyMsg);
            }
            if (result.isQtyNegative()) {
                String qtyMsg = String.format(ResManager.loadResFormat((String)"\u6570\u91cf\u77ed\u7f3a\uff1a%s", (String)"NegativeChecker_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), result.getQty().abs().stripTrailingZeros().toPlainString());
                strs.add(qtyMsg);
            }
            if (result.isTndQtyNegative()) {
                String tndQtyMsg = String.format(ResManager.loadResFormat((String)"\u8f85\u52a9\u6570\u91cf\u77ed\u7f3a\uff1a%s", (String)"NegativeChecker_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), result.getTndQty().abs().stripTrailingZeros().toPlainString());
                strs.add(tndQtyMsg);
            }
            if (CollectionUtils.isNotEmpty(strs)) {
                oneMsg = String.join((CharSequence)"\uff0c", strs) + "\u3002";
            }
            msg.put(entry.getKey(), oneMsg);
        }
        return msg;
    }

    private static String getNegativeDetail(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        String msg = NegativeChecker.getConfigTip(args, msgs);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return msg;
        }
        return NegativeChecker.getDefaultTip(args, msgs);
    }

    private static String getConfigTip(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        ArrayList resultList = new ArrayList();
        List<DynamicObject> tipFileds = NegativeChecker.getConfig(args);
        if (CollectionUtils.isEmpty(tipFileds)) {
            return null;
        }
        ArrayList confFields = new ArrayList(tipFileds.size());
        ArrayList<String> fields = new ArrayList<String>(tipFileds.size());
        for (int i = 0; i < tipFileds.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("seq", i);
            map.put("field", tipFileds.get(i).getString("balfield"));
            map.put("fieldName", tipFileds.get(i).getString("balfieldname"));
            map.put("showprop", tipFileds.get(i).getString("showprop"));
            map.put("basedataprop", tipFileds.get(i).getString("basedataprop"));
            confFields.add(map);
            fields.add(tipFileds.get(i).getString("balfield"));
        }
        QFilter fs = new QFilter("id", "in", msgs.keySet());
        BalanceTB tb = args.getRule().getBalanceTB();
        DataSet balData = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)tb.getName(), (String)NegativeChecker.getBalanceShowCols(tb), (QFilter[])fs.toArray(), null);
        DataSet spData = NegativeChecker.getSpData(args, msgs);
        DataSet data = balData.join(spData, JoinType.INNER).on("keycol", "fkeycol").select(balData.getRowMeta().getFieldNames(), spData.getRowMeta().getFieldNames()).finish();
        data = data.orderBy(new String[]{"fbillno", "fentryseq"});
        Map<Long, String> msgGroup = NegativeChecker.getBalQtyMsg(msgs);
        String template = ResManager.loadKDString((String)"%1$s\uff0c\u7b2c%2$s\u884c\u5206\u5f55", (String)"NegativeChecker_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
        for (Row row : data) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("bill", String.format(template, row.getString("fbillno"), row.get("fentryseq")));
            map.put("qty", msgGroup.get(row.getLong("id")));
            map.put("balId", row.getLong("id"));
            map.put("balentityname", tb.getName());
            map.put("config", confFields);
            map.put("fields", fields);
            resultList.add(map);
        }
        return JSONArray.toJSONString(resultList);
    }

    private static List<DynamicObject> getConfig(BalanceUpdateArgs args) {
        BalanceTB tb = args.getRule().getBalanceTB();
        String billNumStr = "," + args.getRule().getEntityNumber() + ",";
        List tipColList = null;
        QFilter qFilter = new QFilter("baltb", "=", (Object)tb.getName());
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"im_negative_tip_cf", (String)"id,baltb,billscope,entryentity.id,entryentity.balfield,entryentity.balfieldname,entryentity.tipcol,entryentity.showprop,entryentity.basedataprop", (QFilter[])qFilter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject config : dynamicObjects) {
                String billScope = config.getString("billscope");
                if (StringUtils.isEmpty((CharSequence)billScope) || !billScope.contains(billNumStr)) continue;
                DynamicObjectCollection collection = config.getDynamicObjectCollection("entryentity");
                tipColList = collection.stream().filter(item -> item.getBoolean("tipcol")).collect(Collectors.toList());
            }
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (CollectionUtils.isNotEmpty(tipColList)) {
            for (DynamicObject dyObj : tipColList) {
                if (!tb.getKeyCols().contains(dyObj.getString("balfield")) && !"keycol".equals(dyObj.getString("balfield"))) continue;
                list.add(dyObj);
            }
        }
        return list;
    }

    private static String getDefaultTip(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        ArrayList resultList = new ArrayList();
        QFilter fs = new QFilter("id", "in", msgs.keySet());
        BalanceTB tb = args.getRule().getBalanceTB();
        DataSet balData = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)tb.getName(), (String)NegativeChecker.getBalanceShowCols(tb), (QFilter[])fs.toArray(), null);
        DataSet spData = NegativeChecker.getSpData(args, msgs);
        DataSet data = balData.join(spData, JoinType.INNER).on("keycol", "fkeycol").select(balData.getRowMeta().getFieldNames(), spData.getRowMeta().getFieldNames()).finish();
        data = data.orderBy(new String[]{"fbillno", "fentryseq"});
        String template = ResManager.loadKDString((String)"%1$s\uff0c\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u5e93\u5b58\u4e0d\u8db3\uff1a\u7269\u6599\uff1a%3$s\uff08%4$s\uff09", (String)"NegativeChecker_0", (String)"scmc-im-business", (Object[])new Object[0]);
        String lotnum = ResManager.loadKDString((String)"\uff0c\u6279\u53f7\uff1a%s", (String)"NegativeChecker_4", (String)"scmc-im-business", (Object[])new Object[0]);
        Map<Long, String> msgGroup = NegativeChecker.getBalQtyMsg(msgs);
        for (Row row : data) {
            StringBuilder msg = new StringBuilder();
            msg.append(String.format(template, row.getString("fbillno"), row.get("fentryseq"), row.get("material.name"), row.get("material.number")));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{row.getString("lotnum")})) {
                msg.append(String.format(lotnum, row.getString("lotnum")));
            }
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("bill", msg.toString());
            map.put("qty", msgGroup.get(row.getLong("id")));
            map.put("balentityname", tb.getName());
            map.put("balId", row.getLong("id"));
            resultList.add(map);
        }
        return JSONArray.toJSONString(resultList);
    }

    private static String getBalanceShowCols(BalanceTB tb) {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",material.number");
        sb.append(",material.name");
        sb.append(",keycol");
        if (IM_INV_PERIODBALANCE.equals(tb.getName())) {
            sb.append(",lotnumber");
            sb.append(",period");
        } else {
            sb.append(",lotnum");
        }
        return sb.toString();
    }

    public static boolean checkHighCondition(String preCondition, DynamicObject checkObj, MainEntityType checkObjMainEntiy) {
        return NegativeChecker.checkHighCondition(checkObj.getDynamicObjectType().getName(), checkObjMainEntiy, preCondition, checkObj);
    }

    private static boolean checkHighCondition(String entry, MainEntityType type, String preCondition, DynamicObject dynamicObject) {
        RowDataModel rowDataModel = new RowDataModel(entry, type);
        ExpressionParameter preConditionParam = new ExpressionParameter(preCondition, rowDataModel);
        preConditionParam.setFcunLib(FunctionManage.get());
        preConditionParam.setActiveRow((Object)dynamicObject);
        return (Boolean)CalcExprParser.getExpressionValue((ExpressionParameter)preConditionParam);
    }

    private static Object getAppParameter(String appId, String viewType, Long orgId, String key) {
        AppParam appParam = new AppParam(appId, viewType, orgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
    }

    private static String getPerBalNegativeDetail(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        String msg = NegativeChecker.getPerBalConfigTip(args, msgs);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return msg;
        }
        return NegativeChecker.getPerBalDefaultTip(args, msgs);
    }

    private static String getPerBalConfigTip(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        ArrayList resultList = new ArrayList();
        List<DynamicObject> tipFileds = NegativeChecker.getConfig(args);
        if (CollectionUtils.isEmpty(tipFileds)) {
            return null;
        }
        ArrayList confFields = new ArrayList(tipFileds.size());
        ArrayList<String> fields = new ArrayList<String>(tipFileds.size());
        for (int i = 0; i < tipFileds.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("seq", i);
            map.put("field", tipFileds.get(i).getString("balfield"));
            map.put("fieldName", tipFileds.get(i).getString("balfieldname"));
            map.put("showprop", tipFileds.get(i).getString("showprop"));
            map.put("basedataprop", tipFileds.get(i).getString("basedataprop"));
            confFields.add(map);
            fields.add(tipFileds.get(i).getString("balfield"));
        }
        QFilter fs = new QFilter("id", "in", msgs.keySet());
        BalanceTB tb = args.getRule().getBalanceTB();
        DataSet balData = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)tb.getName(), (String)NegativeChecker.getBalanceShowCols(tb), (QFilter[])fs.toArray(), null);
        DataSet spData = NegativeChecker.getSpData(args, msgs);
        DataSet data = balData.join(spData, JoinType.INNER).on("keycol", "fkeycol").select(balData.getRowMeta().getFieldNames(), spData.getRowMeta().getFieldNames()).finish();
        data = data.filter("period >= fperiod");
        data = data.orderBy(new String[]{"fbillno", "fentryseq", "period"});
        Map<Long, String> msgGroup = NegativeChecker.getBalQtyMsg(msgs);
        String template = ResManager.loadKDString((String)"%1$s\uff0c\u7b2c%2$s\u884c\u5206\u5f55", (String)"NegativeChecker_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
        for (Row row : data) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("bill", String.format(template, row.getString("fbillno"), row.get("fentryseq")));
            map.put("qty", msgGroup.get(row.getLong("id")));
            map.put("balId", row.getLong("id"));
            map.put("balentityname", tb.getName());
            map.put("config", confFields);
            map.put("fields", fields);
            map.put("period", row.getInteger("period"));
            resultList.add(map);
        }
        return JSONArray.toJSONString(resultList);
    }

    private static String getPerBalDefaultTip(BalanceUpdateArgs args, Map<Long, NegativeResult> msgs) {
        ArrayList resultList = new ArrayList();
        QFilter fs = new QFilter("id", "in", msgs.keySet());
        BalanceTB tb = args.getRule().getBalanceTB();
        DataSet balData = QueryServiceHelper.queryDataSet((String)NegativeChecker.class.getName(), (String)tb.getName(), (String)NegativeChecker.getBalanceShowCols(tb), (QFilter[])fs.toArray(), null);
        DataSet spData = NegativeChecker.getSpData(args, msgs);
        DataSet data = balData.join(spData, JoinType.INNER).on("keycol", "fkeycol").select(balData.getRowMeta().getFieldNames(), spData.getRowMeta().getFieldNames()).finish();
        data = data.filter("period >= fperiod");
        data = data.orderBy(new String[]{"fbillno", "fentryseq", "period"});
        String template = ResManager.loadKDString((String)"%1$s\uff0c\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u5e93\u5b58\u4e0d\u8db3\uff1a\u7269\u6599\uff1a%3$s\uff08%4$s\uff09", (String)"NegativeChecker_0", (String)"scmc-im-business", (Object[])new Object[0]);
        String lotnum = ResManager.loadKDString((String)"\uff0c\u6279\u53f7\uff1a%s", (String)"NegativeChecker_4", (String)"scmc-im-business", (Object[])new Object[0]);
        Map<Long, String> msgGroup = NegativeChecker.getBalQtyMsg(msgs);
        for (Row row : data) {
            StringBuilder msg = new StringBuilder();
            msg.append(String.format(template, row.getString("fbillno"), row.get("fentryseq"), row.get("material.name"), row.get("material.number")));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{row.getString("lotnumber")})) {
                msg.append(String.format(lotnum, row.getString("lotnumber")));
            }
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("bill", msg.toString());
            map.put("qty", msgGroup.get(row.getLong("id")));
            map.put("balentityname", tb.getName());
            map.put("balId", row.getLong("id"));
            map.put("period", row.getInteger("period"));
            resultList.add(map);
        }
        return JSONArray.toJSONString(resultList);
    }
}

