/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.check;

import java.math.BigDecimal;
import kd.bos.algo.Row;
import kd.mpscmm.msbd.reserve.business.check.NegativeFlag;

class NegativeResult {
    private long recordId;
    private long materialId;
    private String key;
    private boolean baseQtyNegative;
    private boolean qtyNegative;
    private boolean tndQtyNegative;
    private BigDecimal baseQty;
    private BigDecimal qty;
    private BigDecimal tndQty;

    public BigDecimal getBaseQty() {
        return this.baseQty;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public BigDecimal getTndQty() {
        return this.tndQty;
    }

    public boolean isBaseQtyNegative() {
        return this.baseQtyNegative;
    }

    public void setBaseQtyNegative(boolean baseQtyNegative) {
        this.baseQtyNegative = baseQtyNegative;
    }

    public boolean isQtyNegative() {
        return this.qtyNegative;
    }

    public void setQtyNegative(boolean qtyNegative) {
        this.qtyNegative = qtyNegative;
    }

    public boolean isTndQtyNegative() {
        return this.tndQtyNegative;
    }

    public void setTndQtyNegative(boolean tndQtyNegative) {
        this.tndQtyNegative = tndQtyNegative;
    }

    public NegativeResult(NegativeFlag flag, Row row) {
        this.baseQty = row.getBigDecimal("fbaseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fbaseqty");
        this.qty = row.getBigDecimal("fqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fqty");
        this.tndQty = row.getBigDecimal("fqty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("fqty2nd");
        this.baseQtyNegative = flag.isCheckBaseQty() && this.baseQty.compareTo(BigDecimal.ZERO) < 0;
        this.qtyNegative = flag.isCheckQty() && this.qty.compareTo(BigDecimal.ZERO) < 0;
        this.tndQtyNegative = flag.isCheckTndQty() && this.tndQty.compareTo(BigDecimal.ZERO) < 0;
        this.key = row.getString("fkeycol");
        this.materialId = row.getLong("fmaterialid");
        this.recordId = row.getLong("fid");
    }

    public boolean needCheck() {
        return this.baseQtyNegative || this.qtyNegative || this.tndQtyNegative;
    }

    public String getKey() {
        return this.key;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.recordId ^ this.recordId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NegativeResult other = (NegativeResult)obj;
        return this.recordId == other.recordId;
    }

    public String toString() {
        return "NegativeResult [recordId=" + this.recordId + ", key=" + this.key + ", baseQtyNegative=" + this.baseQtyNegative + ", qtyNegative=" + this.qtyNegative + ", tndQtyNegative=" + this.tndQtyNegative + "]";
    }

    public long getMaterialId() {
        return this.materialId;
    }
}

