/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.datasource.DataReader;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class DefaultDataReader
implements DataReader {
    private static final Log logger = LogFactory.getLog(DefaultDataReader.class);
    private static String[] reserveQtyFields = new String[]{"case reserve_base_qty when null then 0 else reserve_base_qty end as reserve_base_qty", "case reserve_qty  when null then 0 else reserve_qty  end as reserve_qty", "case reserve_qty2nd  when null then 0 else reserve_qty2nd  end as reserve_qty2nd"};
    private static final String F_DATA_SOURCE = "data_source";
    private static final String F_ID = "id";
    private static final String F_ENTRY_ID = "entryid";

    @Override
    public DataSet readData(DynamicObject sourceConf, QFilter filter) {
        ColsMap colMap = ColsMap.getColsMap(sourceConf);
        HashMap<String, String> cols = new HashMap<String, String>(colMap.getBillColMap());
        if (!cols.containsKey(F_ID)) {
            cols.put(F_ID, F_ID);
        }
        DynamicObject dataSource = sourceConf.getDynamicObject(F_DATA_SOURCE);
        String actualBalEntity = dataSource.getPkValue().toString();
        String selectCols = StringUtils.join(cols.values(), (char)',');
        logger.info("Query Cols: " + selectCols);
        DataSet data = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)dataSource.getPkValue().toString(), (String)selectCols, (QFilter[])filter.toArray(), null);
        data = data.select(this.colAsCol(cols));
        data = data.addField("'1'", "source_type").addField("'" + actualBalEntity + "'", "source_bal_obj").addField("baseqty - reserve_base_qty", "avbbaseqty").addField("qty - reserve_qty", "avbqty").addField("qty2nd - reserve_qty2nd", "avbqty2nd");
        return data;
    }

    private String colAsCol(Map<String, String> cols) {
        ArrayList<String> colList = new ArrayList<String>(cols.size());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        String[] materiel = cols.get("materiel").split("\\.");
        if (materiel.length > 1) {
            // empty if block
        }
        for (Map.Entry<String, String> entry : cols.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (materiel.length == 1 && "billentry".equals(key)) continue;
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u5bf9\u8c61\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u4f9b\u5e94\u6a21\u578b\uff09\uff1a%1$s\u6ca1\u6709\u914d\u7f6e\u3002", (String)"DefaultDataReader_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), key));
            }
            if (colList.contains(key)) continue;
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(value).append(" AS ").append(key);
            colList.add(key);
        }
        return sb.toString();
    }

    @Override
    public DataSet readData(String supBillFormId, QFilter filter, ColsMap colsMap, boolean isPredict) {
        HashedMap balColMap = new HashedMap(colsMap.getBalColMap());
        if (!balColMap.containsKey(F_ID)) {
            balColMap.put(F_ID, F_ID);
        }
        String billEntry = (String)balColMap.get("billentry");
        String materiel = (String)balColMap.get("materiel");
        if (materiel == null) {
            return null;
        }
        String[] materielArray = materiel.split("\\.");
        if (materielArray.length > 1) {
            balColMap.put(F_ENTRY_ID, billEntry + ".id");
        } else {
            balColMap.put(F_ENTRY_ID, F_ID);
        }
        String selectCols = this.colAsCol((Map<String, String>)balColMap);
        selectCols = isPredict ? (balColMap.get("billentry") != null && materielArray.length > 1 ? StringUtils.join((Object[])new String[]{selectCols, ",", (String)balColMap.get("billentry"), ".seq as seq"}) : StringUtils.join((Object[])new String[]{selectCols, ",null as seq"})) : StringUtils.join((Object[])new String[]{selectCols, ",null as seq"});
        logger.info("Query Cols: " + selectCols);
        DataSet data = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)supBillFormId, (String)selectCols, (QFilter[])filter.toArray(), null);
        if (!balColMap.containsKey("qty2nd")) {
            data = data.addField("baseqty - baseqty", "qty2nd");
        } else if (!balColMap.containsKey("qty")) {
            data = data.addField("baseqty - baseqty", "qty");
        }
        if (isPredict) {
            data = this.getPredictReserveData(data);
        }
        if (!isPredict && ReserveCommonHelper.getScmParam("INV0007")) {
            DataSet spReserveDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as spbaseqty,qty as spqty,qty2nd as spqty2nd", null, null);
            if ((spReserveDataSet = spReserveDataSet.groupBy(new String[]{"invid"}).sum("spbaseqty").sum("spqty").sum("spqty2nd").finish()).hasNext()) {
                String[] fieldArray = data.getRowMeta().getFieldNames();
                data = data.leftJoin(spReserveDataSet).on(F_ID, "invid").select(fieldArray, spReserveDataSet.getRowMeta().getFieldNames()).finish();
                int arrLength = fieldArray.length;
                String[] newFieldArray = new String[arrLength + 3];
                System.arraycopy(fieldArray, 0, newFieldArray, 0, arrLength);
                newFieldArray[arrLength] = "case when spbaseqty is Null then 0 else spbaseqty end as spbaseqty";
                newFieldArray[arrLength + 1] = "case when spqty is Null then 0 else spqty end as spqty";
                newFieldArray[arrLength + 2] = "case when spqty2nd is Null then 0 else spqty2nd end as spqty2nd";
                data = data.select(newFieldArray);
            } else {
                data = data.addField("0", "spbaseqty").addField("0", "spqty").addField("0", "spqty2nd");
            }
        } else {
            data = data.addField("0", "spbaseqty").addField("0", "spqty").addField("0", "spqty2nd");
        }
        String[] rowFieldNames = data.getRowMeta().getFieldNames();
        boolean hasUnit = false;
        boolean hasUnit2nd = false;
        for (String str : rowFieldNames) {
            if ("unit".equals(str)) {
                hasUnit = true;
            }
            if (!"unit2nd".equals(str)) continue;
            hasUnit2nd = true;
        }
        data = data.addField("'1'", "source_type").addField("'" + supBillFormId + "'", "source_bal_obj").addField("baseqty - reserve_base_qty - spbaseqty", "avbbaseqty");
        data = hasUnit && balColMap.get("qty") != null ? data.addField("qty - reserve_qty - spqty", "avbqty") : data.addField("0", "avbqty");
        data = hasUnit2nd && balColMap.get("qty2nd") != null ? data.addField("qty2nd - reserve_qty2nd - spqty2nd", "avbqty2nd") : data.addField("0", "avbqty2nd");
        data = data.filter("avbbaseqty >0");
        data = data.distinct();
        Map<String, Object> aggCfg = ReserveAggregateHelper.getAggregateConfig();
        if (!isPredict && ((Boolean)aggCfg.get("isAggregate")).booleanValue()) {
            List aggregateField = (List)aggCfg.get("aggregateField");
            Map<String, String> aggBalMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
            StringBuilder sb = new StringBuilder();
            for (String field : aggregateField) {
                sb.append(aggBalMap.get(field)).append(" as ").append(field).append(',');
            }
            sb.append("id as aggid");
            QFilter qFilter = new QFilter("barobj", "=", (Object)supBillFormId);
            if ("im_inv_realbalance".equals(supBillFormId)) {
                qFilter.or("barobj", "is null", null).or("barobj", "=", (Object)" ").or("barobj", "=", (Object)"");
            }
            DataSet aggSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserveaggre", (String)sb.toString(), (QFilter[])qFilter.toArray(), null);
            JoinDataSet joinDataSet = data.leftJoin(aggSet);
            for (String field : aggregateField) {
                joinDataSet.on(field, field);
            }
            data = joinDataSet.select(data.getRowMeta().getFieldNames(), new String[]{"aggid"}).finish();
        } else {
            data = data.addField("0", "aggid");
        }
        return data;
    }

    private DataSet getPredictReserveData(DataSet data) {
        Set<Object> entryIds = this.getEntryIds(data);
        if (entryIds.isEmpty()) {
            data = data.addField("0", "reserve_base_qty").addField("0", "reserve_qty").addField("0", "reserve_qty2nd");
            return data;
        }
        int iLength = 0;
        String[] dataFieldNames = data.getRowMeta().getFieldNames();
        for (int i = 0; i < dataFieldNames.length; ++i) {
            if (!"reserve_base_qty".equals(dataFieldNames[i]) && !"reserve_qty".equals(dataFieldNames[i]) && !"reserve_qty2nd".equals(dataFieldNames[i])) continue;
            ++iLength;
        }
        String[] fieldNames = new String[dataFieldNames.length - iLength];
        int j = 0;
        for (int i = 0; i < dataFieldNames.length; ++i) {
            if ("reserve_base_qty".equals(dataFieldNames[i]) || "reserve_qty".equals(dataFieldNames[i]) || "reserve_qty2nd".equals(dataFieldNames[i])) continue;
            fieldNames[j] = dataFieldNames[i];
            ++j;
        }
        DataSet reserveRecords = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_record", (String)"bal_entryid,base_qty as reserve_base_qty ,qty as reserve_qty,qty2nd as reserve_qty2nd", (QFilter[])new QFilter("bal_entryid", "in", entryIds).toArray(), null);
        if (reserveRecords.isEmpty()) {
            data = data.addField("0", "bal_entryid");
            data = data.addField("0", "reserve_base_qty");
            data = data.addField("0", "reserve_qty");
            data = data.addField("0", "reserve_qty2nd");
        } else {
            reserveRecords = reserveRecords.groupBy(new String[]{"bal_entryid"}).sum("reserve_base_qty").sum("reserve_qty").sum("reserve_qty2nd").finish();
            data = data.join(reserveRecords, JoinType.LEFT).on(F_ENTRY_ID, "bal_entryid").select(fieldNames, reserveRecords.getRowMeta().getFieldNames()).finish();
            String[] selectFields = new String[fieldNames.length + reserveQtyFields.length];
            System.arraycopy(fieldNames, 0, selectFields, 0, fieldNames.length);
            System.arraycopy(reserveQtyFields, 0, selectFields, fieldNames.length, reserveQtyFields.length);
            data = data.select(selectFields);
        }
        return data;
    }

    private Set<Object> getEntryIds(DataSet data) {
        HashSet<Object> entryIds = new HashSet<Object>(16);
        DataSet copy = data.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            entryIds.add(row.get(F_ENTRY_ID));
        }
        return entryIds;
    }

    private String colAsSelectColForAggregate(ReserveContext context, Map<String, String> cols, List<String> colList) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : cols.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u5bf9\u8c61\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u4f9b\u5e94\u6a21\u578b\uff09\uff1a%1$s\u6ca1\u6709\u914d\u7f6e\u3002", (String)"DefaultDataReader_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), key));
            }
            if (!context.getAggregateField().contains(key) || colList.contains(key)) continue;
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(value).append(" AS ").append(key);
            colList.add(key);
        }
        return sb.toString();
    }

    @Override
    public DataSet readData(ReserveContext context, String supBillFormId, QFilter filter, ColsMap colsMap) {
        HashedMap balColMap = new HashedMap(colsMap.getBalColMap());
        ArrayList<String> colList = new ArrayList<String>(balColMap.size());
        Map<String, String> aggBalColMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
        String aggSelectCol = this.colAsSelectColForAggregate(context, aggBalColMap, colList);
        QFilter supFilter = new QFilter("barobj", "=", (Object)supBillFormId);
        if ("im_inv_realbalance".equals(supBillFormId)) {
            supFilter.or("barobj", "is null", null).or("barobj", "=", (Object)" ").or("barobj", "=", (Object)"");
        }
        filter = filter.and(supFilter);
        DataSet dataInv = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserveaggre", (String)StringUtils.join((Object[])new String[]{aggSelectCol, ",id as aggid,barobj as source_bal_obj,lockbaseqty,lockqty,lockqty2nd,baseqty,qty2nd,qty"}), (QFilter[])filter.toArray(), null);
        if (ReserveCommonHelper.getScmParam("INV0007")) {
            DataSet spReserveDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as spbaseqty,qty as spqty,qty2nd as spqty2nd", null, null);
            if ((spReserveDataSet = spReserveDataSet.groupBy(new String[]{"invid"}).sum("spbaseqty").sum("spqty").sum("spqty2nd").finish()).hasNext()) {
                String[] fieldArray = dataInv.getRowMeta().getFieldNames();
                dataInv = dataInv.leftJoin(spReserveDataSet).on("aggid", "invid").select(fieldArray, spReserveDataSet.getRowMeta().getFieldNames()).finish();
                int arrLength = fieldArray.length;
                String[] newFieldArray = new String[arrLength + 3];
                System.arraycopy(fieldArray, 0, newFieldArray, 0, arrLength);
                newFieldArray[arrLength] = "case when spbaseqty is Null then 0 else spbaseqty end as spbaseqty";
                newFieldArray[arrLength + 1] = "case when spqty is Null then 0 else spqty end as spqty";
                newFieldArray[arrLength + 2] = "case when spqty2nd is Null then 0 else spqty2nd end as spqty2nd";
                dataInv = dataInv.select(newFieldArray);
            } else {
                dataInv = dataInv.addField("0", "spbaseqty").addField("0", "spqty").addField("0", "spqty2nd");
            }
        } else {
            dataInv = dataInv.addField("0", "spbaseqty").addField("0", "spqty").addField("0", "spqty2nd");
        }
        String[] rowFieldNames = dataInv.getRowMeta().getFieldNames();
        boolean hasUnit = false;
        boolean hasUnit2nd = false;
        for (String str : rowFieldNames) {
            if ("unit".equals(str)) {
                hasUnit = true;
            }
            if (!"unit2nd".equals(str)) continue;
            hasUnit2nd = true;
        }
        dataInv = dataInv.addField("baseqty - lockbaseqty - spbaseqty", "avbbaseqty");
        dataInv = hasUnit && balColMap.get("qty") != null ? dataInv.addField("qty - lockqty - spqty", "avbqty") : dataInv.addField("0", "avbqty");
        dataInv = hasUnit2nd && balColMap.get("qty2nd") != null ? dataInv.addField("qty2nd - lockqty2nd - spqty2nd", "avbqty2nd") : dataInv.addField("0", "avbqty2nd");
        dataInv = dataInv.filter("avbbaseqty >0");
        dataInv = dataInv.distinct();
        return dataInv;
    }
}

