/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.datasource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.datasource.DataReader;
import kd.mpscmm.msbd.reserve.business.datasource.DefaultDataReader;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;
import kd.mpscmm.msbd.reserve.common.util.RowUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class MemoryDataReader
implements DataReader {
    private static final Log logger = LogFactory.getLog(MemoryDataReader.class);
    private static ThreadLocal<Map<Object, Map<String, Object>>> originalDataSource = new ThreadLocal();
    private static ThreadLocal<RowMeta> originalDataRowMata = new ThreadLocal();
    private static final String F_DATA_SOURCE = "data_source";
    private static final String F_ID = "id";

    @Override
    public DataSet readData(DynamicObject sourceConf, QFilter filter) {
        DefaultDataReader defaultDataReader = new DefaultDataReader();
        DataSet dataSet = defaultDataReader.readData(sourceConf, filter);
        DataSet data = MemoryDataReader.getDataSetInMemory(dataSet);
        return data;
    }

    public static void writeBackSource(BillReserveResult billResult) {
        Map<Object, Map<String, Object>> data = originalDataSource.get();
        List<EntryReserveResult> entryResult = billResult.getEntryResultList();
        data.forEach((balanceId, rowValue) -> {
            for (EntryReserveResult entryReserveResult : entryResult) {
                List<StdInvResult> stdInv = entryReserveResult.getStdInvResultList();
                for (StdInvResult invResult : stdInv) {
                    Object balanceIdTmp = invResult.getInvInfo().get("entryid");
                    if (!balanceId.equals(balanceIdTmp)) continue;
                    BigDecimal baseQty = (BigDecimal)rowValue.get("avbbaseqty");
                    rowValue.put("avbbaseqty", baseQty.subtract(invResult.getBaseQty()));
                    BigDecimal qty = (BigDecimal)rowValue.get("avbqty");
                    rowValue.put("avbqty", qty.subtract(invResult.getQty()));
                    BigDecimal qty2nd = (BigDecimal)rowValue.get("avbqty2nd");
                    rowValue.put("avbqty2nd", qty2nd.subtract(invResult.getQty2nd()));
                }
            }
        });
    }

    private static DataSet getDataSetInMemory(DataSet dataInDB) {
        ArrayList<Object[]> dataInMem = new ArrayList<Object[]>(16);
        Map<Object, Map<String, Object>> originalData = originalDataSource.get();
        while (dataInDB.hasNext()) {
            Row row = dataInDB.next();
            Object balanceId = row.get(F_ID);
            Map<String, Object> rowValue = originalData.get(balanceId);
            dataInMem.add(MemoryDataReader.copyRowValue(dataInDB.getRowMeta(), rowValue, row));
        }
        Algo algo = Algo.create((String)"MemoryDataReader.writeBackSource");
        DataSet dataSetInMem = algo.createDataSet(dataInMem.iterator(), dataInDB.getRowMeta());
        return dataSetInMem;
    }

    private static Object[] copyRowValue(RowMeta rowMeta, Map<String, Object> originalRow, Row row) {
        String[] fields = rowMeta.getFieldNames();
        Object[] newFields = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            newFields[i] = row.get(field);
            if (field.equals("avbbaseqty")) {
                newFields[i] = originalRow.get("avbbaseqty");
                continue;
            }
            if (field.equals("avbqty")) {
                newFields[i] = originalRow.get("avbqty");
                continue;
            }
            if (!field.equals("avbqty2nd")) continue;
            newFields[i] = originalRow.get("avbqty2nd");
        }
        return newFields;
    }

    public static void setDataSource(DataSet dataSet) {
        if (dataSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5185\u5b58\u6570\u636e\u6e90\u662f\uff0cDataSet\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemoryDataReader_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        originalDataSource.set(RowUtils.convertToMap(dataSet));
        originalDataRowMata.set(dataSet.getRowMeta());
    }

    public static void loadDBData(QFilter filter) {
        QFilter dataSourceConfig = new QFilter(F_DATA_SOURCE, "=", (Object)"im_inv_realbalance");
        DynamicObject sourceConf = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_data_source", (QFilter[])dataSourceConfig.toArray());
        if (sourceConf == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"MemoryDataReader_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        ColsMap colMap = ColsMap.getColsMap(sourceConf);
        HashedMap cols = new HashedMap(colMap.getBillColMap());
        if (!cols.containsKey(F_ID)) {
            cols.put(F_ID, F_ID);
        }
        DynamicObject dataSource = sourceConf.getDynamicObject(F_DATA_SOURCE);
        String actualBalEntity = dataSource.getPkValue().toString();
        String selectCols = StringUtils.join(cols.values(), (char)',');
        logger.info("Query Cols: " + selectCols);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)actualBalEntity, (String)selectCols, (QFilter[])filter.toArray(), null);
        dataSet = dataSet.addField("'1'", "source_type").addField("'" + actualBalEntity + "'", "source_bal_obj").addField("baseqty - lockbaseqty", "avbbaseqty").addField("qty - lockqty", "avbqty").addField("qty2nd - lockqty2nd", "avbqty2nd");
        originalDataSource.set(RowUtils.convertToMap(dataSet));
        originalDataRowMata.set(dataSet.getRowMeta());
    }

    public static boolean isUseLocalData() {
        return originalDataSource.get() != null;
    }

    public static void clearData() {
        originalDataSource.remove();
    }

    private String colAsCol(Map<String, String> cols) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : cols.entrySet()) {
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(entry.getValue()).append(' ').append(entry.getKey());
        }
        return sb.toString();
    }

    @Override
    public DataSet readData(String supBillFormId, QFilter filter, ColsMap colsMap, boolean ispredict) {
        DefaultDataReader defaultDataReader = new DefaultDataReader();
        DataSet dataSet = defaultDataReader.readData(supBillFormId, filter, colsMap, ispredict);
        DataSet data = MemoryDataReader.getDataSetInMemory(dataSet);
        return data;
    }

    @Override
    public DataSet readData(ReserveContext context, String supBillFormId, QFilter filter, ColsMap colsMap) {
        DefaultDataReader defaultDataReader = new DefaultDataReader();
        DataSet dataSet = defaultDataReader.readData(context, supBillFormId, filter, colsMap);
        DataSet data = MemoryDataReader.getDataSetInMemory(dataSet);
        return data;
    }
}

