/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.decision;

import java.util.LinkedList;
import java.util.List;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.decision.Node;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;

public class NodeResultHelper {
    public static BillReserveResult getResult(Node solutionNode) {
        if (solutionNode == null) {
            return new BillReserveResult();
        }
        BillReserveResult nodeResult = (BillReserveResult)solutionNode.getValueMap().get("reserve_result");
        BillReserveResult result = new BillReserveResult(nodeResult);
        NodeResultHelper.mergeResult(result, nodeResult);
        LinkedList<Node> parents = new LinkedList<Node>();
        if (solutionNode.getParent() != null) {
            parents.offer(solutionNode.getParent());
        }
        while (!parents.isEmpty()) {
            Node parent = (Node)parents.poll();
            BillReserveResult parentResult = (BillReserveResult)parent.getValueMap().get("reserve_result");
            NodeResultHelper.mergeResult(result, parentResult);
            if (parent.getParent() == null) continue;
            parents.offer(parent.getParent());
        }
        return result;
    }

    private static void mergeResult(BillReserveResult originalResult, BillReserveResult tmpResult) {
        if (tmpResult.getReserveResultType() != ReserveResultType.Failed) {
            List<EntryReserveResult> tmpEntryResultList = tmpResult.getEntryResultList();
            tmpEntryResultList.forEach(tmpEntryResult -> {
                Object entryId = tmpEntryResult.getEntryId();
                EntryReserveResult originalEntryResult = NodeResultHelper.getEntryResultByEntryId(originalResult, entryId);
                if (originalEntryResult != null && originalEntryResult.getReserveResultType() != ReserveResultType.Failed) {
                    originalEntryResult.getStdInvResultList().addAll(tmpEntryResult.getStdInvResultList());
                    originalEntryResult.setReservedQty(originalEntryResult.getReservedQty().add(tmpEntryResult.getReservedQty()));
                    originalEntryResult.setReservedBaseQty(originalEntryResult.getReservedBaseQty().add(tmpEntryResult.getReservedBaseQty()));
                    originalEntryResult.setReservedQty2nd(originalEntryResult.getReservedQty2nd().add(tmpEntryResult.getReservedQty2nd()));
                } else {
                    originalResult.getEntryResultList().add((EntryReserveResult)tmpEntryResult);
                }
            });
        }
    }

    private static EntryReserveResult getEntryResultByEntryId(BillReserveResult billReserveResult, Object id) {
        for (int i = 0; i < billReserveResult.getEntryResultList().size(); ++i) {
            if (!id.equals(billReserveResult.getEntryResultList().get(i).getEntryId())) continue;
            return billReserveResult.getEntryResultList().get(i);
        }
        return null;
    }

    public static ReserveContext getReserveContext(Node solutionNode) {
        return (ReserveContext)solutionNode.getValueMap().get("context");
    }
}

