/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.decision.warehouse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.mpscmm.msbd.reserve.business.decision.Node;
import kd.mpscmm.msbd.reserve.business.decision.NodeFactory;
import kd.mpscmm.msbd.reserve.business.decision.SubNodeFactory;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;

public class ReserveAllSubNodeFactory
implements SubNodeFactory {
    @Override
    public List<Node> createSubNodes(Node parent, NodeFactory nodeFactory, Map<Object, Object> args) {
        ArrayList<Node> subNodes = new ArrayList<Node>(2);
        if (parent == null || args == null || args.size() <= 0) {
            return subNodes;
        }
        List warehouseList = (List)parent.getValueMap().get("warehouse_list");
        if (warehouseList == null || warehouseList.size() <= 1) {
            return subNodes;
        }
        BillReserveResult parentResult = (BillReserveResult)parent.getValueMap().get("reserve_result");
        if (parentResult.getReserveResultType() == ReserveResultType.FullSuccess) {
            return subNodes;
        }
        DynamicObject requestBill = (DynamicObject)parent.getValueMap().get("cur_request_bill");
        DynamicObject curRequestBill = (DynamicObject)OrmUtils.clone((Object)requestBill, (IDataEntityType)requestBill.getDynamicObjectType(), (boolean)true, (boolean)true);
        curRequestBill.set("id", requestBill.getPkValue());
        if (parentResult.getReserveResultType() == ReserveResultType.PartSuccess) {
            this.subtractReserved(curRequestBill, parentResult);
        }
        args.put("cur_request_bill", curRequestBill);
        if (parentResult.getReserveResultType() == ReserveResultType.PartSuccess || parentResult.getReserveResultType() == ReserveResultType.Failed) {
            Node node = nodeFactory.newNode(parent, args);
            subNodes.add(node);
        }
        return subNodes;
    }

    private void subtractReserved(DynamicObject requestBill, BillReserveResult parentResult) {
        DynamicObjectCollection entryList = requestBill.getDynamicObjectCollection("bill_entry");
        entryList.forEach(entry -> {
            long entryId = entry.getLong("entry_id");
            EntryReserveResult entryReserveResult = this.getEntryResult(parentResult, entryId);
            BigDecimal baseQty = entry.getBigDecimal("base_qty");
            entry.set("base_qty", (Object)baseQty.subtract(entryReserveResult.getReservedBaseQty()));
            BigDecimal qty = entry.getBigDecimal("qty");
            entry.set("qty", (Object)qty.subtract(entryReserveResult.getReservedBaseQty()));
        });
    }

    private EntryReserveResult getEntryResult(BillReserveResult parentResult, long entryId) {
        for (int i = 0; i < parentResult.getEntryResultList().size(); ++i) {
            long id = (Long)parentResult.getEntryResultList().get(i).getEntryId();
            if (id != entryId) continue;
            return parentResult.getEntryResultList().get(i);
        }
        return null;
    }
}

