/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;

public class AggregateCfgHelper {
    private static String BALCALENTITY = "bal_check_repair";
    private static Log logger = LogFactory.getLog(AggregateCfgHelper.class);
    private static final DBRoute scmRoute = new DBRoute("scm");
    private static final int LIMIT = 1024;
    private static final String BAL_MODEL = "BalanceModel";

    public static OperationResult buildCalTask(DynamicObject entity) {
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"ImBalanceService", (String)"clearRealBalanceKey", (Object[])new Object[]{"msmod_reserveaggre"});
        DynamicObject calObj = AggregateCfgHelper.buildBalTaskObject();
        entity.set("taskid", (Object)calObj.getLong("id"));
        entity.set("taskno", (Object)calObj.getString("taskno"));
        return OperationServiceHelper.executeOperate((String)"publishtask", (String)BALCALENTITY, (DynamicObject[])new DynamicObject[]{calObj}, (OperateOption)OperateOption.create());
    }

    private static DynamicObject buildBalTaskObject() {
        DynamicObject calObj = BusinessDataServiceHelper.newDynamicObject((String)BALCALENTITY);
        Date date = new Date();
        String taskNo = String.valueOf(date.getTime());
        calObj.set("id", (Object)DB.genGlobalLongId());
        calObj.set("taskno", (Object)taskNo);
        calObj.set("tasktype", (Object)"G");
        calObj.set("oprange", (Object)"B");
        DynamicObject balObj = BusinessDataServiceHelper.newDynamicObject((String)"bal_balanceinfo");
        balObj.set("id", (Object)"msmod_reserveaggre");
        balObj.set("number", (Object)"msmod_reserveaggre");
        calObj.set("bal", (Object)balObj);
        calObj.set("reason", (Object)"Aggregate Init.");
        long userId = RequestContext.get().getCurrUserId();
        calObj.set("creater", (Object)userId);
        calObj.set("createdate", (Object)date);
        return calObj;
    }

    public static void reserveQtyInit() {
        String updateSql = "UPDATE t_msmod_reserveaggregate_a SET flockbaseqty=0.0000000000,flockqty=0.0000000000,flockqty2nd=0.0000000000 WHERE flockbaseqty!=0";
        DBRoute scmRoute = new DBRoute("scm");
        DB.execute((DBRoute)scmRoute, (String)updateSql);
        AggregateCfgHelper.reserveAggInit();
        AggregateCfgHelper.updateRecordAggId();
    }

    public static Set<Object> getBalanceTable() {
        DynamicObject[] load;
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)"sourcebill", (QFilter[])new QFilter("targetobj", "=", (Object)"msmod_std_inv_field").toArray());
        Set<Object> balName = fieldMap.values().stream().map(v -> v.get("sourcebill_id")).collect(Collectors.toSet());
        balName.remove("msmod_releasebill");
        balName.remove("msmod_reserveaggre");
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"modeltype,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)balName.toArray())})) {
            String modeltype = dynamicObject.getString("modeltype");
            if (BAL_MODEL.equals(modeltype)) continue;
            balName.remove(dynamicObject.get("number"));
        }
        if (balName.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5e93\u5b58\u8868\u8fdb\u884c\u6c47\u603b\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"InItReserveAggHelper_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        return balName;
    }

    private static void reserveAggInit() {
        Map<String, Object> aggregateConfig = ReserveAggregateHelper.getAggregateConfig();
        List dimList = (List)aggregateConfig.get("aggregateField");
        StringBuilder errDimSb = new StringBuilder();
        Map<String, String> colMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
        StringBuilder selectCols = new StringBuilder();
        StringBuilder recordCols = new StringBuilder();
        for (String dim : dimList) {
            if (colMap.get(dim) == null) {
                errDimSb.append(dim).append(",");
                continue;
            }
            selectCols.append(colMap.get(dim)).append(" as ").append(dim).append(',');
            recordCols.append("s_").append(dim).append(" as ").append(dim).append(',');
        }
        if (errDimSb.length() > 1) {
            errDimSb.deleteCharAt(errDimSb.length() - 1);
        }
        if (errDimSb.length() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7559\u6620\u5c04\u914d\u7f6e\u4e2d\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u6ca1\u6709\u914d\u7f6e\u4ee5\u4e0b\u5b57\u6bb5\u6620\u5c04\uff1a%1$s\u5b57\u6bb5\u3002", (String)"InItReserveAggHelper_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), errDimSb.toString()));
        }
        try {
            AggregateCfgHelper.calLockQtyAndSave(dimList, selectCols, recordCols);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u6c47\u603b\u9884\u7559\u6570\u91cf\u5931\u8d25\u3002", (String)"InItReserveAggHelper_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            if (e.getMessage() != null) {
                msg = String.join((CharSequence)msg, e.getMessage());
            }
            throw new KDBizException(msg);
        }
    }

    private static void calLockQtyAndSave(List<String> dimList, StringBuilder selectCols, StringBuilder recordCols) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)recordCols).append("base_qty").append(" as ").append("lockbaseqty");
        sb.append(",").append("qty").append(" as ").append("lockqty");
        sb.append(",").append("qty2nd").append(" as ").append("lockqty2nd");
        QFilter recordFilter = new QFilter("base_qty", ">", (Object)0);
        DataSet dataInv = QueryServiceHelper.queryDataSet((String)AggregateCfgHelper.class.getName(), (String)"msmod_reserve_record", (String)sb.toString(), (QFilter[])recordFilter.toArray(), null);
        dataInv = dataInv.groupBy(dimList.toArray(new String[dimList.size()])).sum("lockbaseqty").sum("lockqty").sum("lockqty2nd").finish();
        DataSet aggDataSet = QueryServiceHelper.queryDataSet((String)AggregateCfgHelper.class.getName(), (String)"msmod_reserveaggre", (String)selectCols.append("id").toString(), null, null);
        JoinDataSet joinDataSet = dataInv.join(aggDataSet, JoinType.INNER);
        for (String field : dimList) {
            joinDataSet.on(field, field);
        }
        dataInv = joinDataSet.select(new String[]{"id", "lockbaseqty", "lockqty", "lockqty2nd"}).finish();
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveaggre");
        DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
        String updateSql = "update t_msmod_reserveaggregate_a set flockbaseqty = ?,flockqty = ?,flockqty2nd=? where fid = ?";
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        while (dataInv.hasNext()) {
            Row row = dataInv.next();
            Object[] paramA = new Object[]{row.get("lockbaseqty") == null ? BigDecimal.ZERO : row.get("lockbaseqty"), row.get("lockqty") == null ? BigDecimal.ZERO : row.get("lockqty"), row.get("lockqty2nd") == null ? BigDecimal.ZERO : row.get("lockqty2nd"), row.get("id")};
            updateParams.add(paramA);
            if (updateParams.size() <= 1024) continue;
            DB.executeBatch((DBRoute)route, (String)updateSql, updateParams);
            updateParams.clear();
        }
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)updateSql, updateParams);
        }
    }

    private static void updateRecordAggId() {
        Map<String, String> colMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field").getBalColMap();
        Map<String, Object> aggregateConfig = ReserveAggregateHelper.getAggregateConfig();
        List dimList = (List)aggregateConfig.get("aggregateField");
        StringBuilder aggBuilder = new StringBuilder();
        StringBuilder recordCols = new StringBuilder();
        for (Object field : dimList) {
            if (colMap.get(field) == null) continue;
            aggBuilder.append(colMap.get(field)).append(" as ").append((String)field).append(",");
        }
        int i = 0;
        for (String dim : dimList) {
            if (colMap.get(dim) == null) continue;
            if (i++ > 0) {
                recordCols.append(',');
            }
            recordCols.append("s_").append(dim);
        }
        try {
            aggBuilder.append("id as aggid");
            recordCols.append(",id");
            QFilter recordFilter = new QFilter("base_qty", ">", (Object)0);
            DataSet reserve_record = QueryServiceHelper.queryDataSet((String)AggregateCfgHelper.class.getName(), (String)"msmod_reserve_record", (String)recordCols.toString(), (QFilter[])recordFilter.toArray(), null);
            DataSet aggCord = QueryServiceHelper.queryDataSet((String)AggregateCfgHelper.class.getName(), (String)"msmod_reserveaggre", (String)aggBuilder.toString(), null, null);
            JoinDataSet joinDataSet = reserve_record.join(aggCord, JoinType.INNER);
            for (String field : dimList) {
                joinDataSet.on("s_" + field, field);
            }
            DataSet dataSet = joinDataSet.select(new String[]{"id", "aggid"}).finish();
            StringBuilder sql = new StringBuilder();
            sql.append("update t_msmod_reserverecord set faggregateid = ? where fid = ?");
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            while (dataSet.hasNext()) {
                Object[] param = new Object[2];
                Row row = dataSet.next();
                Object recoredId = row.get("id");
                Object aggid = row.get("aggid");
                if (aggid == null) continue;
                param[0] = aggid;
                param[1] = recoredId;
                params.add(param);
                if (params.size() <= 1024) continue;
                AggregateCfgHelper.executeRuleSql(sql.toString(), params);
                params.clear();
            }
            if (params.size() > 0) {
                AggregateCfgHelper.executeRuleSql(sql.toString(), params);
            }
        }
        catch (Exception e) {
            String msg = ResUtil.formatMsg(ResManager.loadKDString((String)"\u66f4\u65b0\u9884\u7559\u8bb0\u5f55\u4e2d\u603b\u91cfid\u503c\u5931\u8d25\u3002", (String)"InItReserveAggHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_1", new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private static void executeRuleSql(String ruleSql, List<Object[]> params) {
        DB.executeBatch((DBRoute)scmRoute, (String)ruleSql, params);
    }

    public static void reCalInvLockQty() {
        DBRoute scmRoute = new DBRoute("scm");
        String clearLockQtySql = "UPDATE t_im_inv_realbalance_a SET flockbaseqty=0.0000000000,flockqty=0.0000000000,flockqty2nd=0.0000000000 WHERE flockbaseqty!=0";
        DB.execute((DBRoute)scmRoute, (String)clearLockQtySql);
        QFilter recordFilter = new QFilter("base_qty", ">", (Object)0);
        recordFilter = recordFilter.and("bal_id", "!=", (Object)0);
        recordFilter = recordFilter.and("ispredict", "=", (Object)false);
        DataSet dataInv = QueryServiceHelper.queryDataSet((String)AggregateCfgHelper.class.getName(), (String)"msmod_reserve_record", (String)"bal_id,base_qty,qty,qty2nd", (QFilter[])recordFilter.toArray(), null);
        dataInv = dataInv.groupBy(new String[]{"bal_id"}).sum("base_qty").sum("qty").sum("qty2nd").finish();
        String updateLockQtySql = "update t_im_inv_realbalance_a set flockbaseqty = ?,flockqty = ?,flockqty2nd=? where fid = ?";
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        while (dataInv.hasNext()) {
            Row row = dataInv.next();
            Object[] paramA = new Object[]{row.get(1) == null ? BigDecimal.ZERO : row.get(1), row.get(2) == null ? BigDecimal.ZERO : row.get(2), row.get(3) == null ? BigDecimal.ZERO : row.get(3), row.get(0)};
            updateParams.add(paramA);
            if (updateParams.size() <= 1024) continue;
            DB.executeBatch((DBRoute)scmRoute, (String)updateLockQtySql, updateParams);
            updateParams.clear();
        }
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)scmRoute, (String)updateLockQtySql, updateParams);
        }
    }
}

