/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReleaseHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceHelper;

public class AutoTaskHelper {
    private static final Log logger = LogFactory.getLog(AutoTaskHelper.class);
    private static final String[] WRITE_BACK_QTY_PROS = new String[]{"reserve_base_qty", "reserve_qty", "reserve_qty2nd"};
    private static final Map<String, String> SP_BAL_COL_MAP;

    public static void autoReleaseReserveRecord() {
        ThreadCache.put((Object)"ReserveOpName", (Object)"autoTask");
        ThreadCache.put((Object)"ReserveOpType", (Object)"delete");
        if (!ReserveCommonHelper.getScmParam("RESERVE002")) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        logger.info(StringUtils.join((Object[])new Serializable[]{"ReserveService autoReleaseReserveRecord==cal.getTime()==", cal.getTime()}));
        QFilter qFilter = new QFilter("expiredate", "<", (Object)cal.getTime());
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)"id,base_qty,qty,qty2nd,expiredate,ispredict,bal_obj,reserve_scheme,bal_id,aggregateid,bill_obj,bill_id,bill_no,billentry_id,billentry_seq", (QFilter[])qFilter.toArray());
        if (col == null || col.length < 1) {
            return;
        }
        logger.info(StringUtils.join((Object[])new Serializable[]{"ReserveService autoReleaseReserveRecord==col.length==", Integer.valueOf(col.length)}));
        StringBuilder logInfo = new StringBuilder();
        for (DynamicObject reserveRecord : col) {
            try (TXHandle tx = TX.requiresNew((String)"autoReleaseReserveRecord");){
                try {
                    ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(col.length);
                    reserveRecord.set("bal_obj", (Object)reserveRecord.getDynamicObject("bal_obj").getString("number"));
                    if (reserveRecord.getDynamicObject("reserve_scheme") != null) {
                        reserveRecord.set("reserve_scheme", reserveRecord.getDynamicObject("reserve_scheme").getPkValue());
                    }
                    recordList.add(reserveRecord);
                    logInfo.append("ReserveService autoReleaseReserveRecord==ReserveRecord id:").append(reserveRecord.getString("id")).append(',');
                    logInfo.append("expiredate==").append(reserveRecord.get("expiredate"));
                    ReleaseHelper.removeReserveByReserveRecord(recordList);
                }
                catch (Throwable e) {
                    logInfo.append(StringUtils.join((Object[])new String[]{logInfo.toString(), "===", e.getMessage()}));
                    tx.markRollback();
                }
            }
        }
        if (logInfo.length() > 0) {
            logger.error(logInfo.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dealHighHotTask() {
        if (!ReserveCommonHelper.getScmParam("INV0007")) return;
        String spEntityName = "msmod_reserve_bal_sp";
        ArrayList<Long> exitReserveList = new ArrayList<Long>(1024);
        Map<String, List<DynamicObject>> routeDataMap = AutoTaskHelper.getDataGroupMap(spEntityName, exitReserveList);
        Iterator<Map.Entry<String, List<DynamicObject>>> iterator = routeDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Throwable throwable;
            TXHandle tx;
            ArrayList<Object[]> delTranIdList;
            String routeKey;
            block28: {
                block29: {
                    Map.Entry<String, List<DynamicObject>> entry = iterator.next();
                    routeKey = entry.getKey();
                    List<DynamicObject> dataList = entry.getValue();
                    Map<Long, Long> tranIdMap = AutoTaskHelper.getTransIdMap(routeKey);
                    delTranIdList = new ArrayList<Object[]>(dataList.size());
                    ArrayList<Long> delReserveIdList = new ArrayList<Long>(8);
                    ArrayList<Long> spIdList = new ArrayList<Long>(dataList.size());
                    Map<String, Map<Long, DynamicObject>> balDataMap = AutoTaskHelper.getValidateDataMap(exitReserveList, dataList, tranIdMap, delTranIdList, delReserveIdList, spIdList);
                    tx = TX.requiresNew((String)"dealHighHotTask:writeBackQty");
                    throwable = null;
                    try {
                        try {
                            for (Map.Entry<String, Map<Long, DynamicObject>> balDataEntry : balDataMap.entrySet()) {
                                AutoTaskHelper.dealOneBalData(balDataEntry);
                            }
                            DeleteServiceHelper.delete((String)spEntityName, (QFilter[])new QFilter("id", "in", spIdList).toArray());
                            DeleteServiceHelper.delete((String)"msmod_reserve_record", (QFilter[])new QFilter("id", "in", delReserveIdList).toArray());
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                            tx.markRollback();
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            tx.close();
                            continue;
                        }
                        if (tx == null) break block28;
                        if (throwable == null) break block29;
                    }
                    catch (Throwable e) {
                        try {
                            throwable = e;
                            throw e;
                        }
                        catch (Throwable throwable3) {
                            if (tx == null) throw throwable3;
                            if (throwable == null) {
                                tx.close();
                                throw throwable3;
                            }
                            try {
                                tx.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        throwable.addSuppressed(e);
                    }
                    break block28;
                }
                tx.close();
            }
            tx = TX.requiresNew((String)"dealHighHotTask:deleteTrans");
            throwable = null;
            try {
                try {
                    AutoTaskHelper.executeBatch(routeKey, "delete from t_reserve_async_info where fid = ? ", delTranIdList);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    tx.markRollback();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private static Map<String, Map<Long, DynamicObject>> getValidateDataMap(List<Long> exitReserveList, List<DynamicObject> dataList, Map<Long, Long> tranIdMap, List<Object[]> delTranIdList, List<Long> delReserveIdList, List<Long> spIdList) {
        HashMap<String, Map<Long, DynamicObject>> balGroupDataMap = new HashMap<String, Map<Long, DynamicObject>>(8);
        for (DynamicObject data : dataList) {
            spIdList.add(data.getLong("id"));
            long transId = data.getLong("transid");
            if (tranIdMap.get(transId) != null) {
                delTranIdList.add(new Object[]{tranIdMap.get(transId)});
            }
            String balNumber = data.getString("balancename");
            if (transId == 0L || tranIdMap.get(transId) != null) {
                HashMap<Long, DynamicObject> dataMap = (HashMap<Long, DynamicObject>)balGroupDataMap.get(balNumber);
                long invId = data.getLong("invid");
                if (dataMap == null) {
                    dataMap = new HashMap<Long, DynamicObject>(1024);
                    dataMap.put(invId, data);
                    balGroupDataMap.put(balNumber, dataMap);
                    continue;
                }
                DynamicObject exitData = (DynamicObject)dataMap.get(invId);
                if (exitData == null) {
                    dataMap.put(invId, data);
                    continue;
                }
                exitData.set("baseqty", (Object)exitData.getBigDecimal("baseqty").add(data.getBigDecimal("baseqty")));
                exitData.set("qty", (Object)exitData.getBigDecimal("qty").add(data.getBigDecimal("qty")));
                exitData.set("qty2nd", (Object)exitData.getBigDecimal("qty2nd").add(data.getBigDecimal("qty2nd")));
                continue;
            }
            long reserveId = data.getLong("reserverecordid");
            if (!exitReserveList.contains(reserveId)) continue;
            delReserveIdList.add(reserveId);
        }
        return balGroupDataMap;
    }

    public static Map<Long, Long> getTransIdMap(String routeKey) {
        DataSet tranDataSet = DB.queryDataSet((String)"AutoTaskHelper:dealHighHotTask", (DBRoute)new DBRoute(routeKey), (String)"select fid,ftransid from t_reserve_async_info");
        HashMap<Long, Long> tranIdMap = new HashMap<Long, Long>(1024);
        while (tranDataSet.hasNext()) {
            Row row = tranDataSet.next();
            tranIdMap.put(row.getLong("ftransid"), row.getLong("fid"));
        }
        return tranIdMap;
    }

    private static void dealOneBalData(Map.Entry<String, Map<Long, DynamicObject>> balDataEntry) {
        String balNumber = balDataEntry.getKey();
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)balNumber);
        ColsMap colMap = ColsMapHelper.findBillColMaps(balNumber, "msmod_std_inv_field");
        ArrayList<String> qtyCols = new ArrayList<String>(8);
        ArrayList<String> realQtyCols = new ArrayList<String>(8);
        String aTag = null;
        for (String proStr : WRITE_BACK_QTY_PROS) {
            String realBalCol = colMap.getByBalCol(proStr);
            IDataEntityProperty pro = balEntityType.findProperty(realBalCol);
            aTag = pro.getTableGroup();
            if (aTag == null) {
                aTag = "null";
            }
            qtyCols.add(proStr);
            realQtyCols.add(pro.getAlias());
        }
        String updateSql = BalanceHelper.getWriteBackSql(balEntityType.getAlias(), aTag, realQtyCols);
        ArrayList<Object[]> balParamList = new ArrayList<Object[]>(1024);
        for (DynamicObject data : balDataEntry.getValue().values()) {
            Object[] balParam = new Object[qtyCols.size() + 1];
            int i = 0;
            for (String qtyCol : qtyCols) {
                balParam[i++] = data.getBigDecimal(SP_BAL_COL_MAP.get(qtyCol));
            }
            balParam[i] = data.getLong("invid");
            balParamList.add(balParam);
        }
        AutoTaskHelper.executeBatch(balEntityType.getDBRouteKey(), updateSql, balParamList);
    }

    public static Map<String, List<DynamicObject>> getDataGroupMap(String spEntityName, List<Long> exitReserveList) {
        HashMap<String, List<DynamicObject>> routeDataMap = new HashMap<String, List<DynamicObject>>(8);
        DynamicObjectCollection dataCols = QueryServiceHelper.query((String)spEntityName, (String)"id,transid,dbroutekey,balancename,invid,reserverecordid,baseqty,qty,qty2nd,createdate,opstatus", null);
        if (dataCols.size() > 0) {
            ArrayList<Long> reserveRecordIdList = new ArrayList<Long>(dataCols.size());
            ArrayList<Object[]> spIdList = new ArrayList<Object[]>(dataCols.size());
            for (DynamicObject data : dataCols) {
                spIdList.add(new Object[]{data.getLong("id")});
                if (AutoTaskHelper.checkDataIsOverTime(data)) continue;
                String routeKey = data.getString("dbroutekey");
                ArrayList<DynamicObject> dataList = (ArrayList<DynamicObject>)routeDataMap.get(routeKey);
                if (dataList == null) {
                    dataList = new ArrayList<DynamicObject>(1024);
                    routeDataMap.put(routeKey, dataList);
                }
                dataList.add(data);
                reserveRecordIdList.add(data.getLong("reserverecordid"));
            }
            TXHandle tx = TX.requiresNew((String)"getDataGroupMap:updateReserveHighHotDataStatus");
            Object object = null;
            try {
                try {
                    AutoTaskHelper.executeBatch("scm", "update t_msmod_reserve_bal_sp set fopstatus='ONMERGE' where fid = ? ", spIdList);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable e) {
                object = e;
                throw e;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)object).addSuppressed(e);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            DynamicObjectCollection reserveCols = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", reserveRecordIdList)});
            for (DynamicObject record : reserveCols) {
                exitReserveList.add(record.getLong("id"));
            }
        }
        return routeDataMap;
    }

    private static boolean checkDataIsOverTime(DynamicObject data) {
        String opStatus = data.getString("opstatus");
        if ("ONMERGE".equals(opStatus)) {
            Date createDate = data.getDate("createdate");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(10, -2);
            if (cal.getTime().before(createDate)) {
                return true;
            }
        }
        return false;
    }

    private static void executeBatch(String routeKey, String sql, List<Object[]> delTranIdList) {
        DB.executeBatch((DBRoute)new DBRoute(routeKey), (String)sql, BalanceHelper.sortSqlParamList(delTranIdList));
    }

    public static void autoCarryReserveOpLog() {
        try (TXHandle tx = TX.requiresNew((String)"autoCarryReserveOpLog");){
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                cal.add(2, -6);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Date expireDate = cal.getTime();
                String logEntityName = "msmod_reserve_oplog";
                QFilter qFilter = new QFilter("createdate", "<", (Object)expireDate);
                QFilter reserveFilter = new QFilter("reserveid", "!=", (Object)0);
                DataSet logSet = QueryServiceHelper.queryDataSet((String)"kd.mpscmm.msbd.reserve.business.helper.AutoTaskHelper.autoCarryReserveOpLog", (String)logEntityName, (String)"balobj,balid,baseqty,qty,qty2nd", (QFilter[])new QFilter[]{qFilter, reserveFilter}, null);
                logSet = logSet.groupBy(new String[]{"balobj", "balid"}).sum("baseqty").sum("qty").sum("qty2nd").finish();
                if (logSet != null) {
                    ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(124);
                    long userId = 0L;
                    while (logSet.hasNext()) {
                        Row row = logSet.next();
                        BigDecimal baseQty = row.getBigDecimal("baseqty");
                        if (baseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_oplog");
                        logObj.set("reserveid", (Object)1L);
                        logObj.set("creater", (Object)userId);
                        logObj.set("createdate", (Object)expireDate);
                        logObj.set("balobj", (Object)row.getString("balobj"));
                        logObj.set("balid", (Object)row.getLong("balid"));
                        logObj.set("baseqty", (Object)row.getBigDecimal("baseqty"));
                        logObj.set("qty", (Object)row.getBigDecimal("qty"));
                        logObj.set("qty2nd", (Object)row.getBigDecimal("qty2nd"));
                        logObj.set("op", (Object)"carry");
                        logObj.set("optype", (Object)"carry");
                        logList.add(logObj);
                    }
                    DeleteServiceHelper.delete((String)logEntityName, (QFilter[])new QFilter[]{qFilter});
                    SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[logList.size()]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
            }
        }
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>(4);
        tempMap.put("reserve_base_qty", "baseqty");
        tempMap.put("reserve_qty", "qty");
        tempMap.put("reserve_qty2nd", "qty2nd");
        SP_BAL_COL_MAP = Collections.unmodifiableMap(tempMap);
    }
}

