/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.SchemeHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;

public class ColsMapHelper {
    public static ColsMap findDemandBillColMap(String formId) {
        return ColsMapHelper.findBillColMaps(formId, "msmod_std_request_bill");
    }

    public static void mappingConfig(Map<String, String> balColMap) {
        List<String> mustSetFieldList = Arrays.asList("baseunit", "baseqty");
        StringBuilder sb = new StringBuilder();
        for (String field : mustSetFieldList) {
            if (balColMap.get(field) != null) continue;
            sb.append(field).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff0c%1$s\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u5bf9\u8c61\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u4f9b\u5e94\u6a21\u578b\uff09\u3002", (String)"ReserveService_9", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), sb));
        }
    }

    public static ColsMap findReleaseBillColMap(String formId) {
        return ColsMapHelper.findBillColMaps(formId, "msmod_releasebill");
    }

    public static Map<String, ColsMap> findBillColMaps(Collection<String> formIds, String targetFormId) {
        HashMap<String, ColsMap> colMaps = new HashMap<String, ColsMap>(formIds.size());
        QFilter filter = new QFilter("sourcebill", "in", formIds);
        filter = filter.and(new QFilter("targetobj", "=", (Object)targetFormId));
        filter.and("isenable", "=", (Object)Boolean.TRUE);
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])filter.toArray());
        for (DynamicObject obj : objs.values()) {
            colMaps.put(obj.getString("sourcebill_id"), new ColsMap(obj));
        }
        return colMaps;
    }

    public static ColsMap findBillColMaps(String formId, String targetFormId) {
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)targetFormId)) {
            return null;
        }
        QFilter filter = new QFilter("sourcebill", "=", (Object)formId);
        filter = filter.and(new QFilter("targetobj", "=", (Object)targetFormId));
        filter.and("isenable", "=", (Object)Boolean.TRUE);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])filter.toArray());
        if (obj == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff1a%1$s\u3002", (String)"ReserveContext_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), formId));
        }
        return new ColsMap(obj);
    }

    public static ColsMap findBillColMap(String formId, String targetFormId) {
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)targetFormId)) {
            return null;
        }
        QFilter filter = new QFilter("sourcebill", "=", (Object)formId);
        filter = filter.and(new QFilter("targetobj", "=", (Object)targetFormId));
        filter.and("isenable", "=", (Object)Boolean.TRUE);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])filter.toArray());
        if (obj == null) {
            return null;
        }
        return new ColsMap(obj);
    }

    public static BigDecimal getMpingQty(DynamicObject entry, String key) {
        BOSExpression bosExpression = new BOSExpression(key);
        Set vars = bosExpression.getVars();
        HashMap<String, BigDecimal> param = new HashMap<String, BigDecimal>(8);
        for (String var : vars) {
            String[] split = var.split("\\.");
            String val = split.length > 1 ? var.split("\\.")[1] : var.split("\\.")[0];
            param.put(var, entry.getBigDecimal(val));
        }
        return (BigDecimal)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), param);
    }

    public static List<ComboItem> getEffectiveSchemeItem(String billName, long billId) {
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>(16);
        DynamicObject requestBill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billName);
        if (requestBill != null) {
            Map<Object, DynamicObject> schemeMap = ColsMapHelper.getEnableManualSchemeMap(billName, requestBill);
            for (DynamicObject scheme : schemeMap.values()) {
                ComboItem item = new ComboItem(new LocaleString(String.format("%s\u3010%s\u3011", scheme.getString("name"), scheme.getString("number"))), scheme.get("id").toString());
                entryItems.add(item);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u636e\u3002", (String)"ReserveSchemeSelectPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        return entryItems;
    }

    private static Map<Object, DynamicObject> getEnableManualSchemeMap(String billName, DynamicObject requestBill) {
        QFilter fs = new QFilter("require_bill", "=", (Object)billName);
        fs = fs.and(new QFilter("status", "=", (Object)"A"));
        fs = fs.and(new QFilter("autoreserve", "=", (Object)Boolean.FALSE));
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        boolean isAggregate = (Boolean)aggregateCfg.get("isAggregate");
        if (!isAggregate) {
            fs = fs.and(new QFilter("aggregate", "=", (Object)Boolean.FALSE));
        } else if (!((Boolean)aggregateCfg.get("compatibleDetail")).booleanValue()) {
            fs = fs.and(new QFilter("aggregate", "=", (Object)Boolean.TRUE));
        }
        Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_scheme", (QFilter[])fs.toArray());
        MainEntityType billType = (MainEntityType)requestBill.getDataEntityType();
        String mainOrg = billType.getMainOrg();
        DynamicObject org = requestBill.getDynamicObject(mainOrg);
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"ReserveSchemeSelectPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        Map<Long, String> orgLotNum = SchemeHelper.getOrgLotNumMap(org, schemeMap.values());
        HashMap<Object, DynamicObject> validateMap = new HashMap<Object, DynamicObject>(8);
        for (DynamicObject scheme : schemeMap.values()) {
            if (!SchemeHelper.checkApplyorg(scheme, (Long)org.getPkValue(), orgLotNum) || !FilterParser.execExcelFormula(scheme.getString("req_filter_value"), requestBill)) continue;
            validateMap.put(scheme.getLong("id"), scheme);
        }
        return validateMap;
    }
}

