/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.reserve.business.helper.EntityParseHelper;

public class FormShowHelper {
    private static Set<String> filterOps = new HashSet<String>();

    public static void showEntryFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, int currentRowIndex, String filterJsonKey, String closeCallBackActionId) {
        try {
            String filterJson = (String)dataModel.getValue(filterJsonKey, currentRowIndex);
            String filedNodes = formPlugin.getPageCache().get("fieldnodes");
            String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
            if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
                formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
                filedNodes = "";
            }
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            FormShowHelper.removeTreeNode(treeNode);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
            formPlugin.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("reserve_filtercond");
            showParameter.getCustomParams().put("formula", filterJson);
            showParameter.getCustomParams().put("entitynumber", entityNumber);
            showParameter.getCustomParams().put("treenodes", filedNodes);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            IFormView view = formPlugin.getView();
            view.showForm(showParameter);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void removeTreeNode(TreeNode node) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if ("auxpty".equals(child.getId()) || "auxpty1".equals(child.getId())) {
                iterator.remove();
                continue;
            }
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            FormShowHelper.removeTreeNode(child);
        }
    }

    public static void closeCallSetEntryCondition(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        try {
            String destValue;
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            String entityNumCache = pageCache.get("entitynumbercachekey");
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
            filterBuilder.buildFilter(false);
            QFilter qFilter = filterBuilder.getQFilter();
            String expression = crCondition.getExpression();
            String string = destValue = qFilter == null ? "" : qFilter.toString();
            if (StringUtils.isNotEmpty((CharSequence)destValue) && StringUtils.isNotEmpty((CharSequence)expression)) {
                destValue = destValue + " and (" + expression + ")";
            } else if (StringUtils.isEmpty((CharSequence)destValue) && StringUtils.isNotEmpty((CharSequence)expression)) {
                destValue = expression;
            }
            String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
            String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
            String rowIndex = pageCache.get("rowIndex");
            dataModel.setValue(filterDesc, (Object)destValueShow, Integer.parseInt(rowIndex));
            dataModel.setValue(filterJson, (Object)returnData, Integer.parseInt(rowIndex));
            dataModel.setValue(filterFormula, (Object)destValue, Integer.parseInt(rowIndex));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void setOperationItems(IDataModel dataModel, IFormView view, String entityKey, String operationKey) {
        DynamicObject entity = dataModel.getDataEntity().getDynamicObject(entityKey);
        ComboEdit opEdit = (ComboEdit)view.getControl(operationKey);
        if (entity == null) {
            opEdit.setComboItems(null);
            return;
        }
        String entityNum = entity.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map operation : operations) {
            String opType = (String)operation.get("type");
            if (filterOps.contains(opType)) continue;
            String opKey = (String)operation.get("key");
            Map opName = (Map)operation.get("name");
            comboItems.add(new ComboItem(LocaleString.fromMap((Map)opName), opKey));
        }
        opEdit.setComboItems(comboItems);
    }

    static {
        filterOps.add("save");
        filterOps.add("delete");
    }
}

