/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;

public class ReserveOpLogHelper {
    private static final Log log = LogFactory.getLog(ReserveOpLogHelper.class);

    public static void createNewLogByRecord(Collection<DynamicObject> records, boolean isNegate) {
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        String traceId = RequestContext.get().getTraceId();
        if (ReserveAggregateHelper.isAggregate()) {
            ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(8);
            for (DynamicObject record : records) {
                if (record.getLong("aggregateid") != 0L) {
                    logList.add(ReserveOpLogHelper.buildLogObjByReserveRecord(isNegate, date, userId, record, true, traceId));
                }
                if (record.getLong("bal_id") == 0L) continue;
                logList.add(ReserveOpLogHelper.buildLogObjByReserveRecord(isNegate, date, userId, record, false, traceId));
            }
            if (logList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[logList.size()]));
            }
        } else {
            DynamicObject[] logArr = new DynamicObject[records.size()];
            int i = 0;
            for (DynamicObject record : records) {
                logArr[i] = ReserveOpLogHelper.buildLogObjByReserveRecord(isNegate, date, userId, record, false, traceId);
                ++i;
            }
            if (i > 0) {
                SaveServiceHelper.save((DynamicObject[])logArr);
            }
        }
    }

    private static DynamicObject buildLogObjByReserveRecord(boolean isNegate, Date date, long userId, DynamicObject record, boolean isAgg, String traceId) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_oplog");
        logObj.set("reserveid", (Object)record.getLong("id"));
        logObj.set("creater", (Object)userId);
        logObj.set("createdate", (Object)date);
        logObj.set("traceid", (Object)traceId);
        if (record.get("bill_obj") instanceof DynamicObject) {
            logObj.set("billobj", (Object)record.getDynamicObject("bill_obj").getString("number"));
        } else {
            logObj.set("billobj", (Object)record.getString("bill_obj"));
        }
        logObj.set("billid", (Object)record.getLong("bill_id"));
        logObj.set("billno", (Object)record.getString("bill_no"));
        logObj.set("billentryid", (Object)record.getLong("billentry_id"));
        logObj.set("billentryseq", (Object)record.getLong("billentry_seq"));
        if (isAgg) {
            logObj.set("balobj", (Object)"msmod_reserveaggre");
            logObj.set("balid", (Object)record.getLong("aggregateid"));
        } else {
            if (record.get("bal_obj") instanceof DynamicObject) {
                logObj.set("balobj", (Object)record.getDynamicObject("bal_obj").getString("number"));
            } else {
                logObj.set("balobj", (Object)record.getString("bal_obj"));
            }
            logObj.set("balid", (Object)record.getLong("bal_id"));
        }
        BigDecimal baseQty = record.getBigDecimal("base_qty");
        if (isNegate) {
            logObj.set("baseqty", (Object)baseQty.negate());
            logObj.set("qty", (Object)record.getBigDecimal("qty").negate());
            logObj.set("qty2nd", (Object)record.getBigDecimal("qty2nd").negate());
        } else {
            logObj.set("baseqty", (Object)baseQty);
            logObj.set("qty", (Object)record.getBigDecimal("qty"));
            logObj.set("qty2nd", (Object)record.getBigDecimal("qty2nd"));
        }
        logObj.set("op", ThreadCache.get((Object)"ReserveOpName"));
        logObj.set("optype", ThreadCache.get((Object)"ReserveOpType"));
        return logObj;
    }

    public static void createNewLogByReleaseRecord(Collection<DynamicObject> records) {
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        String traceId = RequestContext.get().getTraceId();
        if (ReserveAggregateHelper.isAggregate()) {
            ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(8);
            for (DynamicObject record : records) {
                DynamicObject obj;
                if (record.getLong("aggregateid") != 0L && (obj = ReserveOpLogHelper.buildLogObjByReleaseRecord(date, userId, record, true, traceId)) != null) {
                    logList.add(obj);
                }
                if (record.getLong("balid") == 0L || (obj = ReserveOpLogHelper.buildLogObjByReleaseRecord(date, userId, record, false, traceId)) == null) continue;
                logList.add(obj);
            }
            if (logList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[logList.size()]));
            }
        } else {
            DynamicObject[] logArr = new DynamicObject[records.size()];
            int i = 0;
            for (DynamicObject record : records) {
                DynamicObject obj = ReserveOpLogHelper.buildLogObjByReleaseRecord(date, userId, record, false, traceId);
                if (obj == null) continue;
                logArr[i] = obj;
                ++i;
            }
            if (i > 0) {
                SaveServiceHelper.save((DynamicObject[])logArr);
            }
        }
    }

    private static DynamicObject buildLogObjByReleaseRecord(Date date, long userId, DynamicObject record, boolean isAgg, String traceId) {
        BigDecimal baseQty = record.getBigDecimal("base_qty");
        if (baseQty.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_oplog");
        logObj.set("reserveid", (Object)record.getLong("reserve_record"));
        logObj.set("creater", (Object)userId);
        logObj.set("createdate", (Object)date);
        logObj.set("traceid", (Object)traceId);
        if (record.get("bill_obj") instanceof DynamicObject) {
            logObj.set("billobj", (Object)record.getDynamicObject("bill_obj").getString("number"));
        } else {
            logObj.set("billobj", (Object)record.getString("bill_obj"));
        }
        logObj.set("billid", (Object)record.getLong("billid"));
        logObj.set("billno", (Object)record.getString("billno"));
        logObj.set("billentryid", (Object)record.getLong("entryid"));
        logObj.set("billentryseq", (Object)0L);
        if (isAgg) {
            logObj.set("balobj", (Object)"msmod_reserveaggre");
            logObj.set("balid", (Object)record.getLong("aggregateid"));
        } else {
            if (record.get("balobj") instanceof DynamicObject) {
                logObj.set("balobj", (Object)record.getDynamicObject("balobj").getString("number"));
            } else {
                logObj.set("balobj", (Object)record.getString("balobj"));
            }
            logObj.set("balid", (Object)record.getLong("balid"));
        }
        logObj.set("baseqty", (Object)baseQty.negate());
        logObj.set("qty", (Object)record.getBigDecimal("qty").negate());
        logObj.set("qty2nd", (Object)record.getBigDecimal("qty2nd").negate());
        logObj.set("op", ThreadCache.get((Object)"ReserveOpName"));
        logObj.set("optype", ThreadCache.get((Object)"ReserveOpType"));
        return logObj;
    }

    public static void createNewLogByRePlaceRecord(Collection<DynamicObject> records, boolean isNegate) {
        DynamicObject[] logArr = new DynamicObject[records.size()];
        int i = 0;
        String traceId = RequestContext.get().getTraceId();
        for (DynamicObject record : records) {
            BigDecimal baseQty = record.getBigDecimal("baseqty");
            if (baseQty.compareTo(BigDecimal.ZERO) == 0) continue;
            logArr[i] = ReserveOpLogHelper.buildLogObjByRePlaceRecord(record, isNegate, traceId, baseQty);
            ++i;
        }
        if (i > 0) {
            SaveServiceHelper.save((DynamicObject[])logArr);
        }
    }

    private static DynamicObject buildLogObjByRePlaceRecord(DynamicObject record, boolean isNegate, String traceId, BigDecimal baseQty) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_oplog");
        logObj.set("traceid", (Object)traceId);
        logObj.set("reserveid", (Object)record.getLong("recordid"));
        logObj.set("creater", (Object)record.getLong("creater"));
        logObj.set("createdate", record.get("create_date"));
        logObj.set("billobj", (Object)record.getString("billobj"));
        logObj.set("billid", (Object)record.getLong("billid"));
        logObj.set("billno", (Object)record.getString("billno"));
        logObj.set("billentryid", (Object)record.getLong("entryid"));
        logObj.set("billentryseq", (Object)record.getLong("billentryseq"));
        logObj.set("balobj", (Object)record.getString("balancename"));
        logObj.set("balid", (Object)record.getLong("invid"));
        if (isNegate) {
            logObj.set("baseqty", (Object)baseQty.negate());
            logObj.set("qty", (Object)record.getBigDecimal("qty").negate());
            logObj.set("qty2nd", (Object)record.getBigDecimal("qty2nd").negate());
        } else {
            logObj.set("baseqty", (Object)baseQty);
            logObj.set("qty", (Object)record.getBigDecimal("qty"));
            logObj.set("qty2nd", (Object)record.getBigDecimal("qty2nd"));
        }
        logObj.set("op", ThreadCache.get((Object)"ReserveOpName"));
        logObj.set("optype", ThreadCache.get((Object)"ReserveOpType"));
        return logObj;
    }
}

