/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.record;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bal.util.BalQuery;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveCommonHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.common.util.ResUtil;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;

public class BalanceHelper {
    private static final String[] WRITE_BACK_QTY_PROS = new String[]{"reserve_base_qty", "reserve_qty", "reserve_qty2nd"};
    private static final String RESERVE_SP = "msmod_reserve_bal_sp";
    private static final Map<String, String> STD_BAL_COL_MAP;

    public static void writeBackBalQty(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        if (ReserveAggregateHelper.isAggregate()) {
            BalanceHelper.writeBackBalQtyForAggregate(bal, records, colsMap, checkNegative);
        } else if (ThreadCache.get((Object)"reserveHighHotTransId") != null) {
            BalanceHelper.writeBackQtyForDetailHighHot(bal, records, colsMap, checkNegative);
        } else {
            BalanceHelper.writeBackBalQtyForDetail(bal, records, colsMap, checkNegative);
        }
    }

    public static void writeBackDetailBalNotSup(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        BalanceHelper.writeBackBalForDetailNotSup(bal, records, colsMap, checkNegative);
    }

    private static void writeBackBalQtyForAggregate(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        ArrayList<DynamicObject> oldReserveList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> detailRecordList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> aggRecordList = new ArrayList<DynamicObject>(8);
        BalanceHelper.groupRecordForAgg(records, oldReserveList, detailRecordList, aggRecordList);
        BalanceHelper.writeBackBalQtyForDetail(bal, oldReserveList, colsMap, checkNegative);
        if (detailRecordList.size() > 0 || aggRecordList.size() > 0) {
            List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
            if (ThreadCache.get((Object)"reserveHighHotTransId") != null) {
                long[] ids = BalanceHelper.writeBackQtyForDetailHighHot(bal, detailRecordList, colsMap, checkNegative);
                aggRecordList.addAll(detailRecordList);
                BalanceHelper.updateAggReserveQtyForHighHot(checkNegative, aggRecordList, ids);
            } else {
                Map<String, List<Object[]>> unBatchSqlMap = BalanceHelper.writeBackBalQtyForDetail(bal, detailRecordList, colsMap, checkNegative);
                aggRecordList.addAll(detailRecordList);
                BalanceHelper.updateAggReserveQty(checkNegative, aggRecordList, aggregateField, unBatchSqlMap);
            }
        }
    }

    private static void updateAggReserveQtyForHighHot(boolean checkNegative, List<DynamicObject> aggRecordList, long[] detailIds) {
        long[] ids = BalanceHelper.insertSpData("msmod_reserveaggre", aggRecordList, "aggregateid");
        if (checkNegative) {
            try {
                BalanceHelper.checkNegativeInventoryForAgg(aggRecordList);
            }
            catch (KDBizException e) {
                try (TXHandle tx = TX.requiresNew((String)"updateUnAggReserveQtyForHighHot");){
                    try {
                        if (detailIds != null && detailIds.length > 0) {
                            DeleteServiceHelper.delete((String)RESERVE_SP, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)detailIds)});
                        }
                        DeleteServiceHelper.delete((String)RESERVE_SP, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                        if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                            ReserveService.deleteRemoveOpRecordByReserveRecord(aggRecordList);
                        }
                    }
                    catch (Exception e1) {
                        tx.markRollback();
                        throw e1;
                    }
                }
                throw e;
            }
        }
    }

    private static void groupRecordForAgg(Collection<DynamicObject> records, List<DynamicObject> oldReserveList, List<DynamicObject> detailRecordList, List<DynamicObject> aggRecordList) {
        for (DynamicObject record : records) {
            long schemeId = record.getLong("reserve_scheme");
            if (0L == schemeId) {
                oldReserveList.add(record);
                continue;
            }
            if (record.getBoolean("ispredict")) {
                oldReserveList.add(record);
                continue;
            }
            if (record.get("bal_id") == null || record.getLong("bal_id") == 0L) {
                aggRecordList.add(record);
                continue;
            }
            detailRecordList.add(record);
        }
    }

    private static void checkNegativeInventoryForAgg(List<DynamicObject> aggRecordList) {
        DataSet dataSet;
        HashSet<Long> balIds = new HashSet<Long>(1024);
        for (DynamicObject record : aggRecordList) {
            if (record.get("aggregateid") == null || Long.parseLong(record.get("aggregateid").toString()) == 0L) continue;
            balIds.add(record.getLong("aggregateid"));
        }
        if (balIds.size() < 1) {
            return;
        }
        String bal = "msmod_reserveaggre";
        ColsMap colsMap = ColsMapHelper.findBillColMaps("msmod_reserveaggre", "msmod_std_inv_field");
        String baseQty = colsMap.getByBalCol("baseqty");
        String reserveBaseQty = colsMap.getByBalCol("reserve_base_qty");
        if (ReserveCommonHelper.getScmParam("INV0007")) {
            QFilter qFilter = new QFilter("id", "in", balIds);
            dataSet = BalQuery.getBalData4NegativeCheck((String)bal, (QFilter)qFilter, (String[])new String[]{baseQty, reserveBaseQty, "id", "keycol"});
            QFilter spQFilter = new QFilter("invid", "in", balIds);
            DataSet spDataSet = QueryServiceHelper.queryDataSet((String)(BalanceHelper.class.getName() + ":checkAfterWriteBack"), (String)RESERVE_SP, (String)"invid,baseqty as reservebaseqty", (QFilter[])new QFilter[]{spQFilter}, null);
            spDataSet = spDataSet.groupBy(new String[]{"invid"}).sum("reservebaseqty").finish();
            dataSet = dataSet.leftJoin(spDataSet).on("id", "invid").select(dataSet.getRowMeta().getFieldNames(), spDataSet.getRowMeta().getFieldNames()).finish();
            dataSet = dataSet.filter(StringUtils.join((Object[])new String[]{baseQty, "<", reserveBaseQty, "+reservebaseqty"}));
        } else {
            QFilter idFs = QFilter.of((String)BalanceHelper.getQtyStrFs(colsMap), (Object[])new Object[0]);
            idFs = idFs.and("id", "in", balIds);
            dataSet = BalQuery.getBalData4NegativeCheck((String)bal, (QFilter)idFs, (String[])new String[]{baseQty, reserveBaseQty, "id", "keycol"});
        }
        if (dataSet.hasNext()) {
            String msg = ResUtil.formatMsg(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25,\u53ef\u7528\u6570\u91cf\u6216\u9884\u7559\u6570\u91cf\u51fa\u73b0\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u9884\u7559\u3002", (String)"ReserveRecordHandler_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_0", new Object[0]);
            String msg1 = ResUtil.formatMsg(ResManager.loadKDString((String)"\u53cd\u5199\u4f59\u989d\u8868\u3010%1$s\u3011\u5931\u8d25\uff0c\u539f\u56e0\u4e3a", (String)"ReserveRecordHandler_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_2", "msmod_reserveaggre");
            throw new KDBizException(msg1 + msg);
        }
    }

    private static void updateAggReserveQty(boolean checkNegative, List<DynamicObject> records, List<String> aggregateField, Map<String, List<Object[]>> unBatchSqlMap) {
        if (records == null || records.size() == 0) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        for (DynamicObject record : records) {
            Object[] param = new Object[]{record.getBigDecimal("base_qty"), aggregateField.contains("unit") ? record.getBigDecimal("qty") : BigDecimal.ZERO, aggregateField.contains("unit2nd") ? record.getBigDecimal("qty2nd") : BigDecimal.ZERO, record.getLong("aggregateid")};
            paramList.add(param);
        }
        if (paramList.size() > 0) {
            MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveaggre");
            DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
            String sql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
            try (TXHandle tx = TX.requiresNew((String)"updateAggReserveQty");){
                try {
                    DB.executeBatch((DBRoute)route, (String)sql, BalanceHelper.sortSqlParamList(paramList));
                    if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                        ReserveService.buildRemoveOpRecordByReserveRecord(records);
                    }
                }
                catch (Exception e) {
                    if (unBatchSqlMap != null) {
                        try (TXHandle tx2 = TX.requiresNew((String)"unWriteBackBalQty");){
                            try {
                                for (Map.Entry<String, List<Object[]>> sqlEntry : unBatchSqlMap.entrySet()) {
                                    BalanceHelper.executeBatch(route, sqlEntry.getKey(), BalanceHelper.sortSqlParamList(sqlEntry.getValue()));
                                }
                            }
                            catch (Exception e1) {
                                tx2.markRollback();
                                throw e1;
                            }
                        }
                    }
                    tx.markRollback();
                    throw e;
                }
            }
            if (checkNegative) {
                try {
                    BalanceHelper.checkNegativeInventoryForAgg(records);
                }
                catch (KDBizException e) {
                    if (unBatchSqlMap != null) {
                        try (TXHandle tx2 = TX.requiresNew((String)"unWriteBackBalQty");){
                            try {
                                for (Map.Entry<String, List<Object[]>> sqlEntry : unBatchSqlMap.entrySet()) {
                                    BalanceHelper.executeBatch(route, sqlEntry.getKey(), BalanceHelper.sortSqlParamList(sqlEntry.getValue()));
                                }
                                if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                                    ReserveService.deleteRemoveOpRecordByReserveRecord(records);
                                }
                            }
                            catch (Exception e1) {
                                tx2.markRollback();
                                throw e1;
                            }
                        }
                    }
                    BalanceHelper.updateUnAggReserveQty(records, aggregateField);
                    throw e;
                }
            }
        }
    }

    private static void updateUnAggReserveQty(List<DynamicObject> records, List<String> aggregateField) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
        for (DynamicObject record : records) {
            Object[] param = new Object[]{record.getBigDecimal("base_qty").negate(), aggregateField.contains("unit") ? record.getBigDecimal("qty").negate() : BigDecimal.ZERO, aggregateField.contains("unit2nd") ? record.getBigDecimal("qty2nd").negate() : BigDecimal.ZERO, record.getLong("aggregateid")};
            paramList.add(param);
        }
        if (paramList.size() > 0) {
            MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserveaggre");
            DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
            String sql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
            try (TXHandle tx = TX.requiresNew((String)"updateAggReserveQty");){
                try {
                    DB.executeBatch((DBRoute)route, (String)sql, BalanceHelper.sortSqlParamList(paramList));
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static List<Object[]> sortSqlParamList(List<Object[]> list) {
        list.sort(new Comparator<Object[]>(){

            @Override
            public int compare(Object[] arg0, Object[] arg1) {
                if (arg0 == null || arg1 == null) {
                    return 0;
                }
                int pos = arg0.length - 1;
                if (arg0[pos] == null || arg1[pos] == null) {
                    return 0;
                }
                return Long.compare((Long)arg0[pos], (Long)arg1[pos]);
            }
        });
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, List<Object[]>> writeBackBalQtyForDetail(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        if (records == null || records.size() == 0) {
            return null;
        }
        Map<Object, Collection<DynamicObject>> recordGroup = BalanceHelper.groupRecordByScheme(records);
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)bal);
        DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
        HashMap batchSqlMap = new HashMap();
        HashMap<String, List<Object[]>> unBatchSqlMap = new HashMap<String, List<Object[]>>();
        String balTb = balEntityType.getAlias();
        for (Map.Entry<Object, Collection<DynamicObject>> entry : recordGroup.entrySet()) {
            void var13_20;
            String colsMapKey = bal + entry.getKey();
            ColsMap colsMap2 = colsMap.get(colsMapKey);
            if (colsMap2 == null) {
                ColsMap colsMap3 = ColsMap.getDefaultColsMap(bal);
            }
            Map<String, List<String>> map = BalanceHelper.getTbGroup(balEntityType, (ColsMap)var13_20);
            for (Map.Entry<String, List<String>> tbEntry : map.entrySet()) {
                String sql = BalanceHelper.getWriteBackSql(balTb, tbEntry.getKey(), BalanceHelper.parse2BalBdCol(tbEntry.getValue(), balEntityType, (ColsMap)var13_20));
                ArrayList<Object[]> paramList = (ArrayList<Object[]>)batchSqlMap.get(sql);
                ArrayList<Object[]> unParamList = (ArrayList<Object[]>)unBatchSqlMap.get(sql);
                if (paramList == null) {
                    paramList = new ArrayList<Object[]>();
                    batchSqlMap.put(sql, paramList);
                }
                if (unParamList == null) {
                    unParamList = new ArrayList<Object[]>();
                    unBatchSqlMap.put(sql, unParamList);
                }
                List<String> qtyCols = tbEntry.getValue();
                List<Object[]> params = BalanceHelper.getParams(entry.getValue(), qtyCols, true);
                List<Object[]> unParams = BalanceHelper.getParams(entry.getValue(), qtyCols, false);
                unParamList.addAll(unParams);
                paramList.addAll(params);
            }
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"writeBackBalQty");){
            try {
                for (Map.Entry entry : batchSqlMap.entrySet()) {
                    BalanceHelper.executeBatch(route, (String)entry.getKey(), BalanceHelper.sortSqlParamList((List)entry.getValue()));
                }
                if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                    ReserveService.buildRemoveOpRecordByReserveRecord(records);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (checkNegative) {
            try {
                BalanceHelper.batchCheckAfterWriteBack(bal, recordGroup, colsMap);
            }
            catch (KDBizException e) {
                try (TXHandle tXHandle = TX.requiresNew((String)"unWriteBackBalQty");){
                    try {
                        for (Map.Entry entry : unBatchSqlMap.entrySet()) {
                            BalanceHelper.executeBatch(route, (String)entry.getKey(), BalanceHelper.sortSqlParamList((List)entry.getValue()));
                        }
                        if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                            ReserveService.deleteRemoveOpRecordByReserveRecord(records);
                        }
                    }
                    catch (Exception exception) {
                        tXHandle.markRollback();
                        throw exception;
                    }
                }
                throw e;
            }
        }
        return unBatchSqlMap;
    }

    private static long[] writeBackQtyForDetailHighHot(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        if (records == null || records.size() == 0) {
            return null;
        }
        long[] ids = BalanceHelper.insertSpData(bal, records, "bal_id");
        if (checkNegative) {
            try {
                Map<Object, Collection<DynamicObject>> recordGroup = BalanceHelper.groupRecordByScheme(records);
                BalanceHelper.batchCheckAfterWriteBack(bal, recordGroup, colsMap);
            }
            catch (KDBizException e) {
                try (TXHandle tx = TX.requiresNew((String)"unWriteSpQtyForDetailHighHot");){
                    try {
                        DeleteServiceHelper.delete((String)RESERVE_SP, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                        if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                            ReserveService.deleteRemoveOpRecordByReserveRecord(records);
                        }
                    }
                    catch (Exception e1) {
                        tx.markRollback();
                        throw e1;
                    }
                }
                throw e;
            }
        }
        return ids;
    }

    private static long[] insertSpData(String bal, Collection<DynamicObject> records, String invIdName) {
        DynamicObject record;
        long[] ids = DB.genLongIds((String)"t_msmod_reserve_bal_sp", (int)(records.size() * 2));
        long transId = (Long)ThreadCache.get((Object)"reserveHighHotTransId");
        String insertSql = "insert into t_msmod_reserve_bal_sp(fid,ftransid,fdbroutekey,fbillid,fbalancename,finvid,fbaseqty,fqty,fqty2nd,fcreaterid,fcreatedate,freserverecordid,fopstatus) values(?,?,?,?,?,?,?,?,?,?,?,?,'INIT')";
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(records.size());
        String billName = "";
        Iterator<DynamicObject> iterator = records.iterator();
        while (iterator.hasNext() && (billName = (record = iterator.next()).getString("bill_obj")) == null) {
        }
        int i = 0;
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)billName);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject record2 : records) {
            Object[] param = BalanceHelper.buildSingleHighHotParam(bal, ids, transId, i, billEntityType, userId, date, record2, invIdName);
            insertParamList.add(param);
            ++i;
        }
        try (TXHandle tx = TX.requiresNew((String)"writeBackQtyForHighHot");){
            try {
                MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)bal);
                DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
                BalanceHelper.executeBatch(route, insertSql, BalanceHelper.sortSqlParamList(insertParamList));
                if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                    ReserveService.buildRemoveOpRecordByReserveRecord(records);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return ids;
    }

    private static Object[] buildSingleHighHotParam(String bal, long[] ids, long transId, int i, MainEntityType billEntityType, long userId, Date date, DynamicObject record, String invIdName) {
        Object[] param = new Object[]{ids[i], transId, billEntityType.getDBRouteKey(), record.getLong("bill_id"), bal, record.getLong(invIdName), record.getBigDecimal("base_qty"), record.getBigDecimal("qty"), record.getBigDecimal("qty2nd"), userId, date, record.getLong("id") == 0L ? ids[ids.length / 2 + i] : record.getLong("id")};
        return param;
    }

    private static void executeBatch(DBRoute route, String sql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)route, (String)sql, paramsList);
    }

    private static Map<Object, Collection<DynamicObject>> groupRecordByScheme(Collection<DynamicObject> records) {
        HashMap<Object, Collection<DynamicObject>> group = new HashMap<Object, Collection<DynamicObject>>();
        Object schemeId = null;
        ArrayList<DynamicObject> tempList = null;
        for (DynamicObject record : records) {
            schemeId = record.get("reserve_scheme");
            tempList = (ArrayList<DynamicObject>)group.get(schemeId);
            if (tempList == null) {
                tempList = new ArrayList<DynamicObject>();
                group.put(schemeId, tempList);
            }
            tempList.add(record);
        }
        return group;
    }

    public static String getWriteBackSql(String tb, String tbGroup, List<String> qtyDbCols) {
        StringBuilder sql = new StringBuilder(" UPDATE ");
        sql.append(tb);
        if (!"null".equals(tbGroup)) {
            sql.append('_').append(tbGroup);
        }
        sql.append(" SET ");
        int i = 0;
        for (String qtyCol : qtyDbCols) {
            if (i++ > 0) {
                sql.append(',');
            }
            sql.append(qtyCol).append('=').append(qtyCol).append(" + ? ");
        }
        sql.append(" WHERE FID = ?");
        return sql.toString();
    }

    private static Map<String, List<String>> getTbGroup(MainEntityType type, ColsMap colsMap) {
        HashMap<String, List<String>> group = new HashMap<String, List<String>>();
        StringBuilder errSb = new StringBuilder();
        for (String proStr : WRITE_BACK_QTY_PROS) {
            ArrayList<String> cols;
            String realBalCol = colsMap.getByBalCol(proStr);
            IDataEntityProperty pro = type.findProperty(realBalCol);
            if (pro == null) {
                errSb.append(proStr).append(" ");
                continue;
            }
            String tableGroup = pro.getTableGroup();
            if (tableGroup == null) {
                tableGroup = "null";
            }
            if ((cols = (ArrayList<String>)group.get(tableGroup)) == null) {
                cols = new ArrayList<String>();
                group.put(tableGroup, cols);
            }
            cols.add(proStr);
        }
        if (errSb.length() > 0) {
            String msg1 = String.format(ResManager.loadKDString((String)"\u9884\u7559\u6620\u5c04\u914d\u7f6e\u4e2d\u9884\u7559\u4f9b\u5e94\u6a21\u578b\u6ca1\u6709\u914d\u7f6e\u4ee5\u4e0b\u5b57\u6bb5\u6620\u5c04\uff1a%1$s\u5b57\u6bb5\u3002", (String)"InItReserveAggHelper_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), errSb.toString());
            throw new KDBizException(msg1);
        }
        return group;
    }

    private static List<String> parse2BalBdCol(List<String> stBalCols, MainEntityType balEntityType, ColsMap tempColsMap) {
        ArrayList<String> dbCols = new ArrayList<String>(stBalCols.size());
        for (String stBalCol : stBalCols) {
            dbCols.add(balEntityType.findProperty(tempColsMap.getByBalCol(stBalCol)).getAlias());
        }
        return dbCols;
    }

    private static List<Object[]> getParams(Collection<DynamicObject> records, List<String> cols, boolean isAddQty) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(records.size());
        for (DynamicObject record : records) {
            params.add(BalanceHelper.getParam4WriteBack(record, cols, isAddQty));
        }
        return params;
    }

    private static Object[] getParam4WriteBack(DynamicObject record, List<String> qtyCols, boolean isAddQty) {
        Object[] param = new Object[qtyCols.size() + 1];
        int i = 0;
        if (isAddQty) {
            for (String qtyCol : qtyCols) {
                param[i++] = record.getBigDecimal(STD_BAL_COL_MAP.get(qtyCol));
            }
        } else {
            for (String qtyCol : qtyCols) {
                param[i++] = record.getBigDecimal(STD_BAL_COL_MAP.get(qtyCol)).negate();
            }
        }
        param[i] = record.getLong("bal_id");
        return param;
    }

    private static void batchCheckAfterWriteBack(String bal, Map<Object, Collection<DynamicObject>> records, Map<String, ColsMap> colsMap) {
        for (Map.Entry<Object, Collection<DynamicObject>> entry : records.entrySet()) {
            String key = bal + entry.getKey();
            BalanceHelper.checkAfterWriteBack(bal, entry.getValue(), colsMap.get(key));
        }
    }

    private static void checkAfterWriteBack(String bal, Collection<DynamicObject> records, ColsMap colsMap) {
        DataSet dataSet;
        HashSet<Object> balIds = new HashSet<Object>(records.size());
        for (DynamicObject record : records) {
            balIds.add(record.get("bal_id"));
        }
        if (colsMap == null) {
            colsMap = ColsMap.getDefaultColsMap(bal);
        }
        String baseQty = colsMap.getByBalCol("baseqty");
        String reserveBaseQty = colsMap.getByBalCol("reserve_base_qty");
        if (ReserveCommonHelper.getScmParam("INV0007")) {
            QFilter qFilter = new QFilter("id", "in", balIds);
            dataSet = BalQuery.getBalData4NegativeCheck((String)bal, (QFilter)qFilter, (String[])new String[]{baseQty, reserveBaseQty, "id", "keycol"});
            QFilter spQFilter = new QFilter("invid", "in", balIds);
            DataSet spDataSet = QueryServiceHelper.queryDataSet((String)(BalanceHelper.class.getName() + ":checkAfterWriteBack"), (String)RESERVE_SP, (String)"invid,baseqty as reservebaseqty", (QFilter[])new QFilter[]{spQFilter}, null);
            spDataSet = spDataSet.groupBy(new String[]{"invid"}).sum("reservebaseqty").finish();
            dataSet = dataSet.leftJoin(spDataSet).on("id", "invid").select(dataSet.getRowMeta().getFieldNames(), spDataSet.getRowMeta().getFieldNames()).finish();
            dataSet = dataSet.filter(StringUtils.join((Object[])new String[]{baseQty, "<", reserveBaseQty, "+reservebaseqty"}));
        } else {
            QFilter idFs = QFilter.of((String)BalanceHelper.getQtyStrFs(colsMap), (Object[])new Object[0]);
            idFs = idFs.and("id", "in", balIds);
            dataSet = BalQuery.getBalData4NegativeCheck((String)bal, (QFilter)idFs, (String[])new String[]{baseQty, reserveBaseQty, "id", "keycol"});
        }
        if (dataSet.hasNext()) {
            String msg = ResUtil.formatMsg(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25,\u53ef\u7528\u6570\u91cf\u6216\u9884\u7559\u6570\u91cf\u51fa\u73b0\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u9884\u7559\u3002", (String)"ReserveRecordHandler_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_0", new Object[0]);
            String msg1 = ResUtil.formatMsg(ResManager.loadKDString((String)"\u53cd\u5199\u4f59\u989d\u8868\u3010%1$s\u3011\u5931\u8d25\uff0c\u539f\u56e0\u4e3a", (String)"ReserveRecordHandler_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "ReserveRecordHandler_2", bal);
            throw new KDBizException(msg1 + msg);
        }
    }

    private static String getQtyStrFs(ColsMap colsMap) {
        StringBuilder fsStr = new StringBuilder();
        fsStr.append(colsMap.getByBalCol("baseqty"));
        fsStr.append(" < ");
        fsStr.append(colsMap.getByBalCol("reserve_base_qty"));
        return fsStr.toString();
    }

    public static String getQtyStrFs(Map<String, String> balColMap) {
        StringBuilder fsStr = new StringBuilder();
        fsStr.append(balColMap.get("baseqty"));
        fsStr.append(" <");
        fsStr.append(balColMap.get("reserve_base_qty"));
        return fsStr.toString();
    }

    public static void removeReservedBalance(List<DynamicObject> records) {
        BalanceHelper.reverseRecordQty(records);
        Map<String, List<DynamicObject>> groupedRecordMap = BalanceHelper.groupByBalanceTable(records);
        for (Map.Entry<String, List<DynamicObject>> recordEntry : groupedRecordMap.entrySet()) {
            Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)recordEntry.getValue(), recordEntry.getKey());
            BalanceHelper.writeBackBalQty(recordEntry.getKey(), (Collection<DynamicObject>)recordEntry.getValue(), colsMap, false);
        }
        BalanceHelper.reverseRecordQty(records);
    }

    private static void reverseRecordQty(List<DynamicObject> records) {
        for (DynamicObject reserveRecord : records) {
            reserveRecord.set("base_qty", (Object)reserveRecord.getBigDecimal("base_qty").negate());
            reserveRecord.set("qty", (Object)reserveRecord.getBigDecimal("qty").negate());
            reserveRecord.set("qty2nd", (Object)reserveRecord.getBigDecimal("qty2nd").negate());
        }
    }

    @Deprecated
    public static Map<String, ColsMap> provideColsMap(Collection<DynamicObject> records) {
        int size = records.size();
        HashMap<String, ColsMap> resultMap = new HashMap<String, ColsMap>(size);
        for (DynamicObject record : records) {
            resultMap.put(record.getString("bal_obj") + record.get("reserve_scheme"), ColsMapHelper.findBillColMaps(record.getString("bal_obj"), "msmod_std_inv_field"));
        }
        return resultMap;
    }

    public static Map<String, ColsMap> provideColsMapNew(Collection<DynamicObject> records, String bal) {
        ColsMap colsMap = ColsMapHelper.findBillColMaps(bal, "msmod_std_inv_field");
        int size = records.size();
        HashMap<String, ColsMap> resultMap = new HashMap<String, ColsMap>(size);
        for (DynamicObject record : records) {
            resultMap.put(record.getString("bal_obj") + record.get("reserve_scheme"), colsMap);
        }
        return resultMap;
    }

    private static Map<String, List<DynamicObject>> groupByBalanceTable(Collection<DynamicObject> records) {
        HashMap<String, List<DynamicObject>> paramGroup = new HashMap<String, List<DynamicObject>>(8);
        for (DynamicObject record : records) {
            String balObjId = record.getString("bal_obj");
            ArrayList<DynamicObject> params = (ArrayList<DynamicObject>)paramGroup.get(balObjId);
            if (params == null) {
                params = new ArrayList<DynamicObject>();
                paramGroup.put(balObjId, params);
            }
            params.add(record);
        }
        return paramGroup;
    }

    @Deprecated
    public static UpdateRule getBalanceUpdateRule(String billName) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, List<Object[]>> writeBackBalQtyNotSup(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        if (records == null || records.size() == 0) {
            return null;
        }
        Map<Object, Collection<DynamicObject>> recordGroup = BalanceHelper.groupRecordByScheme(records);
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)bal);
        DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
        HashMap batchSqlMap = new HashMap();
        HashMap<String, List<Object[]>> unBatchSqlMap = new HashMap<String, List<Object[]>>();
        String balTb = balEntityType.getAlias();
        for (Map.Entry<Object, Collection<DynamicObject>> entry : recordGroup.entrySet()) {
            void var13_16;
            String colsMapKey = bal + entry.getKey();
            ColsMap colsMap2 = colsMap.get(colsMapKey);
            if (colsMap2 == null) {
                ColsMap colsMap3 = ColsMap.getDefaultColsMap(bal);
            }
            Map<String, List<String>> tbGroup = BalanceHelper.getTbGroup(balEntityType, (ColsMap)var13_16);
            for (Map.Entry<String, List<String>> tbEntry : tbGroup.entrySet()) {
                String sql = BalanceHelper.getWriteBackSql(balTb, tbEntry.getKey(), BalanceHelper.parse2BalBdCol(tbEntry.getValue(), balEntityType, (ColsMap)var13_16));
                ArrayList<Object[]> paramList = (ArrayList<Object[]>)batchSqlMap.get(sql);
                ArrayList<Object[]> unParamList = (ArrayList<Object[]>)unBatchSqlMap.get(sql);
                if (paramList == null) {
                    paramList = new ArrayList<Object[]>();
                    batchSqlMap.put(sql, paramList);
                }
                if (unParamList == null) {
                    unParamList = new ArrayList<Object[]>();
                    unBatchSqlMap.put(sql, unParamList);
                }
                List<String> qtyCols = tbEntry.getValue();
                List<Object[]> params = BalanceHelper.getParams(entry.getValue(), qtyCols, true);
                List<Object[]> unParams = BalanceHelper.getParams(entry.getValue(), qtyCols, false);
                unParamList.addAll(unParams);
                paramList.addAll(params);
            }
        }
        try (TXHandle tx = TX.required((String)"writeBackBalQty");){
            try {
                for (Map.Entry entry : batchSqlMap.entrySet()) {
                    BalanceHelper.executeBatch(route, (String)entry.getKey(), BalanceHelper.sortSqlParamList((List)entry.getValue()));
                }
                if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                    ReserveService.buildRemoveOpRecordByReserveRecord(records);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        if (checkNegative) {
            BalanceHelper.batchCheckAfterWriteBack(bal, recordGroup, colsMap);
        }
        return unBatchSqlMap;
    }

    public static void removeReservedBalanceNotSup(List<DynamicObject> records) {
        BalanceHelper.reverseRecordQty(records);
        Map<String, List<DynamicObject>> groupedRecordMap = BalanceHelper.groupByBalanceTable(records);
        for (Map.Entry<String, List<DynamicObject>> recordEntry : groupedRecordMap.entrySet()) {
            Map<String, ColsMap> colsMap = BalanceHelper.provideColsMapNew((Collection<DynamicObject>)recordEntry.getValue(), recordEntry.getKey());
            String bal = recordEntry.getKey();
            if (ReserveAggregateHelper.isAggregate()) {
                BalanceHelper.writeBackBalQtyForAggregate(bal, records, colsMap, false);
                continue;
            }
            if (ThreadCache.get((Object)"reserveHighHotTransId") != null) {
                BalanceHelper.writeBackQtyForDetailHighHot(bal, records, colsMap, false);
                continue;
            }
            BalanceHelper.writeBackBalQtyNotSup(bal, records, colsMap, false);
        }
        BalanceHelper.reverseRecordQty(records);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, List<Object[]>> writeBackBalForDetailNotSup(String bal, Collection<DynamicObject> records, Map<String, ColsMap> colsMap, boolean checkNegative) {
        if (records == null || records.size() == 0) {
            return null;
        }
        Map<Object, Collection<DynamicObject>> recordGroup = BalanceHelper.groupRecordByScheme(records);
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)bal);
        DBRoute route = DBRoute.of((String)balEntityType.getDBRouteKey());
        HashMap batchSqlMap = new HashMap();
        HashMap<String, List<Object[]>> unBatchSqlMap = new HashMap<String, List<Object[]>>();
        String balTb = balEntityType.getAlias();
        for (Map.Entry<Object, Collection<DynamicObject>> entry : recordGroup.entrySet()) {
            void var13_16;
            String colsMapKey = bal + entry.getKey();
            ColsMap colsMap2 = colsMap.get(colsMapKey);
            if (colsMap2 == null) {
                ColsMap colsMap3 = ColsMap.getDefaultColsMap(bal);
            }
            Map<String, List<String>> tbGroup = BalanceHelper.getTbGroup(balEntityType, (ColsMap)var13_16);
            for (Map.Entry<String, List<String>> tbEntry : tbGroup.entrySet()) {
                String sql = BalanceHelper.getWriteBackSql(balTb, tbEntry.getKey(), BalanceHelper.parse2BalBdCol(tbEntry.getValue(), balEntityType, (ColsMap)var13_16));
                ArrayList<Object[]> paramList = (ArrayList<Object[]>)batchSqlMap.get(sql);
                ArrayList<Object[]> unParamList = (ArrayList<Object[]>)unBatchSqlMap.get(sql);
                if (paramList == null) {
                    paramList = new ArrayList<Object[]>();
                    batchSqlMap.put(sql, paramList);
                }
                if (unParamList == null) {
                    unParamList = new ArrayList<Object[]>();
                    unBatchSqlMap.put(sql, unParamList);
                }
                List<String> qtyCols = tbEntry.getValue();
                List<Object[]> params = BalanceHelper.getParams(entry.getValue(), qtyCols, true);
                List<Object[]> unParams = BalanceHelper.getParams(entry.getValue(), qtyCols, false);
                unParamList.addAll(unParams);
                paramList.addAll(params);
            }
        }
        try (TXHandle tx = TX.required((String)"writeBackBalQty");){
            try {
                for (Map.Entry entry : batchSqlMap.entrySet()) {
                    BalanceHelper.executeBatch(route, (String)entry.getKey(), BalanceHelper.sortSqlParamList((List)entry.getValue()));
                }
                if (checkNegative) {
                    BalanceHelper.batchCheckAfterWriteBack(bal, recordGroup, colsMap);
                }
                if ("remove".equals(ThreadCache.get((Object)"ReserveOpType"))) {
                    ReserveService.buildRemoveOpRecordByReserveRecord(records);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return unBatchSqlMap;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>(4);
        tempMap.put("reserve_base_qty", "base_qty");
        tempMap.put("reserve_qty", "qty");
        tempMap.put("reserve_qty2nd", "qty2nd");
        STD_BAL_COL_MAP = Collections.unmodifiableMap(tempMap);
    }
}

