/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.record;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReleaseRecordHelper {
    public static void createByReserveRecord(List<DynamicObject> reserveRecordList, boolean isRelease) {
        if (reserveRecordList == null) {
            return;
        }
        DynamicObject[] releaseRecordList = new DynamicObject[reserveRecordList.size()];
        Date now = TimeServiceHelper.now();
        Long creator = Long.valueOf(RequestContext.getOrCreate().getUserId());
        for (int i = 0; i < reserveRecordList.size(); ++i) {
            DynamicObject releaseRecord = ReleaseRecordHelper.fromReserveRecord(reserveRecordList.get(i));
            releaseRecord.set("creater", (Object)creator);
            releaseRecord.set("create_date", (Object)now);
            if (isRelease) {
                releaseRecord.set("release_type", (Object)"release");
            } else {
                releaseRecord.set("release_type", (Object)"remove");
            }
            releaseRecordList[i] = releaseRecord;
        }
        SaveServiceHelper.save((DynamicObject[])releaseRecordList);
    }

    private static DynamicObject fromReserveRecord(DynamicObject reserveRecord) {
        DynamicObject releaseRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_release_record");
        releaseRecord.set("reserve_record", reserveRecord.getPkValue());
        releaseRecord.set("qty", (Object)reserveRecord.getBigDecimal("qty"));
        releaseRecord.set("qty2nd", (Object)reserveRecord.getBigDecimal("qty2nd"));
        releaseRecord.set("base_qty", (Object)reserveRecord.getBigDecimal("base_qty"));
        return releaseRecord;
    }
}

