/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.record;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntryType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.reserve.business.record.RequestEntryMatch;
import kd.mpscmm.msbd.reserve.business.strategy.QtyStore;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;

public class RequestBillEntryParam {
    private static final Log logger = LogFactory.getLog(RequestBillEntryParam.class);
    private EntryReserveResult result = null;
    private EntryReserveResult oldResult = null;
    private DynamicObject entry = null;
    public List<RequestEntryMatch> entryMatchs;
    private QtyStore oldQtyStore;
    private QtyStore qtyStore;
    private QtyStore defaultQtyStore;

    public List<RequestEntryMatch> getEntryMatchs() {
        return this.entryMatchs;
    }

    private RequestBillEntryParam(DynamicObject entry) {
        this.entry = entry;
    }

    public static RequestBillEntryParam getInstance(DynamicObject entry) {
        return new RequestBillEntryParam(entry);
    }

    public DynamicObject getBillEntry() {
        return this.entry;
    }

    public EntryReserveResult getResult() {
        if (this.result == null) {
            this.result = new EntryReserveResult();
            this.result.setEntryId(this.entry.getPkValue());
            if (this.entry.getDataEntityType() instanceof EntryType) {
                this.result.setSeq(this.entry.getInt("seq"));
                String billName = ((DynamicObject)this.entry.getParent()).getDataEntityType().getName();
                if ("msmod_reservebill".equals(billName)) {
                    this.result.setReserveObjTypeId(this.entry.get("reserveobjtype"));
                    this.result.setReserveObj(this.entry.get("reserveobj"));
                }
            }
        }
        return this.result;
    }

    public void setResult(EntryReserveResult result) {
        this.result = result;
    }

    public Long getPkvalue() {
        return (Long)this.entry.getPkValue();
    }

    public boolean isSuccess() {
        if (this.result == null) {
            return false;
        }
        ReserveResultType resultType = this.result.getReserveResultType();
        return ReserveResultType.FullSuccess == resultType;
    }

    public void addMatch(String compareType, Object srcVal, String tarKey) {
        if (this.entryMatchs == null) {
            this.entryMatchs = new ArrayList<RequestEntryMatch>(16);
        }
        this.entryMatchs.add(RequestEntryMatch.getInstance(compareType, srcVal, tarKey));
    }

    public boolean match(Row row) {
        boolean isMatch = true;
        if (this.entryMatchs == null || this.entryMatchs.isEmpty()) {
            return isMatch;
        }
        for (RequestEntryMatch entryMatch : this.entryMatchs) {
            if (entryMatch.match(row.get(entryMatch.getTarKey()))) continue;
            isMatch = false;
        }
        return isMatch;
    }

    public boolean match(Row row, Integer[] rowKeyIndexArray) {
        boolean isMatch = true;
        for (int i = 0; i < this.entryMatchs.size(); ++i) {
            if (this.entryMatchs.get(i).match(row.get(rowKeyIndexArray[i].intValue()))) continue;
            isMatch = false;
        }
        return isMatch;
    }

    public QtyStore getQtyStore() {
        if (this.qtyStore == null) {
            this.qtyStore = new QtyStore();
        }
        return this.qtyStore;
    }

    public void setQtyStore(QtyStore qtyStore) {
        this.qtyStore = qtyStore;
    }

    public void setOldQtyStore(QtyStore oldQtyStore) {
        this.oldQtyStore = oldQtyStore;
    }

    public void calQtyStore() {
        if (this.qtyStore == null) {
            return;
        }
        if (this.oldQtyStore == null) {
            this.oldQtyStore = this.qtyStore;
            return;
        }
        if (this.qtyStore.getLockBaseQty().compareTo(this.oldQtyStore.getLockBaseQty()) > 0) {
            this.oldQtyStore = this.qtyStore;
        } else {
            this.qtyStore = this.oldQtyStore;
            this.result = this.oldResult;
        }
    }

    public void clearResult() {
        this.qtyStore = new QtyStore(this.defaultQtyStore);
        this.qtyStore.addLockBaseQty(this.defaultQtyStore.getLockBaseQty());
        this.qtyStore.addLockQty(this.defaultQtyStore.getLockQty());
        this.qtyStore.addLockQty2end(this.defaultQtyStore.getLockQty2end());
        this.oldResult = this.result;
        this.result = null;
    }

    public void clearNotEnoughResult(EntryReserveResult oldEntryResult) {
        this.qtyStore = new QtyStore(this.defaultQtyStore);
        this.qtyStore.addLockBaseQty(oldEntryResult.getReservedBaseQty());
        this.qtyStore.addLockQty(oldEntryResult.getReservedQty());
        this.qtyStore.addLockQty2end(oldEntryResult.getReservedQty2nd());
        this.oldResult = oldEntryResult;
        this.result = oldEntryResult;
    }

    public void initQtyStore(QtyStore defaultQtyStore) {
        this.defaultQtyStore = defaultQtyStore;
    }

    public void clearEntryMatchs() {
        this.entryMatchs = new ArrayList<RequestEntryMatch>();
    }

    public QtyStore getDefaultQtyStore() {
        return this.defaultQtyStore;
    }
}

