/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.replace;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.ReserveServiceCfgFilterHelper;
import kd.mpscmm.msbd.reserve.business.datasource.DefaultDataReader;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveOpLogHelper;
import kd.mpscmm.msbd.reserve.business.record.BalanceHelper;
import kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceBalRecordModel;
import kd.mpscmm.msbd.reserve.business.replace.ReserveReplaceHelper;
import kd.mpscmm.msbd.reserve.common.constant.ReplaceOpStatusEnum;

public class ReserveReplaceService {
    private static final Log logger = LogFactory.getLog(ReserveReplaceService.class);
    private static final String REPLACE_SERVICE_NAME = "ReserveReplace";
    private static final String[] SELECT_COLS = new String[]{"id", "keycol", "warehouse", "material", "org", "baseqty", "qty", "qty2nd", "lockbaseqty", "lockqty", "lockqty2nd"};
    private static final DBRoute scmRoute = new DBRoute("scm");

    public static Set<Object> getReserveReplaceRealIdSet(String serviceName, String billName, Set<Object> billIdSet, String opName) {
        return ReserveReplaceHelper.getReserveReplaceRealIdSet(serviceName, billName, billIdSet, opName);
    }

    public static void dealStockInfo(BalanceUpdateArgs args) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveReplaceService", (String)"dealStockInfo");){
            UpdateCtx ctx = args.getCtx();
            Set billIdSet = ctx.getBillIds();
            String entityNumber = ctx.getEntityNumber();
            DynamicObject serviceCfg = ReserveServiceCfgFilterHelper.ReserveServiceDynamic(entityNumber, REPLACE_SERVICE_NAME);
            String op = StringUtils.join((Object[])new String[]{",", ctx.getOp(), ","});
            if (serviceCfg == null) {
                return;
            }
            if (serviceCfg.getString("billoperation").indexOf(op) < 0) {
                return;
            }
            UpdateRule rule = args.getRule();
            String entryName = rule.getEntryName();
            BalanceTB balanceTB = rule.getBalanceTB();
            String balFormId = balanceTB.getName();
            if (billIdSet.isEmpty()) {
                return;
            }
            Map<String, Object[]> transTypeMap = ReserveServiceCfgFilterHelper.getTransType(REPLACE_SERVICE_NAME, entityNumber, ctx.getOp(), billIdSet);
            if (transTypeMap.size() == 0) {
                return;
            }
            for (Map.Entry<String, Object[]> entry : transTypeMap.entrySet()) {
                DataSet outSet;
                String transType = entry.getKey();
                Object[] objArray = entry.getValue();
                Set realBillIdSet = (Set)objArray[0];
                if ("1".equals(transType)) {
                    ReserveReplaceHelper.replacePredictRecord(args, realBillIdSet);
                    continue;
                }
                ThreadCache.put((Object)"ReserveOpType", (Object)"replace");
                Map<String, String> balColMap = ColsMapHelper.findBillColMaps(balFormId, "msmod_std_inv_field").getBalColMap();
                ReserveReplaceService.mappingConfig(balColMap);
                DataSet updateSet = args.getBalUpdatedInfo4ReserveTrans(Arrays.asList("id", balColMap.get("materiel"), balColMap.get("baseunit"), "unit", "unit2nd"));
                if (updateSet == null || !updateSet.hasNext()) {
                    return;
                }
                DataSet updateSetCopy = updateSet.copy();
                HashSet<Object> entryIds = new HashSet<Object>(1024);
                while (updateSetCopy.hasNext()) {
                    entryIds.add(updateSetCopy.next().getLong("entryid"));
                }
                DataSet inSet = updateSet.copy().filter(StringUtils.join((Object[])new String[]{balColMap.get("baseqty"), ">0"}));
                HashSet<Object> inEntryIds = new HashSet<Object>(1024);
                if (inSet != null && inSet.hasNext()) {
                    ThreadCache.put((Object)"ReserveOpType", (Object)"replaceinlock");
                    ReserveReplaceService.dealStockInData(entityNumber, balanceTB, realBillIdSet, balColMap, inSet, inEntryIds, entryName);
                }
                if ((outSet = updateSet.filter(ReserveReplaceService.getStockOutFilter(balColMap, inEntryIds))) == null || !outSet.hasNext()) continue;
                ThreadCache.put((Object)"ReserveOpType", (Object)"replaceout");
                ReserveReplaceService.dealStockOutData(args, realBillIdSet, entryIds, entityNumber, entryName, balanceTB, balFormId, balColMap, inEntryIds, outSet, entry);
            }
        }
    }

    private static void mappingConfig(Map<String, String> balColMap) {
        List<String> mustSetFieldList = Arrays.asList("baseunit", "baseqty");
        StringBuilder sb = new StringBuilder();
        for (String field : mustSetFieldList) {
            if (balColMap.get(field) != null) continue;
            sb.append(field).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u7559\u8f6c\u79fb\u5931\u8d25\uff0c%1$s\u6ca1\u6709\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u5bf9\u8c61\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u4f9b\u5e94\u6a21\u578b\uff09\u3002", (String)"ReserveService_10", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), sb));
        }
    }

    private static void dealStockOutData(BalanceUpdateArgs args, Set<Object> billIdSet, Set<Object> entryIds, String entityNumber, String entryName, BalanceTB balanceTB, String balFormId, Map<String, String> balColMap, Set<Object> inEntryIds, DataSet outSet, Map.Entry<String, Object[]> entry) {
        String transType = entry.getKey();
        String invIdSel = "bal_id as invId,";
        QFilter qtyF = new QFilter("base_qty", ">", (Object)BigDecimal.ZERO);
        if ("msmod_reserveaggre".equals(balFormId)) {
            invIdSel = "aggregateid as invId,";
        } else {
            qtyF = qtyF.and("bal_id", "!=", (Object)0);
        }
        if ("3".equals(transType)) {
            ReserveReplaceService.saveNoRelationOutData(args, entityNumber, balanceTB, balFormId, balColMap, outSet, qtyF, billIdSet);
        } else if ("4".equals(transType)) {
            ReserveReplaceService.saveOutDataByRule(billIdSet, entityNumber, balanceTB, balFormId, balColMap, outSet, entry, invIdSel);
        } else {
            ReserveReplaceService.saveHaveRelationOutData(billIdSet, entryIds, entityNumber, entryName, balanceTB, balFormId, balColMap, inEntryIds, outSet, invIdSel, qtyF);
        }
    }

    private static void saveOutDataByRule(Set<Object> billIdSet, String entityNumber, BalanceTB balanceTB, String balFormId, Map<String, String> balColMap, DataSet outSet, Map.Entry<String, Object[]> entry, String invIdSel) {
        Object[] objArray = entry.getValue();
        if (objArray[1] == null || "".equals(objArray[1]) || objArray[2] == null || "".equals(objArray[2])) {
            return;
        }
        HashMap<Long, Long> entryReserveIdMap = new HashMap<Long, Long>(8);
        Set<Long> recordIdSet = ReserveReplaceService.getRecordIdSet(billIdSet, entityNumber, objArray, entryReserveIdMap);
        if (recordIdSet == null || recordIdSet.size() == 0) {
            return;
        }
        QFilter recordFilter = new QFilter("id", "in", recordIdSet);
        String selectCol = StringUtils.join((Object[])new String[]{invIdSel, "id,base_qty as reserve_base_qty,qty as reserve_qty,qty2nd  as reserve_qty2nd,s_materiel,s_baseunit,s_unit,s_unit2nd,aggregateid,bal_id,bal_obj,billentry_id"});
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)ReserveReplaceService.class.getName(), (String)"msmod_reserve_record", (String)selectCol, (QFilter[])recordFilter.toArray(), null);
        if (recordDataSet.hasNext()) {
            ArrayList<Long> needReplaceStockId = new ArrayList<Long>(1024);
            Map<Long, Set<ReserveReplaceBalRecordModel>> balModelMap = ReserveReplaceService.getEntryBalRecordMap(outSet, balFormId, balColMap, needReplaceStockId);
            QFilter qFilter = new QFilter("billid", "in", billIdSet);
            qFilter = qFilter.and("outorinflag", "=", (Object)"out");
            StringBuilder selectOpColSb = new StringBuilder();
            selectOpColSb.append("recordid").append(',').append("baseqty").append(',').append("entryid");
            DynamicObjectCollection exitOutOp = QueryServiceHelper.query((String)"saveNoRelationOutData", (String)"msmod_reservereplace_op", (String)selectOpColSb.toString(), (QFilter[])qFilter.toArray(), null);
            HashMap<Long, Integer> exitOutMap = new HashMap<Long, Integer>(exitOutOp.size());
            HashMap<Long, BigDecimal> hasDealEntryMap = new HashMap<Long, BigDecimal>(exitOutOp.size());
            for (DynamicObject op : exitOutOp) {
                exitOutMap.put(op.getLong("recordid"), 1);
                BigDecimal baseQty = op.getBigDecimal("baseqty");
                long entryId = op.getLong("entryid");
                if (hasDealEntryMap.get(entryId) == null) {
                    hasDealEntryMap.put(entryId, baseQty);
                    continue;
                }
                hasDealEntryMap.put(entryId, ((BigDecimal)hasDealEntryMap.get(entryId)).add(baseQty));
            }
            ConvRateContext conRate = new ConvRateContext();
            ArrayList<DynamicObject> opObjList = new ArrayList<DynamicObject>(1024);
            ArrayList<Object[]> recordParamList = new ArrayList<Object[]>(1024);
            ArrayList<String> tbLockFieldList = new ArrayList<String>(8);
            String lockQtySql = "";
            if ("msmod_reserveaggre".equals(balanceTB.getName())) {
                String bal = recordDataSet.copy().next().getString("bal_obj");
                String balTable = MetadataServiceHelper.getDataEntityType((String)bal).getAlias();
                lockQtySql = ReserveReplaceHelper.getUpdateLockQtySql(balTable, bal, ColsMapHelper.findBillColMaps(bal, "msmod_std_inv_field").getBalColMap(), tbLockFieldList, "-");
            } else {
                lockQtySql = ReserveReplaceService.getUpdateLockQtySql(balanceTB, balColMap, tbLockFieldList, "-");
            }
            ArrayList<Object[]> lockParamList = new ArrayList<Object[]>(1024);
            ArrayList<Object[]> lockAggParamList = new ArrayList<Object[]>(1024);
            ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(1024);
            while (recordDataSet.hasNext()) {
                Row row = recordDataSet.next();
                if (exitOutMap != null && exitOutMap.get(row.getLong("id")) != null) continue;
                BigDecimal reserveBaseQty = row.getBigDecimal("reserve_base_qty") == null ? BigDecimal.ZERO : row.getBigDecimal("reserve_base_qty");
                BigDecimal reserveQty = row.getBigDecimal("reserve_qty") == null ? BigDecimal.ZERO : row.getBigDecimal("reserve_qty");
                BigDecimal reserveQty2nd = row.getBigDecimal("reserve_qty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("reserve_qty2nd");
                BigDecimal[] qtyArray = new BigDecimal[]{reserveBaseQty, reserveQty, reserveQty2nd};
                List<DynamicObject> list = ReserveReplaceService.dealOneOutStock(entityNumber, balanceTB, balColMap, balModelMap, conRate, opObjList, recordParamList, tbLockFieldList, lockParamList, lockAggParamList, row, (Long)entryReserveIdMap.get(row.getLong("id")), qtyArray);
                recordList.addAll(list);
            }
            if (opObjList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])opObjList.toArray(new DynamicObject[opObjList.size()]));
            }
            if (recordParamList.size() > 0) {
                String updateOldRecordSql = "update t_msmod_reserverecord set f_base_qty = f_base_qty - ?,f_qty = f_qty - ?,f_qty2nd = f_qty2nd - ? where fid = ?";
                DB.executeBatch((DBRoute)scmRoute, (String)updateOldRecordSql, BalanceHelper.sortSqlParamList(recordParamList));
            }
            if (lockParamList.size() > 0) {
                DB.executeBatch((DBRoute)balanceTB.getDbRoute(), (String)lockQtySql, BalanceHelper.sortSqlParamList(lockParamList));
            }
            if (lockAggParamList.size() > 0) {
                String lockAggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty-?, flockqty =flockqty-?,flockqty2nd =flockqty2nd-? where fid=?";
                DB.executeBatch((DBRoute)scmRoute, (String)lockAggQtySql, BalanceHelper.sortSqlParamList(lockAggParamList));
            }
            ReserveOpLogHelper.createNewLogByRecord(recordList, true);
        }
    }

    private static Set<Long> getRecordIdSet(Set<Object> billIdSet, String entityNumber, Object[] objArray, Map<Long, Long> entryReserveIdMap) {
        String reserveIdFlag = (String)objArray[1];
        String entryIdFlag = (String)objArray[2];
        StringBuilder sb = new StringBuilder();
        sb.append(reserveIdFlag).append(" as reserveId ,").append(entryIdFlag).append(" as entryId");
        QFilter outBillFilter = new QFilter("id", "in", billIdSet);
        DynamicObjectCollection outBillCol = QueryServiceHelper.query((String)entityNumber, (String)sb.toString(), (QFilter[])outBillFilter.toArray());
        StringBuilder errSb = new StringBuilder();
        HashSet<Long> recordIdSet = new HashSet<Long>(1024);
        for (DynamicObject obj : outBillCol) {
            try {
                String[] reserveIdArray;
                if (obj.getString("reserveId") == null || obj.getString("entryId") == null) continue;
                String reserveIdString = obj.getString("reserveId");
                for (String id : reserveIdArray = reserveIdString.split(",")) {
                    long recordId = Long.parseLong(id);
                    recordIdSet.add(recordId);
                    entryReserveIdMap.put(recordId, obj.getLong("entryId"));
                }
            }
            catch (Exception e) {
                errSb.append("==reserveId or entryId is illegal==").append(e.getMessage());
            }
        }
        if (errSb.length() > 0) {
            logger.info(errSb.toString());
        }
        return recordIdSet;
    }

    private static void saveHaveRelationOutData(Set<Object> billIdSet, Set<Object> entryIds, String entityNumber, String entryName, BalanceTB balanceTB, String balFormId, Map<String, String> balColMap, Set<Object> inEntryIds, DataSet outSet, String invIdSel, QFilter qtyF) {
        HashSet<Object> outEntryIDSet = new HashSet<Object>(1024);
        outEntryIDSet.addAll(entryIds);
        outEntryIDSet.removeAll(inEntryIds);
        Map<Object, List<Object>> bOTPEntryIdMap = ReserveHelper.getBotpUpPath4EntryId(entityNumber, entryName, outEntryIDSet.toArray(new Long[outEntryIDSet.size()]), billIdSet.toArray(new Long[billIdSet.size()]));
        HashSet<Object> allEntryIdSet = new HashSet<Object>(1024);
        for (Map.Entry<Object, List<Object>> entry : bOTPEntryIdMap.entrySet()) {
            allEntryIdSet.add(entry.getKey());
            allEntryIdSet.addAll((Collection)entry.getValue());
        }
        QFilter idF = new QFilter("billentry_id", "in", allEntryIdSet);
        idF = idF.and("ispredict", "!=", (Object)"1");
        if (allEntryIdSet.size() > 0) {
            DataSet recordDataSet;
            ArrayList<Long> needReplaceStockId = new ArrayList<Long>(1024);
            Map<Long, Set<ReserveReplaceBalRecordModel>> balModelMap = ReserveReplaceService.getEntryBalRecordMap(outSet, balFormId, balColMap, needReplaceStockId);
            QFilter transFilter = new QFilter("billentryid", "in", allEntryIdSet);
            DataSet transDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reservetrans", (String)"afrecordid,billentryid  as billentry_id,invid as inInvId,baltablename", (QFilter[])new QFilter[]{transFilter}, null);
            if (transDataSet != null && transDataSet.hasNext()) {
                Object aggInvMap;
                ArrayList<Long> afIdList;
                HashSet recordSet = new HashSet(1024);
                ArrayList<Long> invIdList = new ArrayList<Long>(1024);
                ArrayList<Long> aggIdList = new ArrayList<Long>(1024);
                HashMap<Long, ArrayList<Long>> invRecordMap = new HashMap<Long, ArrayList<Long>>(1024);
                DataSet transDataSetCopy = transDataSet.copy();
                while (transDataSetCopy.hasNext()) {
                    Row row = transDataSetCopy.next();
                    long invId = row.getLong("inInvId");
                    if ("t_msmod_reserveaggregate".equals(row.getString("baltablename"))) {
                        aggIdList.add(invId);
                    } else {
                        invIdList.add(invId);
                    }
                    afIdList = (List)invRecordMap.get(invId);
                    if (afIdList == null) {
                        afIdList = new ArrayList<Long>(8);
                    }
                    afIdList.add(row.getLong("afrecordid"));
                    invRecordMap.put(invId, afIdList);
                }
                ArrayList<Long> noTransIdList = new ArrayList<Long>(1024);
                if ("msmod_reserveaggre".equals(balFormId)) {
                    QFilter aggFilter = new QFilter("id", "in", needReplaceStockId);
                    aggInvMap = ReserveReplaceHelper.getAggInvMap("im_inv_realbalance", invIdList, aggFilter.toArray());
                    afIdList = needReplaceStockId.iterator();
                    while (afIdList.hasNext()) {
                        long outAggId = (Long)afIdList.next();
                        if (aggIdList.contains(outAggId)) {
                            recordSet.addAll((Collection)invRecordMap.get(outAggId));
                            continue;
                        }
                        boolean isFind = false;
                        for (Map.Entry entry : aggInvMap.entrySet()) {
                            if (outAggId != (Long)entry.getValue()) continue;
                            recordSet.addAll((Collection)invRecordMap.get(entry.getKey()));
                            isFind = true;
                        }
                        if (isFind) continue;
                        noTransIdList.add(outAggId);
                    }
                } else {
                    Map<Long, Long> aggInvMap2 = ReserveReplaceHelper.getAggInvMap(balFormId, needReplaceStockId, null);
                    aggInvMap = needReplaceStockId.iterator();
                    while (aggInvMap.hasNext()) {
                        long id = (Long)aggInvMap.next();
                        if (invRecordMap.get(id) != null) {
                            recordSet.addAll((Collection)invRecordMap.get(id));
                            continue;
                        }
                        if (invRecordMap.get(aggInvMap2.get(id)) != null) {
                            recordSet.addAll((Collection)invRecordMap.get(aggInvMap2.get(id)));
                            continue;
                        }
                        noTransIdList.add(id);
                    }
                }
                idF = new QFilter("id", "in", recordSet);
                idF = idF.and("ispredict", "!=", (Object)"1");
                String selectCol = StringUtils.join((Object[])new String[]{invIdSel, "id,base_qty as reserve_base_qty,qty as reserve_qty,qty2nd  as reserve_qty2nd,s_materiel,s_baseunit,s_unit,s_unit2nd,aggregateid,bal_id,bal_obj"});
                recordDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_record", (String)selectCol, (QFilter[])new QFilter[]{idF, qtyF}, (String)"updatedate desc");
                if ((recordDataSet = recordDataSet.join(transDataSet).on("id", "afrecordid").select(recordDataSet.getRowMeta().getFieldNames(), transDataSet.getRowMeta().getFieldNames()).finish()).hasNext()) {
                    ReserveReplaceService.saveOutStockData(entityNumber, balanceTB, balColMap, balModelMap, recordDataSet, "billentry_id", bOTPEntryIdMap, billIdSet);
                }
                if (noTransIdList.size() > 0) {
                    idF = new QFilter("billentry_id", "in", allEntryIdSet);
                    idF = idF.and("ispredict", "!=", (Object)"1");
                    idF = "msmod_reserveaggre".equals(balFormId) ? idF.and("aggregateid", "in", needReplaceStockId) : idF.and("bal_id", "in", needReplaceStockId);
                    String selectCol2 = StringUtils.join((Object[])new String[]{invIdSel, "id,base_qty as reserve_base_qty,qty as reserve_qty,qty2nd  as reserve_qty2nd,s_materiel,s_baseunit,s_unit,s_unit2nd,aggregateid,bal_id,bal_obj,billentry_id"});
                    recordDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_record", (String)selectCol2, (QFilter[])new QFilter[]{idF, qtyF}, (String)"updatedate");
                    if (recordDataSet.hasNext()) {
                        ReserveReplaceService.saveOutStockData(entityNumber, balanceTB, balColMap, balModelMap, recordDataSet, "billentry_id", bOTPEntryIdMap, billIdSet);
                    }
                }
            } else {
                idF = "msmod_reserveaggre".equals(balFormId) ? idF.and("aggregateid", "in", needReplaceStockId) : idF.and("bal_id", "in", needReplaceStockId);
                String selectCol = StringUtils.join((Object[])new String[]{invIdSel, "id,base_qty as reserve_base_qty,qty as reserve_qty,qty2nd  as reserve_qty2nd,s_materiel,s_baseunit,s_unit,s_unit2nd,aggregateid,bal_id,bal_obj,billentry_id"});
                recordDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_record", (String)selectCol, (QFilter[])new QFilter[]{idF, qtyF}, (String)"updatedate");
                if (recordDataSet.hasNext()) {
                    ReserveReplaceService.saveOutStockData(entityNumber, balanceTB, balColMap, balModelMap, recordDataSet, "billentry_id", bOTPEntryIdMap, billIdSet);
                }
            }
        }
    }

    private static void saveNoRelationOutData(BalanceUpdateArgs args, String entityNumber, BalanceTB balanceTB, String balFormId, Map<String, String> balColMap, DataSet outSet, QFilter qtyF, Set<Object> billIdSet) {
        DataSet balData = args.getBalData4NegativeCheck(SELECT_COLS);
        balData = balData.addFields(new String[]{"baseqty-lockbaseqty", "qty-lockqty", "qty2nd-lockqty2nd"}, new String[]{"fbaseqty", "fqty", "fqty2nd"});
        balData = balData.select(new String[]{"id as fid", "keycol as fkeycol", "warehouse as fwarehouseid", "material as fmaterialid", "org as forgid", "fbaseqty", "fqty", "fqty2nd", "baseqty as fendbaseqty", "qty as fendqty", "qty2nd as fendqty2nd", "lockbaseqty", "lockqty", "lockqty2nd"});
        if (!(balData = balData.filter("fbaseqty<0 and fendbaseqty>=0")).hasNext()) {
            return;
        }
        DataSet dataSet = outSet.copy().join(balData).on("id", "fid").select(new String[]{"entryid", "billid", "baseqty", "qty", "qty2nd", balColMap.get("materiel"), balColMap.get("baseunit"), "unit", "ENTRYSEQ", "BILLNO"}, balData.getRowMeta().getFieldNames()).finish();
        if (!dataSet.hasNext()) {
            return;
        }
        HashSet<Long> needReplaceStockId = new HashSet<Long>(1024);
        HashMap<Long, Set<ReserveReplaceBalRecordModel>> outBalMap = new HashMap<Long, Set<ReserveReplaceBalRecordModel>>(1024);
        DataSet dataSetCopy = dataSet.copy();
        boolean hasBillNo = ReserveReplaceService.isHasBillNo(dataSetCopy);
        while (dataSetCopy.hasNext()) {
            Row row = dataSetCopy.next();
            long invId = row.getLong("fid");
            needReplaceStockId.add(row.getLong("fid"));
            HashSet<ReserveReplaceBalRecordModel> modelList = (HashSet<ReserveReplaceBalRecordModel>)outBalMap.get(invId);
            if (modelList == null) {
                modelList = new HashSet<ReserveReplaceBalRecordModel>(1024);
            }
            modelList.add(ReserveReplaceService.getBalRecordModel(balFormId, balColMap, row, hasBillNo));
            outBalMap.put(invId, modelList);
        }
        QFilter recordFilter = new QFilter("bal_id", "in", needReplaceStockId);
        String invIdSel = "bal_id as invId,";
        if ("msmod_reserveaggre".equals(args.getRule().getBalanceNo())) {
            recordFilter = new QFilter("aggregateid", "in", needReplaceStockId);
            invIdSel = "aggregateid as invId,";
        }
        recordFilter = recordFilter.and("ispredict", "!=", (Object)"1");
        String selectCol = StringUtils.join((Object[])new String[]{invIdSel, "id,base_qty as reserve_base_qty,qty as reserve_qty,qty2nd  as reserve_qty2nd,s_materiel,s_baseunit,s_unit,s_unit2nd,aggregateid,bal_id,bal_obj"});
        DataSet noRelateDataSet = QueryServiceHelper.queryDataSet((String)DefaultDataReader.class.getName(), (String)"msmod_reserve_record", (String)selectCol, (QFilter[])new QFilter[]{recordFilter, qtyF}, (String)"bal_id desc,aggregateid,updatedate");
        if (noRelateDataSet.hasNext()) {
            ReserveReplaceService.saveOutStockData(entityNumber, balanceTB, balColMap, outBalMap, noRelateDataSet, "invId", null, billIdSet);
        }
    }

    private static ReserveReplaceBalRecordModel getBalRecordModel(String balFormId, Map<String, String> balColMap, Row row, boolean hasBillNo) {
        ReserveReplaceBalRecordModel balRecordModel = new ReserveReplaceBalRecordModel();
        balRecordModel.setBalFormId(balFormId);
        balRecordModel.setBalId(row.getLong("fid"));
        balRecordModel.setBillId(row.getLong("billid"));
        balRecordModel.setEntryId(row.getLong("entryid"));
        if (hasBillNo) {
            balRecordModel.setBillEntrySeq(row.getLong("entryseq"));
            balRecordModel.setBillNo(row.getString("billno"));
        }
        BigDecimal fBaseQty = row.getBigDecimal("fbaseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fbaseqty");
        BigDecimal baseQty = row.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty");
        baseQty = fBaseQty.abs().min(baseQty.abs());
        BigDecimal qty = BigDecimal.ZERO;
        BigDecimal qty2nd = BigDecimal.ZERO;
        if (balColMap.get("qty") != null) {
            BigDecimal fQty = row.getBigDecimal("fqty") == null ? BigDecimal.ZERO : row.getBigDecimal("fqty");
            qty = row.getBigDecimal("qty") == null ? BigDecimal.ZERO : row.getBigDecimal("qty");
            qty = fQty.abs().min(qty.abs());
        }
        if (balColMap.get("qty2nd") != null) {
            BigDecimal fQty2nd = row.getBigDecimal("fqty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("fqty2nd");
            qty2nd = row.getBigDecimal("qty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("qty2nd");
            qty2nd = fQty2nd.abs().min(qty2nd.abs());
        }
        balRecordModel.setBaseQty(baseQty);
        balRecordModel.setQty(qty);
        balRecordModel.setQty2nd(qty2nd);
        balRecordModel.setMaterialId(row.getLong("fmaterialid"));
        balRecordModel.setTotalBaseQty(row.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty").abs());
        balRecordModel.setMaterialId(row.getLong(balColMap.get("materiel")));
        balRecordModel.setBaseUnitId(row.getLong(balColMap.get("baseunit")));
        balRecordModel.setUnitId(row.getLong("unit"));
        return balRecordModel;
    }

    private static void saveOutStockData(String entityNumber, BalanceTB balanceTB, Map<String, String> balColMap, Map<Long, Set<ReserveReplaceBalRecordModel>> outBalMap, DataSet reserveRecordDataSet, String keyName, Map<Object, List<Object>> bOTPEntryIdMap, Set<Object> billIdSet) {
        QFilter qFilter = new QFilter("billid", "in", billIdSet);
        qFilter = qFilter.and("outorinflag", "=", (Object)"out");
        StringBuilder selectOpColSb = new StringBuilder();
        selectOpColSb.append("recordid").append(',').append("baseqty").append(',').append("entryid");
        DynamicObjectCollection exitOutOp = QueryServiceHelper.query((String)"saveNoRelationOutData", (String)"msmod_reservereplace_op", (String)selectOpColSb.toString(), (QFilter[])qFilter.toArray(), null);
        HashMap<Long, Integer> exitOutMap = new HashMap<Long, Integer>(exitOutOp.size());
        HashMap<Long, BigDecimal> hasDealEntryMap = new HashMap<Long, BigDecimal>(exitOutOp.size());
        for (DynamicObject op : exitOutOp) {
            exitOutMap.put(op.getLong("recordid"), 1);
            BigDecimal baseQty = op.getBigDecimal("baseqty");
            long entryId = op.getLong("entryid");
            if (hasDealEntryMap.get(entryId) == null) {
                hasDealEntryMap.put(entryId, baseQty);
                continue;
            }
            hasDealEntryMap.put(entryId, ((BigDecimal)hasDealEntryMap.get(entryId)).add(baseQty));
        }
        ConvRateContext conRate = new ConvRateContext();
        ArrayList<DynamicObject> opObjList = new ArrayList<DynamicObject>(1024);
        ArrayList<Object[]> recordParamList = new ArrayList<Object[]>(1024);
        ArrayList<String> tbLockFieldList = new ArrayList<String>(8);
        String lockQtySql = "";
        if ("msmod_reserveaggre".equals(balanceTB.getName())) {
            String bal = reserveRecordDataSet.copy().next().getString("bal_obj");
            String balTable = MetadataServiceHelper.getDataEntityType((String)bal).getAlias();
            lockQtySql = ReserveReplaceHelper.getUpdateLockQtySql(balTable, bal, ColsMapHelper.findBillColMaps(bal, "msmod_std_inv_field").getBalColMap(), tbLockFieldList, "-");
        } else {
            lockQtySql = ReserveReplaceService.getUpdateLockQtySql(balanceTB, balColMap, tbLockFieldList, "-");
        }
        ArrayList<Object[]> lockParamList = new ArrayList<Object[]>(1024);
        ArrayList<Object[]> lockAggParamList = new ArrayList<Object[]>(1024);
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(1024);
        while (reserveRecordDataSet.hasNext()) {
            Row row = reserveRecordDataSet.next();
            if (exitOutMap != null && exitOutMap.get(row.getLong("id")) != null) continue;
            long recordEntryId = row.getLong(keyName);
            BigDecimal reserveBaseQty = row.getBigDecimal("reserve_base_qty") == null ? BigDecimal.ZERO : row.getBigDecimal("reserve_base_qty");
            BigDecimal reserveQty = row.getBigDecimal("reserve_qty") == null ? BigDecimal.ZERO : row.getBigDecimal("reserve_qty");
            BigDecimal reserveQty2nd = row.getBigDecimal("reserve_qty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("reserve_qty2nd");
            BigDecimal[] qtyArray = new BigDecimal[]{reserveBaseQty, reserveQty, reserveQty2nd};
            if (bOTPEntryIdMap != null) {
                for (Map.Entry<Object, List<Object>> entry : bOTPEntryIdMap.entrySet()) {
                    if (!entry.getValue().contains(recordEntryId)) continue;
                    long realEntryId = (Long)entry.getKey();
                    if (hasDealEntryMap.get(realEntryId) == null) {
                        recordList.addAll(ReserveReplaceService.dealOneOutStock(entityNumber, balanceTB, balColMap, outBalMap, conRate, opObjList, recordParamList, tbLockFieldList, lockParamList, lockAggParamList, row, realEntryId, qtyArray));
                        continue;
                    }
                    Set<ReserveReplaceBalRecordModel> outModelSet = outBalMap.get(realEntryId);
                    if (outModelSet == null) continue;
                    BigDecimal dealBaseQty = (BigDecimal)hasDealEntryMap.get(realEntryId);
                    int isFindCount = 0;
                    for (ReserveReplaceBalRecordModel model : outModelSet) {
                        if (model == null || model.getAvbBaseQty().compareTo(dealBaseQty) != 0) continue;
                        ++isFindCount;
                    }
                    if (isFindCount == outModelSet.size()) continue;
                    recordList.addAll(ReserveReplaceService.dealOneOutStock(entityNumber, balanceTB, balColMap, outBalMap, conRate, opObjList, recordParamList, tbLockFieldList, lockParamList, lockAggParamList, row, realEntryId, qtyArray));
                }
                continue;
            }
            recordList.addAll(ReserveReplaceService.dealOneOutStock(entityNumber, balanceTB, balColMap, outBalMap, conRate, opObjList, recordParamList, tbLockFieldList, lockParamList, lockAggParamList, row, recordEntryId, qtyArray));
        }
        if (opObjList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])opObjList.toArray(new DynamicObject[opObjList.size()]));
        }
        if (recordParamList.size() > 0) {
            String updateOldRecordSql = "update t_msmod_reserverecord set f_base_qty = f_base_qty - ?,f_qty = f_qty - ?,f_qty2nd = f_qty2nd - ? where fid = ?";
            DB.executeBatch((DBRoute)scmRoute, (String)updateOldRecordSql, BalanceHelper.sortSqlParamList(recordParamList));
        }
        if (lockParamList.size() > 0) {
            DB.executeBatch((DBRoute)balanceTB.getDbRoute(), (String)lockQtySql, BalanceHelper.sortSqlParamList(lockParamList));
        }
        if (lockAggParamList.size() > 0) {
            String lockAggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty-?, flockqty =flockqty-?,flockqty2nd =flockqty2nd-? where fid=?";
            DB.executeBatch((DBRoute)scmRoute, (String)lockAggQtySql, BalanceHelper.sortSqlParamList(lockAggParamList));
        }
        ReserveOpLogHelper.createNewLogByRecord(recordList, true);
    }

    private static List<DynamicObject> dealOneOutStock(String entityNumber, BalanceTB balanceTB, Map<String, String> balColMap, Map<Long, Set<ReserveReplaceBalRecordModel>> outBalMap, ConvRateContext conRate, List<DynamicObject> opObjList, List<Object[]> recordParamList, List<String> tbLockFieldList, List<Object[]> lockParamList, List<Object[]> lockAggParamList, Row row, long entryId, BigDecimal[] qtyArray) {
        Set<ReserveReplaceBalRecordModel> outModelSet = outBalMap.get(entryId);
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(8);
        if (outModelSet == null) {
            return recordList;
        }
        BigDecimal reserveBaseQty = qtyArray[0];
        BigDecimal reserveQty = qtyArray[1];
        BigDecimal reserveQty2nd = qtyArray[2];
        for (ReserveReplaceBalRecordModel replaceBalRecordModel : outModelSet) {
            BigDecimal actReplaceBaseQty;
            BigDecimal needReplaceQty2nd;
            if (replaceBalRecordModel == null) continue;
            BigDecimal needReplaceBaseQty = replaceBalRecordModel.getAvbBaseQty() == null ? BigDecimal.ZERO : replaceBalRecordModel.getAvbBaseQty();
            BigDecimal needReplaceQty = replaceBalRecordModel.getAvbQty() == null ? BigDecimal.ZERO : replaceBalRecordModel.getAvbQty();
            BigDecimal bigDecimal = needReplaceQty2nd = replaceBalRecordModel.getAvbQty2nd() == null ? BigDecimal.ZERO : replaceBalRecordModel.getAvbQty2nd();
            if (needReplaceBaseQty.compareTo(BigDecimal.ZERO) == 0 || reserveBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal actReplaceQty = BigDecimal.ZERO;
            BigDecimal actReplaceQty2nd = BigDecimal.ZERO;
            long materialId = replaceBalRecordModel.getMaterialId();
            long baseUnitId = replaceBalRecordModel.getBaseUnitId();
            long unitId = replaceBalRecordModel.getUnitId();
            if (needReplaceBaseQty.compareTo(reserveBaseQty) > 0) {
                actReplaceBaseQty = reserveBaseQty;
                needReplaceBaseQty = needReplaceBaseQty.subtract(reserveBaseQty);
                if (reserveQty.compareTo(BigDecimal.ZERO) > 0 && (needReplaceQty = needReplaceQty.subtract(actReplaceQty = conRate.getSrcQty(actReplaceBaseQty, materialId, unitId, baseUnitId).min(reserveQty))).compareTo(BigDecimal.ZERO) < 0) {
                    needReplaceQty = BigDecimal.ZERO;
                }
                if (reserveQty2nd.compareTo(BigDecimal.ZERO) > 0 && (needReplaceQty2nd = needReplaceQty2nd.subtract(actReplaceQty2nd = reserveQty2nd)).compareTo(BigDecimal.ZERO) < 0) {
                    needReplaceQty2nd = BigDecimal.ZERO;
                }
            } else {
                actReplaceBaseQty = needReplaceBaseQty;
                if (reserveQty.compareTo(BigDecimal.ZERO) > 0) {
                    actReplaceQty = conRate.getSrcQty(actReplaceBaseQty, materialId, unitId, baseUnitId).min(reserveQty);
                }
                if (reserveQty2nd.compareTo(BigDecimal.ZERO) > 0) {
                    actReplaceQty2nd = needReplaceQty2nd.min(reserveQty2nd);
                }
                needReplaceBaseQty = BigDecimal.ZERO;
                needReplaceQty = BigDecimal.ZERO;
                needReplaceQty2nd = BigDecimal.ZERO;
            }
            replaceBalRecordModel.setBaseQty(needReplaceBaseQty);
            replaceBalRecordModel.setQty(needReplaceQty);
            replaceBalRecordModel.setQty2nd(needReplaceQty2nd);
            reserveBaseQty = reserveBaseQty.subtract(actReplaceBaseQty);
            reserveQty = reserveQty.subtract(actReplaceQty);
            reserveQty2nd = reserveQty2nd.subtract(actReplaceQty2nd);
            qtyArray[0] = reserveBaseQty;
            qtyArray[1] = reserveQty;
            qtyArray[2] = reserveQty2nd;
            String balName = balanceTB.getName();
            String balTableName = balanceTB.getTb();
            if ("msmod_reserveaggre".equals(balName)) {
                if (row.getLong("bal_id") == 0L) {
                    opObjList.add(ReserveReplaceService.buildOpDynamicObject(entityNumber, balName, balTableName, row, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd));
                    recordParamList.add(ReserveReplaceHelper.buildQtyParam(actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("id")));
                    lockAggParamList.add(ReserveReplaceHelper.buildQtyParam(actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("aggregateid")));
                    recordList.add(ReserveReplaceHelper.buildRecord4Log(entityNumber, row, entryId, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, "msmod_reserveaggre", row.getLong("aggregateid")));
                    continue;
                }
                balName = row.getString("bal_obj");
                balTableName = MetadataServiceHelper.getDataEntityType((String)balName).getAlias();
                opObjList.add(ReserveReplaceService.buildOpDynamicObject(entityNumber, balName, balTableName, row, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd));
                recordParamList.add(ReserveReplaceHelper.buildQtyParam(actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("id")));
                lockParamList.add(ReserveReplaceHelper.buildOutLockStockParam(balColMap, tbLockFieldList.size(), actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("bal_id")));
                lockAggParamList.add(ReserveReplaceHelper.buildQtyParam(actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("aggregateid")));
                recordList.add(ReserveReplaceHelper.buildRecord4Log(entityNumber, row, entryId, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, balName, row.getLong("bal_id")));
                recordList.add(ReserveReplaceHelper.buildRecord4Log(entityNumber, row, entryId, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, "msmod_reserveaggre", row.getLong("aggregateid")));
                continue;
            }
            opObjList.add(ReserveReplaceService.buildOpDynamicObject(entityNumber, balName, balTableName, row, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd));
            recordParamList.add(ReserveReplaceHelper.buildQtyParam(actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("id")));
            lockParamList.add(ReserveReplaceHelper.buildOutLockStockParam(balColMap, tbLockFieldList.size(), actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("bal_id")));
            recordList.add(ReserveReplaceHelper.buildRecord4Log(entityNumber, row, entryId, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, balName, row.getLong("bal_id")));
            if (!ReserveAggregateHelper.isAggregateInit()) continue;
            lockAggParamList.add(ReserveReplaceHelper.buildQtyParam(actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, row.getLong("aggregateid")));
            recordList.add(ReserveReplaceHelper.buildRecord4Log(entityNumber, row, entryId, replaceBalRecordModel, actReplaceBaseQty, actReplaceQty, actReplaceQty2nd, "msmod_reserveaggre", row.getLong("aggregateid")));
        }
        return recordList;
    }

    private static long getEntryId(String keyName, Map<Object, List<Object>> bOTPEntryIdMap, Row row) {
        long entryId = row.getLong(keyName);
        if (bOTPEntryIdMap != null) {
            for (Map.Entry<Object, List<Object>> entry : bOTPEntryIdMap.entrySet()) {
                if (!entry.getValue().contains(entryId)) continue;
                entryId = (Long)entry.getKey();
            }
        }
        return entryId;
    }

    private static DynamicObject buildOpDynamicObject(String entityNumber, String balName, String balTableName, Row row, ReserveReplaceBalRecordModel replaceBalRecordModel, BigDecimal actReplaceBaseQty, BigDecimal actReplaceQty, BigDecimal actReplaceQty2nd) {
        DynamicObject opObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservereplace_op");
        opObj.set("billobj", (Object)entityNumber);
        opObj.set("billid", (Object)replaceBalRecordModel.getBillId());
        opObj.set("entryid", (Object)replaceBalRecordModel.getEntryId());
        opObj.set("billno", (Object)replaceBalRecordModel.getBillNo());
        opObj.set("billentryseq", (Object)replaceBalRecordModel.getBillEntrySeq());
        opObj.set("opstatus", (Object)ReplaceOpStatusEnum.ONCOMMIT);
        if ("msmod_reserveaggre".equals(balName)) {
            opObj.set("invid", (Object)row.getLong("aggregateid"));
        } else {
            opObj.set("invid", (Object)row.getLong("bal_id"));
        }
        opObj.set("outorinflag", (Object)"out");
        opObj.set("baseqty", (Object)actReplaceBaseQty);
        opObj.set("qty", (Object)actReplaceQty);
        opObj.set("qty2nd", (Object)actReplaceQty2nd);
        opObj.set("recordid", (Object)row.getLong("id"));
        opObj.set("aggregateid", (Object)row.getLong("aggregateid"));
        opObj.set("balancename", (Object)balName);
        opObj.set("baltablename", (Object)balTableName);
        opObj.set("totalbaseqty", (Object)replaceBalRecordModel.getTotalBaseQty());
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        opObj.set("creater", (Object)userId);
        opObj.set("create_date", (Object)date);
        opObj.set("material", (Object)replaceBalRecordModel.getMaterialId());
        opObj.set("baseunit", (Object)replaceBalRecordModel.getBaseUnitId());
        opObj.set("unit", (Object)replaceBalRecordModel.getUnitId());
        return opObj;
    }

    private static Map<Object, Set<Object>> getBOTPSrcEntryMap(String formId, String entryKey, Set<Long> entryIds, Set<Long> billIdSet) {
        HashMap<Object, Set<Object>> srcEntryIdMap = new HashMap<Object, Set<Object>>(16);
        Map<Object, List<Object>> botpUpPath4EntryId = ReserveHelper.getBotpUpPath4EntryId(formId, entryKey, entryIds.toArray(new Long[entryIds.size()]), billIdSet.toArray(new Long[billIdSet.size()]));
        for (Long entryId : entryIds) {
            HashSet<Object> srcEntryIds = new HashSet<Object>(16);
            List<Object> srcIds = botpUpPath4EntryId.get(entryId);
            if (srcIds != null) {
                srcEntryIds.addAll(srcIds);
            }
            srcEntryIds.add(entryId);
            srcEntryIdMap.put(entryId, srcEntryIds);
        }
        return srcEntryIdMap;
    }

    private static String getStockOutFilter(Map<String, String> balColMap, Set<Object> inEntryIds) {
        StringBuilder outSb = new StringBuilder();
        outSb.append(balColMap.get("baseqty")).append("<0");
        StringBuilder idSb = new StringBuilder();
        for (Object id : inEntryIds) {
            idSb.append(id).append(',');
        }
        if (idSb.length() > 0) {
            outSb.append(" and entryid not in (").append((CharSequence)idSb.deleteCharAt(idSb.length() - 1)).append(')');
        }
        return outSb.toString();
    }

    private static void dealStockInData(String entityNumber, BalanceTB balanceTB, Set<Object> realBillIdSet, Map<String, String> balColMap, DataSet inSet, Set<Object> inEntryIds, String entryName) {
        ArrayList<DynamicObject> opObjList = new ArrayList<DynamicObject>(1024);
        ArrayList<String> tbLockFieldList = new ArrayList<String>(8);
        String lockQtySql = ReserveReplaceService.getUpdateLockQtySql(balanceTB, balColMap, tbLockFieldList, "+");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1024);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        Map<Long, Long> sonAndParentIdMap = ReserveReplaceService.getSonAndParentIdMap(entityNumber, realBillIdSet, entryName);
        HashMap<Long, BigDecimal> parentEntryQtyMap = new HashMap<Long, BigDecimal>(1024);
        boolean hasBillNo = ReserveReplaceService.isHasBillNo(inSet);
        while (inSet.hasNext()) {
            long parentId;
            Row row = inSet.next();
            if (!realBillIdSet.contains(row.getLong("billid"))) continue;
            long entryId = row.getLong("entryid");
            inEntryIds.add(entryId);
            DynamicObject opObj = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reservereplace_op");
            opObj.set("billobj", (Object)entityNumber);
            opObj.set("billid", (Object)row.getLong("billid"));
            opObj.set("entryid", (Object)entryId);
            if (hasBillNo) {
                opObj.set("billno", (Object)row.getString("BILLNO"));
                opObj.set("billentryseq", (Object)row.getLong("ENTRYSEQ"));
            }
            opObj.set("opstatus", (Object)ReplaceOpStatusEnum.ONCOMMIT);
            opObj.set("balancename", (Object)balanceTB.getName());
            opObj.set("invid", (Object)row.getLong("id"));
            opObj.set("outorinflag", (Object)"in");
            opObj.set("baltablename", (Object)balanceTB.getTb());
            opObj.set("creater", (Object)userId);
            opObj.set("create_date", (Object)date);
            opObj.set("material", (Object)row.getLong(balColMap.get("materiel")));
            opObj.set("baseunit", (Object)row.getLong(balColMap.get("baseunit")));
            BigDecimal baseQty = row.getBigDecimal(balColMap.get("baseqty"));
            opObj.set("baseqty", (Object)baseQty);
            opObj.set("totalbaseqty", (Object)baseQty);
            if (balColMap.get("unit") != null) {
                opObj.set("unit", (Object)row.getLong(balColMap.get("unit")));
            }
            if (balColMap.get("qty") != null) {
                opObj.set("qty", (Object)row.getBigDecimal(balColMap.get("qty")));
            }
            if (balColMap.get("unit2nd") != null) {
                opObj.set("unit2nd", (Object)row.getLong(balColMap.get("unit2nd")));
            }
            if (balColMap.get("qty2nd") != null) {
                opObj.set("qty2nd", (Object)row.getBigDecimal(balColMap.get("qty2nd")));
            }
            if (entryName.contains(".") && (parentId = sonAndParentIdMap.get(entryId).longValue()) != 0L) {
                BigDecimal totalBaseQty = (BigDecimal)parentEntryQtyMap.get(parentId);
                if (totalBaseQty == null) {
                    totalBaseQty = baseQty;
                    parentEntryQtyMap.put(parentId, totalBaseQty);
                } else {
                    totalBaseQty = totalBaseQty.add(baseQty);
                    parentEntryQtyMap.put(parentId, totalBaseQty);
                }
            }
            ReserveReplaceService.buildUpdateLockQtyParamList(balColMap, tbLockFieldList, paramList, row);
            opObjList.add(opObj);
        }
        if (opObjList.size() > 0) {
            if (entryName.contains(".")) {
                for (DynamicObject opObj : opObjList) {
                    long entryId = opObj.getLong("entryid");
                    if (sonAndParentIdMap.get(entryId) == null) continue;
                    long parentEntryId = sonAndParentIdMap.get(entryId);
                    opObj.set("entryid", (Object)parentEntryId);
                    opObj.set("totalbaseqty", parentEntryQtyMap.get(parentEntryId));
                }
            }
            SaveServiceHelper.save((DynamicObject[])opObjList.toArray(new DynamicObject[0]));
        }
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)balanceTB.getDbRoute(), (String)lockQtySql, BalanceHelper.sortSqlParamList(paramList));
        }
        ReserveOpLogHelper.createNewLogByRePlaceRecord(opObjList, false);
    }

    private static boolean isHasBillNo(DataSet inSet) {
        String[] fieldNameArr;
        boolean hasBillNo = false;
        for (String fieldName : fieldNameArr = inSet.getRowMeta().getFieldNames()) {
            if (!"BILLNO".equals(fieldName)) continue;
            hasBillNo = true;
            break;
        }
        return hasBillNo;
    }

    private static Map<Long, Long> getSonAndParentIdMap(String entityNumber, Set<Object> realBillIdSet, String entryName) {
        HashMap<Long, Long> sonAndParentIdMap = new HashMap<Long, Long>(1024);
        if (entryName.contains(".")) {
            DynamicObject[] stockBillArray;
            String[] entryNameArray = entryName.split("\\.");
            if (entryNameArray.length != 2) {
                return null;
            }
            for (DynamicObject stockBill : stockBillArray = BusinessDataServiceHelper.load((Object[])realBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber))) {
                DynamicObjectCollection parentEntry = stockBill.getDynamicObjectCollection(entryNameArray[0]);
                if (parentEntry == null || parentEntry.size() <= 0) continue;
                for (DynamicObject parent : parentEntry) {
                    DynamicObjectCollection sonEntry = parent.getDynamicObjectCollection(entryNameArray[1]);
                    if (sonEntry == null || sonEntry.size() <= 0) continue;
                    for (DynamicObject son : sonEntry) {
                        sonAndParentIdMap.put(son.getLong("id"), parent.getLong("id"));
                    }
                }
            }
        }
        return sonAndParentIdMap;
    }

    private static void buildUpdateLockQtyParamList(Map<String, String> balColMap, List<String> tbLockFieldList, List<Object[]> paramList, Row row) {
        Object[] param = new Object[tbLockFieldList.size() + 1];
        int j = 0;
        param[j] = row.getBigDecimal(balColMap.get("baseqty"));
        ++j;
        if (balColMap.get("qty") != null) {
            param[j] = row.getBigDecimal(balColMap.get("qty"));
            ++j;
        }
        if (balColMap.get("qty2nd") != null) {
            param[j] = row.getBigDecimal(balColMap.get("qty2nd"));
            ++j;
        }
        param[j] = row.getLong("id");
        paramList.add(param);
    }

    private static String getUpdateLockQtySql(BalanceTB balanceTB, Map<String, String> balColMap, List<String> tbLockFieldList, String op) {
        return ReserveReplaceHelper.getUpdateLockQtySql(balanceTB.getTb(), balanceTB.getName(), balColMap, tbLockFieldList, op);
    }

    private static Map<Long, Set<ReserveReplaceBalRecordModel>> getEntryBalRecordMap(DataSet outDataSet, String balFormId, Map<String, String> balColMap, List<Long> needReplaceStockId) {
        HashMap<Long, Set<ReserveReplaceBalRecordModel>> entryBalIdMap = new HashMap<Long, Set<ReserveReplaceBalRecordModel>>(1024);
        boolean hasBillNo = ReserveReplaceService.isHasBillNo(outDataSet);
        while (outDataSet.hasNext()) {
            Row row = outDataSet.next();
            needReplaceStockId.add(row.getLong("id"));
            ReserveReplaceBalRecordModel balRecordModel = new ReserveReplaceBalRecordModel();
            balRecordModel.setBalFormId(balFormId);
            balRecordModel.setBalId(row.getLong("id"));
            balRecordModel.setBillId(row.getLong("billid"));
            balRecordModel.setEntryId(row.getLong("entryid"));
            if (hasBillNo) {
                balRecordModel.setBillNo(row.getString("BILLNO"));
                balRecordModel.setBillEntrySeq(row.getLong("ENTRYSEQ"));
            }
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal qty2nd = BigDecimal.ZERO;
            if (balColMap.get("qty") != null) {
                qty = row.getBigDecimal(balColMap.get("qty")).abs();
            }
            if (balColMap.get("qty2nd") != null) {
                qty2nd = row.getBigDecimal(balColMap.get("qty2nd")).abs();
            }
            balRecordModel.setBaseQty(row.getBigDecimal(balColMap.get("baseqty")).abs());
            balRecordModel.setQty(qty);
            balRecordModel.setQty2nd(qty2nd);
            balRecordModel.setTotalBaseQty(row.getBigDecimal(balColMap.get("baseqty")).abs());
            balRecordModel.setMaterialId(row.getLong(balColMap.get("materiel")));
            balRecordModel.setBaseUnitId(row.getLong(balColMap.get("baseunit")));
            balRecordModel.setUnitId(row.getLong("unit"));
            HashSet<ReserveReplaceBalRecordModel> modelList = new HashSet<ReserveReplaceBalRecordModel>(8);
            modelList.add(balRecordModel);
            entryBalIdMap.put(row.getLong("entryid"), modelList);
        }
        return entryBalIdMap;
    }

    public static void reserveReplacePollingTask() {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveReplaceService", (String)"reserveReplacePollingTask");){
            ThreadCache.put((Object)"ReserveOpName", (Object)"autoTask");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(12, -30);
            QFilter qFilter = new QFilter("create_date", "<", (Object)cal.getTime());
            DynamicObjectCollection opObjList = QueryServiceHelper.query((String)"msmod_reservereplace_op", (String)ReserveReplaceHelper.getOpSelectCols(), (QFilter[])qFilter.toArray());
            HashMap<String, Set[]> billNameIdMap = new HashMap<String, Set[]>(32);
            HashSet<Long> allIdSet = new HashSet<Long>(1024);
            for (DynamicObject obj : opObjList) {
                HashSet<Long> rollbackIdList;
                HashSet<Long> commitIdSet;
                String billName = obj.getString("billobj");
                Set[] idArray = (Set[])billNameIdMap.get(billName);
                if (idArray == null) {
                    idArray = new Set[2];
                }
                if ((commitIdSet = idArray[0]) == null) {
                    commitIdSet = new HashSet<Long>(1024);
                }
                if ((rollbackIdList = idArray[1]) == null) {
                    rollbackIdList = new HashSet<Long>(1024);
                }
                if (ReplaceOpStatusEnum.ONCOMMIT.toString().equals(obj.getString("opstatus"))) {
                    commitIdSet.add(obj.getLong("billid"));
                } else if (ReplaceOpStatusEnum.ONROLLBACK.toString().equals(obj.getString("opstatus"))) {
                    rollbackIdList.add(obj.getLong("billid"));
                } else {
                    allIdSet.add(obj.getLong("billid"));
                }
                idArray[0] = commitIdSet;
                idArray[1] = rollbackIdList;
                billNameIdMap.put(billName, idArray);
            }
            StringBuilder errSb = new StringBuilder();
            for (Map.Entry entry : billNameIdMap.entrySet()) {
                TXHandle tx2 = TX.requiresNew((String)"ReserveReplaceService-reserveReplacePollingTask-save");
                Throwable throwable = null;
                try {
                    try {
                        Set[] idArray = (Set[])entry.getValue();
                        ReserveReplaceService.dealReserveReplace((String)entry.getKey(), idArray[0]);
                        ReserveReplaceService.reserveReplaceRollBack((String)entry.getKey(), idArray[1]);
                        allIdSet.addAll(idArray[0]);
                        allIdSet.addAll(idArray[1]);
                        DeleteServiceHelper.delete((String)"msmod_reservereplace_op", (QFilter[])new QFilter[]{new QFilter("billid", "in", allIdSet)});
                    }
                    catch (Exception e) {
                        errSb.append(e.getMessage());
                        tx2.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx2 == null) continue;
                    if (throwable != null) {
                        try {
                            tx2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx2.close();
                }
            }
            if (errSb.length() > 0) {
                logger.error("ReserveReplaceService-reserveReplacePollingTask  error:", (Object)errSb);
            }
        }
    }

    public static void dealReserveReplace(String billName, Set<Object> realIdSet) {
        ReserveReplaceHelper.dealReserveReplace(billName, realIdSet);
    }

    public static void reserveReplaceRollBack(String billName, Set<Object> realIdSet) {
        if (ThreadCache.get((Object)"ReserveOpType") == null) {
            ThreadCache.put((Object)"ReserveOpType", (Object)"replaceback");
        }
        ReserveReplaceHelper.reserveReplaceRollBack(billName, realIdSet);
    }

    public static List<Object[]> unReserveRecordReplace(Set<Object> billIds, String entityNumber, DBRoute dbRoute, boolean isRollBack) {
        return ReserveReplaceHelper.unReserveRecordReplace(billIds, entityNumber, dbRoute, isRollBack);
    }

    public static void dealUnReserveReplace(String billName, Set<Object> realIdSet) {
        QFilter idF = new QFilter("billid", "in", realIdSet);
        QFilter formIdF = new QFilter("transbill", "=", (Object)billName);
        formIdF = formIdF.and("deletestatus", "=", (Object)"1");
        DynamicObjectCollection reserveReplaceCols = QueryServiceHelper.query((String)"msmod_reservetrans", (String)"bfrecordid,afrecordid,billentryid,intotalbaseqty,outtotalbaseqty,invid,replacebaseqty,replaceqty,replaceqty2nd,outbaseqty,outqty,outqty2nd,id", (QFilter[])new QFilter[]{idF, formIdF});
        if (reserveReplaceCols.isEmpty()) {
            return;
        }
        HashSet<Long> recordIdSet = new HashSet<Long>(reserveReplaceCols.size());
        for (DynamicObject replaceObj : reserveReplaceCols) {
            recordIdSet.add(replaceObj.getLong("afrecordid"));
        }
        QFilter recordFilter = new QFilter("id", "in", recordIdSet);
        recordFilter = recordFilter.and("deletestatus", "=", (Object)"1");
        DeleteServiceHelper.delete((String)"msmod_reserve_record", (QFilter[])new QFilter[]{recordFilter});
        DeleteServiceHelper.delete((String)"msmod_reservetrans", (QFilter[])new QFilter[]{idF, formIdF});
    }

    public static void unReserveReplaceRollBack(String billName, Set<Object> realIdSet) {
        DynamicObjectCollection reserveReplaceCols;
        Throwable throwable;
        TXHandle tx;
        block30: {
            block31: {
                block32: {
                    tx = TX.requiresNew((String)"ReserveReplaceService-unReserveReplaceRollBack");
                    throwable = null;
                    QFilter idF = new QFilter("billid", "in", realIdSet);
                    QFilter formIdF = new QFilter("transbill", "=", (Object)billName);
                    formIdF = formIdF.and("deletestatus", "=", (Object)"1");
                    reserveReplaceCols = QueryServiceHelper.query((String)"msmod_reservetrans", (String)"bfrecordid,afrecordid,billentryid,intotalbaseqty,outtotalbaseqty,invid,replacebaseqty,replaceqty,replaceqty2nd,outbaseqty,outqty,outqty2nd,id,baltablename,billid,billno,billentryseq,transbill", (QFilter[])new QFilter[]{idF, formIdF});
                    if (!reserveReplaceCols.isEmpty()) break block30;
                    if (tx == null) break block31;
                    if (throwable == null) break block32;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block31;
                }
                tx.close();
            }
            return;
        }
        try {
            try {
                String invQtySql;
                String aggQtySql;
                HashMap<Long, Long> reserveIdsMap = new HashMap<Long, Long>(reserveReplaceCols.size());
                HashMap<Long, DynamicObject> afObjMap = new HashMap<Long, DynamicObject>(reserveReplaceCols.size());
                HashMap<Long, DynamicObject> bfObjMap = new HashMap<Long, DynamicObject>(reserveReplaceCols.size());
                for (DynamicObject reserveReplace : reserveReplaceCols) {
                    reserveIdsMap.put(reserveReplace.getLong("afrecordid"), reserveReplace.getLong("bfrecordid"));
                    afObjMap.put(reserveReplace.getLong("afrecordid"), reserveReplace);
                    bfObjMap.put(reserveReplace.getLong("bfrecordid"), reserveReplace);
                }
                QFilter reserveIdF = new QFilter("id", "in", reserveIdsMap.keySet());
                String selectCols = "id,reserveprctype,bal_id,bal_entryid,base_qty,qty,qty2nd,aggregateid,ispredict,bill_obj,bill_id,bill_no,billentry_id,billentry_seq,bal_obj";
                DynamicObjectCollection aFRecordCol = QueryServiceHelper.query((String)ReserveReplaceHelper.class.getName(), (String)"msmod_reserve_record", (String)selectCols, (QFilter[])new QFilter[]{reserveIdF}, null);
                QFilter oldFilter = new QFilter("id", "in", reserveIdsMap.values());
                oldFilter = oldFilter.and("ispredict", "=", (Object)"0");
                DynamicObjectCollection oldReserveRecord = QueryServiceHelper.query((String)"msmod_reserve_record", (String)selectCols, (QFilter[])new QFilter[]{oldFilter});
                HashMap<Long, DynamicObject> oldRecordMap = new HashMap<Long, DynamicObject>(oldReserveRecord.size());
                for (DynamicObject record : oldReserveRecord) {
                    oldRecordMap.put(record.getLong("id"), record);
                }
                String updateNewRecordSql = "update t_msmod_reserverecord set fdeletestatus = '0',f_base_qty = f_base_qty + ?,f_qty= f_qty + ?,f_qty2nd= f_qty2nd + ? where fid = ?";
                ArrayList<Object[]> newRecordParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                ArrayList<Object[]> newAggParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                ArrayList<Object[]> newInvParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                String updateOldRecordSql = "update t_msmod_reserverecord set f_base_qty = f_base_qty - ?,f_qty= f_qty - ?,f_qty2nd= f_qty2nd - ? where fid = ?";
                ArrayList<Object[]> oldRecordParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                ArrayList<Object[]> oldAggParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                ArrayList<Object[]> oldInvParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                String newTableName = "";
                ArrayList<Object[]> transParamList = new ArrayList<Object[]>(reserveReplaceCols.size());
                for (DynamicObject aFRecord : aFRecordCol) {
                    DynamicObject oldRecord;
                    long afRecordId = aFRecord.getLong("id");
                    long bfRecordID = (Long)reserveIdsMap.get(afRecordId);
                    DynamicObject replaceObj = (DynamicObject)afObjMap.get(afRecordId);
                    newTableName = replaceObj.getString("baltablename");
                    if (StringUtils.isEmpty((CharSequence)newTableName)) continue;
                    transParamList.add(new Object[]{replaceObj.getLong("id")});
                    BigDecimal replaceBaseQty = replaceObj.getBigDecimal("replacebaseqty");
                    BigDecimal replaceQty = replaceObj.getBigDecimal("replaceqty");
                    BigDecimal replaceQty2nd = replaceObj.getBigDecimal("replaceqty2nd");
                    newRecordParamList.add(new Object[]{replaceBaseQty, replaceQty, replaceQty2nd, afRecordId});
                    if (aFRecord.getLong("bal_id") == 0L) {
                        newAggParamList.add(new Object[]{replaceBaseQty, replaceQty, replaceQty2nd, aFRecord.getLong("aggregateid")});
                    } else {
                        newInvParamList.add(new Object[]{replaceBaseQty, replaceQty, replaceQty2nd, aFRecord.getLong("bal_id")});
                        if (ReserveAggregateHelper.isAggregateInit()) {
                            newAggParamList.add(new Object[]{replaceBaseQty, replaceQty, replaceQty2nd, aFRecord.getLong("aggregateid")});
                        }
                    }
                    if ((oldRecord = (DynamicObject)oldRecordMap.get(bfRecordID)) == null) continue;
                    BigDecimal oldBaseQty = replaceObj.getBigDecimal("outbaseqty");
                    BigDecimal oldQty = replaceObj.getBigDecimal("outqty");
                    BigDecimal oldQty2nd = replaceObj.getBigDecimal("outqty2nd");
                    oldRecordParamList.add(new Object[]{oldBaseQty, oldQty, oldQty2nd, bfRecordID});
                    if (aFRecord.getLong("bal_id") == 0L) {
                        oldAggParamList.add(new Object[]{oldBaseQty, oldQty, oldQty2nd, oldRecord.getLong("aggregateid")});
                        continue;
                    }
                    oldInvParamList.add(new Object[]{oldBaseQty, oldQty, oldQty2nd, oldRecord.getLong("bal_id")});
                    if (!ReserveAggregateHelper.isAggregateInit()) continue;
                    oldAggParamList.add(new Object[]{oldBaseQty, oldQty, oldQty2nd, oldRecord.getLong("aggregateid")});
                }
                DB.executeBatch((DBRoute)scmRoute, (String)updateNewRecordSql, BalanceHelper.sortSqlParamList(newRecordParamList));
                if (newAggParamList.size() > 0) {
                    aggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
                    DB.executeBatch((DBRoute)scmRoute, (String)aggQtySql, BalanceHelper.sortSqlParamList(newAggParamList));
                }
                if (newInvParamList.size() > 0) {
                    invQtySql = "update " + newTableName + "_a set flockbaseqty =flockbaseqty+?, flockqty =flockqty+?,flockqty2nd =flockqty2nd+? where fid=?";
                    DB.executeBatch((DBRoute)scmRoute, (String)invQtySql, BalanceHelper.sortSqlParamList(newInvParamList));
                }
                if (oldRecordParamList.size() > 0) {
                    DB.executeBatch((DBRoute)scmRoute, (String)updateOldRecordSql, BalanceHelper.sortSqlParamList(oldRecordParamList));
                }
                if (oldAggParamList.size() > 0) {
                    aggQtySql = "update t_msmod_reserveaggregate_a set flockbaseqty =flockbaseqty-?, flockqty =flockqty-?,flockqty2nd =flockqty2nd-? where fid=?";
                    DB.executeBatch((DBRoute)scmRoute, (String)aggQtySql, BalanceHelper.sortSqlParamList(oldAggParamList));
                }
                if (oldInvParamList.size() > 0) {
                    invQtySql = "update " + newTableName + "_a set flockbaseqty =flockbaseqty-?, flockqty =flockqty-?,flockqty2nd =flockqty2nd-? where fid=?";
                    DB.executeBatch((DBRoute)scmRoute, (String)invQtySql, BalanceHelper.sortSqlParamList(oldInvParamList));
                }
                if (transParamList.size() > 0) {
                    String updateTransSql = "update t_msmod_reservetrans set fdeletestatus = '0' where fid = ?";
                    DB.executeBatch((DBRoute)scmRoute, (String)updateTransSql, BalanceHelper.sortSqlParamList(transParamList));
                }
                ReserveReplaceHelper.createLogForAfterReplace(bfObjMap, reserveIdsMap, aFRecordCol, "backafter");
                ReserveReplaceHelper.createLogForAfterReplace(bfObjMap, reserveIdsMap, oldReserveRecord, "backbefore");
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("unReserveReplaceRollBack error:", (Throwable)e);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

