/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.datasource.DataReader;
import kd.mpscmm.msbd.reserve.business.datasource.DataReaderFactory;
import kd.mpscmm.msbd.reserve.business.datasource.DataSourceHelper;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.QtyStore;
import kd.mpscmm.msbd.reserve.business.strategy.RuleHelper;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;
import kd.mpscmm.msbd.reserve.business.strategy.engine.plugin.RulePluginExecutor;
import org.apache.commons.lang3.StringUtils;

public class RuleEngine {
    private static final Log logger = LogFactory.getLog(RuleEngine.class);

    public static DataSet execute(ReserveContext context, DynamicObject rule, DynamicObject requestEntry) {
        try (TraceSpan ruleEngineSpan = Tracer.create((String)"RuleEngine", (String)"execute");){
            DataSet ruleDataSet = DataSourceHelper.getUsableDataByRule(context, rule, requestEntry);
            ruleDataSet = RuleEngine.executeRulePlugin(context, rule, requestEntry, ruleDataSet);
            DynamicObjectCollection sortFieldList = rule.getDynamicObjectCollection("sort_entry");
            String[] sortStrArray = RuleEngine.getSortStringArray(context, sortFieldList);
            DataSet dataSet = ruleDataSet.orderBy(sortStrArray);
            return dataSet;
        }
    }

    public static DataSet execute(ReserveContext context, DynamicObject rule, DynamicObject requestEntry, QFilter additionalFilter) {
        try (TraceSpan ruleEngineSpan = Tracer.create((String)"RuleEngine", (String)"execute");){
            DataSet ruleDataSet = DataSourceHelper.getUsableDataByRule(context, rule, requestEntry, additionalFilter);
            ruleDataSet = RuleEngine.executeRulePlugin(context, rule, requestEntry, ruleDataSet);
            DynamicObjectCollection sortFieldList = rule.getDynamicObjectCollection("sort_entry");
            String[] sortStrArray = RuleEngine.getSortStringArray(context, sortFieldList);
            DataSet dataSet = ruleDataSet.orderBy(sortStrArray);
            return dataSet;
        }
    }

    private static String[] getSortStringArray(ReserveContext context, DynamicObjectCollection sortFieldList) {
        ArrayList<String> sortStr = new ArrayList<String>(8);
        for (int i = 0; i < sortFieldList.size(); ++i) {
            if (context.getScheme().getBoolean("aggregate") && !context.getAggregateField().contains(((DynamicObject)sortFieldList.get(i)).getString("sort_field_no"))) continue;
            sortStr.add(RuleEngine.getSortString((DynamicObject)sortFieldList.get(i)));
        }
        return sortStr.toArray(new String[sortStr.size()]);
    }

    private static String getSortString(DynamicObject sortEntry) {
        String key = sortEntry.getString("sort_field_no");
        String direction = sortEntry.getString("sort_way");
        return key + " " + direction;
    }

    private static DataSet executeRulePlugin(ReserveContext context, DynamicObject rule, DynamicObject requestEntry, DataSet dataSet) {
        String rulePlugin = RuleHelper.getPlugin(rule);
        if (!RuleHelper.isUsePlugin(rule) || rulePlugin == null) {
            return dataSet;
        }
        String[] fields = dataSet.getRowMeta().getFieldNames();
        ArrayList<Object[]> newData = new ArrayList<Object[]>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            QtyStore qtyStore = RulePluginExecutor.execute(rulePlugin, context, requestEntry, row);
            Object[] newFields = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                newFields[i] = row.get(field);
                if (field.equals("avbbaseqty")) {
                    newFields[i] = qtyStore.getBaseQty();
                    continue;
                }
                if (field.equals("avbqty")) {
                    newFields[i] = qtyStore.getQty();
                    continue;
                }
                if (!field.equals("avbqty2nd")) continue;
                newFields[i] = qtyStore.getQty2end();
            }
            newData.add(newFields);
        }
        Algo algo = Algo.create((String)"RuleEngine.executeRulePlugin");
        DataSet newDataSet = algo.createDataSet(newData.iterator(), dataSet.getRowMeta());
        return newDataSet;
    }

    public static DataSet executeBatch(ReserveContext context, DynamicObject rule, List<RequestBillEntryParam> entryParams) {
        for (RequestBillEntryParam requestBillEntryParam : entryParams) {
            requestBillEntryParam.clearEntryMatchs();
        }
        DynamicObject supSrcObj = rule.getDynamicObject("supsrcobj");
        String supBillFormId = supSrcObj == null ? "im_inv_realbalance" : (String)supSrcObj.getPkValue();
        ColsMap cols = context.getSupColsMap(supBillFormId);
        Map<String, String> balColMap = cols.getBalColMap();
        ColsMapHelper.mappingConfig(balColMap);
        try {
            DataSet readData;
            if (RuleEngine.checkEntryHeader(rule, cols)) {
                return null;
            }
            HashSet<String> tempBillSet = new HashSet<String>(16);
            QFilter supFilter = RuleEngine.getSupFilter(context, rule, entryParams, cols, supBillFormId, tempBillSet);
            if (supFilter == null) {
                supFilter = new QFilter("1", "=", (Object)1);
            }
            logger.info("\u8bfb\u53d6\u6570\u636e\uff0c \u4f9b\u5e94\u5bf9\u8c61\uff1a" + supBillFormId + "\uff0c\u8fc7\u6ee4\u6761\u4ef6\uff1a " + supFilter);
            DataReader dataReader = DataReaderFactory.getDataReader();
            if (rule.getBoolean("ispredict") || !context.getScheme().getBoolean("aggregate")) {
                readData = dataReader.readData(supBillFormId, supFilter, cols, rule.getBoolean("ispredict"));
                StringBuilder filter = RuleEngine.ruleOtherFilter(context, rule, entryParams, cols, tempBillSet, rule.getBoolean("ispredict"));
                if (filter.length() != 0) {
                    readData = readData.filter(filter.toString());
                }
            } else {
                readData = dataReader.readData(context, supBillFormId, supFilter, cols);
                readData = readData.addField(String.valueOf(rule.getBoolean("ispredict")), "ispredict");
                readData = readData.addField("0", "id");
                readData = readData.addField("0", "entryid");
            }
            DynamicObjectCollection sortFieldList = rule.getDynamicObjectCollection("sort_entry");
            String[] sortStrArray = RuleEngine.getSortStringArray(context, sortFieldList);
            return readData.orderBy(sortStrArray);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u7b56\u7565.\u9884\u7559\u89c4\u5219\u914d\u7f6e\u3002", (String)"RuleEngine_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
    }

    private static boolean checkEntryHeader(DynamicObject rule, ColsMap cols) {
        Map<String, String> balColMap = cols.getBalColMap();
        String materiel = balColMap.get("materiel");
        if (materiel == null) {
            return true;
        }
        String[] materielArray = materiel.split("\\.");
        if (materielArray.length == 1) {
            String billEntry = balColMap.get("billentry");
            if (billEntry != null) {
                for (String field : balColMap.values()) {
                    if (!field.startsWith(billEntry + "\\.")) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7559\u7684\u7269\u6599\u662f\u5355\u5934\u5b57\u6bb5\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u5355\u636e\u4f53\uff08\u5206\u5f55\uff09\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u6620\u5c04\u914d\u7f6e\u3002", (String)"RuleEngine_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                }
            }
            DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("rule_entry");
            for (DynamicObject ruleRow : ruleEntry) {
                String property = ruleRow.getString("std_inv_col_no");
                String[] split = property.split("\\.");
                String propertyKey = balColMap.get(split[0]);
                if (StringUtils.isEmpty((CharSequence)propertyKey)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u627e\u5230\u9884\u7559\u6620\u5c04\u5b57\u6bb5, \u4f9b\u5e94\u6a21\u578b\u5b57\u6bb5\uff1a%1$s", (String)"RuleEngine_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), property));
                }
                if (!propertyKey.startsWith(billEntry + "\\.")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7559\u7684\u7269\u6599\u662f\u5355\u5934\u5b57\u6bb5\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u5355\u636e\u4f53\uff08\u5206\u5f55\uff09\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u89c4\u5219\u3002", (String)"RuleEngine_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            }
        }
        return false;
    }

    private static StringBuilder ruleOtherFilter(ReserveContext context, DynamicObject rule, List<RequestBillEntryParam> entryParams, ColsMap cols, Set<String> tempBillSet, boolean isPredict) {
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("rule_entry");
        Map<String, String> colMap = cols.getBalColMap();
        Map<String, String> billMap = cols.getBillColMap();
        StringBuilder filter = new StringBuilder();
        for (DynamicObject ruleRow : ruleEntry) {
            String property = ruleRow.getString("std_inv_col_no");
            String compareType = ruleRow.getString("compare_type");
            IDataEntityProperty pro = null;
            MainEntityType curType = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field");
            pro = (IDataEntityProperty)curType.getAllFields().get(property);
            if (StringUtils.isEmpty((CharSequence)property) || StringUtils.isEmpty((CharSequence)compareType)) continue;
            StringBuilder f = new StringBuilder();
            if (!tempBillSet.contains(property)) continue;
            String propertyKey = colMap.get(property);
            String key = billMap.get(propertyKey);
            Object value = RuleEngine.parseToLong(ruleRow.get("require_bill_col_no"));
            if ((value == null || "".equals(value)) && ((value = RuleEngine.parseToLong(ruleRow.get("require_bill_col"))) == null || "".equals(value))) {
                value = pro instanceof DateProp ? ruleRow.getDate("require_bill_date") : (pro instanceof BasedataProp || pro instanceof QtyProp ? Integer.valueOf(0) : "");
            }
            switch (compareType) {
                case "B": {
                    f.append(key).append(" > ").append(value);
                    break;
                }
                case "C": {
                    f.append(key).append(" < ").append(value);
                    break;
                }
                case "A": {
                    f.append(key).append(" = ").append(value);
                    break;
                }
                case "H": {
                    f.append(key).append(" != ").append(value);
                    break;
                }
                case "D": 
                case "I": {
                    String[] sp = value.toString().split(",");
                    HashSet<Object> vals = new HashSet<Object>(sp.length);
                    for (int i = 0; i < sp.length; ++i) {
                        vals.add(RuleEngine.parseToLong(sp[i]));
                    }
                    if ("I".equals(compareType)) {
                        f.append(key).append(" not in ").append(vals);
                        break;
                    }
                    f.append(key).append(" in ").append(vals);
                    break;
                }
                case "F": {
                    f.append(key).append(" = ").append(RuleEngine.parseToLong(0));
                    break;
                }
                case "E": {
                    f.append(key).append(" != ").append(RuleEngine.parseToLong(0));
                    break;
                }
                case "=": 
                case ">": 
                case "<": {
                    Set<Object> matchVals2 = RuleEngine.addMatch(context, entryParams, property, ruleRow.getString("require_bill_col_no"), compareType, isPredict);
                    if (matchVals2 == null) break;
                    for (Object machVal : matchVals2) {
                        if (StringUtils.isEmpty((CharSequence)f)) {
                            f = f.append(key).append(compareType).append(machVal);
                            continue;
                        }
                        f = f.append(" or ").append(key).append(compareType).append(machVal);
                    }
                    break;
                }
            }
            if ("".equals(filter.toString())) {
                filter.append((CharSequence)f);
                continue;
            }
            if ("".equals(f.toString())) continue;
            filter.append(" and ").append((CharSequence)f);
        }
        return filter;
    }

    private static QFilter getSupFilter(ReserveContext context, DynamicObject rule, List<RequestBillEntryParam> entryParams, ColsMap cols, String supBillFormId, Set<String> tempBillSet) {
        DynamicObjectCollection ruleEntry = rule.getDynamicObjectCollection("rule_entry");
        Map<String, String> colMap = cols.getBalColMap();
        QFilter filter = new QFilter("sourcebill", "=", (Object)supBillFormId);
        filter = filter.and(new QFilter("targetobj", "=", (Object)"msmod_std_inv_field"));
        filter.and("isenable", "=", (Object)Boolean.TRUE);
        DynamicObject dbColsMap = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billfieldmapping", (QFilter[])filter.toArray());
        if (dbColsMap == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff1a%1$s\u3002", (String)"ReserveContext_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), supBillFormId));
        }
        QFilter supFilter = null;
        for (DynamicObject ruleRow : ruleEntry) {
            Object nextType;
            String property = ruleRow.getString("std_inv_col_no");
            String[] split = property.split("\\.");
            String compareType = ruleRow.getString("compare_type");
            IDataEntityProperty pro = null;
            MainEntityType curType = MetadataServiceHelper.getDataEntityType((String)"msmod_std_inv_field");
            if (property.contains(".")) {
                String[] keys = property.split("\\.");
                for (int i = 0; i < keys.length; ++i) {
                    IDataEntityProperty curPro = (IDataEntityProperty)curType.getAllFields().get(keys[i]);
                    pro = curPro;
                    if (!(pro instanceof BasedataProp) || (nextType = ((BasedataProp)curPro).getBaseEntityId()) == null) continue;
                    curType = MetadataServiceHelper.getDataEntityType((String)nextType);
                }
            } else {
                pro = (IDataEntityProperty)curType.getAllFields().get(property);
            }
            if (StringUtils.isEmpty((CharSequence)property) || StringUtils.isEmpty((CharSequence)compareType)) continue;
            QFilter f = null;
            String propertyKey = colMap.get(split[0]);
            if (StringUtils.isEmpty((CharSequence)propertyKey)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u627e\u5230\u9884\u7559\u6620\u5c04\u5b57\u6bb5, \u4f9b\u5e94\u6a21\u578b\u5b57\u6bb5\uff1a%1$s", (String)"RuleEngine_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), property));
            }
            if (split.length > 1) {
                propertyKey = colMap.get(split[0]) + "." + split[1];
            }
            if (!rule.getBoolean("ispredict") && context.getScheme().getBoolean("aggregate") && !context.getAggregateField().contains(property)) continue;
            DynamicObjectCollection rows = dbColsMap.getDynamicObjectCollection("colsmap");
            nextType = rows.iterator();
            while (nextType.hasNext()) {
                DynamicObject row = (DynamicObject)nextType.next();
                String val = row.getString("targetobjcol");
                if (!property.equals(val) || !StringUtils.isBlank((CharSequence)(val = row.getString("sourcebillcol"))) && !"1".equals(row.getString("selectvalue"))) continue;
                tempBillSet.add(property);
            }
            if (tempBillSet.contains(property)) continue;
            Object value = pro instanceof TextProp || pro instanceof ComboProp ? ruleRow.getString("require_bill_col_no") : (pro instanceof DecimalProp ? RuleEngine.parseToBigDecimal(ruleRow.get("require_bill_col_no")) : RuleEngine.parseToLong(ruleRow.get("require_bill_col_no")));
            if ((value == null || "".equals(value)) && ((value = RuleEngine.parseToLong(ruleRow.get("require_bill_col"))) == null || "".equals(value))) {
                value = pro instanceof DateProp ? ruleRow.getDate("require_bill_date") : (pro instanceof BasedataProp || pro instanceof DecimalProp ? Integer.valueOf(0) : "");
            }
            switch (compareType) {
                case "B": {
                    f = new QFilter(propertyKey, ">", value);
                    break;
                }
                case "C": {
                    f = new QFilter(propertyKey, "<", value);
                    break;
                }
                case "A": {
                    f = new QFilter(propertyKey, "=", value);
                    break;
                }
                case "H": {
                    f = new QFilter(propertyKey, "!=", value);
                    break;
                }
                case "D": 
                case "I": {
                    int i;
                    String[] sp;
                    HashSet<Object> vals = new HashSet<Object>(16);
                    if (pro instanceof DateProp || pro instanceof TextProp) {
                        sp = value.toString().split(",");
                        for (i = 0; i < sp.length; ++i) {
                            vals.add(sp[i]);
                        }
                    } else if (pro instanceof DecimalProp) {
                        sp = value.toString().split(",");
                        for (i = 0; i < sp.length; ++i) {
                            vals.add(RuleEngine.parseToBigDecimal(sp[i]));
                        }
                    } else {
                        sp = value.toString().split(",");
                        for (i = 0; i < sp.length; ++i) {
                            vals.add(RuleEngine.parseToLong(sp[i]));
                        }
                    }
                    if ("I".equals(compareType)) {
                        f = new QFilter(propertyKey, "not in", vals);
                        break;
                    }
                    f = new QFilter(propertyKey, "in", vals);
                    break;
                }
                case "F": {
                    f = new QFilter(propertyKey, "=", value);
                    break;
                }
                case "E": {
                    f = new QFilter(propertyKey, "!=", value);
                    break;
                }
                case "=": {
                    Set<Object> matchVals1 = RuleEngine.addMatch(context, entryParams, property, ruleRow.getString("require_bill_col_no"), compareType, rule.getBoolean("ispredict"));
                    if (matchVals1 == null || matchVals1.size() <= 0) break;
                    if (matchVals1.size() == 1 && matchVals1.contains(null)) {
                        matchVals1.remove(null);
                        f = new QFilter(propertyKey, "is null", null);
                        break;
                    }
                    if (matchVals1.size() > 1 && matchVals1.contains(null)) {
                        matchVals1.remove(null);
                        f = new QFilter(propertyKey, "in", matchVals1).or(propertyKey, "is null", null);
                        break;
                    }
                    f = new QFilter(propertyKey, "in", matchVals1);
                    break;
                }
                case ">": 
                case "<": {
                    Set<Object> matchVals = RuleEngine.addMatch(context, entryParams, property, ruleRow.getString("require_bill_col_no"), compareType, rule.getBoolean("ispredict"));
                    if (matchVals == null) break;
                    for (Object machVal : matchVals) {
                        if (f == null) {
                            f = new QFilter(propertyKey, compareType, machVal);
                            continue;
                        }
                        f = f.or(propertyKey, compareType, machVal);
                    }
                    break;
                }
            }
            if (supFilter == null) {
                supFilter = f;
                continue;
            }
            if (f == null) continue;
            supFilter = supFilter.and(f);
        }
        return supFilter;
    }

    private static Set<Object> addMatch(ReserveContext context, List<RequestBillEntryParam> entryParams, String tarKey, String srcKey, String compareType, boolean isPredict) {
        HashSet<Object> srcVals = new HashSet<Object>(entryParams.size());
        boolean isMatch = true;
        for (RequestBillEntryParam entryParam : entryParams) {
            IDataEntityProperty prop;
            DynamicObject billEntry = entryParam.getBillEntry();
            Object srcVal = null;
            String[] sp = srcKey.split("\\.");
            if (billEntry.getDataEntityType() instanceof EntryType) {
                EntryType entityType = (EntryType)billEntry.getDataEntityType();
                if (entityType.getName().equals(sp[0])) {
                    srcVal = FilterParser.getProValue(srcKey, billEntry);
                } else {
                    prop = ((MainEntityType)entityType.getParent()).findProperty(sp[0]);
                    if (!(prop instanceof EntryType)) {
                        srcVal = FilterParser.getProValue(srcKey, (DynamicObject)billEntry.getParent());
                    }
                }
            } else {
                IDataEntityType dataEntityType = billEntry.getDataEntityType();
                if (dataEntityType.getName().equals(sp[0])) {
                    srcVal = FilterParser.getProValue(srcKey, billEntry);
                } else {
                    prop = ((MainEntityType)dataEntityType).findProperty(sp[0]);
                    if (!(prop instanceof EntryType)) {
                        srcVal = FilterParser.getProValue(srcKey, billEntry);
                    }
                }
            }
            if (srcVal instanceof DynamicObject) {
                srcVal = ((DynamicObject)srcVal).getPkValue();
            }
            entryParam.addMatch(compareType, srcVal, tarKey);
            if (!isPredict && context.isAggregate() && !context.getScheme().getBoolean("aggregate")) {
                if (srcVal == null && RuleEngine.getSrcInfoType(billEntry, sp, context) instanceof BasedataProp) {
                    srcVals.add(BigDecimal.ZERO);
                    continue;
                }
                srcVals.add(srcVal);
                continue;
            }
            if (srcVal == null || StringUtils.isEmpty((CharSequence)srcVal.toString())) {
                isMatch = false;
                continue;
            }
            if (!isMatch) continue;
            srcVals.add(srcVal);
        }
        return isMatch ? srcVals : null;
    }

    private static Object getSrcInfoType(DynamicObject billEntry, String[] tagKey, ReserveContext context) {
        if (tagKey.length > 1) {
            return billEntry.getDataEntityType().getProperties().get((Object)tagKey[1]);
        }
        DynamicObject requestBill = context.getRequestBill();
        return requestBill.getDataEntityType().getProperties().get((Object)tagKey[0]);
    }

    private static Object parseToLong(Object value) {
        try {
            return Long.valueOf(value.toString());
        }
        catch (Exception e) {
            return value;
        }
    }

    private static Object parseToBigDecimal(Object value) {
        try {
            return BigDecimal.valueOf(Double.parseDouble(value.toString()));
        }
        catch (Exception e) {
            return value;
        }
    }
}

