/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.SchemeHelper;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.RuleEngine;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.ResultHandlerFactory;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.handler.billresult.RuleResultHandlerFactory;

public final class StrategyEngine {
    @Deprecated
    public static EntryReserveResult execute(ReserveContext context, DynamicObject strategy, DynamicObject requestEntry) {
        try (TraceSpan strategyEngineSpan = Tracer.create((String)"StrategyEngine", (String)"execute");){
            DynamicObjectCollection ruleEntryList = strategy.getDynamicObjectCollection("rule_entry");
            DynamicObjectCollection orderRuleEntryList = SchemeHelper.sortCollectionByField(ruleEntryList, "rule_seq");
            EntryReserveResult strategyResult = new EntryReserveResult();
            strategyResult.setSeq(requestEntry.getInt("seq"));
            strategyResult.setEntryId(requestEntry.getPkValue());
            for (int i = 0; i < orderRuleEntryList.size(); ++i) {
                DynamicObject value = ((DynamicObject)orderRuleEntryList.get(i)).getDynamicObject("reserve_inv_rule");
                DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)value.getPkValue(), (String)"msmod_reserve_inv_rule");
                DataSet ruleDataSet = RuleEngine.execute(context, rule, requestEntry);
                StrategyEngine.processRuleResult(context, strategyResult, (DynamicObject)orderRuleEntryList.get(i), requestEntry, ruleDataSet, rule);
            }
            EntryReserveResult entryReserveResult = strategyResult;
            return entryReserveResult;
        }
    }

    private static void processRuleResult(ReserveContext context, EntryReserveResult strategyResult, DynamicObject ruleEntry, DynamicObject requestEntry, DataSet ruleDataSet, DynamicObject rule) {
        String ruleWay = ruleEntry.getString("rule_way");
        EntryReserveResult ruleResult = ResultHandlerFactory.getHandler(ruleWay).handle(strategyResult, context, ruleDataSet, requestEntry, rule);
        if (ReserveResultType.Failed != ruleResult.getReserveResultType()) {
            StrategyEngine.mergeResult(strategyResult, ruleResult);
        }
        StrategyEngine.validateStrategyResult(context, strategyResult, requestEntry);
    }

    private static void mergeResult(EntryReserveResult strategyResult, EntryReserveResult ruleResult) {
        List<StdInvResult> strategyResults = strategyResult.getStdInvResultList();
        List<StdInvResult> ruleResults = ruleResult.getStdInvResultList();
        for (int j = 0; j < ruleResults.size(); ++j) {
            if (ruleResults.get(j).getBaseQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            strategyResults.add(ruleResults.get(j));
            strategyResult.setReservedQty(strategyResult.getReservedQty().add(ruleResults.get(j).getQty()));
            strategyResult.setReservedBaseQty(strategyResult.getReservedBaseQty().add(ruleResults.get(j).getBaseQty()));
            strategyResult.setReservedQty2nd(strategyResult.getReservedQty2nd().add(ruleResults.get(j).getQty2nd()));
        }
    }

    private static void validateStrategyResult(ReserveContext context, EntryReserveResult strategyResult, DynamicObject requestEntry) {
        int compareResult = strategyResult.getReservedBaseQty().compareTo(context.getAllQty(requestEntry, "base_qty"));
        int isReserved = strategyResult.getReservedBaseQty().compareTo(BigDecimal.ZERO);
        if (isReserved <= 0) {
            strategyResult.setErrorMsg(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u5e93\u5b58\u3002", (String)"StrategyEngine_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            strategyResult.setReserveResultType(ReserveResultType.Failed);
        } else if (compareResult < 0) {
            strategyResult.setReserveResultType(ReserveResultType.PartSuccess);
            strategyResult.setErrorMsg("");
        } else if (compareResult >= 0) {
            strategyResult.setReserveResultType(ReserveResultType.FullSuccess);
            strategyResult.setErrorMsg("");
        }
    }

    public static void execute(ReserveContext context, List<RequestBillEntryParam> entryParams, DynamicObject strategy) {
        Iterator<RequestBillEntryParam> it = entryParams.iterator();
        while (it.hasNext()) {
            RequestBillEntryParam next = it.next();
            if (next.isSuccess()) {
                it.remove();
                continue;
            }
            next.clearResult();
        }
        if (entryParams.isEmpty()) {
            return;
        }
        DynamicObjectCollection ruleEntryList = strategy.getDynamicObjectCollection("rule_entry");
        Map<Object, DynamicObject> ruleMap = StrategyEngine.getRuleMap(ruleEntryList);
        DynamicObjectCollection orderRuleEntryList = SchemeHelper.sortCollectionByField(ruleEntryList, "rule_seq");
        for (int i = 0; i < orderRuleEntryList.size(); ++i) {
            DynamicObject value = ((DynamicObject)orderRuleEntryList.get(i)).getDynamicObject("reserve_inv_rule");
            String ruleWay = ((DynamicObject)orderRuleEntryList.get(i)).getString("rule_way");
            DynamicObject rule = ruleMap.get(value.getPkValue());
            if (rule == null) continue;
            DataSet invDataSet = RuleEngine.executeBatch(context, rule, entryParams);
            StrategyEngine.processRuleResult(context, entryParams, invDataSet, ruleWay, rule, strategy.getLong("id"));
            boolean userPlugin = rule.getBoolean("use_plugin");
            if (!userPlugin) continue;
            RuleResultHandlerFactory.getResultHandlerPlugin(rule.getString("rule_plugin")).handle(context, entryParams);
        }
        for (RequestBillEntryParam entryParam : entryParams) {
            entryParam.calQtyStore();
        }
    }

    public static Map<Object, DynamicObject> getRuleMap(DynamicObjectCollection ruleEntryList) {
        HashSet<Object> ruleIds = new HashSet<Object>(ruleEntryList.size());
        for (DynamicObject ruleEntry : ruleEntryList) {
            DynamicObject rule = ruleEntry.getDynamicObject("reserve_inv_rule");
            if (rule == null) continue;
            ruleIds.add(rule.getPkValue());
        }
        if (ruleIds.isEmpty()) {
            return new HashMap<Object, DynamicObject>(0);
        }
        return BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_inv_rule", (QFilter[])new QFilter("id", "in", ruleIds).toArray());
    }

    private static void processRuleResult(ReserveContext context, List<RequestBillEntryParam> entryParams, DataSet readData, String ruleWay, DynamicObject rule, Long strategyId) {
        ResultHandlerFactory.getHandler(ruleWay).handle(entryParams, context, readData, rule, strategyId);
    }
}

