/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.engine.scene;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.StrategyHelper;
import kd.mpscmm.msbd.reserve.business.strategy.RuleEngine;
import kd.mpscmm.msbd.reserve.business.strategy.engine.scene.RowStore;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResultHelper;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResultHelper;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;

public class ReserveForSuit {
    public static BillReserveResult reserve(ReserveContext context) {
        DynamicObjectCollection entryColl = context.getRequestEntryList();
        BillReserveResult[] result = new BillReserveResult[]{context.getCurBillResult()};
        HashMap<String, List> entryMap = new HashMap<String, List>();
        entryColl.forEach(entry -> {
            String bom = entry.getString("bom");
            ArrayList<DynamicObject> entryList = (ArrayList<DynamicObject>)entryMap.get(bom);
            if (entryList == null) {
                entryList = new ArrayList<DynamicObject>();
                entryMap.put(bom, entryList);
            }
            entryList.add((DynamicObject)entry);
        });
        entryMap.forEach((bom, entryList) -> ReserveForSuit.reserve(context, entryList));
        return result[0];
    }

    private static BillReserveResult reserve(ReserveContext context, List<DynamicObject> entryList) {
        DynamicObjectCollection strategyColl = context.getScheme().getDynamicObjectCollection("strategy_entry");
        if (strategyColl != null && !strategyColl.isEmpty()) {
            DynamicObjectCollection ruleList = StrategyHelper.getRuleList((DynamicObject)strategyColl.get(0));
            block0: for (int i = 0; i < ruleList.size(); ++i) {
                DataSet dataSet = ReserveForSuit.getWarehouseAndOwner(context, entryList, (DynamicObject)ruleList.get(i));
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    QFilter filter = ReserveForSuit.getWarehouseFilter(row).and(ReserveForSuit.getOwnerFilter(row));
                    HashMap<Object, DataSet> entryDataSet = new HashMap<Object, DataSet>(entryList.size());
                    HashMap<Object, DynamicObject> entryMap = new HashMap<Object, DynamicObject>(entryList.size());
                    ReserveForSuit.loadData(entryDataSet, entryMap, context, entryList, filter, (DynamicObject)ruleList.get(i));
                    HashMap<Object, EntryReserveResult> entryResultMap = new HashMap<Object, EntryReserveResult>(entryList.size());
                    ReserveForSuit.fillEntryResult(context, entryResultMap, entryDataSet, entryMap);
                    boolean isAllFullSuccess = BillReserveResultHelper.addEntryResult(context, entryResultMap);
                    if (!isAllFullSuccess) continue;
                    continue block0;
                }
            }
        }
        return context.getCurBillResult();
    }

    private static DataSet getWarehouseAndOwner(ReserveContext context, List<DynamicObject> entryList, DynamicObject rule) {
        try (TraceSpan loadData = Tracer.create((String)"ReserveForSuit", (String)"getWarehouseAndOwner");){
            DataSet dataSet = RuleEngine.execute(context, rule, entryList.get(0));
            context.setExtensionContext(new HashMap<String, Object>());
            DataSet dataSet2 = dataSet = dataSet.groupBy(new String[]{"warehouse", "owner"}).sum("avbbaseqty").finish();
            return dataSet2;
        }
    }

    private static QFilter getWarehouseFilter(Row row) {
        Object warehouse = row.get("warehouse");
        return new QFilter("warehouse", "=", warehouse);
    }

    private static QFilter getOwnerFilter(Row row) {
        Object warehouse = row.get("owner");
        return new QFilter("owner", "=", warehouse);
    }

    private static void loadData(Map<Object, DataSet> entryDataSet, Map<Object, DynamicObject> entryMap, ReserveContext context, List<DynamicObject> entryList, QFilter filter, DynamicObject rule) {
        try (TraceSpan loadData = Tracer.create((String)"ReserveForSuit.loadData", (String)"loadData");){
            for (int i = 0; i < entryList.size(); ++i) {
                DataSet dataSet = RuleEngine.execute(context, rule, entryList.get(i), filter);
                Object entryId = context.getEntryId(entryList.get(i));
                entryMap.put(entryId, entryList.get(i));
                entryDataSet.put(entryId, dataSet);
            }
        }
    }

    private static int calculateMaxPair(ReserveContext context, Map<Object, EntryReserveResult> entryResultMap, Map<Object, DynamicObject> entryMap, Map<Object, DataSet> entryDataSet, Map<Object, RowStore> rowStoreMap) {
        Object[] entryIdArr = entryMap.keySet().toArray();
        int maxPair = Integer.MAX_VALUE;
        try (TraceSpan maxPairSpan = Tracer.create((String)"ReserveForSuit", (String)"calculateMaxPair");){
            int i;
            for (i = 0; i < entryIdArr.length; ++i) {
                RowStore rowStore = rowStoreMap.get(entryIdArr[i]);
                if (rowStore == null) {
                    rowStore = new RowStore();
                    rowStoreMap.put(entryIdArr[i], rowStore);
                }
                DataSet dataSet = entryDataSet.get(entryIdArr[i]);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Map<String, Object> map = EntryReserveResultHelper.rowToMap(dataSet, row);
                    rowStore.addRow(map, ReserveForSuit.subtractReserved(entryResultMap, map, ReserveForSuit.subtractReserved(context, map)));
                }
            }
            for (i = 0; i < entryIdArr.length; ++i) {
                Object entryId = entryIdArr[i];
                RowStore row = rowStoreMap.get(entryId);
                BigDecimal baseQtyInv = row.getTotalBaseQty();
                int radio = entryMap.get(entryId).getInt("ratio");
                if (radio <= 0) {
                    radio = 1;
                }
                int curPair = baseQtyInv.divide(BigDecimal.valueOf(radio), 10, 4).intValue();
                maxPair = Math.min(curPair, maxPair);
            }
        }
        if (maxPair == Integer.MAX_VALUE) {
            maxPair = 0;
        }
        return maxPair;
    }

    private static void fillEntryResult(ReserveContext context, Map<Object, EntryReserveResult> entryResultMap, Map<Object, DataSet> entryDataSet, Map<Object, DynamicObject> entryMap) {
        HashMap<Object, RowStore> rowStoreMap = new HashMap<Object, RowStore>(entryDataSet.size());
        int maxPair = ReserveForSuit.calculateMaxPair(context, entryResultMap, entryMap, entryDataSet, rowStoreMap);
        entryMap.forEach((entryId, entry) -> {
            int radio;
            EntryReserveResult entryResult = (EntryReserveResult)entryResultMap.get(entryId);
            if (entryResult == null) {
                entryResult = new EntryReserveResult();
                entryResult.setSeq(((DynamicObject)entryMap.get(entryId)).getInt("seq"));
                entryResult.setEntryId(entryId);
                entryResultMap.put(entryResult.getEntryId(), entryResult);
            }
            if ((radio = ((DynamicObject)entryMap.get(entryId)).getInt("ratio")) <= 0) {
                radio = 1;
            }
            BigDecimal baseQtyNeeded = BigDecimal.valueOf(maxPair * radio);
            RowStore rowStore = (RowStore)rowStoreMap.get(entryId);
            for (int i = 0; i < rowStore.getRowList().size(); ++i) {
                boolean canStopCurEntry;
                Map<String, Object> row = rowStore.getRowList().get(i);
                BigDecimal baseQtyInv = ReserveForSuit.subtractReserved(context, row);
                if ((baseQtyInv = ReserveForSuit.subtractReserved(entryResultMap, row, baseQtyInv)).compareTo(baseQtyNeeded) <= 0) {
                    baseQtyNeeded = baseQtyNeeded.subtract(baseQtyInv);
                } else {
                    baseQtyInv = baseQtyNeeded;
                    baseQtyNeeded = BigDecimal.ZERO;
                }
                BigDecimal remainBaseQty = context.getEntryRemainBaseQty((DynamicObject)entry);
                remainBaseQty = remainBaseQty.subtract(entryResult.getReservedBaseQty());
                remainBaseQty = remainBaseQty.compareTo(BigDecimal.ZERO) >= 0 ? remainBaseQty : BigDecimal.ZERO;
                BigDecimal bigDecimal = baseQtyInv = remainBaseQty.compareTo(baseQtyInv) > 0 ? baseQtyInv : remainBaseQty;
                if (baseQtyInv.compareTo(BigDecimal.ZERO) > 0 && (canStopCurEntry = EntryReserveResultHelper.addToEntryResult(context, entryResult, (DynamicObject)entryMap.get(entryId), row, baseQtyInv, baseQtyInv, BigDecimal.ZERO))) break;
            }
        });
    }

    private static BigDecimal subtractReserved(ReserveContext context, Map<String, Object> row) {
        BillReserveResult billReserveResult = context.getCurBillResult();
        List<EntryReserveResult> entryReserveResultList = billReserveResult.getEntryResultList();
        BigDecimal[] qtyInv = new BigDecimal[]{(BigDecimal)row.get("avbbaseqty")};
        entryReserveResultList.forEach(entryReserveResult -> {
            List<StdInvResult> stdInvResultList = entryReserveResult.getStdInvResultList();
            stdInvResultList.forEach(stdInvResult -> {
                if (stdInvResult.getInvInfo().get("entryid").equals(row.get("entryid"))) {
                    qtyInv[0] = qtyInv[0].subtract(stdInvResult.getBaseQty());
                }
            });
        });
        return qtyInv[0];
    }

    private static BigDecimal subtractReserved(Map<Object, EntryReserveResult> entryResultMap, Map<String, Object> row, BigDecimal baseQty) {
        BigDecimal[] qtyInv = new BigDecimal[]{baseQty};
        entryResultMap.forEach((key, entryReserveResult) -> {
            List<StdInvResult> stdInvResultList = entryReserveResult.getStdInvResultList();
            stdInvResultList.forEach(stdInvResult -> {
                if (stdInvResult.getInvInfo().get("entryid").equals(row.get("entryid"))) {
                    qtyInv[0] = qtyInv[0].subtract(stdInvResult.getBaseQty());
                }
            });
        });
        return qtyInv[0];
    }
}

