/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResultHelper;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;

public class BillReserveResultHelper {
    private static final Log logger = LogFactory.getLog(BillReserveResultHelper.class);

    public static BillReserveResult getBillResult(ReserveContext context, Map<Object, EntryReserveResult> entryResultMap) {
        BillReserveResult result = new BillReserveResult();
        result.setBillId(context.getRequestBillId());
        ArrayList fullSuccessCount = new ArrayList();
        ArrayList partSuccessCount = new ArrayList();
        entryResultMap.forEach((key, value) -> {
            result.getEntryResultList().add((EntryReserveResult)value);
            if (value.getReserveResultType() == ReserveResultType.PartSuccess) {
                partSuccessCount.add(value);
            } else if (value.getReserveResultType() == ReserveResultType.FullSuccess) {
                fullSuccessCount.add(value);
            }
        });
        if (fullSuccessCount.isEmpty() && partSuccessCount.isEmpty()) {
            result.setReserveResultType(ReserveResultType.Failed);
        } else if (fullSuccessCount.size() != entryResultMap.size()) {
            result.setReserveResultType(ReserveResultType.PartSuccess);
            result.setErrorMsg("");
        } else {
            result.setErrorMsg("");
            result.setReserveResultType(ReserveResultType.FullSuccess);
        }
        return result;
    }

    public static boolean addEntryResult(ReserveContext context, Map<Object, EntryReserveResult> entryResultMap) {
        BillReserveResult result = context.getCurBillResult();
        List<EntryReserveResult> entryResultList = result.getEntryResultList();
        entryResultList.forEach(entryResult -> {
            EntryReserveResult additionalResult = (EntryReserveResult)entryResultMap.get(entryResult.getEntryId());
            if (additionalResult != null) {
                entryResultMap.remove(entryResult.getEntryId());
                EntryReserveResultHelper.mergeEntryResult(entryResult, additionalResult);
            }
        });
        entryResultList.addAll(entryResultMap.values());
        boolean isAllFullSuccess = true;
        for (int i = 0; i < entryResultList.size(); ++i) {
            EntryReserveResult entryResult2 = entryResultList.get(i);
            BillReserveResultHelper.validateEntryResult(context, entryResult2);
            if (entryResult2.getReserveResultType() == ReserveResultType.FullSuccess) continue;
            isAllFullSuccess = false;
        }
        return isAllFullSuccess;
    }

    public static void validateEntryResult(ReserveContext context, EntryReserveResult entryReserveResult) {
        context.getEntryList().forEach(entry -> {
            if (context.getEntryId((DynamicObject)entry).equals(entryReserveResult.getEntryId())) {
                BigDecimal requestBaseQty = context.getAllQty((DynamicObject)entry, "base_qty");
                BigDecimal reservedBaseQty = entryReserveResult.getReservedBaseQty();
                if (entryReserveResult.getReservedBaseQty().compareTo(BigDecimal.ZERO) <= 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u5206\u5f55\u3010" + entryReserveResult.getEntryId() + "\u3011\uff0c\u5168\u90e8\u9884\u7559\u6210\u529f");
                    }
                    entryReserveResult.setReserveResultType(ReserveResultType.Failed);
                } else if (requestBaseQty.compareTo(reservedBaseQty) > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u5206\u5f55\u3010" + entryReserveResult.getEntryId() + "\u3011\uff0c\u90e8\u5206\u9884\u7559\u6210\u529f\uff0c \u9884\u7559\u6570\u91cf\uff1a " + entryReserveResult.getReservedBaseQty());
                    }
                    entryReserveResult.setReserveResultType(ReserveResultType.PartSuccess);
                } else if (requestBaseQty.compareTo(reservedBaseQty) <= 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u5206\u5f55\u3010" + entryReserveResult.getEntryId() + "\u3011\uff0c\u5168\u90e8\u9884\u7559\u6210\u529f\uff0c \u9884\u7559\u6570\u91cf\uff1a " + entryReserveResult.getReservedBaseQty());
                    }
                    entryReserveResult.setReserveResultType(ReserveResultType.FullSuccess);
                }
            }
        });
    }
}

