/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.result;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;

public class EntryReserveResultHelper {
    private static final Log logger = LogFactory.getLog(EntryReserveResultHelper.class);

    public static boolean addToEntryResult(ReserveContext context, EntryReserveResult result, DynamicObject entry, Map<String, Object> row, BigDecimal baseQty, BigDecimal qty, BigDecimal qty2nd) {
        baseQty = EntryReserveResultHelper.getPositiveValue(baseQty, entry.getBigDecimal("base_qty").subtract(result.getReservedBaseQty()));
        qty = EntryReserveResultHelper.getPositiveValue(qty, entry.getBigDecimal("qty").subtract(result.getReservedQty()));
        qty2nd = EntryReserveResultHelper.getPositiveValue(qty2nd, entry.getBigDecimal("aux_qty").subtract(result.getReservedQty2nd()));
        logger.info("\u5206\u5f55\u3010" + entry.get("id") + "\u3011\u9884\u7559, \u5f53\u524d\u5206\u5f55\u9700\u6c42\u6570\uff1a " + entry.getBigDecimal("base_qty") + "\uff0c\u5df2\u7ecf\u9884\u7559\u6570\u91cf\uff1a " + result.getReservedBaseQty() + "\uff0c\u672c\u6b21\u6b32\u9884\u7559\u6570\u91cf\uff1a" + baseQty);
        if (context.getEntryReservedBaseQty(entry).add(result.getReservedBaseQty()).compareTo(entry.getBigDecimal("base_qty")) >= 0) {
            return true;
        }
        logger.info("\u5206\u5f55 \u3010" + entry.get("id") + "\u3011\uff0c\u589e\u52a0\u9884\u7559\u6570\u91cf\uff1a " + baseQty);
        StdInvResult stdInvResult = EntryReserveResultHelper.getStdInvResult(result, row);
        stdInvResult.setQty(stdInvResult.getQty().add(qty));
        stdInvResult.setBaseQty(stdInvResult.getBaseQty().add(baseQty));
        stdInvResult.setQty2nd(stdInvResult.getQty2nd().add(qty2nd));
        result.getStdInvResultList().add(stdInvResult);
        result.setReservedBaseQty(result.getReservedBaseQty().add(baseQty));
        result.setReservedQty(result.getReservedQty().add(qty));
        result.setReservedQty2nd(result.getReservedQty2nd().add(qty2nd));
        result.setReserveResultType(ReserveResultType.PartSuccess);
        if (context.getEntryReservedBaseQty(entry).add(result.getReservedBaseQty()).compareTo(entry.getBigDecimal("base_qty")) >= 0) {
            result.setReserveResultType(ReserveResultType.FullSuccess);
            logger.info("\u5206\u5f55 \u3010" + entry.get("id") + "\u3011\uff0c\u5df2\u7ecf\u5b8c\u6210\u6240\u6709\u6570\u91cf\u9884\u7559");
            return true;
        }
        return false;
    }

    private static StdInvResult getStdInvResult(EntryReserveResult result, Map<String, Object> row) {
        StdInvResult invResult = null;
        for (StdInvResult stdInvResult : result.getStdInvResultList()) {
            if (stdInvResult == null || !row.get("id").equals(stdInvResult.getInvID())) continue;
            invResult = stdInvResult;
            break;
        }
        if (invResult == null) {
            invResult = new StdInvResult();
            invResult.setInvInfo(row);
        }
        return invResult;
    }

    public static void mergeEntryResult(EntryReserveResult originalResult, EntryReserveResult additionalResult) {
        originalResult.setReservedBaseQty(originalResult.getReservedBaseQty().add(additionalResult.getReservedBaseQty()));
        originalResult.setReservedQty(originalResult.getReservedQty().add(additionalResult.getReservedQty()));
        originalResult.setReservedQty2nd(originalResult.getReservedQty2nd().add(additionalResult.getReservedQty2nd()));
        originalResult.getStdInvResultList().addAll(additionalResult.getStdInvResultList());
    }

    private static BigDecimal getPositiveValue(BigDecimal value, BigDecimal needed) {
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        if (value.compareTo(needed) > 0) {
            return needed;
        }
        return value;
    }

    public static Map<String, Object> rowToMap(DataSet dataSet, Row row) {
        String[] names = dataSet.getRowMeta().getFieldNames();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(32);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            result.put(name, row.get(name));
        }
        return result;
    }
}

