/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.result.handler.billresult;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.record.ReserveRecordHelper;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;

public interface BillResultHandler {
    public static final Log logger = LogFactory.getLog(BillResultHandler.class);

    public void handle(BillReserveResult var1, ReserveContext var2);

    default public void createReserveRecord(BillReserveResult result, ReserveContext context) {
        List<EntryReserveResult> entryReserveResultList = result.getEntryResultList();
        ArrayList<StdInvResult> stdInvResults = new ArrayList<StdInvResult>(8);
        for (int i = 0; i < entryReserveResultList.size(); ++i) {
            stdInvResults.addAll(entryReserveResultList.get(i).getStdInvResultList());
        }
        Map<Object, DynamicObject> supInfoMap = ReserveRecordHelper.getSupInfoMap(stdInvResults);
        Map<Long, Integer> entryIdExpireDateMap = ReserveRecordHelper.getInventoryExpireMap(stdInvResults, context.getOrgFilterMap());
        LinkedList<DynamicObject> billReserveRecordList = new LinkedList<DynamicObject>();
        boolean isAggScheme = context.getScheme().getBoolean("aggregate");
        for (int i = 0; i < entryReserveResultList.size(); ++i) {
            List<DynamicObject> entryRecordList = ReserveRecordHelper.fromEntryResult(entryReserveResultList.get(i), context, supInfoMap, entryIdExpireDateMap, isAggScheme);
            billReserveRecordList.addAll(entryRecordList);
        }
        ReserveRecordHandler.createReserveRecord(billReserveRecordList);
    }

    default public boolean isResultUsable(BillReserveResult result, ReserveContext context) {
        boolean isFialReserve;
        boolean isUsable = true;
        DynamicObject scheme = context.getScheme();
        String billResultHandler = scheme.getString("result_handler");
        String supDiff = scheme.getString("supdiff");
        boolean bl = isFialReserve = "A".equals(supDiff) || "D".equals(supDiff);
        if (isFialReserve && ReserveResultType.FullSuccess != result.getReserveResultType() || billResultHandler.equals("3") && ReserveResultType.FullSuccess != result.getReserveResultType() || billResultHandler.equals("6") && ReserveResultType.FullSuccess != result.getReserveResultType()) {
            result.setReserveResultType(ReserveResultType.Failed);
            result.setErrorMsg(ResManager.loadKDString((String)"\u4e0d\u8db3\u4e0d\u9884\u7559", (String)"BillResultHandler_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            isUsable = false;
        } else if (ReserveResultType.Failed == result.getReserveResultType()) {
            result.setReserveResultType(ReserveResultType.Failed);
            result.setErrorMsg(ResManager.loadKDString((String)"\u9884\u7559\u5931\u8d25", (String)"BillResultHandler_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            isUsable = false;
        }
        return isUsable;
    }
}

