/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.result.handler.entryresult;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.QtyStore;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;

public interface EntryResultHandler {
    public EntryReserveResult handle(EntryReserveResult var1, ReserveContext var2, DataSet var3, DynamicObject var4, DynamicObject var5);

    default public Map<String, Object> rowToMap(String[] fieldKeys, Row row) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(32);
        for (int i = 0; i < fieldKeys.length; ++i) {
            String name = fieldKeys[i];
            result.put(name, row.get(name));
        }
        return result;
    }

    default public QtyStore subtractReserved(ReserveContext context, QtyStore usableQty, Row row, BillReserveResult billReserveResult, long aggId, long invEntryId) {
        QtyStore newStore = new QtyStore(usableQty);
        if (billReserveResult == null) {
            billReserveResult = context.getCurBillResult();
        }
        List<EntryReserveResult> entryReserveResultList = billReserveResult.getEntryResultList();
        int entryResultListSize = entryReserveResultList.size();
        boolean isAggScheme = context.getScheme().getBoolean("aggregate");
        for (int i = 0; i < entryResultListSize; ++i) {
            EntryReserveResult entryReserveResult = entryReserveResultList.get(i);
            List<StdInvResult> stdInvResultList = entryReserveResult.getStdInvResultList();
            int invInfoSize = stdInvResultList.size();
            for (int j = 0; j < invInfoSize; ++j) {
                StdInvResult stdInvResult = stdInvResultList.get(j);
                if (context.isAggregate() && isAggScheme && stdInvResult.getAggId() != null) {
                    if (!stdInvResult.getAggId().equals(aggId)) continue;
                    newStore.setBaseQty(newStore.getBaseQty().subtract(stdInvResult.getBaseQty()));
                    newStore.setQty(newStore.getQty().subtract(stdInvResult.getQty()));
                    newStore.setQty2end(newStore.getQty2end().subtract(stdInvResult.getQty2nd()));
                    continue;
                }
                if (!stdInvResult.getInvEntryID().equals(invEntryId)) continue;
                newStore.setBaseQty(newStore.getBaseQty().subtract(stdInvResult.getBaseQty()));
                newStore.setQty(newStore.getQty().subtract(stdInvResult.getQty()));
                newStore.setQty2end(newStore.getQty2end().subtract(stdInvResult.getQty2nd()));
            }
        }
        return newStore;
    }

    public void handle(List<RequestBillEntryParam> var1, ReserveContext var2, DataSet var3, DynamicObject var4, Long var5);
}

