/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.result.handler.entryresult;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.handler.entryresult.EntryResultHandler;
import kd.mpscmm.msbd.reserve.business.strategy.result.handler.entryresult.ReserveAllAvailable;

public class InsufficientNotReserve
implements EntryResultHandler {
    @Override
    public EntryReserveResult handle(EntryReserveResult curStrategyResult, ReserveContext context, DataSet dataSet, DynamicObject requestEntry, DynamicObject rule) {
        ReserveAllAvailable reserveAllAvailable = new ReserveAllAvailable();
        EntryReserveResult entryResult = reserveAllAvailable.handle(curStrategyResult, context, dataSet, requestEntry, rule);
        if (ReserveResultType.FullSuccess != entryResult.getReserveResultType()) {
            entryResult.setReserveResultType(ReserveResultType.Failed);
            entryResult.setErrorMsg(ResManager.loadKDString((String)"\u4e0d\u8db3\u4e0d\u9884\u7559", (String)"InsufficientNotReserve_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        return entryResult;
    }

    @Override
    public void handle(List<RequestBillEntryParam> entryParams, ReserveContext context, DataSet readData, DynamicObject rule, Long strategyId) {
        ReserveAllAvailable reserveAllAvailable = new ReserveAllAvailable();
        reserveAllAvailable.setSaveResult(false);
        HashMap<Long, String> entryParamMap = new HashMap<Long, String>(entryParams.size());
        for (RequestBillEntryParam param : entryParams) {
            EntryReserveResult entryReserveResult = param.getResult();
            if (entryReserveResult.getReservedBaseQty().compareTo(BigDecimal.ZERO) <= 0) continue;
            entryParamMap.put((Long)entryReserveResult.getEntryId(), SerializationUtils.toJsonString((Object)param.getResult()));
        }
        reserveAllAvailable.handle(entryParams, context, readData, rule, strategyId);
        for (RequestBillEntryParam entryParam : entryParams) {
            EntryReserveResult entryResult = entryParam.getResult();
            if (ReserveResultType.FullSuccess == entryResult.getReserveResultType()) continue;
            String str = (String)entryParamMap.get(entryParam.getResult().getEntryId());
            if (str == null) {
                entryParam.clearResult();
                continue;
            }
            EntryReserveResult oldResult = (EntryReserveResult)SerializationUtils.fromJsonString((String)str, EntryReserveResult.class);
            entryParam.clearNotEnoughResult(oldResult);
            List<EntryReserveResult> contextResult = context.getStrategyCurResultMap().get(strategyId).getEntryResultList();
            boolean isFind = false;
            Iterator<EntryReserveResult> it = contextResult.iterator();
            while (it.hasNext()) {
                EntryReserveResult result = it.next();
                if (!result.getEntryId().equals(entryParam.getResult().getEntryId())) continue;
                it.remove();
                isFind = true;
                break;
            }
            if (!isFind) continue;
            contextResult.add(oldResult);
        }
    }
}

