/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.business.strategy.result.handler.entryresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.record.RequestEntryMatch;
import kd.mpscmm.msbd.reserve.business.strategy.QtyStore;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.handler.entryresult.EntryResultHandler;

public class ReserveAllAvailable
implements EntryResultHandler {
    private static final Log logger = LogFactory.getLog(ReserveAllAvailable.class);
    private boolean isSaveResult = true;

    @Override
    public EntryReserveResult handle(EntryReserveResult curStrategyResult, ReserveContext context, DataSet dataSet, DynamicObject requestEntry, DynamicObject rule) {
        EntryReserveResult ruleResult = new EntryReserveResult();
        List<StdInvResult> resultList = ruleResult.getStdInvResultList();
        boolean isPredict = rule.getBoolean("ispredict");
        ruleResult.setEntryId(requestEntry.get("id"));
        QtyStore qtyNeeded = this.getNeeded(curStrategyResult, context, requestEntry);
        while (dataSet.hasNext()) {
            long invEntryId;
            Row row = dataSet.next();
            QtyStore qtyUsable = new QtyStore(row);
            BigDecimal baseRatio = qtyUsable.getBaseQty();
            BigDecimal qtyRatio = qtyUsable.getQty();
            long aggId = row.getLong("aggid");
            if (!(qtyUsable = this.subtractReserved(context, qtyUsable, row, null, aggId, invEntryId = row.getLong("entryid").longValue())).isReservable() || ReserveAllAvailable.ifExist(curStrategyResult, invEntryId)) continue;
            StdInvResult stdInvResult = new StdInvResult();
            stdInvResult.setPredict(isPredict);
            stdInvResult.setInvInfo(this.rowToMap(dataSet.getRowMeta().getFieldNames(), row));
            resultList.add(stdInvResult);
            ruleResult.setReserveResultType(ReserveResultType.PartSuccess);
            if (qtyNeeded.getBaseQty().compareTo(qtyUsable.getBaseQty()) > 0) {
                stdInvResult.setBaseQty(qtyUsable.getBaseQty());
                qtyNeeded.setBaseQty(qtyNeeded.getBaseQty().subtract(qtyUsable.getBaseQty()));
                stdInvResult.setQty(qtyUsable.getQty());
                qtyNeeded.setQty(qtyNeeded.getQty().subtract(qtyUsable.getQty()));
                stdInvResult.setQty2nd(qtyUsable.getQty2end());
                qtyNeeded.setQty2end(qtyNeeded.getQty2end().subtract(qtyUsable.getQty2end()));
                if (qtyNeeded.getQty2end().compareTo(BigDecimal.ZERO) >= 0) continue;
                qtyNeeded.setQty2end(BigDecimal.ZERO);
                continue;
            }
            if (qtyNeeded.getBaseQty().compareTo(qtyUsable.getBaseQty()) > 0) continue;
            stdInvResult.setBaseQty(qtyNeeded.getBaseQty());
            stdInvResult.setQty(qtyNeeded.getBaseQty().multiply(qtyRatio).divide(baseRatio, 10, 4));
            BigDecimal minQty2nd = qtyUsable.getQty2end().min(qtyNeeded.getQty2end());
            minQty2nd = minQty2nd.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : minQty2nd;
            stdInvResult.setQty2nd(minQty2nd);
            ruleResult.setReserveResultType(ReserveResultType.FullSuccess);
            break;
        }
        return ruleResult;
    }

    private static boolean ifExist(EntryReserveResult curStrategyResult, Object invEntryId) {
        List<StdInvResult> result = curStrategyResult.getStdInvResultList();
        for (int i = 0; i < result.size(); ++i) {
            if (!result.get(i).getInvInfo().get("entryid").equals(invEntryId)) continue;
            return true;
        }
        return false;
    }

    private QtyStore getNeeded(EntryReserveResult curResult, ReserveContext context, DynamicObject entry) {
        QtyStore qtyStore = new QtyStore();
        qtyStore.setBaseQty(this.getNeededBaseQty(curResult, context, entry));
        qtyStore.setQty(context.getAllQty(entry, "qty"));
        qtyStore.setQty2end(this.getNeededQty2end(curResult, context, entry));
        return qtyStore;
    }

    private BigDecimal getNeededQty(EntryReserveResult curResult, ReserveContext context, DynamicObject entry) {
        BigDecimal qty = context.getAllQty(entry, "qty");
        if ((qty = qty.subtract(curResult.getReservedQty())).compareTo(BigDecimal.ZERO) <= 0) {
            qty = BigDecimal.ZERO;
        }
        return qty;
    }

    private BigDecimal getNeededBaseQty(EntryReserveResult curResult, ReserveContext context, DynamicObject entry) {
        BigDecimal baseQty = context.getAllQty(entry, "base_qty");
        if ((baseQty = baseQty.subtract(curResult.getReservedBaseQty())).compareTo(BigDecimal.ZERO) <= 0) {
            baseQty = BigDecimal.ZERO;
        }
        return baseQty;
    }

    private BigDecimal getNeededQty2end(EntryReserveResult curResult, ReserveContext context, DynamicObject entry) {
        BigDecimal qty2nd = context.getAllQty(entry, "aux_qty");
        if ((qty2nd = qty2nd.subtract(curResult.getReservedQty2nd())).compareTo(BigDecimal.ZERO) <= 0) {
            qty2nd = BigDecimal.ZERO;
        }
        return qty2nd;
    }

    @Override
    public void handle(List<RequestBillEntryParam> entryParams, ReserveContext context, DataSet invDataSet, DynamicObject rule, Long strategyId) {
        if (invDataSet == null) {
            return;
        }
        boolean isPredict = rule.getBoolean("ispredict");
        String[] fieldKeys = invDataSet.getRowMeta().getFieldNames();
        ArrayList<RequestBillEntryParam> copyParams = new ArrayList<RequestBillEntryParam>(entryParams);
        if (copyParams.isEmpty()) {
            return;
        }
        Map<Long, BillReserveResult> strategyCurResultMap = context.getStrategyCurResultMap();
        BillReserveResult reserveResult = strategyCurResultMap.get(strategyId);
        List<RequestEntryMatch> entryMatchList = ((RequestBillEntryParam)copyParams.get(0)).getEntryMatchs();
        Integer[] rowKeyIndexArray = new Integer[entryMatchList.size()];
        for (int i = 0; i < entryMatchList.size(); ++i) {
            rowKeyIndexArray[i] = invDataSet.getRowMeta().getFieldIndex(entryMatchList.get(i).getTarKey());
        }
        boolean findUnit = false;
        for (int i = 0; i < fieldKeys.length; ++i) {
            if (!"unit".equals(fieldKeys[i])) continue;
            findUnit = true;
            break;
        }
        boolean isAggScheme = context.getScheme().getBoolean("aggregate");
        while (invDataSet.hasNext()) {
            Row invRow = invDataSet.next();
            this.calReserveQty(copyParams, context, invRow, isPredict, fieldKeys, reserveResult, rowKeyIndexArray, findUnit, isAggScheme);
        }
    }

    private void calReserveQty(List<RequestBillEntryParam> copyParams, ReserveContext context, Row invRow, boolean isPredict, String[] fieldKeys, BillReserveResult reserveResult, Integer[] rowKeyIndexArray, boolean findUnit, boolean isAggScheme) {
        ConvRateContext convRate = context.getConvRate();
        Long unit = 0L;
        if (findUnit) {
            unit = invRow.getLong("unit");
        }
        Long baseUnit = invRow.getLong("baseunit");
        Long materialId = invRow.getLong("materiel");
        Iterator<RequestBillEntryParam> it = copyParams.iterator();
        List<EntryReserveResult> entryResultList = reserveResult.getEntryResultList();
        ArrayList<EntryReserveResult> oldResultList = null;
        if (!this.isSaveResult) {
            oldResultList = new ArrayList<EntryReserveResult>(entryResultList);
        }
        long aggId = invRow.getLong("aggid");
        long invEntryId = invRow.getLong("entryid");
        while (it.hasNext()) {
            boolean isExit;
            RequestBillEntryParam entryParam = it.next();
            if (!entryParam.match(invRow, rowKeyIndexArray)) continue;
            QtyStore qtyStore = entryParam.getQtyStore();
            BigDecimal avbBaseQty = qtyStore.getBaseQty().subtract(qtyStore.getLockBaseQty());
            if (avbBaseQty.compareTo(BigDecimal.ZERO) <= 0) {
                it.remove();
                continue;
            }
            QtyStore qtyUsable = new QtyStore(invRow);
            if (!(qtyUsable = this.subtractEntryReserved(context, qtyUsable, reserveResult, aggId, invEntryId, isAggScheme, isPredict)).isReservable()) continue;
            EntryReserveResult result = entryParam.getResult();
            List<StdInvResult> invResultList = result.getStdInvResultList();
            StdInvResult stdInvResult = new StdInvResult();
            stdInvResult.setPredict(isPredict);
            stdInvResult.setInvInfo(this.rowToMap(fieldKeys, invRow));
            stdInvResult.setInvEntryID(invEntryId);
            stdInvResult.setAggId(aggId);
            invResultList.add(stdInvResult);
            BigDecimal reBaseQty = BigDecimal.ZERO;
            BigDecimal reQty = BigDecimal.ZERO;
            BigDecimal invQty2nd = qtyUsable.getQty2end();
            BigDecimal billQty2nd = qtyStore.getQty2end().subtract(qtyStore.getLockQty2end());
            BigDecimal reQty2nd = invQty2nd.min(billQty2nd).max(BigDecimal.ZERO);
            if (avbBaseQty.compareTo(qtyUsable.getBaseQty()) >= 0) {
                reBaseQty = qtyUsable.getBaseQty();
                if (findUnit) {
                    reQty = convRate.getSrcQty(reBaseQty, materialId, unit, baseUnit).min(qtyUsable.getQty());
                }
                stdInvResult.setBaseQty(reBaseQty);
                qtyStore.addLockBaseQty(reBaseQty);
                stdInvResult.setQty(reQty);
                qtyStore.addLockQty(reQty);
                stdInvResult.setQty2nd(reQty2nd);
                qtyStore.addLockQty2end(reQty2nd);
                avbBaseQty = qtyStore.getBaseQty().subtract(qtyStore.getLockBaseQty());
                result.setReserveResultType(avbBaseQty.compareTo(BigDecimal.ZERO) > 0 ? ReserveResultType.PartSuccess : ReserveResultType.FullSuccess);
                this.addReserveQty(result, stdInvResult);
                isExit = false;
                for (EntryReserveResult entryReserveResult : entryResultList) {
                    if (!result.getEntryId().equals(entryReserveResult.getEntryId())) continue;
                    isExit = true;
                    break;
                }
                if (isExit) break;
                entryResultList.add(result);
                break;
            }
            if (avbBaseQty.compareTo(qtyUsable.getBaseQty()) >= 0) continue;
            reBaseQty = avbBaseQty;
            if (findUnit) {
                reQty = convRate.getSrcQty(reBaseQty, materialId, unit, baseUnit).min(qtyUsable.getQty());
            }
            stdInvResult.setBaseQty(reBaseQty);
            stdInvResult.setQty(reQty);
            qtyStore.addLockBaseQty(avbBaseQty);
            qtyStore.addLockQty(reQty);
            stdInvResult.setQty2nd(reQty2nd);
            qtyStore.addLockQty2end(reQty2nd);
            result.setReserveResultType(ReserveResultType.FullSuccess);
            this.addReserveQty(result, stdInvResult);
            isExit = false;
            for (EntryReserveResult entryReserveResult : entryResultList) {
                if (!result.getEntryId().equals(entryReserveResult.getEntryId())) continue;
                isExit = true;
                break;
            }
            if (isExit) continue;
            entryResultList.add(result);
        }
        if (!this.isSaveResult) {
            if (oldResultList == null) {
                oldResultList = new ArrayList(0);
            }
            for (RequestBillEntryParam prams : copyParams) {
                EntryReserveResult result = prams.getResult();
                if (result.getReserveResultType() != ReserveResultType.FullSuccess) continue;
                oldResultList.add(result);
            }
            reserveResult.setEntryResultList(oldResultList);
        }
    }

    private void addReserveQty(EntryReserveResult result, StdInvResult stdInvResult) {
        result.setReservedBaseQty(result.getReservedBaseQty().add(stdInvResult.getBaseQty()));
        result.setReservedQty(result.getReservedQty().add(stdInvResult.getQty()));
        result.setReservedQty2nd(result.getReservedQty2nd().add(stdInvResult.getQty2nd()));
    }

    private QtyStore getNeeded(EntryReserveResult result, ReserveContext context, DynamicObject entry, QtyStore qtyStore) {
        QtyStore qtyNeeded = new QtyStore();
        qtyNeeded.setBaseQty(this.getNeededBaseQty(result, context, entry).subtract(qtyStore.getLockBaseQty()));
        qtyNeeded.setQty(this.getNeededQty(result, context, entry).subtract(qtyStore.getLockQty()));
        qtyNeeded.setQty2end(this.getNeededQty2end(result, context, entry).subtract(qtyStore.getLockQty2end()));
        return qtyNeeded;
    }

    public void setSaveResult(boolean isSaveResult) {
        this.isSaveResult = isSaveResult;
    }

    private QtyStore subtractEntryReserved(ReserveContext context, QtyStore usableQty, BillReserveResult billReserveResult, long aggId, long invEntryId, boolean isAggScheme, boolean isPredict) {
        QtyStore newStore = new QtyStore(usableQty);
        if (billReserveResult == null) {
            billReserveResult = context.getCurBillResult();
        }
        List<EntryReserveResult> entryReserveResultList = billReserveResult.getEntryResultList();
        for (EntryReserveResult entryReserveResult : entryReserveResultList) {
            List<StdInvResult> stdInvResultList = entryReserveResult.getStdInvResultList();
            for (StdInvResult stdInvResult : stdInvResultList) {
                if (!isPredict && context.isAggregate() && isAggScheme && stdInvResult.getAggId() != null) {
                    if (!stdInvResult.getAggId().equals(aggId)) continue;
                    newStore.setBaseQty(newStore.getBaseQty().subtract(stdInvResult.getBaseQty()));
                    newStore.setQty(newStore.getQty().subtract(stdInvResult.getQty()));
                    newStore.setQty2end(newStore.getQty2end().subtract(stdInvResult.getQty2nd()));
                    continue;
                }
                if (!stdInvResult.getInvEntryID().equals(invEntryId)) continue;
                newStore.setBaseQty(newStore.getBaseQty().subtract(stdInvResult.getBaseQty()));
                newStore.setQty(newStore.getQty().subtract(stdInvResult.getQty()));
                newStore.setQty2end(newStore.getQty2end().subtract(stdInvResult.getQty2nd()));
            }
        }
        return newStore;
    }
}

